/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import net.sf.ehcache.distribution.RMIAsynchronousCacheReplicator;
import net.sf.ehcache.distribution.RMISynchronousCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;

public final class RMICacheReplicatorFactory
extends CacheEventListenerFactory {
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";

    public final CacheEventListener createCacheEventListener(Properties properties) {
        boolean replicatePuts = RMICacheReplicatorFactory.extractReplicatePuts(properties);
        boolean replicateUpdates = RMICacheReplicatorFactory.extractReplicateUpdates(properties);
        boolean replicateUpdatesViaCopy = RMICacheReplicatorFactory.extractReplicateUpdatesViaCopy(properties);
        boolean replicateRemovals = RMICacheReplicatorFactory.extractReplicateRemovals(properties);
        boolean replicateAsynchronously = RMICacheReplicatorFactory.extractReplicateAsynchronously(properties);
        if (replicateAsynchronously) {
            return new RMIAsynchronousCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
        }
        return new RMISynchronousCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
    }

    private static boolean extractReplicateAsynchronously(Properties properties) {
        String replicateAsynchronouslyString = PropertyUtil.extractAndLogProperty(REPLICATE_ASYNCHRONOUSLY, properties);
        boolean replicateAsynchronously = replicateAsynchronouslyString != null ? RMICacheReplicatorFactory.parseBoolean(replicateAsynchronouslyString) : true;
        return replicateAsynchronously;
    }

    private static boolean extractReplicateRemovals(Properties properties) {
        String replicateRemovalsString = PropertyUtil.extractAndLogProperty(REPLICATE_REMOVALS, properties);
        boolean replicateRemovals = replicateRemovalsString != null ? RMICacheReplicatorFactory.parseBoolean(replicateRemovalsString) : true;
        return replicateRemovals;
    }

    private static boolean extractReplicateUpdatesViaCopy(Properties properties) {
        String replicateUpdatesViaCopyString = PropertyUtil.extractAndLogProperty(REPLICATE_UPDATES_VIA_COPY, properties);
        boolean replicateUpdatesViaCopy = replicateUpdatesViaCopyString != null ? RMICacheReplicatorFactory.parseBoolean(replicateUpdatesViaCopyString) : true;
        return replicateUpdatesViaCopy;
    }

    private static boolean extractReplicateUpdates(Properties properties) {
        String replicateUpdatesString = PropertyUtil.extractAndLogProperty(REPLICATE_UPDATES, properties);
        boolean replicateUpdates = replicateUpdatesString != null ? RMICacheReplicatorFactory.parseBoolean(replicateUpdatesString) : true;
        return replicateUpdates;
    }

    private static boolean extractReplicatePuts(Properties properties) {
        String replicatePutsString = PropertyUtil.extractAndLogProperty(REPLICATE_PUTS, properties);
        boolean replicatePuts = replicatePutsString != null ? RMICacheReplicatorFactory.parseBoolean(replicatePutsString) : true;
        return replicatePuts;
    }

    private static boolean parseBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }
}

