/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RMICachePeer;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RMICacheManagerPeerListener
implements CacheManagerPeerListener {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$RMICacheManagerPeerListener == null ? (class$net$sf$ehcache$distribution$RMICacheManagerPeerListener = RMICacheManagerPeerListener.class$("net.sf.ehcache.distribution.RMICacheManagerPeerListener")) : class$net$sf$ehcache$distribution$RMICacheManagerPeerListener).getName());
    private static final int MINIMUM_SENSIBLE_TIMEOUT = 200;
    private Registry registry;
    private final String hostName;
    private Integer port;
    private CacheManager cacheManager;
    private Integer socketTimeoutMillis;
    private final List cachePeers = new ArrayList();
    static /* synthetic */ Class class$net$sf$ehcache$distribution$RMICacheManagerPeerListener;

    public RMICacheManagerPeerListener(String hostName, Integer port, CacheManager cacheManager, Integer socketTimeoutMillis) throws UnknownHostException {
        if (hostName != null && hostName.length() != 0) {
            this.hostName = hostName;
            if (hostName.equals("localhost")) {
                LOG.warn((Object)"Explicitly setting the listener hostname to 'localhost' is not recommended. It will only work if all CacheManager peers are on the same machine.");
            }
        } else {
            this.hostName = RMICacheManagerPeerListener.calculateHostAddress();
        }
        if (port == null) {
            throw new IllegalArgumentException("port must be specified in the range 1025 - 65536");
        }
        this.port = port;
        this.cacheManager = cacheManager;
        if (socketTimeoutMillis == null || socketTimeoutMillis < 200) {
            throw new IllegalArgumentException("socketTimoutMillis must be a reasonable value greater than 200ms");
        }
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    private static String calculateHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public final void init() throws CacheException {
        RMICachePeer rmiCachePeer = null;
        try {
            this.startRegistry();
            this.populateListOfRemoteCachePeers();
            for (int i = 0; i < this.cachePeers.size(); ++i) {
                rmiCachePeer = (RMICachePeer)this.cachePeers.get(i);
                Naming.rebind(rmiCachePeer.getUrl(), rmiCachePeer);
            }
            LOG.debug((Object)"Server bound in registry");
        }
        catch (Exception e) {
            String url = null;
            if (rmiCachePeer != null) {
                url = rmiCachePeer.getUrl();
            }
            throw new CacheException("Problem starting listener for RMICachePeer " + url + ". Initial cause was " + e.getMessage(), e);
        }
    }

    final String[] listBoundRMICachePeers() throws CacheException {
        try {
            return this.registry.list();
        }
        catch (RemoteException e) {
            throw new CacheException("Unable to list cache peers " + e.getMessage());
        }
    }

    final Remote lookupPeer(String name) throws CacheException {
        try {
            return this.registry.lookup(name);
        }
        catch (Exception e) {
            throw new CacheException("Unable to lookup peer for replicated cache " + name + " " + e.getMessage());
        }
    }

    private void populateListOfRemoteCachePeers() throws RemoteException {
        String[] names = this.cacheManager.getCacheNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Cache cache = this.cacheManager.getCache(name);
            if (!RMICacheManagerPeerListener.isDistributed(cache)) continue;
            RMICachePeer peer = new RMICachePeer(cache, this.hostName, this.port, this.socketTimeoutMillis);
            this.cachePeers.add(peer);
        }
    }

    private static boolean isDistributed(Cache cache) {
        Set listeners = cache.getCacheEventNotificationService().getCacheEventListeners();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            if (!(cacheEventListener instanceof CacheReplicator)) continue;
            return true;
        }
        return false;
    }

    private void startRegistry() throws RemoteException {
        try {
            this.registry = LocateRegistry.getRegistry(this.port);
            try {
                this.registry.list();
            }
            catch (RemoteException e) {
                this.registry = LocateRegistry.createRegistry(this.port);
            }
        }
        catch (ExportException exception) {
            LOG.fatal((Object)("Exception starting RMI registry. Error was " + exception.getMessage()), (Throwable)exception);
        }
    }

    public final void dispose() throws CacheException {
        try {
            for (int i = 0; i < this.cachePeers.size(); ++i) {
                RMICachePeer rmiCachePeer = (RMICachePeer)this.cachePeers.get(i);
                UnicastRemoteObject.unexportObject(rmiCachePeer, false);
                Naming.unbind(rmiCachePeer.getUrl());
            }
            LOG.debug((Object)"Server unbound in registry");
        }
        catch (Exception e) {
            throw new CacheException("Problem unbinding remote cache peers. Initial cause was " + e.getMessage(), e);
        }
    }

    public final List getBoundCachePeers() {
        return this.cachePeers;
    }

    final List getCachePeers() {
        return this.cachePeers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

