/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import oracle.toplink.essentials.internal.helper.Helper;

public class PrivilegedAccessController {
    private static boolean shouldUsePrivilegedAccess = false;
    private static boolean shouldSecurityManagerBeChecked = true;

    private static Field findDeclaredField(Class javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return PrivilegedAccessController.findDeclaredField(superclass, fieldName);
        }
    }

    private static Method findMethod(Class javaClass, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        try {
            return javaClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            try {
                return PrivilegedAccessController.findMethod(superclass, methodName, methodParameterTypes);
            }
            catch (NoSuchMethodException lastEx) {
                throw ex;
            }
        }
    }

    public static Class getClassForName(final String className) throws ClassNotFoundException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Class.forName(className);
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (ClassNotFoundException)exception.getException();
            }
        }
        return Class.forName(className);
    }

    public static Class getClassForName(final String className, final boolean initialize, final ClassLoader loader) throws ClassNotFoundException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Class.forName(className, initialize, loader);
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (ClassNotFoundException)exception.getException();
            }
        }
        return Class.forName(className, initialize, loader);
    }

    public static ClassLoader getClassLoaderForClass(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    public static Constructor getConstructorFor(final Class javaClass, final Class[] args, final boolean shouldSetAccessible) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        Constructor result = javaClass.getConstructor(args);
                        if (shouldSetAccessible) {
                            result.setAccessible(true);
                        }
                        return result;
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchMethodException)exception.getException();
            }
        }
        Constructor result = javaClass.getConstructor(args);
        if (shouldSetAccessible) {
            result.setAccessible(true);
        }
        return result;
    }

    public static ClassLoader getContextClassLoader(final Thread thread) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return thread.getContextClassLoader();
                }
            });
        }
        return thread.getContextClassLoader();
    }

    public static Constructor getDeclaredConstructorFor(final Class javaClass, final Class[] args, final boolean shouldSetAccessible) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        Constructor result = javaClass.getDeclaredConstructor(args);
                        if (shouldSetAccessible) {
                            result.setAccessible(true);
                        }
                        return result;
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchMethodException)exception.getException();
            }
        }
        Constructor result = javaClass.getDeclaredConstructor(args);
        if (shouldSetAccessible) {
            result.setAccessible(true);
        }
        return result;
    }

    public static Field getField(final Class javaClass, final String fieldName, final boolean shouldSetAccessible) throws NoSuchFieldException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchFieldException {
                        Field field = PrivilegedAccessController.findDeclaredField(javaClass, fieldName);
                        if (shouldSetAccessible) {
                            field.setAccessible(true);
                        }
                        return field;
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchFieldException)exception.getException();
            }
        }
        Field field = PrivilegedAccessController.findDeclaredField(javaClass, fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getDeclaredField(final Class javaClass, final String fieldName, final boolean shouldSetAccessible) throws NoSuchFieldException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchFieldException {
                        Field field = javaClass.getDeclaredField(fieldName);
                        if (shouldSetAccessible) {
                            field.setAccessible(true);
                        }
                        return field;
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchFieldException)exception.getException();
            }
        }
        Field field = javaClass.getDeclaredField(fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field[] getDeclaredFields(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredFields();
                }
            });
        }
        return clazz.getDeclaredFields();
    }

    public static Method getDeclaredMethod(final Class clazz, final String methodName, final Class[] methodParameterTypes) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return clazz.getDeclaredMethod(methodName, methodParameterTypes);
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchMethodException)exception.getException();
            }
        }
        return clazz.getDeclaredMethod(methodName, methodParameterTypes);
    }

    public static Method getMethod(final Class javaClass, final String methodName, final Class[] methodParameterTypes, final boolean shouldSetAccessible) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        Method method = PrivilegedAccessController.findMethod(javaClass, methodName, methodParameterTypes);
                        if (shouldSetAccessible) {
                            method.setAccessible(true);
                        }
                        return method;
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchMethodException)exception.getException();
            }
        }
        Method method = PrivilegedAccessController.findMethod(javaClass, methodName, methodParameterTypes);
        if (shouldSetAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method[] getDeclaredMethods(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        return clazz.getDeclaredMethods();
    }

    public static Field[] getFields(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getFields();
                }
            });
        }
        return clazz.getFields();
    }

    public static Class getFieldType(final Field field) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return field.getType();
                }
            });
        }
        return field.getType();
    }

    public static String getLineSeparator() {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("file.separator");
                }
            });
        }
        return Helper.cr();
    }

    public static Class[] getMethodParameterTypes(final Method method) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Class[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return method.getParameterTypes();
                }
            });
        }
        return method.getParameterTypes();
    }

    public static Class getMethodReturnType(final Method method) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return method.getReturnType();
                }
            });
        }
        return method.getReturnType();
    }

    public static Method[] getMethods(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getMethods();
                }
            });
        }
        return clazz.getMethods();
    }

    public static Object getValueFromField(final Field field, final Object object) throws IllegalAccessException {
        if (shouldUsePrivilegedAccess) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException {
                        return field.get(object);
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (IllegalAccessException)exception.getException();
            }
        }
        return field.get(object);
    }

    public static int getIntValueFromField(final Field field, final Object object) throws IllegalAccessException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException {
                        return new Integer(field.getInt(object));
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (IllegalAccessException)exception.getException();
            }
        }
        return field.getInt(object);
    }

    public static Object invokeConstructor(final Constructor constructor, final Object[] args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException, InstantiationException {
                        return constructor.newInstance(args);
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                Exception throwableException = exception.getException();
                if (throwableException instanceof IllegalAccessException) {
                    throw (IllegalAccessException)throwableException;
                }
                if (throwableException instanceof InstantiationException) {
                    throw (InstantiationException)throwableException;
                }
                throw (InvocationTargetException)throwableException;
            }
        }
        return constructor.newInstance(args);
    }

    public static Object invokeMethod(final Method method, final Object object, final Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        return method.invoke(object, parameters);
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                Exception throwableException = exception.getException();
                if (throwableException instanceof IllegalAccessException) {
                    throw (IllegalAccessException)throwableException;
                }
                throw (InvocationTargetException)throwableException;
            }
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(object, parameters);
    }

    public static Object newInstanceFromClass(final Class clazz) throws IllegalAccessException, InstantiationException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InstantiationException {
                        return clazz.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                Exception throwableException = exception.getException();
                if (throwableException instanceof IllegalAccessException) {
                    throw (IllegalAccessException)throwableException;
                }
                throw (InstantiationException)throwableException;
            }
        }
        return clazz.newInstance();
    }

    public static void setValueInField(final Field field, final Object object, final Object value) throws IllegalAccessException {
        if (shouldUsePrivilegedAccess) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException {
                        field.set(object, value);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                throw (IllegalAccessException)exception.getException();
            }
        } else {
            field.set(object, value);
        }
    }

    private static boolean shouldUsePrivilegedAccess() {
        if (shouldSecurityManagerBeChecked) {
            shouldSecurityManagerBeChecked = false;
            Boolean privilegedPropertySet = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String usePrivileged = System.getProperty("oracle.j2ee.toplink.security.usedoprivileged");
                    String oc4jUsePrivileged = System.getProperty("oracle.j2ee.security.usedoprivileged");
                    boolean propertySet = usePrivileged != null && usePrivileged.equalsIgnoreCase("false") || oc4jUsePrivileged != null && oc4jUsePrivileged.equalsIgnoreCase("false");
                    return new Boolean(propertySet);
                }
            });
            shouldUsePrivilegedAccess = privilegedPropertySet != false ? false : System.getSecurityManager() != null;
        }
        return shouldUsePrivilegedAccess;
    }
}

