/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.ArrayList;
import java.util.List;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.parsing.DotNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.IdentificationVariableDeclNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SelectNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class VariableNode
extends Node {
    private String variableName;
    private String canonicalName;

    public VariableNode() {
    }

    public VariableNode(String newVariableName) {
        this.setVariableName(newVariableName);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String newVariableName) {
        this.variableName = newVariableName;
        this.canonicalName = IdentificationVariableDeclNode.calculateCanonicalName(newVariableName);
    }

    public String getCanonicalVariableName() {
        return this.canonicalName;
    }

    public boolean isVariableNode() {
        return true;
    }

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        String name = this.getCanonicalVariableName();
        ParseTreeContext context = generationContext.getParseTreeContext();
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = generationContext.expressionFor(name);
            if (expression == null || !expression.isExpressionBuilder()) {
                expression = generationContext.selectedExpressionFor(name);
            }
            if (expression == null) {
                expression = new ExpressionBuilder(this.resolveClass(generationContext));
            }
            if (generationContext.selectedExpressionFor(name) == null) {
                generationContext.addSelectedExpression(expression, name);
            }
            this.addAttribute(reportQuery, expression, generationContext);
        } else {
            Expression expression = generationContext.expressionFor(name);
            if (expression == null || !expression.isExpressionBuilder()) {
                expression = generationContext.selectedExpressionFor(name);
            }
            if (expression == null) {
                expression = new ExpressionBuilder(this.resolveClass(generationContext));
            }
            if (generationContext.selectedExpressionFor(name) == null) {
                generationContext.addSelectedExpression(expression, name);
            }
        }
    }

    private void addAttribute(ReportQuery reportQuery, Expression expression, GenerationContext context) {
        String name = this.getCanonicalVariableName();
        List fetchJoinNodes = context.getParseTreeContext().getFetchJoins(name);
        if (fetchJoinNodes == null) {
            reportQuery.addAttribute(name, expression);
        } else {
            ArrayList<Expression> fetchJoinExprs = new ArrayList<Expression>(fetchJoinNodes.size());
            for (Node node : fetchJoinNodes) {
                fetchJoinExprs.add(node.generateExpression(context));
            }
            reportQuery.addItem(name, expression, fetchJoinExprs);
        }
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        String name = this.getCanonicalVariableName();
        if (context.isRangeVariable(name)) {
            String schema = context.schemaForVariable(name);
            this.setType(typeHelper.resolveSchema(schema));
        } else {
            Node path = context.pathForVariable(name);
            if (path == null) {
                throw EJBQLException.aliasResolutionException(name);
            }
            this.setType(path.getType());
        }
        context.usedVariable(name);
        if (context.isDeclaredInOuterScope(name)) {
            context.registerOuterScopeVariable(name);
        }
    }

    public Expression generateBaseBuilderExpression(GenerationContext context) {
        if (context.useParallelExpressions()) {
            return new ExpressionBuilder(this.resolveClass(context));
        }
        return new ExpressionBuilder();
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression myExpression = null;
        String name = this.getCanonicalVariableName();
        myExpression = generationContext.expressionFor(name);
        if (myExpression != null) {
            return myExpression;
        }
        myExpression = generationContext.getParseTreeContext().isRangeVariable(name) ? this.generateBaseBuilderExpression(generationContext) : this.generateExpressionForAlias(generationContext);
        generationContext.addExpression(myExpression, name);
        return myExpression;
    }

    public Expression generateExpressionForAlias(GenerationContext context) {
        if (context.getParseTree().getQueryNode().isSelectNode() && context.shouldCheckSelectNodeBeforeResolving() && ((SelectNode)context.getParseTree().getQueryNode()).isSelected(this.getCanonicalVariableName())) {
            return new ExpressionBuilder();
        }
        Node nodeForAlias = this.getNodeForAlias(context);
        if (nodeForAlias == null) {
            throw EJBQLException.aliasResolutionException(this.getVariableName());
        }
        return nodeForAlias.generateExpression(context);
    }

    public Node getNodeForAlias(GenerationContext context) {
        return context.getParseTreeContext().pathForVariable(this.getCanonicalVariableName());
    }

    public boolean isAlias(GenerationContext context) {
        return this.isAlias(context.getParseTreeContext());
    }

    public boolean isAlias(ParseTreeContext context) {
        String classNameForAlias = context.schemaForVariable(this.getCanonicalVariableName());
        return classNameForAlias != null;
    }

    public Class resolveClass(GenerationContext generationContext) {
        Class clazz = null;
        String name = this.getCanonicalVariableName();
        ParseTreeContext context = generationContext.getParseTreeContext();
        if (context.isRangeVariable(name)) {
            String schema = context.schemaForVariable(name);
            clazz = context.classForSchemaName(schema, generationContext);
        } else {
            DotNode path = (DotNode)context.pathForVariable(name);
            if (path == null) {
                throw EJBQLException.aliasResolutionException(name);
            }
            clazz = path.resolveClass(generationContext);
        }
        return clazz;
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer();
        this.toStringIndent(indent, buffer);
        buffer.append(this.toStringDisplayName() + "[" + this.getVariableName() + "]");
        return buffer.toString();
    }

    public String getAsString() {
        return this.getVariableName();
    }
}

