/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsEntityClassListener;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsSequencingProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.queryframework.ColumnResult;
import oracle.toplink.essentials.queryframework.EJBQLPlaceHolderQuery;
import oracle.toplink.essentials.queryframework.EntityResult;
import oracle.toplink.essentials.queryframework.FieldResult;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAnnotationsProcessor
extends MetadataProcessor {
    private Collection<Class> m_classes;
    private HashSet<AnnotationsDescriptor> m_entitiesWithQueries;
    private AnnotationsSequencingProcessor m_sequencingProcessor;

    public EJBAnnotationsProcessor(AbstractSession session, ClassLoader loader, Collection<Class> classes, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_classes = classes;
        this.m_session = session;
        this.m_metadataDescriptors = new HashMap();
        this.m_validator = new AnnotationsValidator();
        this.m_logger = new AnnotationsLogger(this.m_session);
        this.m_enableLazyForOneToOne = enableLazyForOneToOne;
        this.m_sequencingProcessor = new AnnotationsSequencingProcessor();
        this.m_relatedEntities = new HashSet();
        this.m_entitiesWithQueries = new HashSet();
    }

    public EJBAnnotationsProcessor(AbstractSession session, ClassLoader loader, Collection<Class> entities, boolean enableLazyForOneToOne, HashMap<Class, MetadataDescriptor> metadataDescriptors) {
        this(session, loader, metadataDescriptors.keySet(), enableLazyForOneToOne);
        if (metadataDescriptors != null && !metadataDescriptors.isEmpty()) {
            for (MetadataDescriptor mdd : metadataDescriptors.values()) {
                AnnotationsDescriptor descriptor = new AnnotationsDescriptor(mdd);
                this.m_metadataDescriptors.put(descriptor.getJavaClass(), descriptor);
            }
        }
    }

    public void addEntityListeners(AbstractSession session, Collection<Class> entityClasses) {
        this.updateClassesInMetadata();
        for (Class entityClass : entityClasses) {
            AnnotationsDescriptor descriptor = (AnnotationsDescriptor)this.m_metadataDescriptors.get(entityClass);
            this.processExcludeDefaultListeners(descriptor);
            this.processExcludeSuperclassListeners(descriptor);
            this.processDefaultListeners(descriptor);
            this.processEntityListeners(descriptor);
            this.processEntityEventListener(descriptor);
        }
    }

    public void addNamedQueriesToSession(AbstractSession session) {
        for (AnnotationsDescriptor descriptor : this.m_entitiesWithQueries) {
            for (NamedQuery namedQuery : descriptor.getNamedQueries()) {
                this.processNamedQuery(namedQuery, descriptor, session);
            }
            for (NamedNativeQuery namedNativeQuery : descriptor.getNamedNativeQueries()) {
                this.processNamedNativeQuery(namedNativeQuery, descriptor, session);
            }
        }
    }

    protected void adjustPrimaryKeyNameOnExistingFields(MetadataDescriptor md) {
        ArrayList pkFields = (ArrayList)md.getPrimaryKeyFields();
        if (pkFields.size() <= 1) {
            this.getValidator().throwNoPrimaryKeyAnnotationsFound(md.getJavaClass());
        }
        if (pkFields.size() > 2) {
            this.getValidator().throwUnspecifiedCompositePrimaryKeyNotSupported(md.getJavaClass());
        }
        DatabaseField validPKField = (DatabaseField)pkFields.get(1);
        pkFields.remove(0);
        for (DatabaseField dbField : md.getFieldsWithDefaultPrimaryKeySet()) {
            dbField.setName(validPKField.getName());
        }
        for (DatabaseField dbField : md.getFieldsWithComplexDefaultPrimaryKeySet()) {
            String defaultFieldName = dbField.getName();
            String validFieldName = defaultFieldName.substring(0, defaultFieldName.lastIndexOf("_") + 1) + validPKField.getName();
            dbField.setName(validFieldName);
        }
    }

    protected void adjustTableOnExistingFields(MetadataDescriptor md) {
        Table table = (Table)AnnotationsHelper.getAnnotation(Table.class, md);
        if (table == null) {
            return;
        }
        this.processTable(table.name(), table.catalog(), table.schema(), table.uniqueConstraints(), md);
        for (DatabaseField dbField : md.getFieldsWithDefaultPrimaryTableSet()) {
            dbField.setTable((DatabaseTable)md.getDescriptor().getTables().elementAt(0));
        }
    }

    protected DatabaseTable buildJoinTable(JoinTable joinTable, MetadataAccessor accessor) {
        DatabaseTable dbJoinTable;
        if (joinTable != null) {
            dbJoinTable = this.buildJoinTable(joinTable.name(), joinTable.catalog(), joinTable.schema(), accessor);
            this.processUniqueConstraints(joinTable.uniqueConstraints(), dbJoinTable);
        } else {
            dbJoinTable = this.buildJoinTable(accessor);
        }
        return dbJoinTable;
    }

    public Collection<Class> getClasses() {
        return this.m_classes;
    }

    @Override
    public AnnotationsLogger getLogger() {
        return (AnnotationsLogger)this.m_logger;
    }

    @Override
    public AnnotationsDescriptor getMetadataDescriptor(Class cls) {
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)this.m_metadataDescriptors.get(cls);
        if (descriptor == null) {
            ClassDescriptor descriptorOnProject = MetadataHelper.findDescriptor(this.m_session.getProject(), cls);
            if (descriptorOnProject != null) {
                descriptor = new AnnotationsDescriptor(descriptorOnProject, cls);
            } else {
                descriptor = new AnnotationsDescriptor(cls);
                this.m_session.getProject().addDescriptor(descriptor.getDescriptor());
            }
            this.m_metadataDescriptors.put(cls, descriptor);
        }
        return descriptor;
    }

    @Override
    protected AnnotationsValidator getValidator() {
        return (AnnotationsValidator)this.m_validator;
    }

    @Override
    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataAccessor accessor, String defaultName, String context) {
    }

    @Override
    protected void handlePotentialDefaultPrimaryKeyUsage(DatabaseField dbField, MetadataDescriptor md) {
    }

    @Override
    protected boolean handlePotentialPartialOneToOneRelationshipMapping(OneToOneMapping mapping, List joinColumns) {
        return false;
    }

    @Override
    protected boolean handlePotentialPartialManyToManyRelationshipMapping(ManyToManyMapping mapping, boolean isSource, List relationKeys) {
        return false;
    }

    protected boolean isTransient(AnnotatedElement annotatedElement, int modifier, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(Transient.class, annotatedElement, descriptor)) {
            if (AnnotationsHelper.getDeclaredAnnotationsCount(annotatedElement, descriptor) > 1) {
                this.getValidator().throwMappingAnnotationsAppliedToTransientAttribute(annotatedElement);
            }
            return true;
        }
        if (Modifier.isTransient(modifier)) {
            if (AnnotationsHelper.getDeclaredAnnotationsCount(annotatedElement, descriptor) > 0) {
                this.getValidator().throwMappingAnnotationsAppliedToTransientAttribute(annotatedElement);
            }
            return true;
        }
        return false;
    }

    protected boolean isValidPersistenceElement(AnnotatedElement annotatedElement, int modifiers, AnnotationsDescriptor descriptor) {
        return !this.isTransient(annotatedElement, modifiers, descriptor) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    protected boolean isValidPersistenceField(Field field, AnnotationsDescriptor descriptor) {
        return this.isValidPersistenceElement(field, field.getModifiers(), descriptor);
    }

    protected boolean isValidPersistenceMethod(Method method, AnnotationsDescriptor descriptor) {
        String methodName;
        if (this.isValidPersistenceElement(method, method.getModifiers(), descriptor) && MetadataHelper.isValidPersistenceMethodName(methodName = method.getName())) {
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            String setMethodName = MetadataHelper.getSetMethodName(method, descriptor.getJavaClass());
            if (setMethodName == null) {
                if (AnnotationsHelper.getDeclaredAnnotationsCount(method, descriptor) > 0) {
                    this.getValidator().throwNoCorrespondingSetterMethodDefined(descriptor.getJavaClass(), method);
                }
                this.getLogger().logWarningMessage("annotation_warning_ignore_get_method", descriptor, method);
            } else {
                descriptor.addSetMethodName(methodName, setMethodName);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void populateCollectionMapping(CollectionMapping mapping, Object oneToManyAnnotation, MetadataAccessor accessor) {
        OneToMany oneToMany = (OneToMany)oneToManyAnnotation;
        boolean usesIndirection = false;
        Class targetEntity = Void.TYPE;
        CascadeType[] cascade = new CascadeType[]{};
        if (oneToMany != null) {
            usesIndirection = oneToMany.fetch() == FetchType.LAZY;
            targetEntity = oneToMany.targetEntity();
            cascade = oneToMany.cascade();
        }
        this.populateCollectionMapping(mapping, accessor, targetEntity, (Object[])cascade, usesIndirection);
    }

    @Override
    protected void preProcessGeneratedValue(Object generatedValue, MetadataAccessor accessor, DatabaseField field, MetadataDescriptor descriptor) {
        this.m_sequencingProcessor.preProcessGeneratedValue((GeneratedValue)generatedValue, (AnnotationsAccessor)accessor, field, (AnnotationsDescriptor)descriptor);
    }

    @Override
    protected void preProcessSequencing(MetadataAccessor ma) {
        AnnotationsAccessor accessor = (AnnotationsAccessor)ma;
        this.preProcessSequencing(accessor.getAnnotatedElement(), accessor.getMetadataDescriptor());
    }

    protected void preProcessSequencing(AnnotatedElement annotatedElement, AnnotationsDescriptor descriptor) {
        TableGenerator tableGenerator = (TableGenerator)AnnotationsHelper.getAnnotation(TableGenerator.class, annotatedElement, descriptor);
        this.m_sequencingProcessor.preProcessTableGenerator(tableGenerator, annotatedElement);
        SequenceGenerator sequenceGenerator = (SequenceGenerator)AnnotationsHelper.getAnnotation(SequenceGenerator.class, annotatedElement, descriptor);
        this.m_sequencingProcessor.preProcessSequenceGenerator(sequenceGenerator, annotatedElement);
    }

    protected void processAccessorFields(Class cls, AnnotationsDescriptor descriptor) {
        for (Field field : MetadataHelper.getFields(cls)) {
            if (!this.isValidPersistenceField(field, descriptor)) continue;
            this.processAccessor(new AnnotationsAccessor(field, this, descriptor));
        }
    }

    protected void processAccessorMethods(Class cls, AnnotationsDescriptor descriptor) {
        for (Method method : MetadataHelper.getDeclaredMethods(cls)) {
            if (!this.isValidPersistenceMethod(method, descriptor)) continue;
            this.processAccessor(new AnnotationsAccessor(method, this, descriptor));
        }
    }

    @Override
    protected void processAccessors(MetadataDescriptor descriptor) {
        this.processAccessors(descriptor.getJavaClass(), descriptor.usesPropertyAccess(), descriptor);
    }

    protected void processAccessors(Class cls, boolean usePropertyAccess, MetadataDescriptor md) {
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)md;
        if (usePropertyAccess) {
            this.processAccessorMethods(cls, descriptor);
        } else {
            this.processAccessorFields(cls, descriptor);
        }
        descriptor.setIsProcessed(true);
    }

    @Override
    protected void processJoinTable(MetadataAccessor accessor, ManyToManyMapping mapping) {
        JoinTable joinTable = (JoinTable)AnnotationsHelper.getAnnotation(JoinTable.class, accessor);
        DatabaseTable relationTable = this.buildJoinTable(joinTable, accessor);
        mapping.setRelationTable(relationTable);
        String relationTableName = relationTable.getQualifiedName();
        ArrayList<MetadataJoinColumn> sourceKeys = new ArrayList<MetadataJoinColumn>();
        ArrayList<MetadataJoinColumn> targetKeys = new ArrayList<MetadataJoinColumn>();
        if (joinTable != null) {
            for (JoinColumn joinColumn : joinTable.joinColumns()) {
                sourceKeys.add(this.processJoinColumn(joinColumn, accessor, relationTableName, accessor.getMetadataDescriptor()));
            }
            for (JoinColumn inverseJoinColumn : joinTable.inverseJoinColumns()) {
                targetKeys.add(this.processJoinColumn(inverseJoinColumn, accessor, relationTableName, accessor.getReferenceMetadataDescriptor()));
            }
        }
        this.processJoinTable(accessor, mapping, sourceKeys, targetKeys);
    }

    protected void processAssociationOverrides(Class cls, AnnotationsDescriptor descriptor) {
        AssociationOverride associationOverride;
        AssociationOverrides associationOverrides = (AssociationOverrides)AnnotationsHelper.getAnnotation(AssociationOverrides.class, cls, descriptor);
        if (associationOverrides != null) {
            for (AssociationOverride associationOverride2 : associationOverrides.value()) {
                descriptor.addAssociationOverride(associationOverride2.name(), associationOverride2.joinColumns());
            }
        }
        if ((associationOverride = (AssociationOverride)AnnotationsHelper.getAnnotation(AssociationOverride.class, cls, descriptor)) != null) {
            descriptor.addAssociationOverride(associationOverride.name(), associationOverride.joinColumns());
        }
    }

    @Override
    protected void processAssociationOverrides(MetadataAccessor accessor, AggregateObjectMapping mapping) {
        AssociationOverride associationOverride;
        AssociationOverrides associationOverrides = (AssociationOverrides)AnnotationsHelper.getAnnotation(AssociationOverrides.class, accessor);
        if (associationOverrides != null) {
            for (AssociationOverride associationOverride2 : associationOverrides.value()) {
                this.processAssociationOverride(associationOverride2, accessor, mapping);
            }
        }
        if ((associationOverride = (AssociationOverride)AnnotationsHelper.getAnnotation(AssociationOverride.class, accessor)) != null) {
            this.processAssociationOverride(associationOverride, accessor, mapping);
        }
    }

    protected void processAssociationOverride(AssociationOverride associationOverride, MetadataAccessor accessor, AggregateObjectMapping aggregateMapping) {
        String name;
        MetadataDescriptor descriptor = accessor.getMetadataDescriptor();
        MetadataDescriptor aggregateDescriptor = accessor.getReferenceMetadataDescriptor();
        DatabaseMapping mapping = aggregateDescriptor.getMappingForAttributeName(name = associationOverride.name());
        if (mapping == null) {
            // empty if block
        }
        if (mapping.isOneToOneMapping()) {
            int index = 0;
            for (JoinColumn joinColumn : associationOverride.joinColumns()) {
                DatabaseField fkField = (DatabaseField)((OneToOneMapping)mapping).getForeignKeyFields().elementAt(index++);
                aggregateMapping.addFieldNameTranslation(joinColumn.name(), fkField.getName());
            }
        }
    }

    protected void processAttributeOverrides(Class cls, AnnotationsDescriptor descriptor) {
        AttributeOverride attributeOverride;
        AttributeOverrides attributeOverrides = (AttributeOverrides)AnnotationsHelper.getAnnotation(AttributeOverrides.class, cls, descriptor);
        if (attributeOverrides != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrides.value()) {
                this.processAttributeOverride(attributeOverride2.name(), attributeOverride2.column(), descriptor);
            }
        }
        if ((attributeOverride = (AttributeOverride)AnnotationsHelper.getAnnotation(AttributeOverride.class, cls, descriptor)) != null) {
            this.processAttributeOverride(attributeOverride.name(), attributeOverride.column(), descriptor);
        }
    }

    @Override
    protected void processAttributeOverrides(MetadataAccessor accessor, AggregateObjectMapping mapping) {
        AttributeOverride attributeOverride;
        AttributeOverrides attributeOverrides = (AttributeOverrides)AnnotationsHelper.getAnnotation(AttributeOverrides.class, accessor);
        if (attributeOverrides != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrides.value()) {
                this.processAttributeOverride(attributeOverride2.name(), attributeOverride2.column(), accessor, mapping);
            }
        }
        if ((attributeOverride = (AttributeOverride)AnnotationsHelper.getAnnotation(AttributeOverride.class, accessor)) != null) {
            this.processAttributeOverride(attributeOverride.name(), attributeOverride.column(), accessor, mapping);
        }
    }

    @Override
    protected void processBasic(MetadataAccessor accessor, DirectToFieldMapping mapping) {
        Basic basic = (Basic)AnnotationsHelper.getAnnotation(Basic.class, accessor);
        if (basic != null) {
            if (basic.fetch() == FetchType.LAZY) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_basic_fetch_lazy", accessor);
            }
            mapping.setIsOptional(basic.optional());
        }
    }

    protected void processCallbackMethods(Method[] candidateMethods, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        for (Method method : candidateMethods) {
            this.processPostLoad(method, listener, descriptor);
            this.processPostPersist(method, listener, descriptor);
            this.processPostRemove(method, listener, descriptor);
            this.processPostUpdate(method, listener, descriptor);
            this.processPrePersist(method, listener, descriptor);
            this.processPreRemove(method, listener, descriptor);
            this.processPreUpdate(method, listener, descriptor);
        }
    }

    @Override
    protected void processCascadeType(MetadataAccessor accessor, Object[] types, ForeignReferenceMapping mapping) {
        CascadeType[] cTypes;
        for (CascadeType type : cTypes = (CascadeType[])types) {
            this.setCascadeType(type.name(), mapping);
        }
        if (accessor.getMetadataDescriptor().isCascadePersistSet().booleanValue() && !mapping.isCascadePersist()) {
            this.setCascadeType("PERSIST", mapping);
        }
    }

    protected DatabaseField processColumn(Column column, AnnotatedElement annotatedElement, String attributeName, AnnotationsDescriptor descriptor) {
        return this.processColumn(attributeName, column.name(), column.columnDefinition(), column.table(), column.unique(), column.nullable(), column.insertable(), column.updatable(), column.length(), column.precision(), column.scale(), annotatedElement, descriptor);
    }

    @Override
    protected DatabaseField processColumn(MetadataAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getMetadataDescriptor();
        String attributeName = accessor.getAttributeName();
        AnnotatedElement annotatedElement = (AnnotatedElement)accessor.getAnnotatedElement();
        Column column = (Column)AnnotationsHelper.getAnnotation(Column.class, accessor);
        if (column == null) {
            return this.processColumnDefaults(attributeName, descriptor, annotatedElement);
        }
        return this.processColumn((Object)column, (Object)annotatedElement, attributeName, descriptor);
    }

    @Override
    protected DatabaseField processColumn(Object column, Object annotatedElement, String attributeName, MetadataDescriptor descriptor) {
        return this.processColumn((Column)column, (AnnotatedElement)annotatedElement, attributeName, (AnnotationsDescriptor)descriptor);
    }

    protected void processDefaultListeners(AnnotationsDescriptor descriptor) {
        for (MetadataEntityListener defaultListener : descriptor.getDefaultEventListeners()) {
            defaultListener.initializeCallbackMethods(this.m_loader);
            this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForDefaultListener(defaultListener), defaultListener, descriptor);
        }
    }

    protected void processDiscriminatorColumn(AnnotationsDescriptor descriptor) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)AnnotationsHelper.getAnnotation(DiscriminatorColumn.class, descriptor);
        int length = 31;
        String name = "";
        String columnDefinition = "";
        String discriminatorType = "STRING";
        if (discriminatorColumn != null) {
            name = discriminatorColumn.name();
            discriminatorType = discriminatorColumn.discriminatorType().toString();
            columnDefinition = discriminatorColumn.columnDefinition();
            length = discriminatorColumn.length();
        }
        this.processDiscriminatorColumn(name, columnDefinition, length, discriminatorType, descriptor);
    }

    @Override
    protected void processDiscriminatorValue(MetadataDescriptor descriptor) {
        DiscriminatorValue discriminatorValue = (DiscriminatorValue)AnnotationsHelper.getAnnotation(DiscriminatorValue.class, descriptor);
        String value = discriminatorValue == null ? null : discriminatorValue.value();
        this.processDiscriminatorValue(value, descriptor);
    }

    protected void processMappedSuperclasses(AnnotationsDescriptor descriptor) {
        for (Class mappedSuperclass : (ArrayList)descriptor.getMappedSuperclasses()) {
            this.processNamedQueries(mappedSuperclass, descriptor);
            this.processNamedNativeQueries(mappedSuperclass, descriptor);
            this.processSqlResultSetMappings(mappedSuperclass, descriptor);
            this.processAccessors(mappedSuperclass, descriptor.usesPropertyAccess(), descriptor);
            this.processAttributeOverrides(mappedSuperclass, descriptor);
        }
    }

    @Override
    protected void processEntityClass(Class cls) {
        String entityName = "";
        AnnotationsDescriptor descriptor = null;
        if (AnnotationsHelper.shouldIgnoreAnnotations(cls, this.m_metadataDescriptors)) {
            descriptor = this.getMetadataDescriptor(cls);
        } else {
            Entity entity = (Entity)AnnotationsHelper.getAnnotation(Entity.class, cls);
            if (entity != null) {
                entityName = entity.name();
                descriptor = this.getMetadataDescriptor(cls);
            }
        }
        if (descriptor != null && !descriptor.isProcessed()) {
            descriptor.setIgnoreFlags();
            this.processEntity(entityName, descriptor);
            this.processNamedQueries(descriptor);
            this.processNamedNativeQueries(descriptor);
            this.processSqlResultSetMappings(descriptor);
            this.preProcessSequencing(cls, descriptor);
            this.processTable(descriptor);
            this.processIdClass(descriptor);
            this.processAttributeOverrides(cls, descriptor);
            this.processAssociationOverrides(cls, descriptor);
            this.processMappedSuperclasses(descriptor);
            this.processAccessors(descriptor);
            if (descriptor.isDefaultPrimaryKeySet()) {
                this.adjustPrimaryKeyNameOnExistingFields(descriptor);
            }
            if (descriptor.hasCompositePrimaryKey()) {
                if (descriptor.pkClassWasNotValidated()) {
                    this.getValidator().throwInvalidCompositePKSpecification(cls, descriptor.getPKClassName());
                }
            } else if (!descriptor.hasPrimaryKeyFields() && !descriptor.isInheritanceSubclass()) {
                this.getValidator().throwNoPrimaryKeyAnnotationsFound(cls);
            }
            this.processSecondaryTables(descriptor);
        }
    }

    protected void processEntityEventListener(AnnotationsDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        if (descriptor.hasEntityEventListener()) {
            MetadataEntityListener entityEventListener = descriptor.getEntityEventListener();
            entityEventListener.initializeCallbackMethods(this.m_loader);
        } else {
            AnnotationsEntityClassListener listener = new AnnotationsEntityClassListener(entityClass);
            for (Class mappedSuperclass : (ArrayList)descriptor.getMappedSuperclasses()) {
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForMappedSuperclass(mappedSuperclass, entityClass), listener, descriptor);
            }
            this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityClass(entityClass), listener, descriptor);
            if (listener.hasCallbackMethods()) {
                descriptor.setEntityEventListener(listener);
            }
        }
    }

    protected void processEntityListeners(AnnotationsDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        if (descriptor.hasEntityListenerEventListeners()) {
            for (MetadataEntityListener entityListener : descriptor.getEntityListenerEventListeners()) {
                entityListener.initializeCallbackMethods(this.m_loader);
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(entityListener), entityListener, descriptor);
            }
        } else if (AnnotationsHelper.isAnnotationPresent(EntityListeners.class, descriptor)) {
            if (!descriptor.excludeSuperclassListeners()) {
                List mappedSuperclasses = descriptor.getMappedSuperclasses();
                int mappedSuperclassesSize = mappedSuperclasses.size();
                for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                    Class mappedSuperclass = (Class)mappedSuperclasses.get(i);
                    EntityListeners entityListeners = (EntityListeners)AnnotationsHelper.getAnnotation(EntityListeners.class, mappedSuperclass, descriptor);
                    this.processEntityListeners(entityListeners, entityClass, descriptor);
                }
            }
            EntityListeners entityListeners = (EntityListeners)AnnotationsHelper.getAnnotation(EntityListeners.class, descriptor);
            this.processEntityListeners(entityListeners, entityClass, descriptor);
        }
    }

    protected void processEntityListeners(EntityListeners entityListeners, Class entityClass, AnnotationsDescriptor descriptor) {
        if (entityListeners != null) {
            for (Class entityListener : entityListeners.value()) {
                MetadataEntityListener listener = new MetadataEntityListener(entityListener, entityClass);
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener), listener, descriptor);
                descriptor.addEntityListenerEventListener(listener);
            }
        }
    }

    @Override
    protected void processEnumerated(MetadataAccessor accessor, DirectToFieldMapping mapping) {
        boolean isOrdinal = true;
        if (accessor.hasEnumerated()) {
            Enumerated enumerated = (Enumerated)AnnotationsHelper.getAnnotation(Enumerated.class, accessor);
            isOrdinal = enumerated.value() == EnumType.ORDINAL;
        }
        this.processEnumerated(accessor, isOrdinal, mapping);
    }

    protected void processExcludeDefaultListeners(AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(ExcludeDefaultListeners.class, descriptor)) {
            descriptor.setExcludeDefaultListeners(true);
        }
    }

    protected void processExcludeSuperclassListeners(AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(ExcludeSuperclassListeners.class, descriptor)) {
            descriptor.setExcludeSuperclassListeners(true);
        }
    }

    @Override
    protected void processId(MetadataAccessor accessor, DatabaseField field) {
        Id id = (Id)AnnotationsHelper.getAnnotation(Id.class, accessor);
        if (id != null) {
            this.processId(accessor, field, AnnotationsHelper.getAnnotation(GeneratedValue.class, accessor));
        }
    }

    protected void processIdClass(AnnotationsDescriptor descriptor) {
        IdClass idClass = (IdClass)AnnotationsHelper.getAnnotation(IdClass.class, descriptor);
        if (idClass != null) {
            this.processIdClass(idClass.value(), descriptor);
        }
    }

    @Override
    protected void processInheritanceRoot(MetadataDescriptor metadataDescriptor) {
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)metadataDescriptor;
        Inheritance inheritance = (Inheritance)AnnotationsHelper.getAnnotation(Inheritance.class, descriptor);
        if (inheritance != null || descriptor.isInheritanceRoot()) {
            if (descriptor.ignoreInheritanceAnnotations()) {
                this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_INHERITANCE, descriptor);
            } else {
                String inheritanceStrategy = inheritance == null ? "SINGLE_TABLE" : inheritance.strategy().toString();
                descriptor.setInheritanceStrategy(inheritanceStrategy);
                this.processDiscriminatorColumn(descriptor);
                this.processDiscriminatorValue(descriptor);
            }
        }
    }

    protected MetadataJoinColumn processJoinColumn(JoinColumn joinColumn, MetadataAccessor accessor, String targetTable, MetadataDescriptor sourceDescriptor) {
        return this.processJoinColumn(accessor, targetTable, sourceDescriptor, joinColumn.name(), joinColumn.referencedColumnName(), joinColumn.columnDefinition(), joinColumn.table(), joinColumn.unique(), joinColumn.nullable(), joinColumn.insertable(), joinColumn.updatable());
    }

    @Override
    protected ArrayList<MetadataJoinColumn> processJoinColumns(MetadataAccessor ma) {
        ArrayList<MetadataJoinColumn> allJoinColumns = new ArrayList<MetadataJoinColumn>();
        AnnotationsAccessor accessor = (AnnotationsAccessor)ma;
        AnnotationsDescriptor descriptor = accessor.getMetadataDescriptor();
        String targetTableName = descriptor.getPrimaryTableName();
        MetadataDescriptor referenceDescriptor = accessor.getReferenceMetadataDescriptor();
        String sourceTableName = referenceDescriptor.getPrimaryTableName();
        if (referenceDescriptor.hasCompositePrimaryKey()) {
            JoinColumn[] joinColumns = new JoinColumn[]{};
            if (descriptor.hasAssociationOverrideFor(accessor)) {
                joinColumns = (JoinColumn[])descriptor.getAssociationOverrideFor(accessor);
            } else {
                JoinColumns jcs = (JoinColumns)AnnotationsHelper.getAnnotation(JoinColumns.class, accessor);
                if (jcs == null) {
                    this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
                } else {
                    joinColumns = jcs.value();
                }
            }
            if (joinColumns.length != referenceDescriptor.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
            }
            for (JoinColumn joinColumn : joinColumns) {
                allJoinColumns.add(this.processJoinColumn(joinColumn, accessor, targetTableName, referenceDescriptor));
            }
        } else {
            JoinColumn joinColumn = descriptor.hasAssociationOverrideFor(accessor) ? ((JoinColumn[])descriptor.getAssociationOverrideFor(accessor))[0] : (JoinColumn)AnnotationsHelper.getAnnotation(JoinColumn.class, accessor);
            if (joinColumn == null) {
                if (accessor.hasJoinColumns()) {
                    this.getValidator().throwExcessiveJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
                }
                this.addJoinColumnDefault(allJoinColumns, sourceTableName, targetTableName, descriptor);
            } else {
                allJoinColumns.add(this.processJoinColumn(joinColumn, accessor, targetTableName, referenceDescriptor));
            }
        }
        return allJoinColumns;
    }

    @Override
    protected void processManyToMany(MetadataAccessor accessor) {
        ManyToMany manyToMany = (ManyToMany)AnnotationsHelper.getAnnotation(ManyToMany.class, accessor);
        this.processManyToMany(accessor, manyToMany.targetEntity(), (Object[])manyToMany.cascade(), manyToMany.fetch() == FetchType.LAZY, manyToMany.mappedBy());
    }

    @Override
    protected void processManyToOne(MetadataAccessor accessor) {
        ManyToOne manyToOne = (ManyToOne)AnnotationsHelper.getAnnotation(ManyToOne.class, accessor);
        this.processManyToOne(accessor, manyToOne.targetEntity(), (Object[])manyToOne.cascade(), manyToOne.fetch() == FetchType.LAZY, manyToOne.optional());
    }

    @Override
    protected String processMapKey(MetadataAccessor accessor, CollectionMapping mapping) {
        MapKey mapKey = (MapKey)AnnotationsHelper.getAnnotation(MapKey.class, accessor);
        String mapKeyName = mapKey == null ? "" : mapKey.name();
        return this.processMapKey(accessor, mapping, mapKeyName);
    }

    protected void processNamedNativeQueries(AnnotationsDescriptor descriptor) {
        this.processNamedNativeQueries(descriptor.getJavaClass(), descriptor);
    }

    protected void processNamedNativeQueries(Class entityClass, AnnotationsDescriptor descriptor) {
        NamedNativeQuery namedNativeQuery;
        NamedNativeQueries namedNativeQueries = (NamedNativeQueries)AnnotationsHelper.getAnnotation(NamedNativeQueries.class, entityClass, descriptor);
        if (namedNativeQueries != null) {
            for (NamedNativeQuery namedNativeQuery2 : namedNativeQueries.value()) {
                descriptor.addNamedNativeQuery(namedNativeQuery2);
            }
            this.m_entitiesWithQueries.add(descriptor);
        }
        if ((namedNativeQuery = (NamedNativeQuery)AnnotationsHelper.getAnnotation(NamedNativeQuery.class, entityClass, descriptor)) != null) {
            descriptor.addNamedNativeQuery(namedNativeQuery);
            this.m_entitiesWithQueries.add(descriptor);
        }
    }

    protected void processNamedNativeQuery(NamedNativeQuery namedNativeQuery, AnnotationsDescriptor descriptor, AbstractSession session) {
        String name = namedNativeQuery.name();
        if (session.getQuery(name) != null) {
            this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_QUERY, descriptor, name);
        } else {
            String queryString = namedNativeQuery.query();
            HashMap<String, String> hints = this.processQueryHints(namedNativeQuery.hints());
            Class resultClass = namedNativeQuery.resultClass();
            if (resultClass != Void.TYPE) {
                resultClass = MetadataHelper.getClassForName(resultClass.getName(), this.m_loader);
                session.addQuery(name, EJBQueryImpl.buildSQLDatabaseQuery(resultClass, queryString, hints));
                return;
            }
            String resultSetMapping = namedNativeQuery.resultSetMapping();
            if (!resultSetMapping.equals("")) {
                session.addQuery(name, EJBQueryImpl.buildSQLDatabaseQuery(resultSetMapping, queryString, hints));
                return;
            }
            session.addQuery(name, EJBQueryImpl.buildSQLDatabaseQuery(queryString, hints));
        }
    }

    protected void processNamedQueries(AnnotationsDescriptor descriptor) {
        this.processNamedQueries(descriptor.getJavaClass(), descriptor);
    }

    protected void processNamedQueries(Class entityClass, AnnotationsDescriptor descriptor) {
        NamedQuery namedQuery;
        NamedQueries namedQueries = (NamedQueries)AnnotationsHelper.getAnnotation(NamedQueries.class, entityClass, descriptor);
        if (namedQueries != null) {
            for (NamedQuery namedQuery2 : namedQueries.value()) {
                descriptor.addNamedQuery(namedQuery2);
            }
            this.m_entitiesWithQueries.add(descriptor);
        }
        if ((namedQuery = (NamedQuery)AnnotationsHelper.getAnnotation(NamedQuery.class, entityClass, descriptor)) != null) {
            descriptor.addNamedQuery(namedQuery);
            this.m_entitiesWithQueries.add(descriptor);
        }
    }

    protected void processNamedQuery(NamedQuery namedQuery, AnnotationsDescriptor descriptor, AbstractSession session) {
        String name = namedQuery.name();
        if (session.getQuery(name) != null) {
            this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_QUERY, descriptor, name);
        } else {
            try {
                String queryString = namedQuery.query();
                HashMap<String, String> hints = this.processQueryHints(namedQuery.hints());
                session.addEjbqlPlaceHolderQuery(new EJBQLPlaceHolderQuery(name, queryString, hints));
            }
            catch (Exception exception) {
                this.getValidator().throwErrorProcessingNamedQueryAnnotation(descriptor.getJavaClass(), name, exception);
            }
        }
    }

    @Override
    protected void processOneToMany(MetadataAccessor accessor) {
        OneToMany oneToMany = (OneToMany)AnnotationsHelper.getAnnotation(OneToMany.class, accessor);
        String mappedBy = "";
        if (oneToMany != null) {
            mappedBy = oneToMany.mappedBy();
        }
        this.processOneToMany(accessor, oneToMany, mappedBy);
    }

    @Override
    protected void processOneToOne(MetadataAccessor accessor) {
        OneToOne oneToOne = (OneToOne)AnnotationsHelper.getAnnotation(OneToOne.class, accessor);
        String mappedBy = "";
        Class targetEntity = Void.TYPE;
        CascadeType[] cascade = new CascadeType[]{};
        boolean optional = true;
        boolean usesIndirection = false;
        if (oneToOne != null) {
            targetEntity = oneToOne.targetEntity();
            cascade = oneToOne.cascade();
            usesIndirection = oneToOne.fetch() == FetchType.LAZY;
            optional = oneToOne.optional();
            mappedBy = oneToOne.mappedBy();
        }
        this.processOneToOne(accessor, targetEntity, (Object[])cascade, usesIndirection, optional, mappedBy);
    }

    public AbstractSession processORAnnotations() {
        for (Class cls : this.m_classes) {
            this.processEntityClass(cls);
        }
        this.m_sequencingProcessor.process(this.m_session.getProject().getLogin());
        for (AnnotationsDescriptor descriptor : this.m_relatedEntities) {
            this.processRelatedEntity(descriptor);
        }
        Map aliasDescriptors = this.m_session.getProject().getAliasDescriptors();
        if (aliasDescriptors != null) {
            aliasDescriptors.remove("");
        }
        return this.m_session;
    }

    @Override
    protected void processOrderBy(MetadataAccessor accessor, CollectionMapping mapping) {
        OrderBy orderBy = (OrderBy)AnnotationsHelper.getAnnotation(OrderBy.class, accessor);
        if (orderBy != null) {
            this.processOrderBy(accessor, mapping, orderBy.value());
        }
    }

    protected void processPostLoad(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostLoad.class, method, descriptor)) {
            listener.setPostBuildMethod(method);
            listener.setPostCloneMethod(method);
            listener.setPostRefreshMethod(method);
        }
    }

    protected void processPostPersist(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostPersist.class, method, descriptor)) {
            listener.setPostInsertMethod(method);
        }
    }

    protected void processPostRemove(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostRemove.class, method, descriptor)) {
            listener.setPostDeleteMethod(method);
        }
    }

    protected void processPostUpdate(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PostUpdate.class, method, descriptor)) {
            listener.setPostUpdateMethod(method);
        }
    }

    protected void processPrePersist(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PrePersist.class, method, descriptor)) {
            listener.setPrePersistMethod(method);
        }
    }

    protected void processPreRemove(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PreRemove.class, method, descriptor)) {
            listener.setPreRemoveMethod(method);
        }
    }

    protected void processPreUpdate(Method method, MetadataEntityListener listener, AnnotationsDescriptor descriptor) {
        if (AnnotationsHelper.isAnnotationPresent(PreUpdate.class, method, descriptor)) {
            listener.setPreUpdateWithChangesMethod(method);
        }
    }

    @Override
    protected ArrayList<MetadataJoinColumn> processPrimaryKeyJoinColumns(Object[] primaryKeyJoinColumns, String sourceTableName, String targetTableName, MetadataDescriptor descriptor) {
        ArrayList<MetadataJoinColumn> metadataJoinColumns = new ArrayList<MetadataJoinColumn>();
        for (PrimaryKeyJoinColumn primaryKeyJoinColumn : (PrimaryKeyJoinColumn[])primaryKeyJoinColumns) {
            metadataJoinColumns.add(this.processPrimaryKeyJoinColumn(primaryKeyJoinColumn.name(), primaryKeyJoinColumn.referencedColumnName(), primaryKeyJoinColumn.columnDefinition(), sourceTableName, targetTableName, descriptor));
        }
        return metadataJoinColumns;
    }

    @Override
    protected ArrayList<MetadataJoinColumn> processPrimaryKeyJoinColumns(String sourceTableName, String targetTableName, Object element, MetadataDescriptor md) {
        ArrayList<MetadataJoinColumn> allPrimaryKeyJoinColumns = new ArrayList<MetadataJoinColumn>();
        AnnotatedElement annotatedElement = (AnnotatedElement)element;
        AnnotationsDescriptor descriptor = (AnnotationsDescriptor)md;
        if (descriptor.hasCompositePrimaryKey()) {
            PrimaryKeyJoinColumns primaryKeyJoinColumns = (PrimaryKeyJoinColumns)AnnotationsHelper.getAnnotation(PrimaryKeyJoinColumns.class, annotatedElement, descriptor);
            if (primaryKeyJoinColumns == null || primaryKeyJoinColumns.value().length != descriptor.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(annotatedElement);
            }
            for (PrimaryKeyJoinColumn primaryKeyJoinColumn : primaryKeyJoinColumns.value()) {
                allPrimaryKeyJoinColumns.add(this.processPrimaryKeyJoinColumn(primaryKeyJoinColumn.name(), primaryKeyJoinColumn.referencedColumnName(), primaryKeyJoinColumn.columnDefinition(), sourceTableName, targetTableName, descriptor));
            }
        } else {
            PrimaryKeyJoinColumn primaryKeyJoinColumn = (PrimaryKeyJoinColumn)AnnotationsHelper.getAnnotation(PrimaryKeyJoinColumn.class, annotatedElement, descriptor);
            if (primaryKeyJoinColumn == null) {
                if (descriptor.hasPrimaryKeyJoinColumns()) {
                    this.getValidator().throwExcessivePrimaryKeyJoinColumnsSpecified(annotatedElement);
                }
                this.addJoinColumnDefault(allPrimaryKeyJoinColumns, sourceTableName, targetTableName, descriptor);
            } else {
                allPrimaryKeyJoinColumns.add(this.processPrimaryKeyJoinColumn(primaryKeyJoinColumn.name(), primaryKeyJoinColumn.referencedColumnName(), primaryKeyJoinColumn.columnDefinition(), sourceTableName, targetTableName, descriptor));
            }
        }
        return allPrimaryKeyJoinColumns;
    }

    protected HashMap<String, String> processQueryHints(QueryHint[] queryHints) {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (QueryHint queryHint : queryHints) {
            hm.put(queryHint.name(), queryHint.value());
        }
        return hm;
    }

    protected void processRelatedEntity(AnnotationsDescriptor descriptor) {
        if (descriptor.isInheritanceSubclass()) {
            this.processInheritanceSubclass(descriptor);
        }
        for (MetadataAccessor accessor : descriptor.getRelationshipAccessors()) {
            this.processRelationshipAccessor(accessor);
        }
    }

    protected void processSecondaryTable(SecondaryTable secondaryTable, AnnotationsDescriptor descriptor) {
        if (descriptor.ignoreTableAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_secondary_table", descriptor, secondaryTable.name());
        } else {
            this.processSecondaryTable(secondaryTable.name(), secondaryTable.catalog(), secondaryTable.schema(), secondaryTable.uniqueConstraints(), secondaryTable.pkJoinColumns(), descriptor);
        }
    }

    protected void processSecondaryTables(AnnotationsDescriptor descriptor) {
        SecondaryTables secondaryTables = (SecondaryTables)AnnotationsHelper.getAnnotation(SecondaryTables.class, descriptor);
        if (secondaryTables != null) {
            for (SecondaryTable secondaryTable : secondaryTables.value()) {
                this.processSecondaryTable(secondaryTable, descriptor);
            }
        } else {
            SecondaryTable secondaryTable = (SecondaryTable)AnnotationsHelper.getAnnotation(SecondaryTable.class, descriptor);
            if (secondaryTable != null) {
                this.processSecondaryTable(secondaryTable, descriptor);
            }
        }
    }

    protected void processSqlResultSetMapping(SqlResultSetMapping sqlResultSetMapping) {
        SQLResultSetMapping mapping = new SQLResultSetMapping(sqlResultSetMapping.name());
        for (javax.persistence.EntityResult entityResult : sqlResultSetMapping.entities()) {
            Class entityClass = entityResult.entityClass();
            EntityResult eResult = new EntityResult(entityClass.getName());
            for (javax.persistence.FieldResult fieldResult : entityResult.fields()) {
                eResult.addFieldResult(new FieldResult(fieldResult.name(), fieldResult.column()));
            }
            eResult.setDiscriminatorColumn(entityResult.discriminatorColumn());
            mapping.addResult(eResult);
        }
        for (Annotation annotation : sqlResultSetMapping.columns()) {
            mapping.addResult(new ColumnResult(annotation.name()));
        }
        this.m_session.getProject().addSQLResultSetMapping(mapping);
    }

    protected void processSqlResultSetMappings(AnnotationsDescriptor descriptor) {
        this.processSqlResultSetMappings(descriptor.getJavaClass(), descriptor);
    }

    protected void processSqlResultSetMappings(Class entityClass, AnnotationsDescriptor descriptor) {
        SqlResultSetMappings sqlResultSetMappings = (SqlResultSetMappings)AnnotationsHelper.getAnnotation(SqlResultSetMappings.class, entityClass, descriptor);
        if (sqlResultSetMappings != null) {
            for (SqlResultSetMapping sqlResultSetMapping : sqlResultSetMappings.value()) {
                this.processSqlResultSetMapping(sqlResultSetMapping);
            }
        } else {
            SqlResultSetMapping sqlResultSetMapping = (SqlResultSetMapping)AnnotationsHelper.getAnnotation(SqlResultSetMapping.class, entityClass, descriptor);
            if (sqlResultSetMapping != null) {
                this.processSqlResultSetMapping(sqlResultSetMapping);
            }
        }
    }

    protected void processTable(MetadataDescriptor md) {
        if (md.isDefaultPrimaryTableSet()) {
            this.adjustTableOnExistingFields(md);
        } else if (md.ignoreTableAnnotations()) {
            this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_TABLE, md);
        } else {
            Table table = (Table)AnnotationsHelper.getAnnotation(Table.class, md);
            if (table != null) {
                this.processTable(table.name(), table.catalog(), table.schema(), table.uniqueConstraints(), md);
            } else {
                this.processDefaultTable(md);
            }
        }
    }

    @Override
    protected void processTemporal(MetadataAccessor accessor, DirectToFieldMapping mapping) {
        Temporal temporal = (Temporal)AnnotationsHelper.getAnnotation(Temporal.class, accessor);
        if (temporal == null) {
            this.getValidator().throwNoTemporalTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName());
        } else {
            this.processTemporal(accessor, temporal.value().name(), mapping);
        }
    }

    @Override
    protected void processUniqueConstraints(Object[] constraints, DatabaseTable table) {
        for (UniqueConstraint uniqueConstraint : (UniqueConstraint[])constraints) {
            String[] columnNames = uniqueConstraint.columnNames();
            table.addUniqueConstraint(columnNames);
        }
    }

    public void setClasses(Collection<Class> classes) {
        this.m_classes = classes;
    }
}

