/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.reflect.AnnotatedElement;
import java.util.Hashtable;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.sequencing.QuerySequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.sessions.DatasourceLogin;

public class AnnotationsSequencingProcessor {
    public static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    public static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    public static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private Hashtable<String, SequenceGenerator> m_sequenceGenerators;
    private Hashtable<String, TableGenerator> m_tableGenerators = new Hashtable();
    private Hashtable<AnnotationsDescriptor, GeneratedValue> m_generatedValues;
    private Hashtable<Object, AnnotatedElement> m_annotatedElements;

    public AnnotationsSequencingProcessor() {
        this.m_sequenceGenerators = new Hashtable();
        this.m_generatedValues = new Hashtable();
        this.m_annotatedElements = new Hashtable();
    }

    protected void checkForConflict(GeneratedValue obj1, GeneratedValue obj2) {
        GenerationType type2;
        if (!obj1.generator().equals(obj2.generator())) {
            return;
        }
        if (obj1.generator().equals("")) {
            return;
        }
        GenerationType type1 = obj1.strategy();
        if (type1.equals((Object)(type2 = obj2.strategy()))) {
            return;
        }
        if (type1.equals((Object)GenerationType.IDENTITY) && type2.equals((Object)GenerationType.SEQUENCE) || type2.equals((Object)GenerationType.IDENTITY) && type1.equals((Object)GenerationType.SEQUENCE)) {
            return;
        }
        this.throwConflictException(obj1, obj2);
    }

    protected void checkForConflict(SequenceGenerator obj1, SequenceGenerator obj2) {
        boolean sequenceConflict;
        boolean nameConflict = obj1.name().equals(obj2.name());
        boolean bl = sequenceConflict = obj1.sequenceName().equals(obj2.sequenceName()) && obj1.allocationSize() != obj2.allocationSize();
        if (nameConflict || sequenceConflict) {
            this.throwConflictException(obj1, obj2);
        }
    }

    protected void checkForConflict(SequenceGenerator obj1, TableGenerator obj2) {
        this.checkForConflict(obj2, obj1);
    }

    protected void checkForConflict(TableGenerator obj1, SequenceGenerator obj2) {
        boolean nameConflict = obj1.name().equals(obj2.name());
        boolean sequenceConflict = obj1.pkColumnValue().equals(obj2.sequenceName());
        if (nameConflict || sequenceConflict) {
            this.throwConflictException(obj1, obj2);
        }
    }

    protected void checkForConflict(TableGenerator obj1, TableGenerator obj2) {
        boolean sequenceConflict;
        boolean tableConflict;
        boolean nameConflict = obj1.name().equals(obj2.name());
        if (nameConflict) {
            this.throwConflictException(obj1, obj2);
        }
        boolean bl = tableConflict = obj1.table().equals(obj2.table()) && (!obj1.pkColumnName().equals(obj2.pkColumnName()) || !obj1.valueColumnName().equals(obj2.valueColumnName()));
        if (tableConflict) {
            this.throwConflictException(obj1, obj2);
        }
        boolean bl2 = sequenceConflict = obj1.pkColumnValue().equals(obj2.pkColumnValue()) && (obj1.initialValue() != obj2.initialValue() || obj1.allocationSize() != obj2.allocationSize());
        if (sequenceConflict) {
            this.throwConflictException(obj1, obj2);
        }
    }

    public static String getFullName(AnnotatedElement annotatedElement, Object annotation) {
        return annotatedElement.toString() + annotation.toString();
    }

    protected String getFullName(Object annotation) {
        return AnnotationsSequencingProcessor.getFullName(this.m_annotatedElements.get(annotation), annotation);
    }

    public void preProcessGeneratedValue(GeneratedValue generatedValue, AnnotationsAccessor accessor, DatabaseField field, AnnotationsDescriptor dmd) {
        AnnotatedElement annotatedElement = accessor.getAnnotatedElement();
        if (generatedValue != null) {
            this.m_annotatedElements.put(generatedValue, annotatedElement);
            String generatorName = generatedValue.generator();
            GenerationType generatorType = generatedValue.strategy();
            if (generatorType == GenerationType.AUTO && !generatorName.equals("")) {
                throw ValidationException.idAnnotationCannotSpecifyGenerator(AnnotationsSequencingProcessor.getFullName(annotatedElement, generatedValue), generatorType.toString());
            }
            dmd.setSequenceNumberField(field);
            for (GeneratedValue other : this.m_generatedValues.values()) {
                this.checkForConflict(other, generatedValue);
            }
            this.m_generatedValues.put(dmd, generatedValue);
        }
    }

    public void preProcessSequenceGenerator(SequenceGenerator sequenceGenerator, AnnotatedElement annotatedElement) {
        if (sequenceGenerator != null) {
            this.m_annotatedElements.put(sequenceGenerator, annotatedElement);
            String generatorName = sequenceGenerator.name();
            if (generatorName.equals(DEFAULT_TABLE_GENERATOR)) {
                throw ValidationException.reservedName(AnnotationsSequencingProcessor.getFullName(annotatedElement, sequenceGenerator), DEFAULT_TABLE_GENERATOR, TableGenerator.class.getName());
            }
            SequenceGenerator otherSequenceGenerator = this.m_sequenceGenerators.get(generatorName);
            if (otherSequenceGenerator != null && otherSequenceGenerator.equals(sequenceGenerator)) {
                return;
            }
            for (SequenceGenerator sequenceGenerator2 : this.m_sequenceGenerators.values()) {
                this.checkForConflict(sequenceGenerator2, sequenceGenerator);
            }
            for (TableGenerator tableGenerator : this.m_tableGenerators.values()) {
                this.checkForConflict(tableGenerator, sequenceGenerator);
            }
            this.m_sequenceGenerators.put(generatorName, sequenceGenerator);
        }
    }

    public void preProcessTableGenerator(TableGenerator tableGenerator, AnnotatedElement annotatedElement) {
        if (tableGenerator != null) {
            this.m_annotatedElements.put(tableGenerator, annotatedElement);
            String generatorName = tableGenerator.name();
            if (generatorName.equals(DEFAULT_SEQUENCE_GENERATOR)) {
                throw ValidationException.reservedName(AnnotationsSequencingProcessor.getFullName(annotatedElement, tableGenerator), DEFAULT_SEQUENCE_GENERATOR, SequenceGenerator.class.getName());
            }
            TableGenerator otherTableGenerator = this.m_tableGenerators.get(generatorName);
            if (otherTableGenerator != null && otherTableGenerator.equals(tableGenerator)) {
                return;
            }
            for (TableGenerator tableGenerator2 : this.m_tableGenerators.values()) {
                this.checkForConflict(tableGenerator2, tableGenerator);
            }
            for (SequenceGenerator sequenceGenerator : this.m_sequenceGenerators.values()) {
                this.checkForConflict(sequenceGenerator, tableGenerator);
            }
            this.m_tableGenerators.put(generatorName, tableGenerator);
        }
    }

    public void process(DatasourceLogin login) {
        Sequence sequence;
        String seqName;
        if (this.m_generatedValues.isEmpty()) {
            return;
        }
        for (GeneratedValue generatedValue : this.m_generatedValues.values()) {
            TableGenerator tableGenerator;
            GenerationType type = generatedValue.strategy();
            String generatorName = generatedValue.generator();
            if (type.equals((Object)GenerationType.TABLE)) {
                SequenceGenerator sequenceGenerator = this.m_sequenceGenerators.get(generatorName);
                if (sequenceGenerator == null) continue;
                this.throwConflictException(generatedValue, sequenceGenerator);
                continue;
            }
            if (!type.equals((Object)GenerationType.SEQUENCE) && !type.equals((Object)GenerationType.IDENTITY) || (tableGenerator = this.m_tableGenerators.get(generatorName)) == null) continue;
            this.throwConflictException(generatedValue, tableGenerator);
        }
        Sequence defaultAutoSequence = null;
        NativeSequence defaultNativeSequence = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR);
        Sequence defaultTableSequence = new TableSequence(DEFAULT_TABLE_GENERATOR);
        Hashtable<String, QuerySequence> sequences = new Hashtable<String, QuerySequence>();
        for (SequenceGenerator sequenceGenerator : this.m_sequenceGenerators.values()) {
            String sequenceGeneratorName = sequenceGenerator.name();
            seqName = sequenceGenerator.sequenceName().equals("") ? sequenceGeneratorName : sequenceGenerator.sequenceName();
            sequence = new NativeSequence(seqName, sequenceGenerator.allocationSize());
            sequences.put(sequenceGeneratorName, (QuerySequence)sequence);
            if (sequenceGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                defaultAutoSequence = sequence;
                continue;
            }
            if (!sequenceGeneratorName.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
            defaultNativeSequence = sequence;
        }
        for (TableGenerator tableGenerator : this.m_tableGenerators.values()) {
            String tableGeneratorName = tableGenerator.name();
            seqName = tableGenerator.pkColumnValue().equals("") ? tableGeneratorName : tableGenerator.pkColumnValue();
            sequence = new TableSequence(seqName, tableGenerator.allocationSize());
            sequences.put(tableGeneratorName, (QuerySequence)sequence);
            ((TableSequence)sequence).setTable(new DatabaseTable(MetadataHelper.getFullyQualifiedTableName(tableGenerator.table(), ((TableSequence)sequence).getTableName(), tableGenerator.catalog(), tableGenerator.schema())));
            for (UniqueConstraint uniqueConstraint : tableGenerator.uniqueConstraints()) {
                String[] columnNames = uniqueConstraint.columnNames();
                ((TableSequence)sequence).getTable().addUniqueConstraint(columnNames);
            }
            if (!tableGenerator.pkColumnName().equals("")) {
                ((TableSequence)sequence).setNameFieldName(tableGenerator.pkColumnName());
            }
            if (!tableGenerator.valueColumnName().equals("")) {
                ((TableSequence)sequence).setCounterFieldName(tableGenerator.valueColumnName());
            }
            if (tableGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                defaultAutoSequence = sequence;
                continue;
            }
            if (!tableGeneratorName.equals(DEFAULT_TABLE_GENERATOR)) continue;
            defaultTableSequence = sequence;
        }
        for (AnnotationsDescriptor dmd : this.m_generatedValues.keySet()) {
            GeneratedValue generatedValue = this.m_generatedValues.get(dmd);
            String generatorName = generatedValue.generator();
            sequence = null;
            if (!generatorName.equals("")) {
                sequence = (Sequence)sequences.get(generatorName);
            }
            if (sequence == null) {
                if (generatedValue.strategy() == GenerationType.TABLE) {
                    if (generatorName.equals("")) {
                        sequence = defaultTableSequence;
                    } else {
                        sequence = (Sequence)defaultTableSequence.clone();
                        sequence.setName(generatorName);
                    }
                } else if (generatedValue.strategy() == GenerationType.SEQUENCE || generatedValue.strategy() == GenerationType.IDENTITY) {
                    if (generatorName.equals("")) {
                        sequence = defaultNativeSequence;
                    } else {
                        sequence = (Sequence)defaultNativeSequence.clone();
                        sequence.setName(generatorName);
                    }
                }
            }
            if (sequence != null) {
                dmd.setSequenceNumberName(sequence.getName());
                login.addSequence(sequence);
                continue;
            }
            if (generatedValue.strategy() == GenerationType.AUTO) {
                if (defaultAutoSequence != null) {
                    dmd.setSequenceNumberName(defaultAutoSequence.getName());
                    login.setDefaultSequence(defaultAutoSequence);
                    continue;
                }
                dmd.setSequenceNumberName(DEFAULT_AUTO_GENERATOR);
                continue;
            }
            assert (false);
        }
    }

    protected void throwConflictException(Object obj1, Object obj2) {
        throw ValidationException.annotationsConflict(this.getFullName(obj1), this.getFullName(obj2));
    }
}

