/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors.copying;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.toplink.essentials.descriptors.copying.AbstractCopyPolicy;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.sessions.Record;
import oracle.toplink.essentials.sessions.Session;

public class CloneCopyPolicy
extends AbstractCopyPolicy {
    protected String methodName;
    protected String workingCopyMethodName;
    protected transient Method method;
    protected transient Method workingCopyMethod;

    public Object buildClone(Object domainObject, Session session) throws DescriptorException {
        if (this.getMethodName() == null) {
            return this.getDescriptor().getObjectBuilder().buildNewInstance();
        }
        try {
            return PrivilegedAccessController.invokeMethod(this.getMethod(), domainObject, new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileCloning(domainObject, this.getMethodName(), this.getDescriptor(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileCloning(domainObject, this.getMethodName(), this.getDescriptor(), exception);
        }
    }

    public Object buildWorkingCopyClone(Object domainObject, Session session) throws DescriptorException {
        if (this.getWorkingCopyMethodName() == null) {
            return this.buildClone(domainObject, session);
        }
        try {
            return PrivilegedAccessController.invokeMethod(this.getWorkingCopyMethod(), domainObject, new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileCloning(domainObject, this.getMethodName(), this.getDescriptor(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileCloning(domainObject, this.getMethodName(), this.getDescriptor(), exception);
        }
    }

    public Object buildWorkingCopyCloneFromRow(Record row, ObjectBuildingQuery query) throws DescriptorException {
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        if (this.getWorkingCopyMethodName() != null) {
            Object original = builder.buildNewInstance();
            builder.buildAttributesIntoShallowObject(original, (AbstractRecord)row, query);
            return this.buildWorkingCopyClone(original, query.getSession());
        }
        return builder.buildNewInstance();
    }

    protected Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected Method getWorkingCopyMethod() {
        return this.workingCopyMethod;
    }

    public String getWorkingCopyMethodName() {
        return this.workingCopyMethodName;
    }

    public void initialize(Session session) throws DescriptorException {
        try {
            if (this.getMethodName() != null) {
                this.setMethod(Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), this.getMethodName(), new Class[0]));
            }
        }
        catch (NoSuchMethodException exception) {
            session.getIntegrityChecker().handleError(DescriptorException.noSuchMethodWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), exception));
        }
        catch (SecurityException exception) {
            session.getIntegrityChecker().handleError(DescriptorException.securityWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), exception));
        }
        if (this.getWorkingCopyMethodName() != null) {
            try {
                this.setWorkingCopyMethod(Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), this.getWorkingCopyMethodName(), new Class[0]));
            }
            catch (NoSuchMethodException exception) {
                session.getIntegrityChecker().handleError(DescriptorException.noSuchMethodWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), exception));
            }
            catch (SecurityException exception) {
                session.getIntegrityChecker().handleError(DescriptorException.securityWhileInitializingCopyPolicy(this.getMethodName(), this.getDescriptor(), exception));
            }
        }
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    protected void setWorkingCopyMethod(Method method) {
        this.workingCopyMethod = method;
    }

    public void setWorkingCopyMethodName(String methodName) {
        this.workingCopyMethodName = methodName;
    }

    public boolean buildsNewInstance() {
        return this.getMethodName() == null;
    }

    public String toString() {
        return Helper.getShortClassName(this) + "(" + this.getMethodName() + ")";
    }
}

