const serverConfig = require('./API/global/serverConfig');
const dbConnection = require('./API/dbConnection');
//Decreapt the password
serverConfig.decryptAsync(serverConfig.encryptedDBPass).then( realPass =>{
    //Export the passwword so other module can use
    serverConfig.exportDBPass(realPass);

    //Enstablish Database connection
    dbConnection.setSequelizeConn(realPass).then((res)=>{
        //Initial server
        initServer()
    }).catch(err => console.log(err));
}).catch(err =>{
    console.log(err)
})

function initServer(){
    var http = require('http');
    var path = require('path');
    const serverConfig = require('./API/global/serverConfig');
    const globalData = require('./API/global/globalData');
    const express = require('express');
    const app = express();
    var cors = require('cors');
    var bodyParser = require('body-parser');
    var clsSocketServer = require("./API/model/socketServer");
    var obj_socketServer = new clsSocketServer();
    var clsLoginCounter = require('./API/model/LoginCounterReset');
    var obj_LoginCounter = new clsLoginCounter();

const systemPrechecks = require('./API/routes/systemPrechecksRoute');
    const login = require('./API/routes/loginRoutes');
    const parameters = require('./API/routes/parametersRoute');
    const department = require('./API/routes/deptRoutes');
    const role = require('./API/routes/roleRoute');
    const report = require('./API/routes/reportRoute');
    const activityLog = require('./API/routes/activity.route');
    const user = require('./API/routes/userRoutes');
    const stage = require('./API/routes/stageRoute');
    const content = require('./API/routes/contentRoute');
    const passwordcomplexity = require('./API/routes/pwdcomplexityRoute');
    const otherequipment = require('./API/routes/otherequipmentRoute');
    const admin = require('./API/routes/adminRoute');
    const media = require('./API/routes/mediaRoute');
    const balance = require('./API/routes/balanceRoute');
    const nomenclature = require('./API/routes/nomenclatureRoute');
    const MachineRoute = require('./API/routes/machineRoute');
    const right = require('./API/routes/rightRoute');
    const cubicle = require('./API/routes/cubicleRoute');
    const bin = require('./API/routes/binRoute.route');
    //const binCubicle = require('./API/routes/binCubicleRoute');
    const editstatus = require('./API/routes/editstatusRoute');
    const instrument = require('./API/routes/instrumentRoute');
    const vernier = require('./API/routes/vernierRoute');
    const calibrationbox = require('./API/routes/calibrationboxRoute');
    const ldap = require('./API/routes/ldapRoute');
    const product = require('./API/routes/productRoute');
    const AreaSettingRoute = require('./API/routes/areaSettingRoute');
    const portSetting = require('./API/routes/portSettingRoute');
    const precalibration = require('./API/routes/precalibrationRoute');
    const recalibration = require('./API/routes/recalibrationRoute');
    const BatchSummary = require('./API/routes/batchRoute');
    const tabletCapsule = require('./API/routes/tabletCapsuleRoute');
    var dailyCalibrationReport = require('./API/routes/dailyCalibReportRoute');
    // var monthlyCalibrationReport = require('./API/routes/monthlyCalibReportRoute');
    var alertSetting = require('./API/routes/alertRoute');
    var periodicCalibrationReport = require('./API/routes/periodicCalibReportRoute');

const WebSocketHandler = require('./API/WebServer/controller/socketHandler');
    var bodyParser = require('body-parser');
    app.use(express.static(path.join(__dirname, '')));
    app.get('*', function (req, res, next) {
        res.sendFile(__dirname + "");
    });

    // creating instance of Web server which handles Angular request
    const WebSocketServer = http.createServer(app);
    var io = require('socket.io')(WebSocketServer);
    var jsonParser = bodyParser.json();
    // ***************************************************************************************//
    // API PART                                                                               //
    //*************************************************************************************** *//
    app.use(cors({ credentials: true, origin: true }));
    //app.use(cacheControl());
    app.use(bodyParser.json());
    app.use(express.json());

    app.use('/API/login', login);
    app.use('/API/parameter', parameters);
    app.use('/API/department', department);
    app.use('/API/user', user);
    app.use('/API/ActivityLog', activityLog);
    app.use('/API/stage', stage);
    app.use('/API/content', content);
    app.use('/API/role', role);
    app.use('/API/user', user);
    app.use('/API/otherequipment', otherequipment);
    app.use('/API/admin', admin);
    app.use('/API/pwdcomplexity', passwordcomplexity);
    app.use('/API/right', right);
    app.use('/API/editstatus', editstatus);
    app.use('/API/balance', balance);
    app.use('/API/nomenclature', nomenclature);
    app.use('/API/cubicle', cubicle);
    app.use('/API/bin', bin);
    //app.use('/API/binCubicle', binCubicle);
    app.use('/API/instrument', instrument);
    app.use('/API/alert', alertSetting);
    app.use('/API/vernier', vernier);
    app.use('/API/calibrationbox', calibrationbox);
    app.use('/API/product', product);
    app.use('/API/precalibration', precalibration);
    app.use('/API/report', report);
    app.use('/API/machine', MachineRoute);
    app.use('/API/ldap', ldap);
    app.use('/API/media', media);
    app.use('/API/area', AreaSettingRoute);
    app.use('/API/port', portSetting);
    app.use('/API/systemPrechecks', systemPrechecks);
    app.use('/API/recalibration', recalibration);
    app.use('/API/batch', BatchSummary);
    app.use('/API/tabletCapsule', tabletCapsule);
    app.use('/API/dailyCalibrationReport',dailyCalibrationReport);
    // app.use('/API/monthlyCalibrationReport',monthlyCalibrationReport);
    app.use('/API/periodicCalibrationReport',periodicCalibrationReport);

    app.listen(serverConfig.APIPORT, () => {
        console.log(`API SERVER STARTED ON : ${serverConfig.APIPORT} ....`);
    });
    //***************************************************************************************************** */
    // Web Socket server
    //******************************************************************************************************* */
    WebSocketServer.listen(serverConfig.WebPort, serverConfig.host, function () {
        console.log(`WEB SERVER STARTED ON : ${serverConfig.WebPort} ....`);
        setInterval(() => {
            // This code check for database connection continuousy 
            globalData.arrWebSocket.forEach(e => {
                obj_socketServer.getUserIDForConnection().then(result => {
                    //console.log(result);
                }).catch(err => {
                    globalData.arrWebSocket.forEach(e => {
                        var msg = { status: 'success', data: 'Setting database connection' };
                        e.emit('msg', {
                            msg: msg
                        });

                    });
                });
            });
       }, 2000);
    }).on("error", function (err) {
        console.log(err);
        console.log('WEB SERVER FAILED..');
    });
    
    io.on('connection', function (sock) {
        // console.log('socket connected')
        // Every single socket push in global arrWebSocket Array
        if (!globalData.arrWebSocket.includes(sock)) {
            globalData.arrWebSocket.push(sock);
        }
        var msg = { status: 'success', data: 'Connected' };
        setTimeout(() => { 
            sock.emit('msg', {
                msg: msg
            });
        },2000);
    
        sock.on('msg', function (msg) {
        // console.log('msg', msg)
        });
        // invokes when WEB CLIENT SOCKET disconnects
        sock.on("disconnect", function (reason) {
            console.log('reason', reason);

       globalData.arrWebSocket.splice(globalData.arrWebSocket.indexOf(sock), 1);
            WebSocketHandler.handleSocket(sock);
        });
        // invokes when error occured while in network
        sock.on("error", function (error) {
            globalData.arrWebSocket.splice(globalData.arrWebSocket.indexOf(sock), 1);
            WebSocketHandler.handleSocket(sock);
            console.log('something wrong happpened here', error);
        });
    });


 /**
     * 15/06/2021
     * This API is used for every logged in user who is working on browser,
     * This will set loginCounter = 0 to keep him active in database,
     * other wise database event will keep incrementing loginCounter and logged him/her out after timeout period.
     */

 app.post('/resetLoginCounter',jsonParser,function(req, res){
        obj_LoginCounter.resetLoginAttempt(req);
        res.send(`{"status":"success","result":"Login Counter Reset"}`);
    });
}
