const express = require('express');
const router = express.Router();
const cubicle = require('../controller/cubicleController');
router.get('/getArea', cubicle.getArea);
router.get('/all', cubicle.getCubicleInfo);
router.get('/area/all', cubicle.getAreaInfo);
router.get('/batch/all', cubicle.getBatches);
router.post('/maxBatchStatus',cubicle.getMaxStatusForBatch);
router.get('/wgmtStatus', cubicle.checkWeighmentStatus);
router.get('/wgmtStatus/:intCubicleNo', cubicle.checkWeighmentStatus);
router.post('/ProductSamples', cubicle.getProductSamples); 
router.post('/updateCubicle', cubicle.updateCubicle);
router.post('/EndCubicleBatch', cubicle.endCubicleBatch);
router.post('/chkCalibSatus', cubicle.chkCalibSatus);
router.post('/getProductDetailIndNGrp', cubicle.getProductDetailIndNGrp);
router.post('/getCubicleTypeFromArea', cubicle.getCubicleTypeFromArea); 
router.post('/getDataOnSelectionOfCubicle', cubicle.getDataOnSelectionOfCubicle);
router.post('/getProductTypeFromDatabase',cubicle.getProductTypeFromDatabase);
router.post('/getProductUnit',cubicle.getProductUnit);
router.post('/saveSample', cubicle.saveSample);
router.post('/getSampleFromProductCubicle',cubicle.getSampleFromProductCubicle);
router.post('/batchForCubical',cubicle.batchForCubical);
module.exports = router;