const express = require('express');
const router = express.Router();
const report = require('../controller/reportController');
const printers = require('../controller/printerController');

router.post('/GenerateReport', report.generateReport);
router.post('/auditActivityLog', report.rptActivityLog);
router.post('/rptAuditStage', report.rptAuditStage);
router.post('/GetPrinters', printers.getPrinterList);
router.post('/PrintReport', printers.printReport);
router.post('/auditAdminName', report.auditAdminName);
router.post('/auditpasswordComplexity', report.auditpasswordComplexity);
router.post('/auditAdminPasswordChange', report.auditAdminPassword);
router.post('/auditsetAllParameters', report.auditSetAllParam);
router.post('/auditUnauthorizedLogin', report.rptUnauthorizeLogin);
router.post('/rptAuditRoles', report.rptAuditRoles);
router.post('/rptAuditUser', report.rptAuditUser);
router.post('/rptDepartment', report.rptDepartment);
router.post('/rptCalibrationBox', report.rptCalibBox);
router.post('/rptAuditBalance', report.rptAuditBalnce);
router.post('/rptAuditVernier', report.rptAuditVernier);
router.post('/rptAuditotherEquipment', report.rptAuditOther);
router.post('/rptAuditMachine', report.rptAuditMachine);
router.post('/rptAuditMedia', report.rptAuditMedia);
router.post('/rptAuditProduct', report.rptAuditProduct);
router.post('/rptAuditArea', report.rptAuditArea);
router.post('/rptAuditPort', report.rptAuditPort);
router.post('/rptAuditContainer', report.rptAuditContainer);
router.post('/rptAuditBinStage', report.rptAuditBinStage);
router.post('/rptAuditCubicle', report.rptAuditCubicle);
router.post('/rptAuditCleaner', report.rptAuditCleaner);
router.post('/rptAuditRecalib', report.rptAuditRecalib);
router.post('/rptAuditAlert', report.rptAlertAudit);
router.post('/printcountupSummary', report.increasePrintCountSummary);
router.post('/printcountupBinSummary', report.increasePrintCountBinSummary);
router.post('/increasePrintCountUpBinLabel', report.increasePrintCountUpBinLabel);
router.post('/printReasonReportCalibration', report.printReasonReportCalibration);
router.post('/printCountUpCalibration', report.increasePrintCountCalibration);
router.post('/rptAuditPrecalibration', report.rptAuditPrecalibration);
router.post('/periodicCalibrationRemarkForFailed',report.periodicCalibrationRemarkForFailed);

module.exports = router;