const express = require('express')
const router = express.Router();
const binController = require('../controller/bin.controller');
router.get('/getCleaner', binController.getCleaner);
router.post('/addCleaner', binController.addCleaner);
router.get('/getAuditCleaner', binController.getAuditCleaner);

router.get('/getStages', binController.getStages);
router.post('/addStage', binController.addStage);
router.get('/getAuditStage', binController.getAuditStage);

router.get('/getContainer', binController.getContainer);
router.post('/addContainer', binController.addContainer);
router.post('/discardContainer', binController.discardContainer);
router.get('/getAuditContainer', binController.getAuditContainer);

router.post('/getProductCleanerDetail', binController.getProductCleanerDetail);
router.post('/getBinForRelease', binController.getBinForRelease);
router.post('/releaseContainer', binController.releaseContainer);

/** Setting */
router.post('/update', binController.update);
router.get('/getAreaForAudit', binController.getAreaForAudit);//bin setting audit trail
router.get('/all', binController.getBinSettingInfo);
router.get('/getBinList', binController.getBinList);
router.post('/getBinListAssignedToSameCubicle', binController.getBinListAssignedToSameCubicle);
router.post('/getGrossWtStatus', binController.getGrossWtStatus);
router.post('/countBin', binController.getCountBin);
router.post('/checkBinBalAssignToCubicle', binController.checkBinBalAssignToCubicle);
router.post('/editTareWeight', binController.editTareWeight);

router.get('/getProductFromProductMaster', binController.getProductFromProductMaster);
router.get('/getProductNameFromProductMaster', binController.getProductNameFromProductMaster);
router.post('/getBatches', binController.getBatches);
router.post('/getBatchFromCubicleUsingProduct', binController.getBatchFromCubicleUsingProduct);


/** Report */
router.post('/getBinDataGetPrd', binController.getBinDataGetPrd);
router.post('/getBinDataGetBatch', binController.getBinDataGetBatch);

/**Summary */
router.post('/getPrinterNo', binController.getPrinterNo);
router.post('/storeBinDataInTemp', binController.storeBinDataInTemp);

/**Label Gernation */
router.post('/getBinMasterData', binController.getBinMasterData);
router.post('/storeBinLabelDataInTemp', binController.storeBinLabelDataInTemp);

//Fetch Recorcd
router.post('/getProductFromCubicle',binController.getProductFromCubical)

module.exports = router;