const express = require('express');
const router = express.Router();
const product = require('../controller/productController');
const capsule = require('../controller/capsuleController');
router.get('/getProduct', product.getProduct);
router.post('/getProduct', product.getProductForEdit);
router.post('/save', product.saveProduct); // to save Tablet getProductInfo
router.post('/saveCapsule', capsule.saveProduct); // To Save capsule
router.post('/getTabletDetails', product.getTabletDetails); // for getting tablet Master and All details
router.post('/getCapsuleDetails', product.getCapsuleDetails); // for getting capsule Master and All details
router.post('/activateProduct', product.activateProduct);
router.post('/getProductDetailBatchSummary', product.getProductDetailBatchSummary);// route for product summary
router.get('/checkPrdCombination/:strPrdType', product.getProductCombination);
router.put('/update', product.updateProduct); // for update tablet
router.put('/updateCapsule', capsule.UpdateProduct); // for update capsule
router.post('/getProductDetails', product.productDetail);
router.post('/getProductDetailsFroGranulation', product.productDetailForGranulation);
router.post('/checkForCapMasterEntry', product.checkForCapMaster);
router.post('/checkForTabMasterEntry', product.checkForTabMaster);
router.post('/validateProduct', product.validateProduct); // for tablet edit product
router.post('/validateCapsule', product.validateCapsule); // for capsule edit product
router.post('/validateNewProduct/:strPrdType', product.validateNewProduct); // for capsule new product add
router.post('/checkInCubicle', product.checkInCubicle);
//router.get('/getPerviousProductData',product.getPerviousProductData);
router.post('/getStatusCount', product.getStatusCount);
router.post('/checkProductExist', product.checkProductExist);

router.post('/checkWeighmentDone', product.checkWeighmentDone); // no use

module.exports = router;

