var IterateObject = require("iterate-object");

class validateYield {
   constructor() {
      this.objResult = {};
   }

   async validateYield(objProductNew) {
      var resCapsule = {}, resComp = {}, resCoat = {};
      if(objProductNew.CubicleType == "Compression")
      {
         resComp = await this.compParam(objProductNew);
      }
      else if(objProductNew.CubicleType == "Coating")
      {
         resCoat = await this.coatParam(objProductNew);
      }
      else
      {
         resCapsule = await this.capsuleParam(objProductNew);
      }
      
      if (resCapsule != true && resComp != true && resCoat != true) {
         return "No Change";
      }
      else {
         //var strChanged = "";
         var strNewValue = "";

         //"Individual : Nominal : value,Group : Nominal : value"
         IterateObject(this.objResult, function (value, key1) {

            var i = 1;
            var obj = value;
            IterateObject(obj, (value, key) => {
               if (value != false) {
                  //if (i == 1) {
                     //strNewValue = strNewValue + "|" + key1;
                     //strNewValue = strNewValue + key1 + "-";
                  //}
                  strNewValue = strNewValue + key + ":";
                  strNewValue = strNewValue + value + ",";
                  // ", ";
                  i = i + 1;
               }

            })
         });
      }

      var strNewValue = 'CubicleType:'+objProductNew.CubicleType+','+strNewValue;
      const objProduct = {};
      Object.assign(objProduct, { strNewValue });
      return objProduct;
   }

   capsuleParam(objProductNew) {
      const objCap = {
         capsule: {
            CapTheoraticalYield: "",
            BatchNLT: "",
            BatchNMT: "",
            StageNLT: "",
            StageNMT: ""
         }
      }
      var IsChanged = false;
      if (objProductNew.Cap_TheoraticalYield != "" || objProductNew.Cap_TheoraticalYield != undefined ||
         objProductNew.Cap_TheoraticalYield != null || objProductNew.Cap_TheoraticalYield != 99999) {
         objCap.capsule.CapTheoraticalYield = objProductNew.Cap_TheoraticalYield != "" ? objProductNew.Cap_TheoraticalYield : false;
         objCap.capsule.BatchNLT = objProductNew.Cap_Batch_NLT != "" ? objProductNew.Cap_Batch_NLT : false;
         objCap.capsule.BatchNMT = objProductNew.Cap_Batch_NMT != "" ? objProductNew.Cap_Batch_NMT : false;
         objCap.capsule.StageNLT = objProductNew.Cap_YC_NLT != "" ? objProductNew.Cap_YC_NLT : false;
         objCap.capsule.StageNMT = objProductNew.Cap_YC_NMT != "" ? objProductNew.Cap_YC_NMT : false;
         IsChanged = true;
      }
      else {
         IsChanged = false;
      }
      if (IsChanged == true) {
         Object.assign(this.objResult, objCap);
      }
      return IsChanged;



   }

   compParam(objProductNew) {
      const objComp = {
         comp: {
            TabTheoraticalYield: "",
            BatchNLT: "",
            BatchNMT: "",
            StageNLT: "",
            StageNMT: ""

         }
      }
      var IsChanged = false;
      if(objProductNew.Comp_Batch_NLT != "" || objProductNew.Comp_Batch_NMT != "" || objProductNew.Comp_YC_NLT != ""
      || objProductNew.Comp_YC_NMT != ""){
         if (objProductNew.Tab_TheoraticalYield != "" || objProductNew.Tab_TheoraticalYield != undefined ||
         objProductNew.Tab_TheoraticalYield != null || objProductNew.Tab_TheoraticalYield != 99999) {
         objComp.comp.TabTheoraticalYield =  objProductNew.Tab_TheoraticalYield != "" ? objProductNew.Tab_TheoraticalYield : false;
         objComp.comp.BatchNLT = objProductNew.Comp_Batch_NLT != "" ? objProductNew.Comp_Batch_NLT : false;
         objComp.comp.BatchNMT = objProductNew.Comp_Batch_NMT != "" ? objProductNew.Comp_Batch_NMT : false;
         objComp.comp.StageNLT = objProductNew.Comp_YC_NLT != "" ? objProductNew.Comp_YC_NLT : false;
         objComp.comp.StageNMT = objProductNew.Comp_YC_NMT != "" ? objProductNew.Comp_YC_NMT : false;

         IsChanged = true;
         }
         else {
            IsChanged = false;
         }
      }
      

      if (IsChanged == true) {
         Object.assign(this.objResult, objComp);
      }
      return IsChanged;



   }

   coatParam(objProductNew) {
      const objCoat = {
         coat: {
            TabTheoraticalYield: "",
            BatchNLT: "",
            BatchNMT: "",
            StageNLT: "",
            StageNMT: ""

         }
      }
      var IsChanged = false;
      if(objProductNew.Coat_Batch_NLT != "" || objProductNew.Coat_Batch_NMT != "" || objProductNew.Coat_YC_NLT != ""
      || objProductNew.Coat_YC_NMT != ""){
         if (objProductNew.Tab_TheoraticalYield != "" || objProductNew.Tab_TheoraticalYield != undefined ||
            objProductNew.Tab_TheoraticalYield != null || objProductNew.Tab_TheoraticalYield != 99999) {
            objCoat.coat.TabTheoraticalYield = objProductNew.Tab_TheoraticalYield != "" ? objProductNew.Tab_TheoraticalYield : false;
            objCoat.coat.BatchNLT = objProductNew.Coat_Batch_NLT != "" ? objProductNew.Coat_Batch_NLT : false;
            objCoat.coat.BatchNMT = objProductNew.Coat_Batch_NMT != "" ? objProductNew.Coat_Batch_NMT : false;
            objCoat.coat.StageNLT = objProductNew.Coat_YC_NLT != "" ? objProductNew.Coat_YC_NLT : false;
            objCoat.coat.StageNMT = objProductNew.Coat_YC_NMT != "" ? objProductNew.Coat_YC_NMT : false;

            IsChanged = true;
         }
         else {
            IsChanged = false;
         }
      }
      if (IsChanged == true) {
         Object.assign(this.objResult, objCoat);
      }
      return IsChanged;



   }

}


module.exports = validateYield;