const Database = require('../database/clsQueryProcess');
const database = new Database();
const dbcon = require('../Utills/db');
const date = require('date-and-time');

class yieldReconcilation {
    async storeYieldReco(value) {
        var responseObj = {};
        var checkYield = await this.checkYield(value);
        if (checkYield == false) {
            Object.assign(responseObj, { status: 'success' }, { result: 'Yield Already Exist' });
            return (responseObj);
        }
        else {
            const addYield = await this.addYield(value);
            Object.assign(responseObj, { status: 'success' }, { result: 'Yield Added Successfully' });
            return (responseObj);
        }
    }

    async checkYield(value) {
        try {
            const objMaster = {
                str_tableName: 'tbl_yield_product_master',
                data: '*',
                condition: [
                    { str_colName: 'BFGCode', value: value.BFGCode, comp: 'eq' },
                    { str_colName: 'ProductName', value: value.ProductName, comp: 'eq' },
                    { str_colName: 'PVersion', value: value.PVersion, comp: 'eq' },
                    { str_colName: 'Version', value: value.Version, comp: 'eq' },
                    { str_colName: 'ProductType', value: value.ProductType, comp: 'eq' },
                    { str_colName: 'CubicleType', value: value.CubicleType, comp: 'eq' },

                ]
            }
            var result = await database.select(objMaster);
            if (result[0].length > 0) {
                return false;
            }
            else {
                return true;
            }

        } catch (error) {
            return error;
        }

    }

    async addYield(value) {
        try {
            var now = new Date();
            const addYieldObj = {
                str_tableName: 'tbl_yield_product_master',
                data: [
                    { str_colName: 'BFGCode', value: value.BFGCode },
                    { str_colName: 'ProductName', value: value.ProductName },
                    { str_colName: 'PVersion', value: value.PVersion},
                    { str_colName: 'Version', value: value.Version },
                    { str_colName: 'ProductType', value: value.ProductType},
                    { str_colName: 'CubicleType', value: (value.CubicleType == undefined || value.CubicleType == "") ? "Compression" : value.CubicleType },
                    { str_colName: 'Tab_TheoraticalYield', value: (value.Tab_TheoraticalYield == undefined || value.Tab_TheoraticalYield == "") ? 0 : value.Tab_TheoraticalYield },
                    { str_colName: 'Comp_Batch_NLT', value: (value.Comp_Batch_NLT == undefined || value.Comp_Batch_NLT == "") ? 0 : value.Comp_Batch_NLT },
                    { str_colName: 'Comp_Batch_NMT', value: (value.Comp_Batch_NMT == undefined || value.Comp_Batch_NMT == "") ? 0 : value.Comp_Batch_NMT },
                    { str_colName: 'Comp_YC_NLT', value: (value.Comp_YC_NLT == undefined || value.Comp_YC_NLT == "") ? 0 : value.Comp_YC_NLT },
                    { str_colName: 'Comp_YC_NMT', value: (value.Comp_YC_NMT == undefined || value.Comp_YC_NMT == "") ? 0 : value.Comp_YC_NMT },
                    { str_colName: 'Coat_Batch_NLT', value: (value.Coat_Batch_NLT == undefined || value.Coat_Batch_NLT == "") ? 0 : value.Coat_Batch_NLT},
                    { str_colName: 'Coat_Batch_NMT', value: (value.Coat_Batch_NMT == undefined || value.Coat_Batch_NMT == "") ? 0 : value.Coat_Batch_NMT },
                    { str_colName: 'Coat_YC_NLT', value: (value.Coat_YC_NLT == undefined || value.Coat_YC_NLT == "") ? 0 : value.Coat_YC_NLT },
                    { str_colName: 'Coat_YC_NMT', value: (value.Coat_YC_NMT == undefined || value.Coat_YC_NMT == "") ? 0 : value.Coat_YC_NMT },
                    { str_colName: 'Cap_TheoraticalYield', value: (value.Cap_TheoraticalYield == undefined || value.Cap_TheoraticalYield == "") ? 0 : value.Cap_TheoraticalYield },
                    { str_colName: 'Cap_YC_NLT', value: (value.Cap_YC_NLT == undefined || value.Cap_YC_NLT == "") ? 0 : value.Cap_YC_NLT },
                    { str_colName: 'Cap_Batch_NMT', value: (value.Cap_Batch_NMT == undefined || value.Cap_Batch_NMT == "") ? 0 : value.Cap_Batch_NMT },
                    { str_colName: 'Cap_YC_NMT', value: (value.Cap_YC_NMT == undefined || value.Cap_YC_NMT == "") ? 0 : value.Cap_YC_NMT },
                    { str_colName: 'Cap_Batch_NLT', value: (value.Cap_Batch_NLT == undefined || value.Cap_Batch_NLT == "") ? 0 : value.Cap_Batch_NLT },

                ]
            }
            var result2 = await database.save(addYieldObj);

            const auditYield = {
                str_tableName: 'tbl_audit_yiled_product',
                data: [
                    { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: value.UserID },
                    { str_colName: 'username', value: value.UserName },
                    { str_colName: 'ACT', value: 'Add Yield' },
                    { str_colName: 'Remark', value: value.Remark },
                    { str_colName: 'ProductId', value: value.BFGCode },
                    { str_colName: 'ProductName', value: value.ProductName },
                    { str_colName: 'PrdVersion', value: value.PVersion },
                    { str_colName: 'Version', value: value.Version },
                    { str_colName: 'ProductType', value: value.ProductType },
                    { str_colName: 'CubicleType', value: value.CubicleType },
                    { str_colName: 'OldValue', value: 'NA' },
                    { str_colName: 'NewValue', value: value.auditObject.result.strNewValue },

                ]
            }
            var result1 = await database.save(auditYield);


            const activityLogObj = {
                str_tableName: 'tbl_activity_log',
                data: [
                    { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: value.UserID },
                    { str_colName: 'username', value: value.UserName },
                    { str_colName: 'activity', value: "Yield Reconcilation Added" },
                ]
            }
            var activityresult = await database.save(activityLogObj);

            return true;
        } catch (error) {
            return error;
        }
    }

    async updateProductYield(value) {
        var responseObj = {};
        const updateGranulationObj = {
            str_tableName: 'tbl_yield_product_master',
            data: [
                { str_colName: 'ProductType', value: parseInt(value.ProductType) },
                { str_colName: 'CubicleType', value: (value.CubicleType == undefined || value.CubicleType == "") ? "Compression" : value.CubicleType },
                { str_colName: 'Tab_TheoraticalYield', value: (value.Tab_TheoraticalYield == undefined || value.Tab_TheoraticalYield == "") ? 0 : value.Tab_TheoraticalYield},
                { str_colName: 'Comp_Batch_NLT', value: (value.Comp_Batch_NLT == undefined || value.Comp_Batch_NLT == "") ? 0 : value.Comp_Batch_NLT },
                { str_colName: 'Comp_Batch_NMT', value: (value.Comp_Batch_NMT == undefined || value.Comp_Batch_NMT == "") ? 0 : value.Comp_Batch_NMT },
                { str_colName: 'Comp_YC_NLT', value: (value.Comp_YC_NLT == undefined || value.Comp_YC_NLT == "") ? 0 : value.Comp_YC_NLT },
                { str_colName: 'Comp_YC_NMT', value: (value.Comp_YC_NMT == undefined || value.Comp_YC_NMT == "") ? 0 : value.Comp_YC_NMT },
                { str_colName: 'Coat_Batch_NLT', value: (value.Coat_Batch_NLT == undefined || value.Coat_Batch_NLT == "") ? 0 : value.Coat_Batch_NLT },
                { str_colName: 'Coat_Batch_NMT', value: (value.Coat_Batch_NMT == undefined || value.Coat_Batch_NMT == "") ? 0 : value.Coat_Batch_NMT },
                { str_colName: 'Coat_YC_NLT', value: (value.Coat_YC_NLT == undefined || value.Coat_YC_NLT == "") ? 0 : value.Coat_YC_NLT},
                { str_colName: 'Coat_YC_NMT', value: (value.Coat_YC_NMT == undefined || value.Coat_YC_NMT == "") ? 0 : value.Coat_YC_NMT},
                { str_colName: 'Cap_TheoraticalYield', value: (value.Cap_TheoraticalYield  == undefined || value.Cap_TheoraticalYield == "") ? 0 : value.Cap_TheoraticalYield},
                { str_colName: 'Cap_Batch_NMT', value: (value.Cap_Batch_NMT == undefined || value.Cap_Batch_NMT == "") ? 0 : value.Cap_Batch_NMT},
                { str_colName: 'Cap_YC_NLT', value: (value.Cap_YC_NLT == undefined || value.Cap_YC_NLT == "") ? 0 : value.Cap_YC_NLT},
                { str_colName: 'Cap_YC_NMT', value: (value.Cap_YC_NMT == undefined || value.Cap_YC_NMT == "") ? 0 : value.Cap_YC_NMT}
            ],
            condition: [
                { str_colName: 'BFGCode', value: value.BFGCode, comp: 'eq' },
                { str_colName: 'ProductName', value: value.ProductName, comp: 'eq' },
                { str_colName: 'PVersion', value: value.PVersion, comp: 'eq' },
                { str_colName: 'Version', value: value.Version, comp: 'eq' }
            ]
        }
        let result = await database.update(updateGranulationObj);
        var now = new Date();

        const auditYield = {
            str_tableName: 'tbl_audit_yiled_product',
            data: [
                { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                { str_colName: 'userid', value: value.UserID },
                { str_colName: 'username', value: value.UserName },
                { str_colName: 'ACT', value: value.Action },
                { str_colName: 'Remark', value: value.Remark },
                { str_colName: 'ProductId', value: value.BFGCode },
                { str_colName: 'ProductName', value: value.ProductName },
                { str_colName: 'PrdVersion', value: value.PVersion },
                { str_colName: 'Version', value: value.Version },
                { str_colName: 'ProductType', value: parseInt(value.ProductType) },
                { str_colName: 'CubicleType', value: value.CubicleType },
                { str_colName: 'OldValue', value: value.auditObject.result.productYield.oldData },
                { str_colName: 'NewValue', value: value.auditObject.result.productYield.newData }

            ]
        }
        var result1 = await database.save(auditYield);


        const activityLogObj = {
            str_tableName: 'tbl_activity_log',
            data: [
                { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                { str_colName: 'userid', value: value.UserID },
                { str_colName: 'username', value: value.UserName },
                { str_colName: 'activity', value: "Yield Reconcilation Updated" },
            ]
        }
        let activityresult = await database.save(activityLogObj);

        Object.assign(responseObj, { status: 'success' }, { result: 'Yield Updated Successfully' });
        return (responseObj);
    }

    async getAllProduct(){
        try{

            var objGetAllProduct = {
                str_tableName: 'tbl_yield_product_master',
                data: '*'
            }

            var resAllProduct = await database.select(objGetAllProduct);

            return resAllProduct[0];

        }catch(error){
            return(error);
        }
    }

    async getProductYield(req) {
        try {
            var responseObj = {};
            var CubicleType;
            var str_tableNameYield;
            if (req == 'Compression') {
                str_tableNameYield = 'tbl_product_tablet';
                CubicleType = 'Compression';
            } else if (req == 'Capsule Filling') {
                str_tableNameYield = 'tbl_product_capsule';
                CubicleType = 'Capsule Filling';
            } else {
                str_tableNameYield = 'tbl_product_tablet_coated';
                CubicleType = 'Coating';
            }

            const objMaster = {
                str_tableName: str_tableNameYield,
                data: '*',
                condition: [
                    { str_colName: 'Param1_Nom', value: 99999, comp: 'ne' },
                ]
            }
            if (req == 'Coating') {
                objMaster.condition.push({ str_colName: 'Param2_Nom', value: 99999, comp: 'ne' })
            }
            if ((req == 'Compression') || (req == 'Coating') || (req == 'Capsule Filling')){
                objMaster.condition.push({ str_colName: 'locked', value: 0, comp: 'eq' })
            }


            const objMasterYield = {
                str_tableName: 'tbl_yield_product_master',
                data: '*',
                condition: [
                    { str_colName: 'CubicleType', value: CubicleType, comp: 'eq' },
                ]
            }
            var data1 = await database.select(objMasterYield);
            var data = await database.select(objMaster);
            var yeildDoneArr = [];
            var yeildNotDone = [];


            // For Loop for find out which product are in yeild as well as tablet & capsule
            for (let obj of data1[0]) {
                for (let k of data[0]) {
                    if ((k.ProductId.trim() == obj.BFGCode.trim()) && (k.ProductName.trim() == obj.ProductName.trim()) &&
                        (k.ProductVersion.trim() == obj.PVersion.trim()) && (k.Version.trim() == obj.Version.trim())) {
                        yeildDoneArr.push(k);
                    }
                }
            }
            // For Loop for Finding out which product does not have yeild yet.
            if (yeildDoneArr.length == 0) {
                yeildNotDone = data[0]
            } else {
                // for (let yd of yeildDoneArr) {
                //     for (let k of data[0]) {
                //         if (k.ProductId.trim() != yd.ProductId.trim() && k.ProductName.trim() != yd.ProductName.trim() &&
                //             k.ProductVersion.trim() != yd.ProductVersion.trim() && k.Version.trim() != yd.Version.trim()) {

                //             if(yeildNotDone.find(r=> r.ProductId.trim() == yd.ProductId.trim() && r.ProductName.trim() == yd.ProductName.trim() 
                //                 && r.ProductVersion.trim() == yd.ProductVersion.trim() && r.Version.trim() == yd.Version.trim()) == undefined)
                //                 {
                //                     yeildNotDone.push(k);
                //                 }
                           
                //         }
                //     }

                // }

                for (let k of data[0]) {
                    /**check product is in yield table or not */
                    const getPrd = {
                        str_tableName: "tbl_yield_product_master",
                        data:"Count(*) as cnt",
                        condition:[
                            {str_colName:"BFGCode", value:k.ProductId.trim()},
                            {str_colName:"ProductName", value:k.ProductName.trim()},
                            {str_colName:"PVersion", value:k.ProductVersion.trim()},
                            {str_colName:"Version", value:k.Version.trim()},
                            {str_colName:"CubicleType", value:req}
                        ]
                    }

                    let res = await database.select(getPrd);
                    if(res[0][0].cnt == 0)
                    {
                        yeildNotDone.push(k);
                    }
                }
            }

            Object.assign(responseObj, { status: 'success' }, { result: yeildNotDone });
            return responseObj;
        } catch (error) {
            return error;
        }
    }

    async getYieldProductDetail(value){
        try{
            var responseObj = {};
            const objMaster = {
                str_tableName: 'tbl_yield_product_master',
                data: '*',
                condition: [
                    { str_colName: 'BFGCode', value: value.BFGCode, comp: 'eq' },
                    { str_colName: 'ProductName', value: value.ProductName, comp: 'eq' },
                    { str_colName: 'PVersion', value: value.ProductVersion, comp: 'eq' },
                    { str_colName: 'Version', value: value.Version, comp: 'eq' },
                    { str_colName: 'CubicleType', value: value.CubicleType, comp: 'eq' }

                ]
            }
            var result = await database.select(objMaster);
            if (result[0].length > 0) {
                Object.assign(responseObj, { status: 'success' }, { result: result[0][0] });
                return responseObj;
            } else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Product yield data not found' });
                return responseObj;
            }

        }catch(error){
            return error;
        }
    }
}
module.exports = yieldReconcilation;