var ActiveDirectory = require('activedirectory');
var globalData = require('../ldapGlobal/severConfig');
var configData = require('../global/serverConfig');
const requestIp = require('request-ip');
const date = require('date-and-time');
const models = require("../dbConnection").models;

var config = {
    url: globalData.ldapServer,
    baseDN: globalData.baseDn
  }

  class LDAP {
  
    validateUser(strUserName,strPassword,req) {
      return new Promise((resolve, reject) => {
        var ad = new ActiveDirectory(config);
        let Ip = requestIp.getClientIp(req);
        if( req.body.source && req.body.source == 'IDS') {
            Ip = req.body.ip;
        }

        if( req.body.source && req.body.source == 'hardware') {
            console.log("1.source",req.body.source,"-req.body.hmi",req.body.hmi);
            Ip = req.body.hmi;
        }

        var username = strUserName;
        var password = strPassword;
        var byPassLDAP = configData.byPassLDAP;
  
        if(byPassLDAP == true)
        {
          resolve({ response: 'Authenticated' });
        }
        else
        {
          var $this = this;
          configData.decryptAsync(password).then( resPass =>{
          ad.authenticate(username, resPass, function (err, auth) {
            if (err) {
                resolve({ response: 'Authenticated failed' });
                }
            if (auth) {
                resolve({ response: 'Authenticated' });
            }
            else{
              $this.insertEntryInUnauthorizedUser(username,Ip).then(res =>{
                resolve({response: 'Authenticated failed'});
              })
            }
          });
          });
        }

      })
  
    }

    async insertEntryInUnauthorizedUser(username,Ip)
    {
      try{
          let now = new Date();
          let splitIp = Ip.split(':');

          // when split length === 1 then it come from tsh than show directly IP
          let ClientIp = splitIp.length === 1 ? Ip : splitIp[3];
          if (ClientIp === undefined) {
              ClientIp = '127.0.0.1'
          } else {
              ClientIp = ClientIp
          }

          let resultGet = await models.tbl_users.findAll({where:
            { UserName: username }
          });

          await models.tbl_audit_unauthorized_user.create({
              dt: date.format(now, 'YYYY-MM-DD'),
              tm: date.format(now, 'HH:mm:ss'),
              userid: resultGet[0].UserID,
              username: resultGet[0].UserInitials,
              Host: ClientIp
          });
      return "Success";
      }catch(error){
        return error;
      }
    }
    
  }
  
  module.exports = LDAP;