const date = require('date-and-time');
const setTimeZone = require('../Utills/setTimeZone');
let sha1 = require('sha1');
let in_array = require('in_array');
const requestIp = require('request-ip');
const jsonfile = require('jsonfile');
const config = require('../global/serverConfig');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const {Op} = require("sequelize");
const sequelize = require('./../dbConnection').sequelize;
const { QueryTypes } = require('sequelize');


class UserModel {
    async getUsers() {
        try {
            let obj_response = {},actualData = [],data = {},data1 = {},arr_finalData = [],arr_dbDate = [];
            let now = new Date();
            var str_setBy,str_userStatus;

            let resultAllParamData = await models.tbl_setallparameter.findAll();
            data = resultAllParamData;
            let passwordExpPeriod = parseInt(data[0].tbl_config_PasswordExpPeriod);
            let resultGetUser = await models.tbl_users.findAll();
            let dt_today = date.format(now, 'YYYY-MM-DD');
            data1 = resultGetUser;

            for(let i = 0; i < resultGetUser.length; i++){
                let str_userid = data1[i].UserID;
                let str_username = data1[i].UserName;
                let str_passchange = data1[i].PwdChg;
                let str_role = data1[i].Role;
                let int_status = data1[i].Status;
                let str_lastLogin = data1[i].PwdChgDate;
               
                let str_passwordStatus = str_passchange;

                str_setBy = (str_passwordStatus == 0) ? str_userid : 'Admin';
              
                str_userStatus = (int_status == 0) ? 'Enable' : (int_status == 1) ? 'Temporary Disable' : (int_status == 2) ? 'Permanent Disable' :
                                 (int_status == 4) ? 'Auto Disable' : 'Lock User';
               
                setTimeZone.convertDate(str_lastLogin).then(passRemDate => {
                    let dt_newDate = new Date(passRemDate);
                    let dt_required = date.addDays(dt_newDate, passwordExpPeriod);
                    let dt_first  = new Date(dt_today),  
                    dt_secondDate = new Date(dt_required),
                    tm_difference = Math.abs(dt_secondDate.getTime() <= dt_first.getTime());
                    var dt_reqDate = tm_difference;
                    var password_status = (dt_reqDate == 1) ? 'Expired' : 'Active till  '+ dt_required;
                    arr_dbDate.push(password_status);
                });

                let arr_final = {'userid':str_userid,'username':str_username,'passwordSetBy':str_setBy,'role':str_role,'status':str_userStatus,'add':arr_dbDate};
                arr_finalData.push(arr_final);
            }
                let arr_alldata = [];
                for(let i = 0; i < data1.length; i++){
                    arr_alldata = {userdata : data1[i],status:arr_finalData[i]};
                    actualData.push(arr_alldata);
                }

                Object.assign(obj_response, { status: 'success' }, { result: actualData })
                return obj_response;

        } catch (error) {
            return error;
        }
    }

    async getPerticularUser(req) {
        try {
            let result = await models.tbl_users.findAll({where:
                {UserID: req.body.userId}
            });

            return result;

        } catch (error) {
            return error;
        }
    }

   async storeUser(value) {
        try{
            var obj_response = {};
           
            var result = await models.tbl_users.findAll({where:
                { UserID: value.userID }
            });

            if(result.length > 0){
                Object.assign(obj_response, { status: 'success' }, { result: 'User Already Exist' })
                return obj_response;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                    var now = new Date(); 
                    await models.tbl_users.create({
                        UserID: value.userID,
                        UserName: value.userName,
                        Pwd: sha1(value.userPassword),
                        userType: 2 ,
                        PwdChgDate: date.format(now, 'YYYY-MM-DD'),
                        PwdExpStauts: 0,
                        Status: 0,
                        Reason: 0,
                        PwdChg: 1,
                        isadmin: 0,
                        LastLoginDt: date.format(now, 'YYYY-MM-DD'),
                        UserInitials: value.userInitials,
                        loginatmpt: 0,
                        suspensionPeriod: null,
                        autoEnbl: 0,
                        active: 0,
                        realPassword: value.userPassword,
                        lstActvtyTime: 0,
                        Department: value.userDepartment,
                        Role: value.userRoles,
                        HostName: 0,
                        locked: 0,
                        editCounter: 0,
                        loginCounter: 0,
                        source: 0,
                        PREV_STATUS: 0,
                        Domain: 0,
                        failedAtmpTime: 0
                    },{
                        transaction: t
                    });

                    await models.tbl_audit_users.create({
                        //var now = new Date();
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.loggeduserID,
                        username: value.loggeduserName,
                        NewRole: value.userRoles,
                        ACT: value.action,
                        KeyCode: value.userID,
                        KeyValue: value.userName,
                        Remark: value.remark,
                        NewDepartment: value.userDepartment
                    },{
                        transaction: t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.loggeduserID,
                        username: value.loggeduserName,
                        activity: 'User Added' 
                    },{
                        transaction: t
                    });
                });

                Object.assign(obj_response, { status: 'success' }, { result: 'User Added Successfully' })
                return obj_response;
            }
            
        }catch(error){
            return error;
        }
    }

  async storeUserLdp(value) {
        try{

            var obj_response = {};
           
            var result = await models.tbl_users.findAll({where:
                { UserID: value.userID }
            });

            if(result.length > 0){
                Object.assign(obj_response, { status: 'success' }, { result: 'User Already Exist' })
                return obj_response;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                    var now = new Date(); 

                    await models.tbl_users.create({
                        UserID: value.userID,
                        UserName: value.userName,
                        userType: 2 ,
                        PwdChgDate: date.format(now, 'YYYY-MM-DD'),
                        PwdExpStauts: 0,
                        Status: 0,
                        Reason: 0,
                        PwdChg: 1,
                        isadmin: 0,
                        LastLoginDt: date.format(now, 'YYYY-MM-DD'),
                        UserInitials: value.userInitials,
                        loginatmpt: 0,
                        suspensionPeriod: null,
                        autoEnbl: 0,
                        active: 0,
                        lstActvtyTime: 0,
                        Department: value.userDepartment,
                        Role: value.userRoles,
                        HostName: 0,
                        locked: 0,
                        editCounter: 0,
                        loginCounter: 0,
                        source: 0,
                        PREV_STATUS: 0,
                        Domain: 0,
                        failedAtmpTime: 0
                    },{
                        transaction: t
                    });
                    
                    await models.tbl_audit_users.create({
                        //var now = new Date();
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.loggeduserID,
                        username: value.loggeduserName,
                        NewRole: value.userRoles,
                        ACT: value.action,
                        KeyCode: value.userID,
                        KeyValue: value.userInitials,
                        Remark: value.remark,
                        NewDepartment: value.userDepartment
                    },{
                        transaction: t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.loggeduserID,
                        username: value.loggeduserName,
                        activity: 'User Added' 
                    },{
                        transaction: t
                    });
                });

                Object.assign(obj_response, { status: 'success' }, { result: 'User Added Successfully' })
                return obj_response;
            }
            
        }catch(error){
            console.log("error",error);
            return error;
        }
    } 

    updateUserStatus(req) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let lock = parseInt(req.body.lock);
            let userid = req.body.userid;
            if(lock == 1){
                const updateUserstatusObj = {
                    str_tableName: 'tbl_users',
                    data: [
                        { str_colName: 'locked', value: lock }
                    ],
                    condition: [
                        { str_colName: 'UserID', value: userid }
                    ]  
                }
                database.update(updateUserstatusObj).catch(err => console.log(err));
                Object.assign(responseObj, { status: 'success' }, { result: 'lock update' })
                resolve(responseObj)
            }else{
                const updateUserstatusObj = {
                    str_tableName: 'tbl_users',
                    data: [
                        { str_colName: 'locked', value: lock }
                    ],
                    condition: [
                        { str_colName: 'UserID', value: userid }
                    ]  
                }
                database.update(updateUserstatusObj).catch(err => console.log(err));
                Object.assign(responseObj, { status: 'success' }, { result: 'lock deleted' })
                resolve(responseObj)
            }
        })
    }

    async updateUser(value)
    {
        try {
            var userData = await this.userDataDetail(value);
            var userSpecialRight = await this.userSpecialRightData(value);
            var companyName = await this.getDeveloperFile();
            var file = companyName;
            var jsonData = jsonfile.readFileSync(file);
            var ldapVal = jsonData.Ldap[0].Value;
            var updateUserData = await this.updateUserDetails(value,userData[0],userSpecialRight,ldapVal);  
            return updateUserData; 
        } catch (error) {
            console.log(error);
            return error;
        }
            
    }
    async userDataDetail(value){
        try {
            let str_query = `SELECT tbl_users.Role, tbl_users.Department, tbl_users.UserInitials, tbl_role.role_rights, tbl_users.UserName, tbl_users.UserID FROM tbl_users LEFT JOIN tbl_role ON tbl_role.role_name = tbl_users.Role WHERE tbl_users.UserID = '${value.oldUserID}'`;
            var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });
            if(result.length > 0)
            {
                return result;
            }
            else{
                return false;
            }
        } catch (error) {
            return error;
        }

    }
    async userSpecialRightData(value)
    {   
        try {
            var result = await models.tbl_rights_special.findAll({where:
                {userid:value.oldUserID}
            });
            if(result.length > 0)
            {
                return result;
            }
            else
            {
                return false;
            }
        } catch (error) {
            return error;
        }
    }
async updateUserDetails(value,userData,userSpecialRight,ldapVal)
{
    try {
        var obj_response = {};
        let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
            var now = new Date();
            var userid = value.userID;
            var newRole = value.role;
            var NewDepartment = value.department;
            var roleRights = value.selectedRoleRights;
            var splRights = value.selectedSplRights;
            var removeRights = [];
            var oldRole = userData.Role;
            var OldDepartment = userData.Department;
            var Olduser = userData.UserInitials;
            var str_oldUserID = userData.UserID;
            var previousRole = value.oldRights;
            var previousSpecialRole = value.oldSpecialRights;
            var previousRemoveRole = value.oldRemoveRights;
            var str_oldUserName =(ldapVal == 0) ? userData.UserName : userData.UserInitials;// NLDAP uses UserName
            
            var oldPreviousRole = previousRole.concat(previousSpecialRole);
            var OldTotalRight = oldPreviousRole.filter(val => !previousRemoveRole.includes(val));
            var newTotalRight = roleRights.concat(splRights);
    
            // for right Remove
            var newTotalRight1 = new Set(newTotalRight);
            var newRightRemove = [...new Set([...OldTotalRight].filter(x => !newTotalRight1.has(x)))];
            var finalRemoveRight = [...new Set([...previousRemoveRole].filter(x => !newTotalRight1.has(x)))];
            var allRemove = newRightRemove.concat(finalRemoveRight);
            if(allRemove.length == 0){
                if(previousRemoveRole.length > 0){
                    var deletePeriviousRight = await this.deletePeriviousRight(userid,newRole,previousRemoveRole,t);
                }
            }
            //if()
            // for right RightAdded
            var newTotalRight2 = new Set(OldTotalRight);
            var newUserRightsAdd = [...new Set([...newTotalRight].filter(x => !newTotalRight2.has(x)))];
    
            /*** END ****/
            var deleteSplRight = await this.deleteSpecialRight(userid,t);
            var deleteRemoveRight = await this.deleteRemoveRight(userid,newRole,allRemove,t);
            if(newRole != oldRole){
                var deleteAllRight = await this.deleteAllUserRight(userid,t);
                var changesRoleRights = await this.getChangesRoleRights(newRole,t);
                if(changesRoleRights != false){
                    var roleRightForNewRole =  changesRoleRights;
                    var removeRoleforNewRole =roleRightForNewRole.filter(item => roleRights.indexOf(item) < 0);
                    var saveRemoveRoleForNewRole = await this.saveRemoveRoleForNewRole(removeRoleforNewRole,splRights,userid,newRole,t);
                }
            }else{
                var addSplUserRights = await this.addSplUserRights(splRights,userid,t);
                var addRemoveUserRights = await this.removeUserRights(allRemove,userid,newRole,t);
            }
            var latestRights = newUserRightsAdd.toString();
            var latestRemoveRights = newRightRemove.toString();
            var auditRemoveRight,auditNewRight;
            if(latestRemoveRights.length == 0)
            {
                auditRemoveRight = 'NA'; 
            } 
            else
            {
                auditRemoveRight = newRightRemove.toString();
            } 
    
            if(latestRights.length == 0)
            {
                auditNewRight = 'NA'; 
            } 
            else
            {
                auditNewRight = newUserRightsAdd.toString();
            } 
    
                await models.tbl_users.update({
                        Role: newRole,
                        Department: NewDepartment,
                        UserInitials: value.userInitials,
                        UserName: value.username,
                        UserID: userid,
                        locked: 0,
                },{where:
                    {UserID: str_oldUserID}
                },{
                    transaction: t
                });
            
                var username;
                if(ldapVal == 0) // NLDAP uses UserName
                {
                    username = value.username;//userData[0].UserInitials;
                }
                else // LDAP used userInitials
                {
                    username = value.userInitials;//userData[0].UserName;
                }
    
                var str_keycode = (str_oldUserID == value.userID) ? value.userID : 
                "New User ID: " + value.userID + ",Old User ID: " + str_oldUserID;
                // Issue resolved for Softshell Edit User 040821 | ReportedBy : Chaitanya
                if(ldapVal == 0) // Non LDAP
                {
                    var str_keyvalue = (str_oldUserName == value.username) ? value.username : 
                    "New User Name: " + value.username + ",Old User Name: " + str_oldUserName;
                }
                else // LDAP
                {
                    var str_keyvalue = (str_oldUserName == value.userInitials) ? value.userInitials : 
                    "New User Name: " + value.userInitials + ",Old User Name: " + str_oldUserName;
                }
                
                await models.tbl_audit_users.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.loggedUserid,
                        username: value.loggedUsername,
                        OldRole: oldRole,
                        NewRole: newRole,
                        ACT: value.hdnAction,
                        KeyCode: str_keycode,
                        KeyValue: str_keyvalue,
                        RightAdded: auditNewRight,
                        RightRemoved: auditRemoveRight,
                        Remark: value.remark,
                        OldDepartment: OldDepartment,
                        NewDepartment: NewDepartment
                },{
                    transaction: t
                });

                await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.loggedUserid,
                        username: value.loggedUsername,
                        activity: 'User Updated' 
            },{
                transaction: t
            });
        });
        
        Object.assign(obj_response, { status: 'success' }, { result: 'User Updated Successfully' });
        return obj_response;
    } catch (error) {
        console.log(error);
        return error;
    }
}



async deleteSpecialRight(userid,t)
{
    try {
        await models.tbl_rights_special.destroy({where:
            {userid: userid}
        });
        return true;
    } catch (error) {
        return error;
    }
}

async deleteRemoveRight(userid,newRole,finalRemoveRight,t)
{
    try {
        for(var i = 0; i < finalRemoveRight.length; i++){
            await models.tbl_rights_removed.destroy({where:
                {
                    userid: userid,
                    role_name: newRole,
                    removed_right: {[Op.ne]:finalRemoveRight[i]}
                }
            });
         }
       
        return true;
    } catch (error) {
        return error;
    }
   
}

async deletePeriviousRight(userid,newRole,previousRemoveRole,t){
    try {
        for(var i = 0; i < previousRemoveRole.length; i++){

            await models.tbl_rights_removed.destroy({where:
                {
                    userid: userid,
                    role_name: newRole,
                    removed_right: previousRemoveRole[i] 
                }
            });
        }
        return true; 
    } catch (error) {
        return error;
    }
   
     
}

async addSplUserRights(splRights,userid)
{
    try{
        if(splRights.length > 0)
        {
            for(let k = 0;k < splRights.length;k++){
                let addsplRight = splRights[k];
                await models.tbl_rights_special.create({
                    userid: userid,
                    spl_right: addsplRight
                });    
            }
            return true;
        }
        else
        {
            return false;
        }
    }catch(error){
        return error;
    }
}

async removeUserRights(removeRights,userid,newRole)
{
    try{
        if(removeRights.length > 0)
        {
            for(let l = 0;l < removeRights.length;l++){
                let addremoveRight = removeRights[l];
                await models.tbl_rights_removed.create({
                    userid: userid,
                    removed_right: addremoveRight,
                    role_name: newRole
                });    
            }
            return true;
        }
        else
        {
            return false;
        }
    }catch(error){
        return error;
    }
}

async deleteAllUserRight(userid,t){
    try{

        await models.tbl_rights_special.destroy({where:
            {userid: userid}
        });

        await models.tbl_rights_removed.destroy({where:
            {userid: userid}
        });
        return true;

    }catch(error){
        return error;
    }
}

async getChangesRoleRights(newRole,t){
    try{

        let strCombinedRoles;
            if (sequelize.options.dialect === 'mssql') {
                strCombinedRoles = ` STRING_AGG(role_rights, ',') `;
            } else { // For mysql
                strCombinedRoles = ` GROUP_CONCAT(role_rights) `;
            }
            let str_query = `SELECT ${strCombinedRoles} as rights from tbl_role where role_name = '${newRole}'`;   

        //let str_query = `SELECT GROUP_CONCAT(role_rights) as rights from tbl_role where role_name = '${newRole}'`;
        var result = await sequelize.query(str_query,{ type: QueryTypes.SELECT });

        var data = result[0];
        var str_rights = data.rights;
        var arr_right = str_rights.split(',');
        return arr_right;  
    }catch(error){
        console.log("getChangesRoleRights",error);
        return error;
    }
}

async saveRemoveRoleForNewRole(removeRoleforNewRole,splRights,userid,newRole){
    try{
        if(removeRoleforNewRole.length > 0)
        {
            for(let l = 0;l < removeRoleforNewRole.length;l++){
                let addremoveRight = removeRoleforNewRole[l];
                await models.tbl_rights_removed.create({
                    userid: userid,
                    removed_right: addremoveRight,
                    role_name: newRole
                });
            }
        }

        if(splRights.length > 0)
        {
            for(let k = 0;k < splRights.length;k++){
                let addsplRight = splRights[k];
                await models.tbl_rights_special.create({
                    userid: userid,
                    spl_right: addsplRight
                }); 
            }
            return true;
        }
        else
        {
            return false;
        }

    }catch(error){
        return error;
    }
}

  async  tempUserStatus(req,value){
        try{
            let clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3]
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            }
            ip=ip.split('.')[3];
            let obj_response = {};

            /** delete from temp table */
            await models.tbl_user_statusreport.destroy({ where:
                {HMIID: ip}  
            });

            let result = await models.tbl_users.findAll({where: 
                { Status: parseInt(value.str_status) }
            });
           
            if(result.length > 0){
                 await models.tbl_user_statusreport.findAll({where: 
                    { HMIID: ip }
                });
               
                for(var i = 0; i < result.length; i++)
                    {

                        await models.tbl_user_statusreport.create({ 
                                UserID: result[i].UserID, 
                                UserName: (value.isLdap == 0) ? result[i].UserName : result[i].UserInitials, 
                                Role: result[i].Role, 
                                Dept: result[i].Department, 
                                Status: value.str_status1,
                                HMIID: ip  
                            });
                    }
                    Object.assign(obj_response, { status: 'success' },{data:ip});
                    return obj_response;

            }else{
                Object.assign(obj_response, { status: 'success' },{data:'No records found'});
                return obj_response;
            }

        }catch(error){
            return error;
        }
            
    }


    async getDeveloperFile(){ // used name from config.json file
        try{
            var str_configFileName = config.developerPanelFileName;
            return str_configFileName;
        }catch(error){
            return error;
        }
    }

     /** this function is used to get user id from user table for change profile for superadmin */
     async getUsersForChangeProfile()
     {
         try {
            let res = await models.tbl_users.findAll({where:[
                {
                   Status: 0,
                   PwdExpStauts: 0,
                   Role: {[Op.ne]:'SuperAdmin'}
                }
            ]});
            return res;
         } catch (error) {
             return error;
         }
        
     }
    
}


module.exports = UserModel;