const fs = require('fs');
const path = require('path');
const date = require('date-and-time');
const serverConfig = require('../global/serverConfig');
const Database = require('../database/clsQueryProcess');
const clsTransDatabase = require('../database/clsQueryTransactProcess');
const clsTablet = require('./clsTabletModel');
const clsCapsule = require('./clsProductCapsuleModel');
const requestIp = require('request-ip');
var FtpClient = require('../FTP/client');
const dbCon = require('../Utills/db');
var ftpClient = new FtpClient();
const database = new Database();
const objTranDatabase = new clsTransDatabase();
const seqTransaction = require("../dbConnection");
var models = require("../dbConnection").models;
const sequelize = require('./../dbConnection').sequelize;
const { Op } = require("sequelize");

const Gbl_Obj_DB_Engine = {};
if (sequelize.options.dialect === 'mssql') {
    let Obj_MSSql = {
        path: '../lib/jasperreports-5.6.0',
        reports: {

        },
        drivers: {
            sqljdbc: {
                path: '../lib/sqljdbc4-2.0.jar',
                class: 'com.microsoft.sqlserver.jdbc.SQLServerDriver',
                type: 'sqljdbc'
            }
        },
        conns: {
            MS_SQL_SERVER: {
                host: serverConfig.dbHost,
                port: 1433,
                dbname: serverConfig.dbName,
                user: serverConfig.dbUser,
                pass: serverConfig.dbPass,
                driver: 'sqljdbc',
                jdbc: `jdbc:sqlserver://${serverConfig.dbHost}:1433;databaseName=${serverConfig.dbName}`,
                validationTimeout: 600
            }
        },
        defaultConn: 'MS_SQL_SERVER',
        java: ["-Djava.awt.headless=true"]//Array of java options, for example ["-Djava.awt.headless=true"]
    }
    Object.assign(Gbl_Obj_DB_Engine, Obj_MSSql);
} else { // For mysql
    let Obj_MySql = {
        path: '../lib/jasperreports-5.6.0',
        reports: {
        },
        drivers: {
            mysql: {
                path: '../lib/com.mysql.jdbc_5.1.5.jar',
                class: 'com.mysql.jdbc.Driver',
                type: 'mysql'
            }
        },
        conns: {
            MY_SQL_SERVER: {
                host: serverConfig.dbHost,
                port: 3306,
                dbname: serverConfig.dbName,
                user: serverConfig.dbUser,
                pass: serverConfig.dbPass,
                driver: 'mysql',
                validationTimeout: 600
            }
        },
        defaultConn: 'MY_SQL_SERVER',
        java: ["-Djava.awt.headless=true"] // Array of java options, for example ["-Djava.awt.headless=true"]
    };
    Object.assign(Gbl_Obj_DB_Engine, Obj_MySql);
}

jasper = require('node-jasper')(Gbl_Obj_DB_Engine);



/**
 * @description Class used to print the report which send request to Jasper reports
 */
class ReportModel {
    constructor(strReportName, str_data) {
        //    this.getProjectName().then(strProjName => {
        //         jasper.reports = {
        //             hw: {
        //                 jasper: '../jasperFiles/' + strProjName + '/' + strReportName + '.jasper'
        //             }
        //         }
        //    })

        jasper.reports.hw = {
            jasper: ''
        }
        this.newJO = jasper;
        this.reportDataObject = {
            report: 'hw',
            data: str_data
        };

    }

    async getProjectName() {
        try {
            let result = await models.tbl_rpt_path.findOne({ attributes: ['proj_name'] });
            return result.proj_name;
        } catch (error) {
            return error;
        }
    }

    makeReport(strJasperName, objDataObject, intClientIP) {

        return new Promise((resolve, reject) => {

            // this.getProjectName().then(strProjName => {
            let filesFrom = sequelize.options.dialect === 'mssql' ? 'MSSQL' : 'MYSQL';

            jasper.reports.hw = {
                jasper: `../jasperFiles/CP10G/${filesFrom}/${strJasperName}.jasper`
            }

            if (this.reportDataObject.data === undefined) { // Other than In-Process reports.
                this.reportDataObject = {
                    report: 'hw',
                    data: objDataObject
                };
                // this.newJO = jasper; // coment this
            }

            // var pdf = "";
            //  pdf = jasper.pdf(report);

            var pdf = this.newJO.pdf(this.reportDataObject);

            const strReportName = strJasperName + '_[' + intClientIP + ']_' + objDataObject.UserId + '.pdf';

            var filepath = "./reports/" + strReportName
            console.log("filepath", filepath);

            var filename = {
                "filepath": serverConfig.reporthost + path.basename(filepath)
            };

            //check if file is present or not 
            fs.access(filepath, fs.constants.F_OK | fs.constants.W_OK, (err) => {
                if (err) {
                    //file is not present 



                    var currentDate = new Date()
                    var val = `${currentDate.getDate()}.${currentDate.getMonth() + 1}.${currentDate.getFullYear()}`;



                    const stream = fs.createWriteStream("./reports/" + strReportName);
                    stream.write(Buffer.from(pdf, 'binary'), () => {

                        stream.close();
                        resolve(filename);
                    })
                    stream.on('finish', function () {
                        // ftpClient.connect(function () { });
                        // var Randomval = Math.floor(1000 + Math.random() * 9000);
                        // ftpClient.upload([`reports/${strReportName}`], `/Cipla/Test/Individual/${val}`, {
                        //     baseDir: 'reports',
                        //     overwrite: 'older',
                        //     name: `${strJasperName}${intClientIP}${Randomval}`
                        // }, function (result) {
                        //     console.log('sdsdsd', result);
                        // });
                        stream.close();
                        resolve(filename);
                    });
                    stream.on('error', (err) => {
                        stream.close();
                        reject(err);
                    })

                } else {
                    //file is present then delete it and then create it 
                    //  var val = Math.floor(1000 + Math.random() * 9000);
                    var currentDate = new Date()
                    var val = `${currentDate.getDate()}.${currentDate.getMonth() + 1}.${currentDate.getFullYear()}`;
                    fs.unlink(filepath, (err) => {
                        if (err) {
                            reject(err);
                        } else {

                            const stream = fs.createWriteStream("./reports/" + strReportName);
                            stream.write(Buffer.from(pdf, 'binary'), () => {
                                stream.close();
                                resolve(filename);

                            })
                            stream.on('finish', function () {
                                // ftpClient.connect(function () { });
                                // var Randomval = Math.floor(1000 + Math.random() * 9000);
                                // ftpClient.upload([`reports/${strReportName}`], `/Cipla/Test/Individual/${val}`, {
                                //     baseDir: 'reports',
                                //     overwrite: 'older',
                                //     name: `${strJasperName}${intClientIP}${Randomval}`
                                // }, function (result) {
                                //     // console.log('sdsdsd',result);
                                // });
                                stream.close();
                                resolve(filename);
                            });
                            stream.on('error', (err) => {
                                stream.close();
                                reject(err);
                            })

                        }

                    });

                }
            });
            // });

        });

        // var report = {
        //     report: 'hw',
        //     data: objDataObject
        // }



    }

    makeReportSummary(strJasperName, objDataObject, intClientIP) {

        return new Promise((resolve, reject) => {

            var report = {
                report: 'hw',
                data: objDataObject
            }

            var pdf = "";
            pdf = jasper.pdf(report);

            const strReportName = strJasperName + '_[' + intClientIP + ']_' + objDataObject.UserId + '.pdf';

            var filepath = "./reports/" + strReportName

            var filename = {
                "filepath": serverConfig.reporthost + path.basename(filepath)
            };

            //check if file is present or not 
            fs.access(filepath, fs.constants.F_OK | fs.constants.W_OK, (err) => {
                if (err) {
                    //file is not present 



                    var currentDate = new Date()
                    var val = `${currentDate.getDate()}.${currentDate.getMonth() + 1}.${currentDate.getFullYear()}`;



                    const stream = fs.createWriteStream("./reports/" + strReportName);
                    stream.write(Buffer.from(pdf, 'binary'), () => {

                        stream.close();
                        resolve(filename);
                    })
                    stream.on('finish', function () {
                        // ftpClient.connect(function () { });
                        // var Randomval = Math.floor(1000 + Math.random() * 9000);
                        // ftpClient.upload([`reports/${strReportName}`], `/Cipla/Test/Individual/${val}`, {
                        //     baseDir: 'reports',
                        //     overwrite: 'older',
                        //     name: `${strJasperName}${intClientIP}${Randomval}`
                        // }, function (result) {
                        //     console.log('sdsdsd', result);
                        // });
                        stream.close();
                        resolve(filename);
                    });
                    stream.on('error', (err) => {
                        stream.close();
                        reject(err);
                    })

                } else {
                    //file is present then delete it and then create it 
                    //  var val = Math.floor(1000 + Math.random() * 9000);
                    var currentDate = new Date()
                    var val = `${currentDate.getDate()}.${currentDate.getMonth() + 1}.${currentDate.getFullYear()}`;
                    fs.unlink(filepath, (err) => {
                        if (err) {
                            reject(err);
                        } else {

                            const stream = fs.createWriteStream("./reports/" + strReportName);
                            stream.write(Buffer.from(pdf, 'binary'), () => {
                                stream.close();
                                resolve(filename);

                            })
                            stream.on('finish', function () {
                                // ftpClient.connect(function () { });
                                // var Randomval = Math.floor(1000 + Math.random() * 9000);
                                // ftpClient.upload([`reports/${strReportName}`], `/Cipla/Test/Individual/${val}`, {
                                //     baseDir: 'reports',
                                //     overwrite: 'older',
                                //     name: `${strJasperName}${intClientIP}${Randomval}`
                                // }, function (result) {
                                //     // console.log('sdsdsd',result);
                                // });
                                stream.close();
                                resolve(filename);
                            });
                            stream.on('error', (err) => {
                                stream.close();
                                reject(err);
                            })

                        }

                    });

                }
            });
        });


    }



    //Model function for Audit trail
    reptAdminName(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;

            models.tbl_audit_adminname.findAll({
                where:
                {
                    dt: { [Op.between]: [fromDate, toDate] },
                }
            }).then(result => {
                if (result.length > 0) {

                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }

    /**
     * 
     * @param {*} value parameter for report generation for admin password
     * @param {*} ClientIp Client Ip of requesting resource
     */
    rptAdminPassword(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            var str_query = {};

            str_query = {
                Action: "Change Admin Password",
                dt: { [Op.between]: [fromDate, toDate] }
            };

            models.tbl_audit_change_password.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })

                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }

    rptSetAllParam(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let selectedParameter = value.reportObj.data.SelectedValue;

            models.tbl_audit_all_periods.findAll({
                where:
                {
                    dt: { [Op.between]: [fromDate, toDate] },
                    TypeOfPeriod: selectedParameter
                }
            }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            });
        });
    }
    /**
    * @param value
    * @description Model creates report for Activity Log 
    */
    reportActivityLog(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            var fromDate = value.reportObj.data.FromDate;
            var toDate = value.reportObj.data.ToDate;
            var selectedUserId = value.reportObj.data.SelectedValue;
            var str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };
            if (selectedUserId != "") Object.assign(str_query, { userid: selectedUserId })
            // {
            //     str_query = 
            // }
            // else
            // {
            //     str_query = {
            //         dt:{[Op.between]:[fromDate,toDate]}
            //     };
            // }
            models.tbl_activity_log.findOne({ where: str_query }).then(result => {
                if (result != undefined) {
                    // this.getProjectName().then(str_projectName=>{
                    // jasper.reports = {
                    //     hw: {
                    //         jasper: '../jasperFiles/SHG/' + value.reportObj.FileName + '.jasper'
                    //     }
                    // }

                    //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                    this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp).then(result => {
                        resolve(Object.assign(result, { status: 'success' }));
                    }).catch(err => {
                        reject(err);
                    })
                    // });
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response);
                }
            });

        });
    }
    /**
 * @param value
 * @description Model creates report for UnAuthorized Login 
 */
    rptUnauthorizeLogin(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let selectedUserId = value.reportObj.data.SelectedValue;
            var str_query;

            if (selectedUserId != "All") {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] },
                    Host: selectedUserId
                };
            }
            else {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] }
                };
            }
            models.tbl_audit_unauthorized_user.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    this.getProjectName().then(str_projectName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + str_projectName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp).then(result => {
                            resolve(Object.assign(result, { status: 'success' }));
                        }).catch(err => {
                            reject(err);
                        })
                    });
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response);
                }
            });

        });
    }
    /**
* @param value
* @description Model creates report for AuditRoles
*/
    rptAuditRoles(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            let str_query = {};

            str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { RoleName: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { ACT: SelectedAction });
            }

            models.tbl_audit_role.findAll({ where: str_query }).then((result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            })).catch(err => { reject(err) })

        })
    }
    /**
  * 
  * @param {*} value Value required for report printing
  * @param {*} ClientIp Ip of requested client
  * @description Model for User report generation
  * @memberof ReportModel
  */
    rptAuditUsers(value, ClientIp) {
        return new Promise((resolve, reject) => {
            var obj_response = {};
            var fromDate = value.reportObj.data.FromDate;
            var toDate = value.reportObj.data.ToDate;
            var selectedUserId = value.reportObj.data.SelectedValue;
            var selectedAction = value.reportObj.data.SelectedAction;
            var query;

            var str_query = {};

            if (value.reportObj.FileName == "RepoAuditChangePasswordSelf" || value.reportObj.FileName == "RepoAuditChangePassword") {
                var action = (value.reportObj.FileName == "RepoAuditChangePasswordSelf") ? "Change Own Password" : "Change Others Password";

                str_query = {
                    Action: action,
                    dt: { [Op.between]: [fromDate, toDate] }
                };

                if (selectedUserId !== "") {
                    Object.assign(str_query, { DoneByUserID: selectedUserId });
                }

                query = models.tbl_audit_change_password.findAll({ where: str_query });

            }
            else {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] }
                };

                if (selectedUserId != "") {
                    Object.assign(str_query, { KeyCode: selectedUserId });
                }

                if (selectedAction != "") {
                    Object.assign(str_query, { ACT: selectedAction });
                }

                query = models.tbl_audit_users.findAll({ where: str_query });
            }

            query.then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITIALIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
 * 
 * @param {*} value Value required for report printing
 * @param {*} ClientIp Ip of requested client
 * @description Model for User report generation
 * @memberof ReportModel
 */
    rptDeparment(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let selectedAction = value.reportObj.data.SelectedAction;
            var str_query = {};
            str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { NewValue: SelectedValue });
            }

            if (selectedAction != "") {
                Object.assign(str_query, { Act: selectedAction });
            }

            models.tbl_audit_department.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITIALIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
* 
* @param {*} value Value required for report printing
* @param {*} ClientIp Ip of requested client
* @description Model for User report generation
* @memberof ReportModel
*/
    rptCalibratiobBox(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let selectedAction = value.reportObj.data.SelectedAction;
            let selectedBoxType = value.reportObj.data.selectedBoxType;

            var str_query = {};

            str_query = {
                ACB_dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { ACB_ID: SelectedValue });
            }

            if (selectedAction != "") {
                Object.assign(str_query, { ACB_ACT: selectedAction });
            }

            if (selectedBoxType != "") {
                Object.assign(str_query, { ACB_Type: selectedBoxType });
            }

            models.tbl_audit_calibrationbox.findAll({ where: str_query }).then(result => {

                if (result.length > 0) {
                    // CONSTRUCTURE INITIALIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
     * 
     * @param {*} value Value required for report printing
     * @param {*} ClientIp Ip of requested client
     * @description Model for Balance report generation
     * @memberof ReportModel
     */
    rptBalance(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            var str_query = {};

            str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { Bal_Id: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { ACT: SelectedAction });
            }

            models.tbl_audit_bal_setting.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
     * 
     * @param {*} value Value required for report printing
     * @param {*} ClientIp Ip of requested client
     * @description Model for Balance report generation
     * @memberof ReportModel
     */
    rptVernier(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            let str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            }
            if (SelectedValue !== "") {
                Object.assign(str_query, { VernierID: SelectedValue })
                // selectDataObj.condition.push({ str_colName: 'VernierID', value: SelectedValue })
            }
            if (SelectedAction !== "") {
                Object.assign(str_query, { ACT: SelectedAction })
                // selectDataObj.condition.push({ str_colName: 'ACT', value: SelectedAction })
            }
            models[strTableName].findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
     * 
     * @param {*} value Value required for report printing
     * @param {*} ClientIp Ip of requested client
     * @description Model for Balance report generation
     * @memberof ReportModel
     */
    rptOtherEquipment(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            let SelectedType = value.reportObj.data.SelectedType;
            var str_query = {};

            str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { Eqp_ID: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { Action: SelectedAction });
            }

            if (SelectedType != "") {
                Object.assign(str_query, { Eqp_Type: SelectedType });
            }

            models.tbl_audit_other_equipment.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
     * 
     * @param {*} value Value required for report printing
     * @param {*} ClientIp Ip of requested client
     * @description Model for MAchine report generation
     * @memberof ReportModel
     */
    rptMachine(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            var str_query = {};

            str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { MachineID: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { ACT: SelectedAction });
            }

            models.tbl_audit_machine.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
    * 
    * @param {*} value Value required for report printing
    * @param {*} ClientIp Ip of requested client
    * @description Model for Media report generation
    * @memberof ReportModel
    */
    rptMedia(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            var str_query = {};

            str_query = {
                dt: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { Media: SelectedValue });
            }

            models.tbl_audit_dtmedia.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
   * 
   * @param {*} value Value required for report printing
   * @param {*} ClientIp Ip of requested client
   * @description Model for Stage report generation
   * @memberof ReportModel
   */
    rptStage(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            var str_query;

            if (SelectedValue != "") {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] },
                    Stage: SelectedValue
                };
            }
            else {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] }
                };
            }

            models.tbl_audit_stages.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            });
        })
    }
    /**
* 
* @param {*} value Value required for report printing
* @param {*} ClientIp Ip of requested client
* @description Model for Product report generation
* @memberof ReportModel
*/
    rptProduct(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            let prdType = value.reportObj.data.prdType;

            if (SelectedValue == '1') {
                strTableName = 'tbl_audit_product';
            }
            else if (SelectedValue == '3') {
                strTableName = 'tbl_audit_product_multihaler';
            }
            else if (SelectedValue == '4') {
                strTableName = 'tbl_audit_product_softshell';
            }
            else if (SelectedValue == '5') {
                strTableName = 'tbl_audit_product_dosadry';
            }
            else {
                strTableName = 'tbl_audit_product_capsule';
            }

            var str_query = {};

            str_query =
            {
                DT: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue == '1') {
                Object.assign(str_query, { type: prdType });
            }

            if (SelectedValue == '2') {
                Object.assign(str_query, { ProductType: SelectedValue }, { type: prdType });
            }

            if (SelectedValue == '3' || SelectedValue == '4' || SelectedValue == '5') {
                Object.assign(str_query, { ProductType: SelectedValue });
            }

            if (SelectedAction !== "") {
                Object.assign(str_query, { ACT: SelectedAction });
            }

            models['' + strTableName].findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports =
                        {
                            hw:
                            {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                }
                else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
//  * 
//  * @param {*} value Value required for report printing
//  * @param {*} ClientIp Ip of requested client
//  * @description Model for Product report generation
//  * @memberof ReportModel
//  */
    //     rptProduct(value, ClientIp) {
    //         return new Promise((resolve, reject) => {
    //             let responseObj = {};
    //             let strTableName = value.strTableName;
    //             let fromDate = value.reportObj.data.FromDate;
    //             let toDate = value.reportObj.data.ToDate;
    //             let SelectedValue = value.reportObj.data.SelectedValue;
    //             let SelectedAction = value.reportObj.data.SelectedAction;
    //             if (SelectedValue == '1') {
    //                 strTableName = 'tbl_audit_product';
    //             } else {
    //                 strTableName = 'tbl_audit_product_capsule';
    //             }
    //             let selectDataObj = {
    //                 str_tableName: strTableName,
    //                 data: '*',
    //                 condition: [
    //                     { str_colName: 'DT', value: fromDate, value1: toDate, comp: 'btn' }
    //                 ]
    //             }
    //             if (SelectedAction !== "") {
    //                 selectDataObj.condition.push({ str_colName: 'ACT', value: SelectedAction })
    //             }
    //             database.select(selectDataObj).then(result => {
    //                 if (result[0].length > 0) {
    //                     // CONSTRUCTURE INITLIZED WITH FILENAME
    //                     jasper.reports = {
    //                         hw: {
    //                             jasper: '../jasperFiles/' + value.reportObj.FileName + '.jasper'
    //                         }
    //                     }
    //                     //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
    //                     this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
    //                         .then(result => {
    //                             //SUCCESS
    //                             resolve(Object.assign(result, { status: 'success' }))
    //                         }).catch(err => {
    //                             //ERR
    //                             reject(err);
    //                         })
    //                 } else {
    //                     //ENTRIES NOT PRESENT
    //                     responseObj = { status: 'success', data: 'No records found' };
    //                     resolve(responseObj)
    //                 }
    //             }).catch(err => { reject(err) })
    //         })
    //     }
    /**
* 
* @param {*} value Value required for report printing
* @param {*} ClientIp Ip of requested client
* @description Model for Area audit report generation
* @memberof ReportModel
*/
    rptArea(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            var str_query;

            if (SelectedValue != "") {
                str_query = {
                    DT: { [Op.between]: [fromDate, toDate] },
                    Area: SelectedValue
                };
            }
            else {
                str_query = {
                    DT: { [Op.between]: [fromDate, toDate] }
                };
            }

            models[value.strTableName].findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
* 
* @param {*} value Value required for report printing
* @param {*} ClientIp Ip of requested client
* @description Model for rptContainer audit report generation
* @memberof ReportModel
*/
    rptContainer(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            let obj_query = { where: { dt: { [Op.between]: [fromDate, toDate] } } };

            if (SelectedValue !== "") {
                Object.assign(obj_query.where, { Act: SelectedValue });
            }

            if (SelectedAction !== "") {
                if (strTableName == "tbl_audit_bin_release") {
                    Object.assign(obj_query.where, { CubType: SelectedAction });
                }
                else {
                    Object.assign(obj_query.where, { ContainerID: SelectedAction });
                }

            }
            models[strTableName].findAll(obj_query).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }


    rptAuditBinStage(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            var str_query;

            if (SelectedValue != "") {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] },
                    Stage: SelectedValue
                };
            }
            else {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] }
                };
            }

            models[strTableName].findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }


    /**
* 
* @param {*} value Value required for report printing
* @param {*} ClientIp Ip of requested client
* @description Model for rptCubicle audit report generation
* @memberof ReportModel
*/
    rptCubicle(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            var str_query;
            str_query = {
                DT: { [Op.between]: [fromDate, toDate] },
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { Area: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { ACT: SelectedAction });
            }


            models[strTableName].findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }


    /**
* 
* @param {*} value Value required for report printing
* @param {*} ClientIp Ip of requested client
* @description Model for rptCubicle audit report generation
* @memberof ReportModel
*/
    rptRecalib(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            var str_query;

            str_query = {
                DT: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { CalibType: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { EqpType: SelectedAction });
            }

            models.tbl_audit_recalibration.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }

    /**
     * This function will increase a printcount
     *
     * @param {*} objPrintCount : Object with following structure 
     * `{
     *      intReportSerNo : Report Serial no of report,
     *      reportOption : Type of Weighment i.e Indiv, Group Etc.
     *      reportType : Complete / Incomplete
     *      recordFrom : Current / Archive
     * }`
     * @returns
     * @memberof ReportModel
     */

    async increasePrintNoCapsule(objPrintCount) {

        const arrTransactionQueries = [];
        const objCapsule = new clsCapsule();
        const TableName = await objCapsule.commanFunctionForFindingOutTableName(objPrintCount.reportOption,
            objPrintCount.reportType, objPrintCount.recordFrom);

        const objTableUpdate = {
            str_tableName: TableName.masterTableName,
            data: [
                { str_colName: 'PrintNo', value: objPrintCount.intPrintCount }
            ],
            condition: [
                { str_colName: 'RepSerNo', value: objPrintCount.intReportSerNo }
            ],
            action: 'up'
        }

        var now = new Date();
        const objAuditEntry = {
            str_tableName: TableName.strPrintTableName,
            data: [
                { str_colName: 'RepSrNo', value: objPrintCount.intReportSerNo },
                { str_colName: 'PrintNo', value: objPrintCount.intPrintCount },
                { str_colName: 'Reason', value: objPrintCount.strReason },
                { str_colName: 'Title', value: TableName.intWeighmentSrNo },
                { str_colName: 'UserID', value: objPrintCount.strUserId },
                { str_colName: 'UserName', value: objPrintCount.strUserName },
                { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
                { str_colName: 'IsIncomplete', value: objPrintCount.reportType == "Complete" ? 1 : 0 },

            ],
            action: 'in'
        }


        const objActivityLog = {
            str_tableName: "tbl_activity_log",
            data: [
                { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                { str_colName: "userid", value: objPrintCount.strUserId },
                { str_colName: "username", value: objPrintCount.strUserName },
                { str_colName: "activity", value: objPrintCount.reportOption + ' Report Printed' },
            ],
            action: "in"
        }

        arrTransactionQueries.push(objTableUpdate, objAuditEntry, objActivityLog);
        var res = await objTranDatabase.funMakeQueries(arrTransactionQueries);
        return res;


    }

    async increasePrintNoSummary(objPrintCount) {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();
                // await models.tbl_batchsummary.update({
                //     PrintNo: parseInt(Number(objPrintCount.int_printNo + 1))
                // }, {
                //     where:
                //     {
                //         ProductType: objPrintCount.str_prdType,
                //         CubType: objPrintCount.str_cubType,
                //         BatchNo: objPrintCount.str_batchNo,
                //         ReportOption: objPrintCount.str_reportOption,
                //         ProductId: objPrintCount.str_prdID,
                //         ProductName: objPrintCount.str_prdName,
                //         PrdVersion: objPrintCount.str_prdVersion,
                //         Version: objPrintCount.str_version,
                //         Side: objPrintCount.str_side,
                //         Area: objPrintCount.str_area
                //     }
                // }, {
                //     transaction: t
                // });
                let PrintCount = await models.tbl_batchsummary.findAll({
                    attribute: ['PrintNo'],
                    where:
                    {
                        ProductType: objPrintCount.str_prdType,
                        CubType: objPrintCount.str_cubType,
                        BatchNo: objPrintCount.str_batchNo,
                        ReportOption: objPrintCount.str_reportOption,
                        ProductId: objPrintCount.str_prdID,
                        ProductName: objPrintCount.str_prdName,
                        PrdVersion: objPrintCount.str_prdVersion,
                        Version: objPrintCount.str_version,
                        Side: objPrintCount.str_side,
                        Area: objPrintCount.str_area
                    }
                });
                await models.tbl_batchsummary.update({
                    PrintNo: PrintCount[0].PrintNo + 1
                },
                    {
                        where: {
                            ProductType: objPrintCount.str_prdType,
                            CubType: objPrintCount.str_cubType,
                            BatchNo: objPrintCount.str_batchNo,
                            ReportOption: objPrintCount.str_reportOption,
                            ProductId: objPrintCount.str_prdID,
                            ProductName: objPrintCount.str_prdName,
                            PrdVersion: objPrintCount.str_prdVersion,
                            Version: objPrintCount.str_version,
                            Side: objPrintCount.str_side,
                            Area: objPrintCount.str_area
                        },
                        transaction: t
                    });

                await models.tbl_batchsummary_printrecord.create({
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    ProductType: objPrintCount.str_prdType,
                    CubType: objPrintCount.str_cubType,
                    BatchNo: objPrintCount.str_batchNo,
                    ParamName: objPrintCount.str_reportOption,
                    BFGCode: objPrintCount.str_prdID,
                    PrdName: objPrintCount.str_prdName,
                    PrdVersion: objPrintCount.str_prdVersion,
                    Version: objPrintCount.str_version,
                    Side: objPrintCount.str_side,
                    PrintNo: parseInt(Number(objPrintCount.int_printNo + 1)),
                    Reason: objPrintCount.strReason,
                    Area: objPrintCount.str_area
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: "Summary-" + objPrintCount.str_reportOption + ' Report Printed',
                }, {
                    transaction: t
                });
            });

            return "Done";
        } catch (error) {
            return error;
        }

    }

    async increasePrintCountBinSummary(objPrintCount) {
        try {
            var transactionRep = await seqTransaction.sequelize.transaction(async (t) => {
                const arrTransactionQueries = [];
                var strTableName = "";
                if (objPrintCount.str_type == "Compression") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
                }
                else if (objPrintCount.str_type == "Coating") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";
                }
                else if (objPrintCount.str_type == "Granulation") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";
                }
                else if (objPrintCount.str_type == "IPC") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";
                }
                else {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived";
                }

                let PrintCount = await models[strTableName].findAll({
                    attribute: ['Bin_PrintNoSummary'],
                    where: {
                        Bin_ProductID: objPrintCount.str_prdID,
                        Bin_ProductName: objPrintCount.str_prdName,
                        Bin_ProductVersion: objPrintCount.str_prdVersion,
                        Bin_Version: objPrintCount.str_version,
                        Bin_BatchNo: objPrintCount.str_batchNo,
                        Bin_area: objPrintCount.str_type,
                        Bin_BatchComplete: 1,
                    }
                });


                await models[strTableName].update({
                    Bin_PrintNoSummary: PrintCount[0].Bin_PrintNoSummary + 1
                },
                    {
                        where: {
                            Bin_ProductID: objPrintCount.str_prdID,
                            Bin_ProductName: objPrintCount.str_prdName,
                            Bin_ProductVersion: objPrintCount.str_prdVersion,
                            Bin_Version: objPrintCount.str_version,
                            Bin_BatchNo: objPrintCount.str_batchNo,
                            Bin_area: objPrintCount.str_type,
                            Bin_BatchComplete: 1,
                        }
                    });

                var now = new Date();

                await models.tbl_bin_summary_printrecord.create({
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    CubType: objPrintCount.str_type,
                    BatchNo: objPrintCount.str_batchNo,
                    BFGCode: objPrintCount.str_prdID,
                    PrdName: objPrintCount.str_prdName,
                    PrdVersion: objPrintCount.str_prdVersion,
                    Version: objPrintCount.str_version,
                    PrintNo: parseInt(Number(PrintCount[0].Bin_PrintNoSummary + 1)),
                    Reason: objPrintCount.strReason,
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: objPrintCount.lblBinText + " " + objPrintCount.rptLabelForActivity,
                }, {
                    transaction: t
                });

                return "done";
            })
            return transactionRep;
        } catch (error) {
            console.log(error);
            throw error;
        }

    }


    async increasePrintCountUpBinLabel(objPrintCount) {
        try {
            var transactionRep = await seqTransaction.sequelize.transaction(async (t) => {
                const arrTransactionQueries = [];
                var strTableName = "";
                if (objPrintCount.str_type == "Compression") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
                }
                else if (objPrintCount.str_type == "Coating") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";
                }
                else if (objPrintCount.str_type == "Granulation") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";
                }
                else if (objPrintCount.str_type == "Capsule Filling") {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived";
                }
                else {
                    (objPrintCount.str_ICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";
                }

                // const objSummaryUpdate = {
                //     str_tableName: strTableName,
                //     data: [
                //         { str_colName: 'Bin_PrintNo', value: parseInt(Number(objPrintCount.int_printNo + 1)) }
                //     ],
                //     condition: [
                //         { str_colName: 'RecNo', value: objPrintCount.intRecNo, comp: 'eq' }
                //     ],
                //     action: 'up'
                // }

                let PrintCount = await models[strTableName].findAll({
                    attribute: ['Bin_PrintNo'],
                    where: { RecNo: objPrintCount.intRecNo }
                });


                await models[strTableName].update({
                    Bin_PrintNo: PrintCount[0].Bin_PrintNo + 1
                }, {
                    where: { RecNo: objPrintCount.intRecNo },
                    transaction: t
                });


                var now = new Date();
                // const objAuditEntry = {
                //     str_tableName: "tbl_bin_label_printrecord",
                //     data: [
                //         { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
                //         { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
                //         { str_colName: 'UserID', value: objPrintCount.strUserId },
                //         { str_colName: 'UserName', value: objPrintCount.strUserName },
                //         { str_colName: 'CubType', value: objPrintCount.str_type },
                //         { str_colName: 'BatchNo', value: objPrintCount.str_batchNo },
                //         { str_colName: 'BFGCode', value: objPrintCount.str_prdID },
                //         { str_colName: 'PrdName', value: objPrintCount.str_prdName },
                //         { str_colName: 'PrdVersion', value: objPrintCount.str_prdVersion },
                //         { str_colName: 'Version', value: objPrintCount.str_version },
                //         { str_colName: 'PrintNo', value: parseInt(Number(objPrintCount.int_printNo + 1)) },
                //         { str_colName: 'Reason', value: objPrintCount.strReason },
                //         { str_colName: 'RepSerNo', value: objPrintCount.intRecNo }
                //     ],
                //     action: 'in'
                // }

                await models.tbl_bin_label_printrecord.create({
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    CubType: objPrintCount.str_type,
                    BatchNo: objPrintCount.str_batchNo,
                    BFGCode: objPrintCount.str_prdID,
                    PrdName: objPrintCount.str_prdName,
                    PrdVersion: objPrintCount.str_prdVersion,
                    Version: objPrintCount.str_version,
                    PrintNo: parseInt(Number(PrintCount[0].Bin_PrintNo + 1)),
                    Reason: objPrintCount.strReason,
                    RepSerNo: objPrintCount.intRecNo
                }, {
                    transaction: t
                });
                // const objActivityLog = {
                //     str_tableName: "tbl_activity_log",
                //     data: [
                //         { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                //         { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                //         { str_colName: "userid", value: objPrintCount.strUserId },
                //         { str_colName: "username", value: objPrintCount.strUserName },
                //         { str_colName: "activity", value: objPrintCount.rptLabelForActivity },
                //     ],
                //     action: "in"
                // }

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: objPrintCount.rptLabelForActivity,
                }, {
                    transaction: t
                });

                return "Done";

            });
            return transactionRep;
        } catch (error) {
            return error;
        }
    }


    /**
         * This function will increase a printcount for calibraion reports
         *
         * @param {*} objPrintCount : Object with following structure 
         * `{
         *      calibrationType : Daily/ Periodic,
         *      date : date.
         *      reportType : Complete / Incomplete
         *      printNo : Print number
         *      strReason : Reason
         * }`
         * @returns
         * @memberof ReportModel
         */
    // async increasePrintNoCalibration(objPrintCount) {

    //     var objAuditEntry;
    //     let transaction = await seqTransaction.sequelize.transaction(async (t) => {
    //         if (objPrintCount.calibrationType == 'Daily') {
    //             var now = new Date();

    //             const objAuditEntry = await models.tbl_calibration_daily_print.create({
    //                 BalanceID: objPrintCount.BalanceID,
    //                 PrintNo: Number(objPrintCount.printNo + 1),
    //                 Reason: objPrintCount.strReason,
    //                 Title: 'DailyCalibration',
    //                 UserID: objPrintCount.userID,
    //                 UserName: objPrintCount.username,
    //                 Print_Dt: date.format(now, 'YYYY-MM-DD'),
    //                 Print_Tm: date.format(now, 'HH:mm:ss'),
    //                 Rept_Month: objPrintCount.date.split('-')[1],
    //                 Rept_Year: objPrintCount.date.split('-')[0],
    //                 Incomplete: objPrintCount.reportType == "Complete" ? 0 : 1,
    //                 Daily_CalibChange: objPrintCount.calibChange
    //             }, {
    //                 transaction: t
    //             });
    //             let result = objAuditEntry;
    //         }
    //         else {
    //             var now = new Date();
    //             var strTableName = "";

    //             (objPrintCount.reportType == "Complete") ? strTableName = "tbl_calibration_periodic_master" : strTableName = "tbl_calibration_periodic_master_failed";

    //             await models[strTableName].update({
    //                 Periodic_PrintNo: Number(objPrintCount.printNo + 1)
    //             }, {
    //                 where:
    //                     { Periodic_RepNo: objPrintCount.repSrNo },
    //                 transaction: t
    //             });

    //             const objAuditEntry = await models.tbl_calibration_periodic_print.create({
    //                 BalanceID: objPrintCount.BalanceID,
    //                 RepSrNo: objPrintCount.repSrNo,
    //                 PrintNo: Number(objPrintCount.printNo + 1),
    //                 Reason: objPrintCount.strReason,
    //                 Title: 'PeriodicCalibration',
    //                 UserID: objPrintCount.userID,
    //                 UserName: objPrintCount.username,
    //                 Print_Dt: date.format(now, 'YYYY-MM-DD'),
    //                 Print_Tm: date.format(now, 'HH:mm:ss'),
    //                 Incomplete: objPrintCount.reportType == "Complete" ? 0 : 1
    //             }, {
    //                 transaction: t
    //             });
    //         }

    //         const objActivityLog = await models.tbl_activity_log.create
    //             ({
    //                 dt: date.format(now, 'YYYY-MM-DD'),
    //                 tm: date.format(now, 'HH:mm:ss'),
    //                 userid: objPrintCount.userID,
    //                 username: objPrintCount.username,
    //                 activity: objPrintCount.calibrationType + ' Calibration Report Printed',
    //             }, {
    //                 transaction: t
    //             });
    //         let result = objActivityLog;

    //     });
    //     return result;
    // }

    async increasePrintNoCalibration(objPrintCount) {
        try {
            var objAuditEntry;
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                if (objPrintCount.calibrationType == 'Daily') {
                    var now = new Date();

                    const objAuditEntry = await models.tbl_calibration_daily_print.create({
                        BalanceID: objPrintCount.BalanceID,
                        PrintNo: Number(objPrintCount.printNo + 1),
                        Reason: objPrintCount.strReason,
                        Title: 'DailyCalibration',
                        UserID: objPrintCount.userID,
                        UserName: objPrintCount.username,
                        Print_Dt: date.format(now, 'YYYY-MM-DD'),
                        Print_Tm: date.format(now, 'HH:mm:ss'),
                        Rept_Month: objPrintCount.date.split('-')[1],
                        Rept_Year: objPrintCount.date.split('-')[0],
                        Incomplete: objPrintCount.reportType == "Complete" ? 0 : 1,
                        Daily_CalibChange: objPrintCount.calibChange
                    }, {
                        transaction: t
                    });
                    let result = objAuditEntry;
                }
                else {
                    var now = new Date();
                    var strTableName = "";

                    var int_periodicFirstReportRepeatability = serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name == 'PeriodicFirstReportRepeatability').Value;
                    if (int_periodicFirstReportRepeatability == '1') {
                        (objPrintCount.reportType == "Complete") ? strTableName = "tbl_calibration_repetability_master" : strTableName = "tbl_calibration_repetability_master_failed";

                        await models[strTableName].update({
                            Repet_PrintNo: Number(objPrintCount.printNo + 1)
                        }, {
                            where:
                                { Repet_RepNo: objPrintCount.repSrNo },
                            transaction: t
                        });

                        const objAuditEntry = await models.tbl_calibration_repetability_print.create({
                            BalanceID: objPrintCount.BalanceID,
                            RepSrNo: objPrintCount.repSrNo,
                            PrintNo: Number(objPrintCount.printNo + 1),
                            Reason: objPrintCount.strReason,
                            Title: 'PeriodicCalibration',
                            UserID: objPrintCount.userID,
                            UserName: objPrintCount.username,
                            Print_Dt: date.format(now, 'YYYY-MM-DD'),
                            Print_Tm: date.format(now, 'HH:mm:ss'),
                            Incomplete: objPrintCount.reportType == "Complete" ? 0 : 1
                        }, {
                            transaction: t
                        });
                    }
                    else {
                        (objPrintCount.reportType == "Complete") ? strTableName = "tbl_calibration_periodic_master" : strTableName = "tbl_calibration_periodic_master_failed";

                        await models[strTableName].update({
                            Periodic_PrintNo: Number(objPrintCount.printNo + 1)
                        }, {
                            where:
                                { Periodic_RepNo: objPrintCount.repSrNo },
                            transaction: t
                        });

                        const objAuditEntry = await models.tbl_calibration_periodic_print.create({
                            BalanceID: objPrintCount.BalanceID,
                            RepSrNo: objPrintCount.repSrNo,
                            PrintNo: Number(objPrintCount.printNo + 1),
                            Reason: objPrintCount.strReason,
                            Title: 'PeriodicCalibration',
                            UserID: objPrintCount.userID,
                            UserName: objPrintCount.username,
                            Print_Dt: date.format(now, 'YYYY-MM-DD'),
                            Print_Tm: date.format(now, 'HH:mm:ss'),
                            Incomplete: objPrintCount.reportType == "Complete" ? 0 : 1
                        }, {
                            transaction: t
                        });
                    }

                }

                const objActivityLog = await models.tbl_activity_log.create
                    ({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: objPrintCount.userID,
                        username: objPrintCount.username,
                        activity: objPrintCount.calibrationType + ' Calibration Report Printed',
                    }, {
                        transaction: t
                    });
                let result = objActivityLog;
            });
            return "Success";
        } catch (error) {
            return error;
        }
    }

    async printCountUpCalibrationVernier(objPrintCount) {

        const arrTransactionQueries = [];

        var now = new Date();
        var strTableName = "";
        (objPrintCount.reportType == "Complete") ? strTableName = "tbl_calibration_periodic_master_vernier" : strTableName = "tbl_calibration_periodic_master_vernier_incomplete";

        const objAuditEntry = {
            str_tableName: 'tbl_calibration_periodic_vernier_print',
            data: [
                { str_colName: 'VernierID', value: objPrintCount.VernierCode },
                { str_colName: 'RepSrNo', value: objPrintCount.repSrNo },
                { str_colName: 'PrintNo', value: Number(objPrintCount.printNo + 1) },
                { str_colName: 'Reason', value: objPrintCount.strReason },
                { str_colName: 'Title', value: 'PeriodicCalibration' },
                { str_colName: 'UserID', value: objPrintCount.userID },
                { str_colName: 'UserName', value: objPrintCount.username },
                { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
                { str_colName: 'Incomplete', value: objPrintCount.reportType == "Complete" ? 0 : 1 },

            ],
            action: 'in'
        }


        var objPrintEntryInMaster = {
            str_tableName: strTableName,
            data: [
                { str_colName: 'Periodic_PrintNo', value: Number(objPrintCount.printNo + 1) }
            ],
            condition: [
                { str_colName: 'Periodic_RepNo', value: objPrintCount.repSrNo }
            ],
            action: 'up'
        }

        arrTransactionQueries.push(objPrintEntryInMaster);


        const objActivityLog = {
            str_tableName: "tbl_activity_log",
            data: [
                { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                { str_colName: "userid", value: objPrintCount.userID },
                { str_colName: "username", value: objPrintCount.username },
                { str_colName: "activity", value: "Vernier-" + objPrintCount.calibrationType + ' Calibration Report Printed' },
            ],
            action: "in"
        }

        arrTransactionQueries.push(objAuditEntry, objActivityLog);
        let res = await objTranDatabase.funMakeQueries(arrTransactionQueries);
        return res;
    }

    async verifyReportCapsule(objReport) {

        const arrTransactionQueries = [];

        const objCapsule = new clsCapsule();
        const TableName = await objCapsule.commanFunctionForFindingOutTableName(objReport.reportOption,
            objReport.reportType, objReport.recordFrom);
        var objTableUpdate;
        var now = new Date();
        if (objReport.reportType == 'Complete') {
            if (objReport.outOfLimit == false)//if out of limit then store remark
            {
                objTableUpdate = {
                    str_tableName: TableName.masterTableName,
                    data: [
                        { str_colName: 'CheckedByID', value: objReport.strUserId },
                        { str_colName: 'CheckedByName', value: objReport.strUserName },
                        { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD HH:mm:ss') },
                        { str_colName: 'RepoLabel13', value: objReport.strReason }
                    ],
                    condition: [
                        { str_colName: 'RepSerNo', value: objReport.intReportSerNo }
                    ],
                    action: 'up'
                }
            }
            else {
                objTableUpdate = {
                    str_tableName: TableName.masterTableName,
                    data: [
                        { str_colName: 'CheckedByID', value: objReport.strUserId },
                        { str_colName: 'CheckedByName', value: objReport.strUserName },
                        { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD HH:mm:ss') }
                    ],
                    condition: [
                        { str_colName: 'RepSerNo', value: objReport.intReportSerNo }
                    ],
                    action: 'up'
                }
            }
        }
        else {
            objTableUpdate = {
                str_tableName: TableName.masterTableName,
                data: [
                    { str_colName: 'CheckedByID', value: objReport.strUserId },
                    { str_colName: 'CheckedByName', value: objReport.strUserName },
                    { str_colName: 'RepoLabel13', value: objReport.strReason },
                    { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD HH:mm:ss') }
                ],
                condition: [
                    { str_colName: 'RepSerNo', value: objReport.intReportSerNo }
                ],
                action: 'up'
            }
        }


        const objActivityLog = {
            str_tableName: "tbl_activity_log",
            data: [
                { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                { str_colName: "userid", value: objReport.strUserId },
                { str_colName: "username", value: objReport.strUserName },
                { str_colName: "activity", value: objReport.reportOption + ' Report Verified' },
            ],
            action: "in"
        }

        arrTransactionQueries.push(objTableUpdate, objActivityLog);
        var res = objTranDatabase.funMakeQueries(arrTransactionQueries);
        return res;


    }


    async checkCapsuleReportIsVerified(objReport) {
        const objCapsule = new clsCapsule();
        const TableName = await objCapsule.commanFunctionForFindingOutTableName(objReport.reportOption,
            objReport.reportType, objReport.recordFrom);
        var res = await dbCon.execute("Select CheckedByID from " + TableName.masterTableName + " where RepSerNo=" + objReport.intReportSerNo);
        return res[0][0].CheckedByID;

    }

    async printReasonReportCapsule(value, req) {
        try {

            let clientIp = requestIp.getClientIp(req);
            const objCapsule = new clsCapsule();
            const TableName = await objCapsule.commanFunctionForFindingOutTableName(value.reportOption,
                value.reportType, value.recordFrom);
            var data = {};
            let printTableName = TableName.strPrintTableName;
            let selectObj = {
                str_tableName: printTableName,
                data: '*',
                condition: [
                    { str_colName: 'RepSrNo', value: value.RepSrNo }
                ]
            }
            var responseObj = {};
            var printResult = await database.select(selectObj);
            if (printResult[0].length > 0) {
                // check if temporary table having entry related to HMI if present then delte it first then 
                // copy cuurent data
                let checkObj = {
                    str_tableName: 'tbl_printoutreason_weighingreport',
                    data: '*',
                    condition: [
                        { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                    ]
                }
                var checkResul = await database.select(checkObj);
                if (checkResul[0].length > 0) {
                    let deleteObj = {
                        str_tableName: 'tbl_printoutreason_weighingreport',
                        condition: [
                            { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                        ]
                    }
                    var delRes = await database.delete(deleteObj);
                    for (const obj of printResult[0]) {
                        let inserDataObj = {
                            str_tableName: 'tbl_printoutreason_weighingreport',
                            data: [
                                { str_colName: 'RepSrNo', value: obj.RepSrNo },
                                { str_colName: 'PrintNo', value: obj.PrintNo },
                                { str_colName: 'Reason', value: obj.Reason },
                                { str_colName: 'Title', value: obj.Title },
                                { str_colName: 'UserID', value: obj.UserID },
                                { str_colName: 'UserName', value: obj.UserName },
                                { str_colName: 'Print_Dt', value: obj.Print_Dt },
                                { str_colName: 'Print_Tm', value: obj.Print_Tm },
                                { str_colName: 'IsIncomplete', value: obj.IsIncomplete[0] },
                                { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] },
                            ]
                        }
                        var result = database.save(inserDataObj);
                        Object.assign(data, { HmiId: clientIp.split(':')[3].split('.')[3] });


                    }

                } else {
                    for (const obj of printResult[0]) {
                        let inserDataObj = {
                            str_tableName: 'tbl_printoutreason_weighingreport',
                            data: [
                                { str_colName: 'RepSrNo', value: obj.RepSrNo },
                                { str_colName: 'PrintNo', value: obj.PrintNo },
                                { str_colName: 'Reason', value: obj.Reason },
                                { str_colName: 'Title', value: obj.Title },
                                { str_colName: 'UserID', value: obj.UserID },
                                { str_colName: 'UserName', value: obj.UserName },
                                { str_colName: 'Print_Dt', value: obj.Print_Dt },
                                { str_colName: 'Print_Tm', value: obj.Print_Tm },
                                { str_colName: 'IsIncomplete', value: obj.IsIncomplete[0] },
                                { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] },
                            ]
                        }
                        var result = await database.save(inserDataObj);
                        Object.assign(data, { HmiId: clientIp.split(':')[3].split('.')[3] });


                    }
                }
                return data;

            } else {
                Object.assign(responseObj, { 'status': 'success', 'data': 'No record Found' });
                return responseObj;
            }

        } catch (err) {
            console.log(err);
            return err;
        }
    }
    /**
     * @param {*} value Value contaning parameters send from client side
     * @description Model for moving data from permanent table to temprary table
     */
    async printReasonReportCalibration(value, req) {
        try {
            let data = {};
            let clientIp = requestIp.getClientIp(req);
            var selectObj;

            if (value.calibrationType == 'Daily') {
                selectObj = await models.tbl_calibration_daily_print.findAll
                    ({
                        where:
                        {
                            'BalanceID': value.BalanceID,
                            'Rept_Month': value.date.split('-')[1],
                            'Rept_Year': value.date.split('-')[0],
                            'Incomplete': (req.body.reportType == "Complete") ? 0 : 1,
                            'Daily_CalibChange': value.calibChange
                        }
                    });
            }
            else {
                var int_periodicFirstReportRepeatability = serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name == 'PeriodicFirstReportRepeatability').Value;
                var result = (int_periodicFirstReportRepeatability == '1' ? 'tbl_calibration_repetability_print' : 'tbl_calibration_periodic_print');
                selectObj = await models[result].findAll
                    ({
                        where:
                        {
                            'BalanceID': value.BalanceID,
                            'RepSrNo': value.repserno,
                            'Title': "PeriodicCalibration",
                            'Incomplete': value.reportType == "Complete" ? 0 : 1,
                        }
                    });

            }

            if (selectObj.length != 0) {
                //delete from tbl_printoutreason_weighingreport table
                const deleteObject = await models.tbl_printoutreason_weighingreport.destroy({
                    where:
                        { HMIID: clientIp.split(':')[3] }
                });

                if (selectObj.length > 0) {
                    for (const obj of selectObj) {
                        const insertObj = await models.tbl_printoutreason_weighingreport.create
                            ({
                                RepSrNo: value.BalanceID,
                                PrintNo: obj.PrintNo,
                                Reason: obj.Reason,
                                Title: obj.Title,
                                UserID: obj.UserID,
                                UserName: obj.UserName,
                                Print_Dt: obj.Print_Dt,
                                Print_Tm: date.format(obj.Print_Tm, 'HH:mm:ss'),
                                IsIncomplete: obj.Incomplete,
                                HMIID: clientIp.split(':')[3],
                            });
                    }

                    Object.assign(data, { status: 'success' }, { HmiId: clientIp.split(':')[3] })
                    return data;
                }
                else {
                    Object.assign(data, { status: 'success' }, { result: 'No Record Found' })
                    return data;
                }
            }
            else {
                Object.assign(data, { status: 'success' }, { result: 'No Record Found' })
                return data;
            }
        }
        catch (error) {
            console.log("printReasonReportCalibration", error);
            return error;
        }
    }

    async printReasonReportVernierCalibration(value, req) {
        let clientIp = requestIp.getClientIp(req);
        const selectObj = {
            str_tableName: 'tbl_calibration_periodic_vernier_print',
            data: '*',
            condition: [
                { str_colName: 'VernierID', value: value.VernierCode },
                { str_colName: 'RepSrNo', value: value.repserno },
                { str_colName: 'Incomplete', value: value.reportType == "Complete" ? 0 : 1 }
            ]
        }

        let response = await database.select(selectObj);
        // First we have to delete entry repsected to HMI
        const deleteObj = {
            str_tableName: 'tbl_printoutreason_weighingreport',
            condition: [
                { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
            ]
        }
        let res = await database.delete(deleteObj);
        if (response[0].length > 0) {
            for (let i = 0; i <= response[0].length - 1; i++) {
                let insertObj = {
                    str_tableName: 'tbl_printoutreason_weighingreport',
                    data: [
                        { str_colName: 'RepSrNo', value: value.VernierCode },
                        { str_colName: 'PrintNo', value: response[0][i].PrintNo },
                        { str_colName: 'Reason', value: response[0][i].Reason },
                        { str_colName: 'Title', value: "VernierCalibration" },
                        { str_colName: 'UserID', value: response[0][i].UserID },
                        { str_colName: 'UserName', value: response[0][i].UserName },
                        { str_colName: 'Print_Dt', value: response[0][i].Print_Dt },
                        { str_colName: 'Print_Tm', value: response[0][i].Print_Tm },
                        { str_colName: 'IsIncomplete', value: response[0][i].Incomplete[0] },
                        { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                    ]
                }
                let res = await database.save(insertObj);
            }
            let data = {};
            Object.assign(data, { HmiId: clientIp.split(':')[3].split('.')[3] })
            return data;
        } else {
            return ({ status: 'success', data: 'No Record Found' })
        }
    }

    async rptAlert(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            var str_query;

            if (SelectedValue != "") {
                str_query = {
                    DT: { [Op.between]: [fromDate, toDate] },
                    Area: SelectedValue
                };
            }
            else {
                str_query = {
                    DT: { [Op.between]: [fromDate, toDate] }
                };
            }

            models.tbl_audit_alertsetting.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }

    /**
   * 
   * @param {*} value Value required for report printing
   * @param {*} ClientIp Ip of requested client
   * @description Model for Media report generation
   * @memberof ReportModel
   */
    rptPort(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let obj_response = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue; // area
            var str_query;

            if (SelectedValue != "") {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] },
                    Area: SelectedValue
                };
            }
            else {
                str_query = {
                    dt: { [Op.between]: [fromDate, toDate] }
                };
            }

            models.tbl_audit_portsetting.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    obj_response = { status: 'success', data: 'No records found' };
                    resolve(obj_response)
                }
            }).catch(err => { reject(err) })
        })
    }

    rptAuditYield(value, ClientIp) {
        return new Promise((resolve, reject) => {
            var responseObj = {};
            var strTableName = value.strTableName;
            var fromDate = value.reportObj.data.FromDate;
            var toDate = value.reportObj.data.ToDate;
            var SelectedValue = value.reportObj.data.SelectedValue;
            var SelectedAction = value.reportObj.data.SelectedAction;
            var prdType = value.reportObj.data.prdType;

            var selectDataObj = {
                str_tableName: strTableName,
                data: '*',
                condition: [
                    { str_colName: 'DT', value: fromDate, value1: toDate, comp: 'btn' }
                ]
            }

            if (SelectedAction != "") {
                selectDataObj.condition.push(
                    { str_colName: 'ACT', value: SelectedAction, comp: 'eq' })
            }
            if (SelectedValue != "") {
                selectDataObj.condition.push(
                    { str_colName: 'ProductType', value: SelectedValue, comp: 'eq' })
            }
            if (prdType != "") {
                selectDataObj.condition.push(
                    { str_colName: 'CubicleType', value: prdType, comp: 'eq' })
            }
            database.select(selectDataObj).then(result => {
                if (result[0].length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })

        })
    }


    /**
     * 
     * @param {*} value Value required for report printing
     * @param {*} ClientIp Ip of requested client
     * @description Model for cleaner report generation
     * @memberof ReportModel
     */
    rptAuditCleaner(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let obj_query = { where: { dt: { [Op.between]: [fromDate, toDate] } } };
            if (SelectedValue !== "") {
                Object.assign(obj_query.where, { CleanerId: SelectedValue })
            }

            models[strTableName].findAll(obj_query).then(result => {
                // database.select(selectDataObj).then(result => {
                if (result.length > 0) {
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }

    AdminPasswordComplexity(value, ClientIp) {

        return new Promise((resolve, reject) => {
            let responseObj = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;

            models.tbl_audit_pwd_complexity.findAll({
                where:
                {
                    dt: { [Op.between]: [fromDate, toDate] },
                }
            }).then(result => {
                if (result.length > 0) {

                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }

    rptAuditPrecalibration(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let SelectedAction = value.reportObj.data.SelectedAction;
            var str_query;

            str_query = {
                DT: { [Op.between]: [fromDate, toDate] }
            };

            if (SelectedValue != "") {
                Object.assign(str_query, { Equipment_ID: SelectedValue });
            }

            if (SelectedAction != "") {
                Object.assign(str_query, { ACT: SelectedAction });
            }


            models.tbl_audit_precalibration.findAll({ where: str_query }).then(result => {
                if (result.length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }


    printcountupYield(objPrintCount) {
        return new Promise((resolve, reject) => {
            const arrTransactionQueries = [];
            const objYieldUpdate = {
                str_tableName: "tbl_yield_report_master",
                data: [
                    { str_colName: 'PrintNo', value: parseInt(Number(objPrintCount.int_printNo + 1)) }
                ],
                condition: [
                    { str_colName: 'RepSerNo', value: objPrintCount.RepSerNo, comp: 'eq' }
                ],
                action: 'up'
            }

            var now = new Date();
            const objPrintEntry = {
                str_tableName: "tbl_yieldreport_printrecord",
                data: [
                    { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'UserID', value: objPrintCount.strUserId },
                    { str_colName: 'UserName', value: objPrintCount.strUserName },
                    { str_colName: 'CubType', value: objPrintCount.str_type },
                    { str_colName: 'BatchNo', value: objPrintCount.str_batchNo },
                    { str_colName: 'BFGCode', value: objPrintCount.str_prdID },
                    { str_colName: 'PrdName', value: objPrintCount.str_prdName },
                    { str_colName: 'PrdVersion', value: objPrintCount.str_prdVersion },
                    { str_colName: 'Version', value: objPrintCount.str_version },
                    { str_colName: 'PrintNo', value: parseInt(objPrintCount.int_printNo) },
                    { str_colName: 'Reason', value: objPrintCount.strReason },
                    { str_colName: 'YieldType', value: objPrintCount.str_YieldType },
                    { str_colName: 'RepSerNo', value: objPrintCount.RepSerNo }
                ],
                action: 'in'
            }


            const objActivityLog = {
                str_tableName: "tbl_activity_log",
                data: [
                    { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                    { str_colName: "userid", value: objPrintCount.strUserId },
                    { str_colName: "username", value: objPrintCount.strUserName },
                    { str_colName: "activity", value: 'Yield Report Printed' },
                ],
                action: "in"
            }

            arrTransactionQueries.push(objYieldUpdate, objPrintEntry, objActivityLog);
            objTranDatabase.funMakeQueries(arrTransactionQueries).then((res) => {
                resolve(res);
            }).catch((err) => {
                console.log(err);
                reject(err);
            })
        })
    }

    /** this function is used to  */
    async periodicCalibrationRemarkForFailed(objReport) {
        const arrTransactionQueries = [];
        var now = new Date();
        var objRemarkUpdate,objActivityLog;
        var PeriodicFirstReportRepeatability = serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name == 'PeriodicFirstReportRepeatability').Value;
        if (PeriodicFirstReportRepeatability == "1") {
             objRemarkUpdate = await models.tbl_calibration_repetability_master_failed.update({
                Repet_calibStatus: objReport.strReason,
                Repet_VerifyID: objReport.strUserId,
                Repet_VerifyName: objReport.strUserName,
                Repet_VerifyDate: date.format(now, 'YYYY-MM-DD')
            }, {
                where:
                {
                    Repet_RepNo: objReport.repSrNo
                }
            });

             objActivityLog = await models.tbl_activity_log.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: objReport.strUserId,
                username: objReport.strUserName,
                activity: 'Periodic Report-Failed Remark'
            })
        } else {
            //  objRemarkUpdate = {
            //     str_tableName: "tbl_calibration_periodic_master_failed",
            //     data: [
            //         { str_colName: 'Periodic_calibStatus', value: objReport.strReason },
            //         { str_colName: 'Periodic_VerifyID', value: objReport.strUserId },
            //         { str_colName: 'Periodic_VerifyName', value: objReport.strUserName },
            //         { str_colName: 'Perodic_VerifyDate', value: date.format(now, 'YYYY-MM-DD') }
            //     ],
            //     condition: [
            //         { str_colName: 'Periodic_RepNo', value: objReport.repSrNo }
            //     ],
            //     action: 'up'
            // }

            //  objActivityLog = {
            //     str_tableName: "tbl_activity_log",
            //     data: [
            //         { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
            //         { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
            //         { str_colName: "userid", value: objReport.strUserId },
            //         { str_colName: "username", value: objReport.strUserName },
            //         { str_colName: "activity", value: 'Periodic Report-Failed Remark' },
            //     ],
            //     action: "in"
            // }

            // arrTransactionQueries.push(objRemarkUpdate, objActivityLog);
            // let res = await objTranDatabase.funMakeQueries(arrTransactionQueries);
            // return res;
             objRemarkUpdate = await models.tbl_calibration_periodic_master_failed.update({
                Periodic_calibStatus: objReport.strReason,
                Periodic_VerifyID: objReport.strUserId,
                Periodic_VerifyName: objReport.strUserName,
                Perodic_VerifyDate: date.format(now, 'YYYY-MM-DD')
            }, {
                where:
                {
                    Periodic_RepNo: objReport.repSrNo
                }
            });
            objActivityLog = await models.tbl_activity_log.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: objReport.strUserId,
                username: objReport.strUserName,
                activity: 'Periodic Report-Failed Remark'
            })
        }

        return true;
    }

    async periodicCalibrationRemarkForFailedVernier(objReport) {
        const arrTransactionQueries = [];

        var now = new Date();
        const objRemarkUpdate = {
            str_tableName: "tbl_calibration_periodic_master_vernier_incomplete",
            data: [
                { str_colName: 'Periodic_Remark', value: objReport.strReason },
                { str_colName: 'Periodic_VerifyID', value: objReport.strUserId },
                { str_colName: 'Periodic_VerifyName', value: objReport.strUserName },
                { str_colName: 'Perodic_VerifyDate', value: date.format(now, 'YYYY-MM-DD') }
            ],
            condition: [
                { str_colName: 'Periodic_RepNo', value: objReport.repSrNo }
            ],
            action: 'up'
        }

        const objActivityLog = {
            str_tableName: "tbl_activity_log",
            data: [
                { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                { str_colName: "userid", value: objReport.strUserId },
                { str_colName: "username", value: objReport.strUserName },
                { str_colName: "activity", value: 'Vernier Periodic Report-Failed Remark' },
            ],
            action: "in"
        }

        arrTransactionQueries.push(objRemarkUpdate, objActivityLog);
        let res = await objTranDatabase.funMakeQueries(arrTransactionQueries);
        return res;
    }

    async increaseMVLPrintNo(objPrintCount) {
        const arrTransactionQueries = [];
        const objTablet = new clsTablet();

        const selectDetailRpt = {
            str_tableName: 'tbl_rpt_path',
            data: '*',
        }
        var strProjName = "";
        let resPrd = await database.select(selectDetailRpt);
        strProjName = resPrd[0][0]['proj_name'];

        const TableName = objTablet.commanFunctionForFindingOutTableName(objPrintCount.reportOption,
            objPrintCount.reportType, objPrintCount.recordFrom, strProjName);

        var objTableUpdate = {}, objAuditEntry = {};
        if (objPrintCount.reportOption == "Dosa Dry Syrup") {
            for (let i = 0; i <= objPrintCount.intReportSerNo.length; i++) {
                objTableUpdate = {
                    str_tableName: TableName.masterTableName,
                    data: [
                        { str_colName: 'PrintNo', value: objPrintCount.intPrintCount }
                    ],
                    condition: [
                        { str_colName: 'RepSerNo', value: i + 1 }
                    ]
                }

                let res = await database.update(objTableUpdate);

            }
        }
        else {
            objTableUpdate = {
                str_tableName: TableName.masterTableName,
                data: [
                    { str_colName: 'PrintNo', value: objPrintCount.intPrintCount }
                ],
                condition: [
                    { str_colName: 'RepSerNo', value: objPrintCount.intReportSerNo }
                ],
                action: 'up'
            }
        }

        var now = new Date();

        if (objPrintCount.reportOption == "Dosa Dry Syrup") {
            objAuditEntry = {
                str_tableName: TableName.strPrintTableName,
                data: [
                    { str_colName: 'RepSrNo', value: objPrintCount.MasterNo },
                    { str_colName: 'PrintNo', value: objPrintCount.intPrintCount },
                    { str_colName: 'Reason', value: objPrintCount.strReason },
                    { str_colName: 'Title', value: TableName.intWeighmentSrNo },
                    { str_colName: 'UserID', value: objPrintCount.strUserId },
                    { str_colName: 'UserName', value: objPrintCount.strUserName },
                    { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'IsIncomplete', value: objPrintCount.reportType == "Complete" ? 1 : 0 },

                ],
                action: 'in'
            }
        }
        else {
            objAuditEntry = {
                str_tableName: TableName.strPrintTableName,
                data: [
                    { str_colName: 'RepSrNo', value: objPrintCount.intReportSerNo },
                    { str_colName: 'PrintNo', value: objPrintCount.intPrintCount },
                    { str_colName: 'Reason', value: objPrintCount.strReason },
                    { str_colName: 'Title', value: TableName.intWeighmentSrNo },
                    { str_colName: 'UserID', value: objPrintCount.strUserId },
                    { str_colName: 'UserName', value: objPrintCount.strUserName },
                    { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'IsIncomplete', value: objPrintCount.reportType == "Complete" ? 1 : 0 },

                ],
                action: 'in'
            }
        }


        const objActivityLog = {
            str_tableName: "tbl_activity_log",
            data: [
                { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
                { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
                { str_colName: "userid", value: objPrintCount.strUserId },
                { str_colName: "username", value: objPrintCount.strUserName },
                { str_colName: "activity", value: "Tablet-" + objPrintCount.reportOption + ' Report Printed' },
            ],
            action: "in"
        }

        if (objPrintCount.reportOption == "Dosa Dry Syrup") {
            arrTransactionQueries.push(objAuditEntry, objActivityLog);
        }
        else {
            arrTransactionQueries.push(objTableUpdate, objAuditEntry, objActivityLog);
        }

        let res = await objTranDatabase.funMakeQueries(arrTransactionQueries);
        return res;

    }

    /**
       * 
       * @param {*} value Value required for report printing
       * @param {*} ClientIp Ip of requested client
       * @description Model for Content report generation
       * @memberof ReportModel
       */
    rptContent(value, ClientIp) {
        return new Promise((resolve, reject) => {
            let responseObj = {};
            let strTableName = value.strTableName;
            let fromDate = value.reportObj.data.FromDate;
            let toDate = value.reportObj.data.ToDate;
            let SelectedValue = value.reportObj.data.SelectedValue;
            let selectDataObj = {
                str_tableName: strTableName,
                data: '*',
                condition: [
                    { str_colName: 'DT', value: fromDate, value1: toDate, comp: 'btn' }
                ]
            }
            if (SelectedValue !== "") {
                selectDataObj.condition.push({ str_colName: 'Content', value: SelectedValue })
            }
            database.select(selectDataObj).then(result => {
                if (result[0].length > 0) {
                    // CONSTRUCTURE INITLIZED WITH FILENAME
                    this.getProjectName().then(strProjName => {
                        jasper.reports = {
                            hw: {
                                jasper: '../jasperFiles/' + strProjName + '/' + value.reportObj.FileName + '.jasper'
                            }
                        }

                        //ENTRIES PRESENT THEN CALL MAKEREPORT FUNCTION
                        this.makeReport(value.reportObj.FileName, value.reportObj.data, ClientIp)
                            .then(result => {
                                //SUCCESS
                                resolve(Object.assign(result, { status: 'success' }))
                            }).catch(err => {
                                //ERR
                                reject(err);
                            })
                    })
                } else {
                    //ENTRIES NOT PRESENT
                    responseObj = { status: 'success', data: 'No records found' };
                    resolve(responseObj)
                }
            }).catch(err => { reject(err) })
        })
    }

}
module.exports = ReportModel;