const dbCon = require('../Utills/db');
const Database = require('../database/clsQueryProcess');
const database = new Database();
const date = require('date-and-time');

class SoftGelModel {
    async addProductSoftgel(value){
        try{
            var responseObj = {};
            const checkSoftgel = await this.checkSoftgel(value);
                if(checkSoftgel == false){
                    Object.assign(responseObj, { status: 'success' }, { result: 'Softgel Product Already Exist' });
                    return(responseObj);
                }
                else{
                    const addSoftgel = await this.addSoftgel(value);
                    Object.assign(responseObj, { status: 'success' }, { result: 'Softgel Product Added Successfully' });
                    return(responseObj);
                }
    
    
        }catch(error){
            return error;
        }
    }
    async checkSoftgel(value){
        try{
            const objMaster = {
                str_tableName:'tbl_product_master',
                data:'*',
                condition:[
                    { str_colName: 'ProductId', value: value.BFGCode,comp: 'eq' },
                    { str_colName: 'ProductName', value: value.ProductName, comp: 'eq' },
                    { str_colName: 'ProductVersion', value: value.PVersion, comp: 'eq' },
                    { str_colName: 'Version', value: value.Version, comp: 'eq' }
                ] 
            }
            var result = await database.select(objMaster);
            if(result[0].length > 0)
            {
                return false;
            }
            else{
                return true;
            }
    
        } catch(error){
            return error;
        }
    }
    async addSoftgel(value){
        try{
            var now = new Date();
            const addSoftGelMasterObj = {
                str_tableName: 'tbl_product_master',
                    data: [
                        { str_colName: 'ProductId', value: value.BFGCode },
                        { str_colName: 'ProductName', value: value.ProductName },
                        { str_colName: 'ProductType', value: 4 },
                        { str_colName: 'ProductVersion', value: value.PVersion },
                        { str_colName: 'Version', value: value.Version },
                        { str_colName: 'IsActive', value: 0 },
                        { str_colName: 'isBinWeighing', value: 0 },
                        { str_colName: 'BatchSize', value: 0 },
                        { str_colName: 'BatchUnit', value: 0 },
                        { str_colName: 'IsBilayer', value: 0 },
                        { str_colName: 'IsBilayerLbl', value: 0 },
                        { str_colName: 'IsTrilayer', value: 0 },
                        { str_colName: 'IsTrilayerLbl', value: 0 },
                        { str_colName: 'IsCoated', value: 0 },
                        { str_colName: 'IsGranulation', value: 0 },
                        { str_colName: 'IsCompress', value: 0 },
                        { str_colName: 'NominalNomenclature', value: 0 },
                        { str_colName: 'locked', value: 0 },
                        { str_colName: 'userID', value: value.UserID },
                        { str_colName: 'ISBfGChecked', value: value.int_chkBFG },
                        { str_colName: 'ISPrdVersionChecked', value: value.int_chkPrdVersion },
                        { str_colName: 'ISVersionChecked', value: value.int_chkVersion }
                    ]
            }
            var result1 = await database.save(addSoftGelMasterObj);
            const auditObj = {
                str_tableName: 'tbl_audit_product_softshell',
                    data: [
                        { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                        { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                        { str_colName: 'userid', value: value.UserID },
                        { str_colName: 'username', value: value.UserName },
                        { str_colName: 'ACT', value: value.Action },
                        { str_colName: 'Remark', value: value.Remark },
                        { str_colName: 'ProductId', value: value.BFGCode },
                        { str_colName: 'ProductName', value: value.ProductName },
                        { str_colName: 'PrdVersion', value: value.PVersion },
                        { str_colName: 'Version', value: value.Version },
                        { str_colName: 'ProductType', value: 4 },
                        { str_colName: 'OldValue', value: 'NA' },
                        { str_colName: 'NewValue', value: value.auditObject.result.SoftGel.newData == undefined ? "NA" : value.auditObject.result.SoftGel.newData },
                        { str_colName: 'OldValuePrd', value: 'NA' },
                        { str_colName: 'NewValuePrd', value: 'NA' }
                    ]
            }
            var result3 = await database.save(auditObj);
            //console.log(auditObj);
            const SoftgelLog = {
                str_tableName: 'tbl_activity_log',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: value.UserID },
                    { str_colName: 'username', value: value.UserName },
                    { str_colName: 'activity', value: 'Softgel Product Added' }
                ]
            }
            var result4 = await database.save(SoftgelLog);
            return true;
        }catch(error){
            return error;
        }
    }
    
    async getProductSoftgel(){
        try {
            var responseObj = {};
            const objMaster = {
                str_tableName:'tbl_product_master',
                data:'*',
                condition:[
                    { str_colName: 'ProductType', value: 4 }
                ] 
            }
            var resMaster = await database.select(objMaster);
            Object.assign(responseObj, { status: 'success' }, { result: resMaster[0] });
            return(responseObj);
        } catch (error) {

            return error;
        }
    }

    async getProductDetailForCubicle(req){
        try {
            var responseObj = {};
            const objMaster = {
                str_tableName:'tbl_product_softshell',
                data:'*',
                condition:[
                    { str_colName: 'ProductId', value: req.body.ProductId },
                    { str_colName: 'ProductName', value: req.body.ProductName },
                    { str_colName: 'ProductVersion', value: req.body.ProductVersion },
                    { str_colName: 'Version', value: req.body.Version },
                    { str_colName: 'BatchNo', value: req.body.batch }
                ] 
            }
            var resMaster = await database.select(objMaster);
            Object.assign(responseObj, { status: 'success' }, { result: resMaster[0] });
            return(responseObj);
        } catch (error) {

            return error;
        }
    }


    async activateProductSoftgel(value){
        try{
            var responseObj = {};
            var now = new Date();
            var productStatus = value.action;
            if(productStatus == "Approve Product"){
                const addSoftGelMasterObj = {
                    str_tableName: 'tbl_product_master',
                    data: [
                        { str_colName: 'IsActive', value: 1 }
                    ],
                    condition:[
                        { str_colName: 'ProductId', value: value.productID },
                        { str_colName: 'ProductName', value: value.productName },
                        { str_colName: 'ProductType', value: parseInt(value.productType) },
                        { str_colName: 'ProductVersion', value: value.productVersion },
                        { str_colName: 'Version', value: value.Version }
                    ]
                }
                var result1 = await database.update(addSoftGelMasterObj);
                const auditObj = {
                    str_tableName: 'tbl_audit_product_softshell',
                        data: [
                            { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                            { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                            { str_colName: 'userid', value: value.userId },
                            { str_colName: 'username', value: value.userName },
                            { str_colName: 'ACT', value: value.action },
                            { str_colName: 'Remark', value: value.remark },
                            { str_colName: 'ProductId', value: value.productID },
                            { str_colName: 'ProductName', value: value.productName },
                            { str_colName: 'PrdVersion', value: value.productVersion },
                            { str_colName: 'Version', value: value.Version },
                            { str_colName: 'ProductType', value: 4 },
                            { str_colName: 'OldValue', value:"NA" },
                            { str_colName: 'NewValue', value:"NA" },
                            { str_colName: 'OldValuePrd', value:"NA" },
                            { str_colName: 'NewValuePrd', value:"NA" }
                        ]
                }
                var result3 = await database.save(auditObj);
                Object.assign(responseObj, { status: 'success' }, { result: 'Product Activate Successfully' });
                return(responseObj);
            }else{
                const addSoftGelMasterObj1 = {
                    str_tableName: 'tbl_product_master',
                    data: [
                        { str_colName: 'IsActive', value: 0 }
                    ],
                    condition:[
                        { str_colName: 'ProductId', value: value.productID },
                        { str_colName: 'ProductName', value: value.productName },
                        { str_colName: 'ProductType', value: parseInt(value.productType) },
                        { str_colName: 'ProductVersion', value: value.productVersion },
                        { str_colName: 'Version', value: value.Version }
                    ]
                }
                var result2 = await database.update(addSoftGelMasterObj1);
                const auditObj1 = {
                    str_tableName: 'tbl_audit_product_softshell',
                        data: [
                            { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                            { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                            { str_colName: 'userid', value: value.userId },
                            { str_colName: 'username', value: value.userName },
                            { str_colName: 'ACT', value: value.action },
                            { str_colName: 'Remark', value: value.remark },
                            { str_colName: 'ProductId', value: value.productID },
                            { str_colName: 'ProductName', value: value.productName },
                            { str_colName: 'PrdVersion', value: value.productVersion },
                            { str_colName: 'Version', value: value.Version },
                            { str_colName: 'ProductType', value: 4 },
                            { str_colName: 'OldValue', value:"NA" },
                            { str_colName: 'NewValue', value:"NA" },
                            { str_colName: 'OldValuePrd', value:"NA" },
                            { str_colName: 'NewValuePrd', value:"NA" }
                        ]
                }
                var result4 = await database.save(auditObj1);

                Object.assign(responseObj, { status: 'success' }, { result: 'Product Deactivate Successfully' });
                return(responseObj);
            }
        }catch(error)
        {
            return error;
        }
    }
}

module.exports = SoftGelModel;