const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");

class PortSetting {
    async getAuditAreaPort() {
        try {
            let result = await models.tbl_audit_portsetting.findAll({attributes:['Area']});
            return result;
        } catch (error) {
            console.log(error);
            throw error
        }
    }
    
    async savePortSettingDetails(objPortSetting) {
        try {
            var obj_response = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();
                let int_cubicleNo = objPortSetting.Sys_CubicNo;

                await models.tbl_cubical.update({
                    Sys_PortNo: objPortSetting.Sys_PortNo,
                    Sys_Port1: objPortSetting.Sys_Port1,
                    Sys_Port2: objPortSetting.Sys_Port2,
                    Sys_Port3: objPortSetting.Sys_Port3,
                    Sys_Port4: objPortSetting.Sys_Port4
                },{
                    where: {Sys_CubicNo: int_cubicleNo},
                    transaction: t
                });


                let setPreviousIDNone = await this.setPreviousTypeIDToNone(objPortSetting,int_cubicleNo,t);
                let setID = await this.setSelectedID(objPortSetting,int_cubicleNo,t);
            
                await models.tbl_audit_portsetting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPortSetting.userid,
                    username: objPortSetting.username,
                    Remark: objPortSetting.Remark,
                    Act: objPortSetting.Act,
                    Area: objPortSetting.area,
                    OldData: objPortSetting.OldData,
                    NewData: objPortSetting.NewData,
                    CubicleNo: objPortSetting.Sys_CubicNo,
                    CubicName: objPortSetting.cubicleName,
                    ISIDSSetting: (objPortSetting.str_settingType == "Area") ? 0 : 1
                },
                {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPortSetting.userid,
                    username: objPortSetting.username,
                    activity: objPortSetting.activitylog
                },
                {
                    transaction: t
                });

                //Deleting balance data from precalibration only when balance is removed from the area
                let oldBalID,newBalID;

                if(objPortSetting['prev_Port1'] === 'Balance'){
                    oldBalID =  objPortSetting['prev_Port1ID'];
                }else if(objPortSetting['prev_Port2'] === 'Balance'){
                    oldBalID = objPortSetting['prev_Port2ID'];
                }else if(objPortSetting['prev_Port3'] === 'Balance'){
                    oldBalID = objPortSetting['prev_Port3ID'] 
                }else{
                    //If no balance found in previous balance than dont clear data
                    oldBalID = 'None';
                }

                if(objPortSetting['Sys_Port1'] === 'Balance'){
                    newBalID =  objPortSetting['Sys_Port1_ID'];
                }else if(objPortSetting['Sys_Port2'] === 'Balance'){
                    newBalID = objPortSetting['Sys_Port2_ID'];
                }else if(objPortSetting['Sys_Port3'] === 'Balance'){
                    newBalID = objPortSetting['Sys_Port3_ID']
                }else{
                    //If no balance found in previous balance than dont clear data
                    newBalID = 'None';
                }
                
                
                //Deleting data for Balance
                if(oldBalID  != 'None' && (oldBalID != newBalID)){
                    await models.tbl_precalibration_daily.destroy({
                        where:{
                            Equipment_ID:  oldBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_periodic.destroy({
                        where:{
                            Equipment_ID:  oldBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_uncertainty.destroy({
                        where:{
                            Equipment_ID:  oldBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_linearity.destroy({
                        where:{
                            Equipment_ID:  oldBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_repeatability.destroy({
                        where:{
                            Equipment_ID:  oldBalID
                        },
                        transaction: t
                    });
                    await models.tbl_precalibration_eccentricity.destroy({
                        where:{
                            Equipment_ID:  oldBalID
                        },
                        transaction: t
                    });

                    await models.tbl_balance.update({
                        Bal_ChangeWt: 1
                    },{
                        where: { Bal_ID: oldBalID },
                        transaction:t
                    });
                }

                

                //Deleting balance data from precalibration only when ipc balance is removed from the area
                let oldBinBalID,newBinBalID;

                if(objPortSetting['prev_Port1'] === 'IPC Balance'){
                    oldBinBalID =  objPortSetting['prev_Port1ID'];
                }else if(objPortSetting['prev_Port2'] === 'IPC Balance'){
                    oldBinBalID = objPortSetting['prev_Port2ID'];
                }else if(objPortSetting['prev_Port3'] === 'IPC Balance'){
                    oldBinBalID = objPortSetting['prev_Port3ID'] 
                }else{
                    //If no balance found in previous balance than dont clear data
                    oldBinBalID = 'None';
                }

                if(objPortSetting['Sys_Port1'] === 'IPC Balance'){
                    newBinBalID =  objPortSetting['Sys_Port1_ID'];
                }else if(objPortSetting['Sys_Port2'] === 'IPC Balance'){
                    newBinBalID = objPortSetting['Sys_Port2_ID'];
                }else if(objPortSetting['Sys_Port3'] === 'IPC Balance'){
                    newBinBalID = objPortSetting['Sys_Port3_ID']
                }else{
                    //If no balance found in previous balance than dont clear data
                    newBinBalID = 'None';
                }

                //Deleting data for BIN BALANCE
                if(oldBinBalID  != 'None' &&  (oldBinBalID != newBinBalID)){
                    await models.tbl_precalibration_daily.destroy({
                        where:{
                            Equipment_ID:  oldBinBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_periodic.destroy({
                        where:{
                            Equipment_ID:  oldBinBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_uncertainty.destroy({
                        where:{
                            Equipment_ID:  oldBinBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_linearity.destroy({
                        where:{
                            Equipment_ID:  oldBinBalID
                        },
                        transaction: t
                    });
                    
                    await models.tbl_precalibration_repeatability.destroy({
                        where:{
                            Equipment_ID:  oldBinBalID
                        },
                        transaction: t
                    });
                    await models.tbl_precalibration_eccentricity.destroy({
                        where:{
                            Equipment_ID:  oldBinBalID
                        },
                        transaction: t
                    });

                    return "Done"
                }

                await models.tbl_balance.update({
                    Bal_ChangeWt: 1
                },{
                    where: { Bal_ID: oldBinBalID },
                    transaction:t
                });
            });

            Object.assign(obj_response, { status: 'success' }, { result: 'Port Setting Updated Successfully' });
            return obj_response;
 
        } catch (error) {
            console.log("Port Setting",error);
            throw error;
        }
    }     

    // if previous type and selected type not match then update respective ids to None
    async setPreviousTypeIDToNone(objPortSetting,int_cubicleNo,t)
    {
        try {
                for (var i = 1; i <= 4; i++) 
                {
                    var str_type = objPortSetting['Sys_Port' + i];
                    var str_pretype = objPortSetting['prev_Port' + i];
                    if(str_type != str_pretype)
                    {
                        switch (str_pretype) {
                            case "Balance":
                                await models.tbl_cubical.update({
                                    Sys_BalID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                    
                                await models.tbl_calibration_status.update({
                                    BalID: "None",
                                    D: 0,
                                    P: 0,
                                    E: 0,
                                    R: 0,
                                    U: 0,
                                    L: 0,
                                    V: 0
                                },{
                                    where: {Cubicle: int_cubicleNo},
                                    transaction: t
                                });

                                await models.tbl_recalibration_balance_status.update({
                                    Bal_ID: "None",
                                    DailyBalRecalib: 0,
                                    PeriodicBalRecalib: 0,
                                    YearBalRecalib: 0,
                                    LinearityBalRecalib: 0,
                                    DailyMARecalib: 0,
                                    HalfYearMARecalib: 0,
                                    RecalibSetDt_daily: null,
                                    RecalibSetDt_periodic: null,
                                    RecalibSetDt_Year: null
                                },{
                                    where: {CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                    
                            break;
                            case "IPC Balance":
                                await models.tbl_cubical.update({
                                    Sys_BinBalID: "None"
                                },{
                                    where: {Sys_CubicNo: objPortSetting.Sys_CubicNo},
                                    transaction: t
                                });
                    
                                await models.tbl_calibration_status_bin.update({
                                    BalID: "None",
                                    D: 0,
                                    P: 0,
                                    E: 0,
                                    R: 0,
                                    U: 0,
                                    L: 0,
                                    V: 0
                                },{
                                    where: {Cubicle: int_cubicleNo},
                                    transaction: t
                                });

                                await models.tbl_recalibration_balance_status_bin.update({
                                    Bal_ID: "None",
                                    DailyBalRecalib: 0,
                                    PeriodicBalRecalib: 0,
                                    YearBalRecalib: 0,
                                    LinearityBalRecalib: 0,
                                    DailyMARecalib: 0,
                                    HalfYearMARecalib: 0,
                                    RecalibSetDt_daily: null,
                                    RecalibSetDt_periodic: null,
                                    RecalibSetDt_Year: null
                                },{
                                    where: {CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Vernier":
                                await models.tbl_cubical.update({
                                    Sys_VernierID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                    
                                await models.tbl_recalibration_vernier_status.update({
                                    DailyVerRecalib: 0,
                                    PeriodicVerRecalib: 0,
                                    RecalibSetDt_daily: null,
                                    RecalibSetDt_periodic: null
                                },{
                                    where: {CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Hardness":
                                await models.tbl_cubical.update({
                                    Sys_HardID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Tablet Tester":
                                await models.tbl_cubical.update({
                                    Sys_HardID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Friabilator":
                                await models.tbl_cubical.update({
                                    Sys_FriabID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Disintegration Tester":
                                await models.tbl_cubical.update({
                                    Sys_DTID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Moisture Analyzer":
                                await models.tbl_cubical.update({
                                    Sys_MoistID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Tapped Density":
                                await models.tbl_cubical.update({
                                    Sys_TapDensityID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Tap Density":
                                await models.tbl_cubical.update({
                                    Sys_TapDensityID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                            break;

                            case "Sieve Shaker":
                                await models.tbl_cubical.update({
                                    Sys_SieveShakerID: "None"
                                },{
                                    where: {Sys_CubicNo: int_cubicleNo},
                                    transaction: t
                                });
                                break;

                            default:
                                break;
                        }
                    }
                }
                return "Success";
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async setSelectedID(objPortSetting,int_cubicleNo,t)
    {
        try {
            for (var i = 1; i <= 4; i++) 
            {
                var str_type = objPortSetting['Sys_Port' + i];

                switch (str_type) {
                    case "Balance":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_BalID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
    
                            await models.tbl_calibration_status.update({
                                BalID: objPortSetting['Sys_Port'+i+'_ID'],
                                D: 0,
                                P: 0,
                                E: 0,
                                R: 0,
                                U: 0,
                                L: 0,
                                V: 0
                            },{
                                where: {Cubicle: int_cubicleNo},
                                transaction: t
                            });

                            await models.tbl_recalibration_balance_status.update({
                                Bal_ID: objPortSetting['Sys_Port'+i+'_ID'],
                                DailyBalRecalib: 0,
                                PeriodicBalRecalib: 0,
                                YearBalRecalib: 0,
                                LinearityBalRecalib: 0,
                                DailyMARecalib: 0,
                                HalfYearMARecalib: 0,
                                RecalibSetDt_daily: null,
                                RecalibSetDt_periodic: null,
                                RecalibSetDt_Year: null
                            },{
                                where: {CubicNo: int_cubicleNo},
                                transaction: t
                            });
    
                        }
                        
                    break;

                    case "IPC Balance":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_BinBalID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: objPortSetting.Sys_CubicNo},
                                transaction: t
                            });
    
                            await models.tbl_calibration_status_bin.update({
                                BalID: objPortSetting['Sys_Port'+i+'_ID'],
                                D: 0,
                                P: 0,
                                E: 0,
                                R: 0,
                                U: 0,
                                L: 0,
                                V: 0
                            },{
                                where: {Cubicle: int_cubicleNo},
                                transaction: t
                            });

                            await models.tbl_recalibration_balance_status_bin.update({
                                Bal_ID: objPortSetting['Sys_Port'+i+'_ID'],
                                DailyBalRecalib: 0,
                                PeriodicBalRecalib: 0,
                                YearBalRecalib: 0,
                                LinearityBalRecalib: 0,
                                DailyMARecalib: 0,
                                HalfYearMARecalib: 0,
                                RecalibSetDt_daily: null,
                                RecalibSetDt_periodic: null,
                                RecalibSetDt_Year: null
                            },{
                                where: {CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                       
                    break;

                    case "Vernier":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_VernierID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
    
                            await models.tbl_recalibration_vernier_status.update({
                                DailyVerRecalib: 0,
                                PeriodicVerRecalib: 0,
                                RecalibSetDt_daily: null,
                                RecalibSetDt_periodic: null
                            },{
                                where: {CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                       
                    break;

                    case "Hardness":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_HardID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                        
                    break;

                    case "Tablet Tester":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_HardID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                        
                    break;

                    case "Friabilator":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_FriabID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                       
                    break;

                    case "Disintegration Tester":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_DTID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                      
                    break;

                    case "Moisture Analyzer":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_MoistID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                       
                    break;

                    case "Tapped Density":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_TapDensityID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                       
                    break;

                    case "Tap Density":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_TapDensityID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                       
                    break;

                    case "Sieve Shaker":
                        if(objPortSetting['Sys_Port'+i+'_ID'] != objPortSetting['prev_Port'+i+'ID'])
                        {
                            await models.tbl_cubical.update({
                                Sys_SieveShakerID: objPortSetting['Sys_Port'+i+'_ID']
                            },{
                                where: {Sys_CubicNo: int_cubicleNo},
                                transaction: t
                            });
                        }
                        
                    break;
                    default:
                        break;
                }
            }
            return "Success";
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
}
module.exports = PortSetting;