const date = require('date-and-time')
const Database = require('../database/clsQueryProcess');
const database = new Database();
const dbCon = require('../Utills/db');
const convertDate = require('../middleware/setTimeZone');
const requestIp = require('request-ip');
const moment = require('moment-timezone');
const in_array = require('in_array');
const clsStoredProcedure = require('./clsStoredProcedure');
const objStoredProcedure = new clsStoredProcedure();
var dateformat = require('dateformat');
const jsonfile = require('jsonfile');
const loginmodel = require('./clsloginModel');
const loginobj = new loginmodel;
const clsMathJS = require('./clsMathJS');
const math = new clsMathJS();
const serverConfig = require('../global/serverConfig');

const models = require('./../dbConnection').models;
const sequelize = require('./../dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const { Op } = require("sequelize");
const seqTransaction = require("../dbConnection");


class PeriodicCalibReport {

    async getDetailsForPeriodicCalibration(value) {
        try {
            var int_ =  serverConfig.developerPanelData.ProjectName[0].Name;
            var responseObj = {};
            var objPeriodic = {}, objEcc = {}, objRep = {}, objUncer = {}, objLin = {};
            var int_periodicFirstReportRepeatability =  serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'PeriodicFirstReportRepeatability').Value;
            var str_table_Per, str_table_Ecc, str_table_Rep, str_table_Uncer, str_table_Lin;
            if (value.reportType == "Complete") {
                str_table_Per = "tbl_calibration_periodic_master";
                str_table_Ecc = "tbl_calibration_eccentricity_master";
                str_table_Rep = "tbl_calibration_repetability_master";
                str_table_Uncer = "tbl_calibration_uncertinity_master";
                str_table_Lin = "tbl_calibration_linearity_master";
            }
            else {
                str_table_Per = "tbl_calibration_periodic_master_failed";
                str_table_Ecc = "tbl_calibration_eccentricity_master_failed";
                str_table_Rep = "tbl_calibration_repetability_master_failed";
                str_table_Uncer = "tbl_calibration_uncertinity_master_failed";
                str_table_Lin = "tbl_calibration_linearity_master_failed";
            }

            if (value.intFlagPeriodic == 1) {
                objPeriodic = await models[str_table_Per].findAll({
                    where:
                    {
                        Periodic_CalbDate: { [Op.between]: [value.fromDate, value.toDate] },
                        Periodic_BalID: { [Op.eq]: [value.balanceCode] }
                    }
                });
            }

            if (value.intFlagEccent == 1) {

                objEcc = await models[str_table_Ecc].findAll({
                    where:
                    {
                        Eccent_CalbDate: { [Op.between]: [value.fromDate, value.toDate] },
                        Eccent_BalID: { [Op.eq]: [value.balanceCode] }
                    }
                });
            }

            if (value.intFlagRepet == 1) {
                objRep = await models[str_table_Rep].findAll({
                    where:
                    {
                        Repet_CalbDate: { [Op.between]: [value.fromDate, value.toDate] },
                        Repet_BalID: { [Op.eq]: [value.balanceCode] }
                    }
                });
            }

            if (value.intFlagUncer == 1) {
                objUncer = await models[str_table_Uncer].findAll({
                    where:
                    {
                        Uncertinity_CalbDate: { [Op.between]: [value.fromDate, value.toDate] },
                        Uncertinity_BalID: { [Op.eq]: [value.balanceCode] },
                    }
                });
            }

            if (value.intFlagLin == 1) {
                objLin = await models[str_table_Lin].findAll({
                    where:
                    {
                        Linear_CalbDate: { [Op.between]: [value.fromDate, value.toDate] },
                        Linear_BalID: { [Op.eq]: [value.balanceCode] },
                    }
                });
            }


            let resultPer = (int_periodicFirstReportRepeatability == '1' ? objRep : objPeriodic) ;
            let resultUncer = objUncer;
            let resultEcc = objEcc;
            if ((resultPer.length > 0) && (value.reportType == "Complete")) {
                Object.assign(responseObj, { status: 'success' }, { result: resultPer })
                return responseObj;
            }
            if ((resultPer.length > 0) && (value.reportType != "Complete")) {
                Object.assign(responseObj, { status: 'success' }, { result: resultPer })
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Records Not Found' })
                return responseObj;
            }

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async getBalanceID(value) {
        try {
            var obj_response = {};
            var toDate = value.toDate;
            var fromDate = value.fromDate;
            var str_tableName,obj_getBalID;
            var int_periodicFirstReportRepeatability =  serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'PeriodicFirstReportRepeatability').Value;
            if(int_periodicFirstReportRepeatability == '1') {
                (value.reportType == "Complete") ? str_tableName = "tbl_calibration_repetability_master" : str_tableName = "tbl_calibration_repetability_master_failed";
                    obj_getBalID = await models['' + str_tableName].findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('Repet_BalID')), 'Repet_BalID']],
                        where:
                        {
                            Repet_CalbDate: { [Op.between]: [fromDate, toDate] }
                        }
                    });
            }else{
                (value.reportType == "Complete") ? str_tableName = "tbl_calibration_periodic_master" : str_tableName = "tbl_calibration_periodic_master_failed";
                    obj_getBalID = await models['' + str_tableName].findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('Periodic_BalID')), 'Periodic_BalID']],
                        where:
                        {
                            Periodic_CalbDate: { [Op.between]: [fromDate, toDate] }
                        }
                    });
            }   

            let result = obj_getBalID;
            Object.assign(obj_response, { status: 'success' }, { result: result })
            return obj_response;

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async getVernierID(req) {
        try {
            let obj_response = {};
            var toDate = req.body.toDate;
            var fromDate = req.body.fromDate;
            var str_tableName;

            (req.body.reportType == "Complete") ? str_tableName = "tbl_calibration_periodic_master_vernier" : str_tableName = "tbl_calibration_periodic_master_vernier_incomplete";

            const obj_getBalID = {
                str_tableName: str_tableName,
                data: 'DISTINCT Periodic_VerID',
                condition: [
                    { str_colName: 'Periodic_CalbDate', value: fromDate, value1: toDate, comp: 'btn' }
                ]
            }

            let result = await database.select(obj_getBalID);
            Object.assign(obj_response, { status: 'success' }, { result: result[0] })
            return obj_response;

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async getVernierRecord(value) {
        try {
            var responseObj = {};
            var toDate = value.toDate;
            var fromDate = value.fromDate;
            var VernierID = value.VernierCode;
            var str_tableName;

            (value.reportType == "Complete") ? str_tableName = "tbl_calibration_periodic_master_vernier" : str_tableName = "tbl_calibration_periodic_master_vernier_incomplete";

            const obj_getVernierData = {
                str_tableName: str_tableName,
                data: '*',
                condition: [
                    { str_colName: 'Periodic_VerID', value: VernierID, comp: 'eq' },
                    { str_colName: 'Periodic_CalbDate', value: fromDate, value1: toDate, comp: 'btn' }
                ]
            }
            let result = await database.select(obj_getVernierData);
            Object.assign(responseObj, { status: 'success' }, { result: result[0] })
            return responseObj;
        } catch (error) {
            return error;
        }
    }

    async storeVerifyDetailForCalibration(value) {
        try {
            var responseObj = {};
            var str_type = value.reportType;
            var str_table, str_Table_eccentricity, str_Table_repetability, str_Table_uncertinity, str_Table_Lin;
            let now = new Date();
            if (str_type == "Complete") {
                str_table = "tbl_calibration_periodic_master";
                str_Table_eccentricity = "tbl_calibration_eccentricity_master";
                str_Table_repetability = "tbl_calibration_repetability_master";
                str_Table_uncertinity = "tbl_calibration_uncertinity_master";
                str_Table_Lin = "tbl_calibration_linearity_master";
            }
            else {
                str_table = "tbl_calibration_periodic_master_failed";
                str_Table_eccentricity = "tbl_calibration_eccentricity_master_failed";
                str_Table_repetability = "tbl_calibration_repetability_master_failed";
                str_Table_uncertinity = "tbl_calibration_uncertinity_master_failed";
                str_Table_Lin = "tbl_calibration_linearity_master_failed";
            }
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
       
            var result = await models[str_table].update({
                Periodic_VerifyID: value.userId,
                Periodic_VerifyName: value.username,
                Periodic_VerifyDate: date.format(now, 'YYYY-MM-DD'),
                Periodic_VerifyTime: date.format(now, 'HH:mm:ss')
            }, {
                where:
                    { Periodic_RepNo: value.repSrNo },
                    transaction: t
            });

            var result = await models[str_Table_eccentricity].update({
                Eccent_VerifyID: value.userId,
                Eccent_VerifyName: value.username,
                Eccent_VerifyDate: date.format(now, 'YYYY-MM-DD')
            }, {
                where:
                    { Eccent_RepNo: value.repSrNo },
                    transaction: t
            });

            var result = await models[str_Table_repetability].update({
                Repet_VerifyID: value.userId,
                Repet_VerifyName: value.username,
                Repet_VerifyDate: date.format(now, 'YYYY-MM-DD')
            }, {
                where:
                    { Repet_RepNo: value.repSrNo },
                    transaction: t
            });

            var result = await models[str_Table_uncertinity].update({
                Uncertinity_VerifyID: value.userId,
                Uncertinity_VerifyName: value.username,
                Uncertinity_VerifyDate: date.format(now, 'YYYY-MM-DD')
            }, {
                where:
                    { Uncertinity_RepNo: value.repSrNo },
                    transaction: t
            });

            var result = await models[str_Table_Lin].update({
                Linear_VerifyID: value.userId,
                Linear_VerifyName: value.username,
                Linear_VerifyDate: date.format(now, 'YYYY-MM-DD')
            }, {
                where:
                    { Linear_RepNo: value.repSrNo },
                    transaction: t
            });

        });
            Object.assign(responseObj, { status: 'success' }, { result: 'Records Updated' })
            return responseObj;
        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async storeVerifyDetailForVernierCalibration(req) {
        try {
            var responseObj = {};
            var str_type = req.body.reportType;
            var str_table;
            let now = new Date();
            if (str_type == "Complete") {
                str_table = "tbl_calibration_periodic_master_vernier";
            }
            else {
                str_table = "tbl_calibration_periodic_master_vernier_incomplete";
            }
            const objPeriodic = {
                str_tableName: str_table,
                data: [
                    { str_colName: 'Periodic_VerifyID', value: req.body.userId },
                    { str_colName: 'Periodic_VerifyName', value: req.body.username },
                    { str_colName: 'Perodic_VerifyDate', value: date.format(now, 'YYYY-MM-DD') }
                ],
                condition: [
                    { str_colName: 'Periodic_RepNo', value: req.body.repSrNo }
                ]
            }
            var result = await database.update(objPeriodic);

            Object.assign(responseObj, { status: 'success' }, { result: 'Records Updated' })
            return responseObj;
        } catch (error) {
            return error;
        }
    }

    async getData(balId, MasterRes, detailRes) {
        try {
            var strStdWt = MasterRes.Periodic_StdWeight;
            var strPosWt = MasterRes.Periodic_PosTol;
            var strNegWt = MasterRes.Periodic_NegTol;
            var stdWt = strStdWt.split(',');
            var posWt = strPosWt.split(',');
            var negWt = strNegWt.split(',');
            var std1 = 0; var std2 = 0; var std3 = 0; var std4 = 0;
            var tol1 = 0; var tol2 = 0; var tol3 = 0; var tol4 = 0;
            var pos1 = 0; var neg1 = 0; var pos2 = 0; var neg2 = 0;
            var pos3 = 0; var neg3 = 0; var pos4 = 0; var neg4 = 0;
            var diffpos1 = 0; var diffneg1 = 0; var diffpos2 = 0; var diffneg2 = 0;
            var diffpos3 = 0; var diffneg3 = 0; var diffpos4 = 0; var diffneg4 = 0;
            const balDataObj = {
                str_tableName: 'tbl_balance',
                data: '*',
                condition: [
                    { str_colName: 'Bal_ID', value: balId, comp: 'eq' },
                ]
            }
            var balRes = await database.select(balDataObj);
            var balData = balRes[0][0];
            var balDP = balData.Bal_DP;
            var dpVal = 0;
            if (balDP == 0) {
                dpVal = 3;
            } else {
                dpVal = balDP;
            }
            for (var i = 0; i < stdWt.length; i++) {
                if (i == 0) {
                    std1 = parseFloat(stdWt[i]).toFixed(dpVal);
                    pos1 = parseFloat(posWt[i]).toFixed(dpVal);
                    neg1 = parseFloat(negWt[i]).toFixed(dpVal);
                    diffpos1 = Math.abs(Number(pos1) - Number(std1));
                    diffneg1 = Math.abs(Number(std1) - Number(neg1));
                    if (diffpos1 == diffneg1) { tol1 = '±' + parseFloat(diffpos1).toFixed(dpVal) }
                    else { tol1 = '-' + parseFloat(diffneg1).toFixed(dpVal) + ' +' + parseFloat(diffpos1).toFixed(dpVal) }

                }
                if (i == 1) {
                    std2 = parseFloat(stdWt[i]).toFixed(dpVal);
                    pos2 = parseFloat(posWt[i]).toFixed(dpVal);
                    neg2 = parseFloat(negWt[i]).toFixed(dpVal);
                    diffpos2 = Math.abs(Number(pos2) - Number(std2));
                    diffneg2 = Math.abs(Number(std2) - Number(neg2));
                    if (diffpos2 == diffneg2) { tol2 = '±' + parseFloat(diffpos2).toFixed(dpVal) }
                    else { tol2 = '-' + parseFloat(diffneg2).toFixed(dpVal) + ' +' + parseFloat(diffpos2).toFixed(dpVal) }

                }
                if (i == 2) {
                    std3 = parseFloat(stdWt[i]).toFixed(dpVal);
                    pos3 = parseFloat(posWt[i]).toFixed(dpVal);
                    neg3 = parseFloat(negWt[i]).toFixed(dpVal);
                    diffpos3 = Math.abs(Number(pos3) - Number(std3));
                    diffneg3 = Math.abs(Number(std3) - Number(neg3));
                    if (diffpos3 == diffneg3) { tol3 = '±' + parseFloat(diffpos3).toFixed(dpVal) }
                    else { tol3 = '-' + parseFloat(diffneg3).toFixed(dpVal) + ' +' + parseFloat(diffpos3).toFixed(dpVal) }

                }
                if (i == 3) {
                    std4 = parseFloat(stdWt[i]).toFixed(dpVal);
                    pos4 = parseFloat(posWt[i]).toFixed(dpVal);
                    neg4 = parseFloat(negWt[i]).toFixed(dpVal);
                    diffpos4 = Math.abs(Number(pos4) - Number(std4));
                    diffneg4 = Math.abs(Number(std4) - Number(neg4));
                    if (diffpos4 == diffneg4) { tol4 = '±' + parseFloat(diffpos4).toFixed(dpVal) }
                    else { tol4 = '-' + parseFloat(diffneg4).toFixed(dpVal) + ' +' + parseFloat(diffpos4).toFixed(dpVal) }

                }
            }
            var j = 1;
            var stdwt = [];
            var certificateNo = [];
            //var validate = [];
            var decimalpt = 3;
            var pactualWT1 = 0; var pactualWT2 = 0; var pactualWT3 = 0; var pactualWT4 = 0;
            var pstdWT1 = 0; var pstdWT2 = 0; var pstdWT3 = 0; var pstdWT4 = 0;
            for (var pv of detailRes[0]) {
                if (j == 1) {
                    pactualWT1 = parseFloat(pv.Periodic_ActualWt).toFixed(dpVal);
                    pstdWT1 = parseFloat(pv.Periodic_BalStdWt).toFixed(dpVal);
                    stdwt.push(pv.Periodic_StdWtBoxID);
                    var date1 = pv.Periodic_ValDate;
                    var certificat1 = pv.Periodic_WeightBox_certfctNo;
                    var certificatval1 = certificat1.split(',');
                    var dateVal1 = date1.split(',');
                    var dateFinalVal1;
                    if (dateVal1.length == 1) {
                        var dateValue1 = date1.split('-');
                        dateFinalVal1 = dateValue1[2] + '.' + dateValue1[1] + '.' + dateValue1[0];

                        certificateNo.push(pv.Periodic_WeightBox_certfctNo + '/' + dateFinalVal1);
                    } else {
                        var k = 0
                        for (var d of dateVal1) {
                            var dateVal11 = d.split('-');
                            dateFinalVal1 = dateVal11[2] + '.' + dateVal11[1] + '.' + dateVal11[0];

                            certificateNo.push(certificatval1[k] + '/' + dateFinalVal1);
                            k++;
                        }
                    }
                }
                if (j == 2) {
                    pactualWT2 = parseFloat(pv.Periodic_ActualWt).toFixed(dpVal);
                    pstdWT2 = parseFloat(pv.Periodic_BalStdWt).toFixed(dpVal);
                    stdwt.push(pv.Periodic_StdWtBoxID);

                    var date2 = pv.Periodic_ValDate;
                    var certificat2 = pv.Periodic_WeightBox_certfctNo;
                    var certificatval2 = certificat2.split(',');
                    var dateVal2 = date2.split(',');
                    var dateFinalVal2;
                    if (dateVal2.length == 1) {
                        var dateValue2 = date2.split('-');
                        dateFinalVal2 = dateValue2[2] + '.' + dateValue2[1] + '.' + dateValue2[0];

                        certificateNo.push(pv.Periodic_WeightBox_certfctNo + '/' + dateFinalVal2);
                    } else {
                        var l = 0;
                        for (var d of dateVal2) {
                            var dateVal12 = d.split('-');
                            dateFinalVal2 = dateVal12[2] + '.' + dateVal12[1] + '.' + dateVal12[0];
                            certificateNo.push(certificatval2[l] + '/' + dateFinalVal2);
                            l++;
                        }
                    }
                }
                if (j == 3) {
                    pactualWT3 = parseFloat(pv.Periodic_ActualWt).toFixed(dpVal);
                    pstdWT3 = parseFloat(pv.Periodic_BalStdWt).toFixed(dpVal);
                    stdwt.push(pv.Periodic_StdWtBoxID);
                    var date3 = pv.Periodic_ValDate;
                    var certificat3 = pv.Periodic_WeightBox_certfctNo;
                    var certificatval3 = certificat3.split(',');
                    var dateVal3 = date3.split(',');
                    var dateFinalVal3;
                    if (dateVal3.length == 1) {
                        var dateValue3 = date3.split('-');
                        dateFinalVal3 = dateValue3[2] + '.' + dateValue3[1] + '.' + dateValue3[0];
                        certificateNo.push(pv.Periodic_WeightBox_certfctNo + '/' + dateFinalVal3);
                    } else {
                        var m = 0;
                        for (var d of dateVal3) {
                            var dateVal13 = d.split('-');
                            dateFinalVal3 = dateVal13[2] + '.' + dateVal13[1] + '.' + dateVal13[0];
                            certificateNo.push(certificatval3[m] + '/' + dateFinalVal3);
                            m++;
                        }
                    }
                }
                if (j == 4) {
                    pactualWT4 = parseFloat(pv.Periodic_ActualWt).toFixed(dpVal);
                    pstdWT4 = parseFloat(pv.Periodic_BalStdWt).toFixed(dpVal);
                    stdwt.push(pv.Periodic_StdWtBoxID);

                    var date4 = pv.Periodic_ValDate;
                    var certificat4 = pv.Periodic_WeightBox_certfctNo;
                    var certificatval4 = certificat4.split(',');
                    var dateVal4 = date4.split(',');
                    var dateFinalVal4;
                    if (dateVal4.length == 1) {
                        var dateValue4 = date4.split('-');
                        dateFinalVal4 = dateValue4[2] + '.' + dateValue4[1] + '.' + dateValue4[0];

                        certificateNo.push(pv.Periodic_WeightBox_certfctNo + '/' + dateFinalVal4);
                    } else {
                        var n = 0;
                        for (var d of dateVal4) {
                            var dateVal14 = d.split('-');
                            dateFinalVal4 = dateVal14[2] + '.' + dateVal14[1] + '.' + dateVal14[0];
                            certificateNo.push(certificatval4[n] + '/' + dateFinalVal4);
                            n++;
                        }
                    }
                }

                j++;
            }
            var finalStdWT = [];
            for (var stdVal of stdwt) {
                var resultWT = stdVal.split(',');
                if (resultWT.length > 1) {
                    for (var i = 0; i < resultWT.length; i++) {
                        finalStdWT.push(resultWT[i]);
                    }
                }
                else {
                    finalStdWT.push(resultWT[0]);
                }
            }
            var stdWTVal = [...new Set(finalStdWT)];
            var certificateNoVal = [...new Set(certificateNo)];
            //var certificateValiDate = [...new Set(validate)];
            var finalcertificateNoVal = certificateNoVal.filter(e => e !== 'NULL');
            var stdWTValues = stdWTVal.filter(e => e !== 'NULL');
            var cetificate = finalcertificateNoVal.toString();
            return {
                std1: std1,
                std2: std2,
                std3: std3,
                std4: std4,
                pos1: pos1,
                pos2: pos2,
                pos3: pos3,
                pos4: pos4,
                neg1: neg1,
                neg2: neg2,
                neg3: neg3,
                neg4: neg4,
                tol1: tol1,
                tol2: tol2,
                tol3: tol3,
                tol4: tol4,
                pactualWT1: pactualWT1,
                pactualWT2: pactualWT2,
                pactualWT3: pactualWT3,
                pactualWT4: pactualWT4,
                pstdWT1: pstdWT1,
                pstdWT2: pstdWT2,
                pstdWT3: pstdWT3,
                pstdWT4: pstdWT4,
                CerNumOrValDate: cetificate,
                StdWtBoxId: stdWTValues.toString(),
                //valdate:certificateValiDate.toString(),
                maxcap: parseFloat(MasterRes.Periodic_MaxCap).toFixed(dpVal),
                leastcount: parseFloat(MasterRes.Periodic_LeastCnt).toFixed(dpVal),
                minoptRange: parseFloat(MasterRes.Periodic_Bal_MinoptRange).toFixed(dpVal),
                maxoptRange: parseFloat(MasterRes.Periodic_Bal_MaxoptRange).toFixed(dpVal)
            };


        } catch (error) {
            return error;
        }
    }

    async getCheckByForPeriodicCalibration(value) {
        try {
            var responseObj = {};
            var str_type = value.reportType;
            var str_table,objPeriodic;
            var int_periodicFirstReportRepeatability = serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'PeriodicFirstReportRepeatability').Value;
            if(int_periodicFirstReportRepeatability == '1') {
                (str_type == "Complete") ? str_table = "tbl_calibration_repetability_master" : str_table = "tbl_calibration_repetability_master_failed";

             objPeriodic = await models[str_table].findAll({
                where:
                {
                    Repet_RepNo: { [Op.eq]: [value.repSrNo] }
                }
            });
            }else{
                (str_type == "Complete") ? str_table = "tbl_calibration_periodic_master" : str_table = "tbl_calibration_periodic_master_failed";

                 objPeriodic = await models[str_table].findAll({
                    where:
                    {
                        Periodic_RepNo: { [Op.eq]: [value.repSrNo] }
                    }
                });
            }
            var result = objPeriodic;
            if (result.length > 0) {
                Object.assign(responseObj, { status: 'success' }, { result: result[0] })
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Records Not Found' })
                return responseObj;
            }

        } catch (error) {
            return error;
        }
    }

    async getCheckByForPeriodicVernierCalibration(req) {
        try {
            var responseObj = {};
            var str_type = req.body.reportType;
            var str_table;
            (str_type == "Complete") ? str_table = "tbl_calibration_periodic_master_vernier" : str_table = "tbl_calibration_periodic_master_vernier_incomplete";

            const objPeriodic = {
                str_tableName: str_table,
                data: '*',
                condition: [
                    { str_colName: 'Periodic_RepNo', value: req.body.repSrNo }
                ]
            }
            var result = await database.select(objPeriodic);
            if (result[0].length > 0) {
                Object.assign(responseObj, { status: 'success' }, { result: result[0][0] })
                return responseObj;
            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Records Not Found' })
                return responseObj;
            }

        } catch (error) {
            return error;
        }
    }

    async storeDataInTempTableVernier(req) {
        try {
            var responseObj = {};
            var clientIp = requestIp.getClientIp(req);
            var str_vernierData = await this.getVernier(req);

            const selectDetailRpt = {
                str_tableName: 'tbl_rpt_path',
                data: '*',
            }
            var result1 = await database.select(selectDetailRpt);
            var proj_name = result1[0][0]['proj_name'];

            var Periodic = "false";

            var periodicCalib = await this.getPeriodicCalibrationDataVernier(req);
            var deleteCalibData = await this.deleteCalibrationAllDataVernier(clientIp);
            var periodicCalibStoreData = await this.periodicCalibInsertDataVernier(periodicCalib, clientIp, req.body.reportType);

            if (periodicCalib != false) {
                Periodic = "true";
            }

            if ((periodicCalib == false) && (req.body.reportType == 'Complete')) {
                Object.assign(responseObj, { status: 'Fail' });
                return responseObj;
            } else {
                var MasterTableName = "";
                if (req.body.reportType == 'Complete') {
                    MasterTableName = 'tbl_calibration_periodic_master_vernier';
                } else {
                    MasterTableName = 'tbl_calibration_periodic_master_vernier_incomplete';
                }

                var int_dpPer = 2;
                var periodicCal = await dbCon.execute(`SELECT 
                ROUND(CAST(Periodic_MaxCap AS DECIMAL(20,15)), ${int_dpPer}) AS maxCap 
                FROM ${MasterTableName} WHERE Periodic_RepNo = ${req.body.repSrNo}`);

                var periodicVal = periodicCal[0][0];
                var MonthF = "";
                var arrStdBlocks = [];
                var detailData = periodicCalib.periodicdetail;
                detailData.forEach(element => {
                    arrStdBlocks.push(Number(element.Periodic_StdBlock));
                });
                // to replace last "," with and 
                function replaceLast(x, y, z) {
                    var a = x.split("");
                    a[x.lastIndexOf(y)] = z;
                    return a.join("");
                }
                var strStdBlock = replaceLast(arrStdBlocks.join(','), ',', ' and ');
                var dimentionReportText = `Check the dimension of the blocks of ${strStdBlock} mm and record the observation in following table`;
                Object.assign(responseObj, { status: 'success' }, {
                    SelectedValue: req.body.repSrNo, HmiId: clientIp.split(':')[3].split('.')[3], UserId: req.body.userId, MonthF: MonthF,
                    UserName: req.body.username, waterMark: true, printNo: Number(req.body.printNo), Periodic: Periodic, ICReport: req.body.reportType
                },
                    { calibDate: periodicCalibStoreData.calibDate }, { nextCalibDate: periodicCalibStoreData.nextCalibDate },
                    { dimStdBlock: dimentionReportText });

                return responseObj;
            }

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    /**Five Point Calibration */
    async storeDataInTempTableForIncrency(req, value) {
        try {
            var responseObj = {};
            var clientIp = requestIp.getClientIp(req);
            // var balance = await this.getBalance(value);

            var obj_getDateTimeFormat = await models.tbl_nomenclature.findAll();
            var resultDateTime = obj_getDateTimeFormat;
            var str_dtformat = resultDateTime[0]['dateFormat'];

            // var bal_check = await this.getBalancWeights(value);
            var Repeatability = "false", Uncertanity = "false", Eccentricity = "false", Periodic = "false", Linearity = "false";

            var periodicCalib = await this.getPeriodicCalibrationData(value);//Accuracy
            var repetabilityCalib = await this.getRepetabilityCalibrationData(value);
            var uncertinityCalib = await this.getUncertinityCalibrationData(value);//Sensitivity
            var eccentricityCalib = await this.getEccentricityCalibrationData(value);
            var linearityCalib = await this.getLinearityCalibrationData(value);

            var detailData;
            if ((periodicCalib != false) && (periodicCalib != undefined)) {
                detailData = [...periodicCalib.periodicdetail];
            }
            if (repetabilityCalib != false) {
               var detailData = [...detailData,...repetabilityCalib.repetabilityDetail];
            }
            if (eccentricityCalib != false) {
                detailData = [...detailData,...eccentricityCalib.eccentricityDetail];
            }

            if (uncertinityCalib != false) {
                detailData = [...detailData,...uncertinityCalib.uncertinityDetail];
            }

            var sarr_stdWeights = [];
            for (var j = 0; j < detailData.length; j++) {
                var std_wt;
                if(detailData[j].Periodic_StdWtBoxID == undefined)
                {
                    if(detailData[j].Repet_StdWtID == undefined)
                    {
                        if(detailData[j].Eccent_StdWtID == undefined)
                        {
                            std_wt = detailData[j].Uncertinity_StdWtID.split(',');
                        }
                        else{
                            std_wt = detailData[j].Eccent_StdWtID.split(',');
                        }
                    }
                    else{
                        std_wt = detailData[j].Repet_StdWtID.split(',');
                    }
                }
                else{
                    std_wt = detailData[j].Periodic_StdWtBoxID.split(',');
                }
                for (const i of std_wt) {
                    if(sarr_stdWeights.includes(i) == false)
                    {
                        sarr_stdWeights.push(i);
                    }
                }
                var std_wtVal = sarr_stdWeights.toString();    
            }

            var sarr_stdWeightBox_certfctNo = [];
            for (var j = 0; j < detailData.length; j++) {
                var std_wtboxcertNo;
                if(detailData[j].Periodic_WeightBox_certfctNo == undefined)
                {
                    if(detailData[j].Repet_WeightBox_certfctNo == undefined)
                    {
                        if(detailData[j].Eccent_WeightBox_certfctNo == undefined)
                        {
                            std_wtboxcertNo = detailData[j].Uncertinity_WeightBox_certfctNo.split(',');
                        }
                        else{
                            std_wtboxcertNo = detailData[j].Eccent_WeightBox_certfctNo.split(',');
                        }
                    }
                    else{
                        std_wtboxcertNo = detailData[j].Repet_WeightBox_certfctNo.split(',');
                    }
                }
                else{
                    std_wtboxcertNo = detailData[j].Periodic_WeightBox_certfctNo.split(',');
                }
                for (const i of std_wtboxcertNo) {
                    if(sarr_stdWeightBox_certfctNo.includes(i) == false)
                    {
                        sarr_stdWeightBox_certfctNo.push(i);
                    }
                }
                var std_WeightBox_certfctNo = sarr_stdWeightBox_certfctNo.toString();    
            }

            var int_periodicFirstReportRepeatability =  serverConfig.developerPanelData.IncrencyCommon.find(x=>x.Name == 'PeriodicFirstReportRepeatability').Value;

            if(int_periodicFirstReportRepeatability != '1') {
                var sarr_stdWtBox_ValDate = [];
                for (var j = 0; j < detailData.length; j++) {
                    var std_wtboxValDate;
                    if(detailData[j].Periodic_ValDate == undefined)
                    {
                        if(detailData[j].Repet_ValDate == undefined)
                        {
                            if(detailData[j].Eccent_ValDate == undefined)
                            {
                                if( detailData[j].Uncertinity_ValDate == undefined){
                                    std_wtboxValDate = '' 
                                }else {
                                    std_wtboxValDate = detailData[j].Uncertinity_ValDate.split(',');
                                }
                            }
                            else{
                                std_wtboxValDate = detailData[j].Eccent_ValDate.split(',');
                            }
                        }
                        else{
                            std_wtboxValDate = detailData[j].Repet_ValDate.split(',');
                        }
                    }
                    else{
                        std_wtboxValDate = detailData[j].Periodic_ValDate.split(',');
                    }
                    for (const i of std_wtboxValDate) {
                        if(sarr_stdWtBox_ValDate.includes(i) == false)
                        {
                            sarr_stdWtBox_ValDate.push(i);
                        }
                    }    
                }
                var std_WeightBox_ValDate = sarr_stdWtBox_ValDate.toString();
            }

            
            var deleteCalibData = await this.deleteCalibrationAllData(clientIp, value);
            if ((periodicCalib != false) && (periodicCalib != undefined)) {
                var periodicCalibStoreData = await this.periodicCalibInsertData(periodicCalib, clientIp, value.reportType, str_dtformat, std_wtVal, std_WeightBox_certfctNo, std_WeightBox_ValDate);
                Periodic = "true";
            }
            if (repetabilityCalib != false) {
                var repetabilityCalibStoreData = await this.repetabilityCalibInsertData(repetabilityCalib, clientIp, value.reportType,std_wtVal);
                Repeatability = "true";
                var repetDev =  Number(repetabilityCalib.repetabilityMaster.Repet_Deviation);
                var repetLeastCount = Number(repetabilityCalib.repetabilityMaster.Repet_LeastCnt);
                var repetFormula = "";
                if( repetDev > (0.41 * repetLeastCount)) {
                     repetFormula = "2 X SD";
                }else{
                    repetFormula = "2 X (0.41 X d)"
                }
            }

            if (uncertinityCalib != false) {
                var uncertinityCalibStoreData = await this.uncertinityCalibInsertData(uncertinityCalib, clientIp, value.reportType);
                Uncertanity = "true";
            }

            if (eccentricityCalib != false) {
                var eccentricityCalibStoreData = await this.eccentricityCalibInsertData(eccentricityCalib, clientIp, value.reportType);
                Eccentricity = "true";
            }
            if (linearityCalib != false) {
                var linearityCalibStoreData = await this.linearityCalibInsertDataForCM(linearityCalib, clientIp, value.reportType);
                Linearity = "true";
            }

                if(int_periodicFirstReportRepeatability == '1') {
                    if ((repetabilityCalib == false) && (value.reportType == 'Complete')) {
                        Object.assign(responseObj, { status: 'Fail' });
                        return responseObj;
                    } else if ((repetabilityCalib == false) && (value.reportType != 'Complete')) {
                        Object.assign(responseObj, { status: 'Fail' });
                        return responseObj;
                    }
                    else {
                        Object.assign(responseObj, { status: 'success' }, {
                            SelectedAction: req.body.repSrNo, 
                            HmiId: clientIp.split(':')[3], 
                            UserId: req.body.userId,
                            UserName: req.body.username,
                            UserId: req.body.userId,
                            Eccentricity: Eccentricity,
                            Repeatability: Repeatability,
                            Uncertanity: Uncertanity,
                            Linearity : Linearity,
                            reportType: req.body.reportType,
                            printNo: Number(req.body.printNo),
                            MeanRep: (Repeatability == "true")? repetabilityCalib.repetabilityMaster.Repet_Mean : 0,
                            CalStandDevRep: (Repeatability == "true")? repetabilityCalib.repetabilityMaster.Repet_Deviation : 0,
                            waterMark: true,
                            repetFormula : (Repeatability == "true")? repetFormula : "",
                        });
                        return responseObj;
                    }
                }else {
                    if ((periodicCalib == false) && (value.reportType == 'Complete')) {
                        Object.assign(responseObj, { status: 'Fail' });
                        return responseObj;
                    } else if ((periodicCalib == false) && (value.reportType != 'Complete')) {
                        Object.assign(responseObj, { status: 'Fail' });
                        return responseObj;
                    }
                    else {
                        Object.assign(responseObj, { status: 'success' }, {
                            SelectedAction: req.body.repSrNo, 
                            HmiId: clientIp.split(':')[3], 
                            UserId: req.body.userId,
                            UserName: req.body.username,
                            UserId: req.body.userId,
                            Eccentricity: Eccentricity,
                            Repeatability: Repeatability,
                            Uncertanity: Uncertanity,
                            Linearity : Linearity,
                            reportType: req.body.reportType,
                            printNo: Number(req.body.printNo),
                            MeanRep: (Repeatability == "true")? repetabilityCalib.repetabilityMaster.Repet_Mean : 0,
                            CalStandDevRep: (Repeatability == "true")? repetabilityCalib.repetabilityMaster.Repet_Deviation : 0,
                            MeanUncert: (Uncertanity == "true")? uncertinityCalib.uncertinityMaster.Uncertinity_Mean : 0,
                            CalStandDevUncert: (Uncertanity == "true")? uncertinityCalib.uncertinityMaster.Uncertinity_SD : 0,
                            waterMark: true,
                            Upper:periodicCalib.periodicdetail.length
                        });
                        return responseObj;
                    }
                }




        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getBalance(value) {
        try {
            var balObj = await models.tbl_balance.findAll({
                where: {
                    Bal_ID: value.balId
                }
            })
            var balData = balObj;
            if (balData.length > 0) {
                return balData[0];
            } else {
                false;
            }
        } catch (error) {
            return error;
        }
    }

    async getVernier(req) {
        try {
            const obj_getVerDetail = {
                str_tableName: 'tbl_vernier',
                data: '*',
                condition: [
                    { str_colName: 'VernierID', value: req.body.VernierCode, comp: 'eq' }
                ]
            }
            var verData = await database.select(obj_getVerDetail);
            if (verData[0].length > 0) {
                return verData[0][0];
            } else {
                false;
            }
        } catch (error) {
            return error;
        }
    }

    async getBalancWeights(value) {
        try {
            var balObj = await models.tbl_balance_weights.findAll({
                where: {
                    Bal_ID: value.balId
                }
            })
            var balData = balObj;
            if (balData.length > 0) {
                return balData[0];
            } else {
                false;
            }
        } catch (error) {
            return error;
        }
    }

    async getPeriodicCalibrationData(value) {
        try {
            var resoponseObj = {};
            var MasterTableName;
            var detailTableName;
            if (value.reportType == 'Complete') {
                MasterTableName = 'tbl_calibration_periodic_master';
                detailTableName = 'tbl_calibration_periodic_detail';
            } else {
                MasterTableName = 'tbl_calibration_periodic_master_failed';
                detailTableName = 'tbl_calibration_periodic_detail_failed';
            }

            var periodicMaster = await models[MasterTableName].findAll({
                where: {
                    Periodic_RepNo: value.repSrNo
                }
            });

            if (periodicMaster.length > 0) {

                var periodicDetailObj = await models[detailTableName].findAll({
                    where: {
                        Periodic_RepNo: value.repSrNo
                    }
                });

                var periodicDetail = periodicDetailObj;
                Object.assign(resoponseObj, { periodicMaster: periodicMaster[0], periodicdetail: periodicDetail });
                return resoponseObj;

            } else {
                return false;
            }

        } catch (error) {
            return (error);
        }
    }

    async getPeriodicCalibrationDataVernier(req) {
        try {
            var resoponseObj = {};
            var MasterTableName;
            var detailTableName;
            if (value.reportType == 'Complete') {
                MasterTableName = 'tbl_calibration_periodic_master_vernier';
                detailTableName = 'tbl_calibration_periodic_detail_vernier';
            } else {
                MasterTableName = 'tbl_calibration_periodic_master_vernier_incomplete';
                detailTableName = 'tbl_calibration_periodic_detail_vernier_incomplete';
            }
            const periodicMasterObj = {
                str_tableName: MasterTableName,
                data: '*',
                condition: [
                    { str_colName: 'Periodic_RepNo', value: req.body.repSrNo, comp: 'eq' }
                ]
            }
            var periodicMaster = await database.select(periodicMasterObj);

            if (periodicMaster[0].length > 0) {

                var dp = 2;

                const periodicDetailObj = await dbCon.execute(`Select Periodic_RepNo, Periodic_RecNo,
                round(Periodic_StdBlock,${dp}) AS Periodic_StdBlock,round(Periodic_NegTol,${dp}) AS Periodic_NegTol
                ,round(Periodic_PosTol,${dp}) AS Periodic_PosTol,round(Periodic_ActualWt,${dp}) AS Periodic_ActualWt,
                Periodic_BlockboxID,Periodic_Block,Periodic_BlockIdentification,Periodic_BlockboxCert,
                round(PercentofCapacity,${dp}) AS PercentofCapacity,Periodic_BlockboxValidUpto,Decimal_Point from ${detailTableName} where 
                Periodic_RepNo = ${req.body.repSrNo}`);
                var periodicDetail = periodicDetailObj;
                Object.assign(resoponseObj, { periodicMaster: periodicMaster[0][0], periodicdetail: periodicDetail[0] });
                return resoponseObj;

            } else {
                return false;
            }

        } catch (error) {
            return (error);
        }
    }

    async getEccentricityCalibrationData(value) {
        try {
            var resoponseObj = {};
            var MasterTableName;
            var detailTableName;
            if (value.reportType == 'Complete') {
                MasterTableName = 'tbl_calibration_eccentricity_master';
                detailTableName = 'tbl_calibration_eccentricity_detail';
            } else {
                MasterTableName = 'tbl_calibration_eccentricity_master_failed';
                detailTableName = 'tbl_calibration_eccentricity_detail_failed';
            }

            var eccentricityMasterObj = await models[MasterTableName].findAll({
                where: {
                    Eccent_RepNo: value.repSrNo
                }
            });
            var eccentricityMaster = eccentricityMasterObj;


            if (eccentricityMaster.length > 0) {

                var eccentricityDetailObj = await models[detailTableName].findAll({
                    where: {
                        Eccent_RepNo: value.repSrNo
                    }
                });


                var eccentricityDetail = eccentricityDetailObj;
                Object.assign(resoponseObj, { eccentricityMaster: eccentricityMaster[0], eccentricityDetail: eccentricityDetail });
                return resoponseObj;

            } else {
                return false;
            }

        } catch (error) {
            return (error);
        }
    }

    async getRepetabilityCalibrationData(value) {
        try {
            var resoponseObj = {};
            var MasterTableName;
            var detailTableName;
            if (value.reportType == 'Complete') {
                MasterTableName = 'tbl_calibration_repetability_master';
                detailTableName = 'tbl_calibration_repetability_detail';
            } else {
                MasterTableName = 'tbl_calibration_repetability_master_failed';
                detailTableName = 'tbl_calibration_repetability_detail_failed';
            }

            var repetabilityMasterObj = await models[MasterTableName].findAll({
                where: {
                    Repet_RepNo: value.repSrNo
                }
            });
            var repetabilityMaster = repetabilityMasterObj;

            if (repetabilityMaster.length > 0) {

                var repetabilityDetailObj = await models[detailTableName].findAll({
                    where: {
                        Repet_RepNo: value.repSrNo
                    }
                });

                var repetabilityDetail = repetabilityDetailObj;
                Object.assign(resoponseObj, { repetabilityMaster: repetabilityMaster[0], repetabilityDetail: repetabilityDetail });
                return resoponseObj;

            } else {
                return false;
            }

        } catch (error) {
            return (error);
        }
    }

    async getUncertinityCalibrationData(value) {
        try {
            var resoponseObj = {};
            var MasterTableName;
            var detailTableName;
            if (value.reportType == 'Complete') {
                MasterTableName = 'tbl_calibration_uncertinity_master';
                detailTableName = 'tbl_calibration_uncertinity_detail';
            } else {
                MasterTableName = 'tbl_calibration_uncertinity_master_failed';
                detailTableName = 'tbl_calibration_uncertinity_detail_failed';
            }

            var uncertinityMasterObj = await models[MasterTableName].findAll({
                where: {
                    Uncertinity_RepNo: value.repSrNo
                }
            });
            var uncertinityMaster = uncertinityMasterObj;

            if (uncertinityMaster.length > 0) {
                var uncertinityDetailObj = await models[detailTableName].findAll({
                    where: {
                        Uncertinity_RepNo: value.repSrNo
                    }
                });
                var uncertinityDetail = uncertinityDetailObj;
                Object.assign(resoponseObj, { uncertinityMaster: uncertinityMaster[0], uncertinityDetail: uncertinityDetail });
                return resoponseObj;

            } else {
                return false;
            }

        } catch (error) {
            console.log(error);
            return (error);
        }
    }

    async getLinearityCalibrationData(value) {
        try {
            var resoponseObj = {};
            var MasterTableName;
            var detailTableName;
            if (value.reportType == 'Complete') {
                MasterTableName = 'tbl_calibration_linearity_master';
                detailTableName = 'tbl_calibration_linearity_detail';
            } else {
                MasterTableName = 'tbl_calibration_linearity_master_failed';
                detailTableName = 'tbl_calibration_linearity_detail_failed';
            }

            var linearityMasterObj = await models[MasterTableName].findAll({
                where: {
                    Linear_RepNo: value.repSrNo
                }
            });
            var linearityMaster = linearityMasterObj;

            if (linearityMaster.length > 0) {

                var linearityDetailObj = await models[detailTableName].findAll({
                    where: {
                        Linear_RepNo: value.repSrNo
                    }
                });

                var linearityDetail = linearityDetailObj;
                Object.assign(resoponseObj, { linearityMaster: linearityMaster[0], linearityDetail: linearityDetail });
                return resoponseObj;
            } else {
                return false;
            }
        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async deleteCalibrationAllData(clientIp, value) {
        try {
            var hmiId = clientIp.split(':')[3];
            var deletePeriodicMaster = await models.tbl_calibration_periodic_master_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deletePeriodicDetail = await models.tbl_calibration_periodic_detail_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteEccentricityMaster = await models.tbl_calibration_eccentricity_master_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteEccentricityDetail = await models.tbl_calibration_eccentricity_detail_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteRepetabilityMaster = await models.tbl_calibration_repetability_master_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteRepetabilityDetail = await models.tbl_calibration_repetability_detail_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteUncertinityMaster = await models.tbl_calibration_uncertinity_master_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteUncertinityDetail = await models.tbl_calibration_uncertinity_detail_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });

            var deleteLinearityMaster = await models.tbl_calibration_linearity_master_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });
            var deleteLinearityDetail = await models.tbl_calibration_linearity_detail_temp.destroy({
                where: {
                    HMIID: hmiId
                }
            });

            return true;
        } catch (error) {
            return error;
        }

    }

    async deleteCalibrationAllDataVernier(clientIp) {
        try {
            var hmiId = clientIp.split(':')[3].split('.')[3];

            var deletePeriodicMaster = await models.tbl_calibration_periodic_master_vernier_temp.destroy({
                where: {
                    HMI_ID: hmiId
                }
            });

            const deletePeriodicDetail = {
                str_tableName: 'tbl_calibration_periodic_detail_vernier_temp',
                condition: [
                    { str_colName: 'HMI_ID', value: hmiId }
                ]
            }

            var deletePeriodicMasterRecords = await database.delete(deletePeriodicMaster);
            var deletePeriodicDetailRecords = await database.delete(deletePeriodicDetail);
            return true;
        } catch (error) {
            return error;
        }

    }

    async periodicCalibInsertData(periodicCalib, clientIp, reportType, str_dtformat, std_wtVal, std_WeightBox_certfctNo, std_WeightBox_ValDate) {
        try {
            var masterData = periodicCalib.periodicMaster;
            var detailData = periodicCalib.periodicdetail;
            
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var insertPeriodicMaster = await models.tbl_calibration_periodic_master_temp.create({
                    Periodic_RepNo: masterData.Periodic_RepNo,
                    Periodic_CalbDate: masterData.Periodic_CalbDate,
                    Periodic_DueDate: masterData.Periodic_DueDate,
                    Periodic_CalbTime: date.format(masterData.Periodic_CalbTime, 'HH:mm:ss') , 
                    Periodic_CubicalNo: masterData.Periodic_CubicalNo,
                    Periodic_CubicalName: masterData.Periodic_CubicalName,
                    Periodic_Area: masterData.Periodic_Area,
                    Periodic_IDSNo: masterData.Periodic_IDSNo,
                    Periodic_BalID: masterData.Periodic_BalID,
                    Periodic_Serial: masterData.Periodic_Serial,
                    Periodic_Make: masterData.Periodic_Make,
                    Periodic_Model: masterData.Periodic_Model,
                    Periodic_Unit: masterData.Periodic_Unit,
                    Periodic_Dept: masterData.Periodic_Dept,
                    Periodic_MassWeight: masterData.Periodic_MassWeight,
                    Periodic_LeastCnt: masterData.Periodic_LeastCnt,
                    Periodic_MaxCap: masterData.Periodic_MaxCap,
                    Periodic_MinCap: masterData.Periodic_MinCap,
                    Periodic_Bal_MinOR: masterData.Periodic_Bal_MinOR,
                    Periodic_Bal_MaxOR: masterData.Periodic_Bal_MaxOR,
                    Periodic_ZeroError: masterData.Periodic_ZeroError,
                    Periodic_SpritLevel: masterData.Periodic_SpritLevel,
                    Periodic_GeneralCare: masterData.Periodic_GeneralCare,
                    Periodic_UserID: masterData.Periodic_UserID,
                    Periodic_UserName: masterData.Periodic_UserName,
                    Periodic_VerifyID: masterData.Periodic_VerifyID,
                    Periodic_VerifyName: masterData.Periodic_VerifyName,
                    Periodic_VerifyDate: (masterData.Periodic_VerifyDate == null)? "1992-12-08 00:00:00" : date.format(masterData.Periodic_VerifyDate, 'YYYY-MM-DD HH:mm:ss'),
                    Periodic_VerifyTime: (masterData.Periodic_VerifyTime == null) ? "00:00:00" : date.format(masterData.Periodic_VerifyTime, 'HH:mm:ss'), 
                    Periodic_PrintNo: masterData.Periodic_PrintNo,
                    Periodic_IsRecalib: masterData.Periodic_IsRecalib,
                    Periodic_DP: masterData.Periodic_DP,
                    Periodic_StdWeight: masterData.Periodic_StdWeight,
                    Periodic_NegTol: masterData.Periodic_NegTol,
                    Periodic_PosTol: masterData.Periodic_PosTol,
                    Periodic_Remark: masterData.Periodic_Remark,
                    Periodic_AllWeightboxID: std_wtVal,
                    Periodic_AllWeightboxCert: std_WeightBox_certfctNo,
                    Periodic_AllWeightboxValidUpto: std_WeightBox_ValDate,
                    Periodic_IsBinBalance: masterData.Periodic_IsBinBalance,
                    HMIID: clientIp.split(':')[3],
                    Periodic_Location: masterData.Periodic_Location,
                    Periodic_RoomNo: masterData.Periodic_RoomNo,
                    Periodic_calibStatus: masterData.Periodic_calibStatus,
                    Periodic_CalbReason: (masterData.Periodic_CalbReason == null)? 'NA': masterData.Periodic_CalbReason,
                    Periodic_Pattern: masterData.Periodic_Pattern,
                    Periodic_Frequency: masterData.Periodic_Frequency,
                    Periodic_Bal_Cert_No:masterData.Periodic_Bal_Cert_No
                }, {
                    transaction: t
                });

                for (var i = 0; i < detailData.length; i++) {
                
                    var insertPeriodicDetail = await models.tbl_calibration_periodic_detail_temp.create({
                        Periodic_RepNo: detailData[i].Periodic_RepNo,
                        Periodic_RecNo: detailData[i].Periodic_RecNo,
                        Periodic_BalStdWt: detailData[i].Periodic_BalStdWt,
                        Periodic_BalNegTol: detailData[i].Periodic_BalNegTol,
                        Periodic_BalPosTol: detailData[i].Periodic_BalPosTol,
                        Periodic_ActualWt: detailData[i].Periodic_ActualWt,
                        Periodic_StdWtBoxID: detailData[i].Periodic_StdWtBoxID,
                        Periodic_StdWt: detailData[i].Periodic_StdWt,
                        Periodic_WtIdentification: detailData[i].Periodic_WtIdentification,
                        Periodic_WeightBox_certfctNo: detailData[i].Periodic_WeightBox_certfctNo,
                        Periodic_DP: detailData[i].Periodic_DP,
                        PercentofCapacity: detailData[i].PercentofCapacity,
                        Periodic_ValDate: detailData[i].Periodic_ValDate,
                        Periodic_Tolerance: detailData[i].Periodic_Tolerance,
                        Periodic_Remark: detailData[i].Periodic_Remark,
                        HMIID: clientIp.split(':')[3]
                    }, {
                        transaction: t
                    });
                }//for loop
                return "success";
            });
            return true;
        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async periodicCalibInsertDataVernier(periodicCalib, clientIp, reportType) {
        try {
            var result = "";
            var responseObj = {};
            var dp = periodicCalib.periodicMaster.Decimal_Point;
            (reportType == 'Complete') ? result = "Complies" : result = periodicCalib.periodicMaster.Periodic_Remark;
            var CalbDate, CalbDueDate;
            if (date.format(periodicCalib.periodicMaster.Periodic_CalbDate, 'YYYY-MM-DD') == '1992-12-08') {
                CalbDate = 'NA';
            } else {
                CalbDate = date.format(periodicCalib.periodicMaster.Periodic_CalbDate, 'YYYY-MM-DD');
            }

            if (date.format(periodicCalib.periodicMaster.Periodic_DueDate, 'YYYY-MM-DD') == '1992-12-08') {
                CalbDueDate = 'NA';
            } else {
                CalbDueDate = date.format(periodicCalib.periodicMaster.Periodic_DueDate, 'YYYY-MM-DD');
            }
            const insertPeriodicMaster = {
                str_tableName: 'tbl_calibration_periodic_master_vernier_temp',
                data: [
                    { str_colName: 'Periodic_RepNo', value: periodicCalib.periodicMaster.Periodic_RepNo },
                    { str_colName: 'Periodic_CalbDate', value: date.format(periodicCalib.periodicMaster.Periodic_CalbDate, 'YYYY-MM-DD') },
                    { str_colName: 'Periodic_CalbTime', value: periodicCalib.periodicMaster.Periodic_CalbTime },
                    { str_colName: 'Periodic_VerID', value: periodicCalib.periodicMaster.Periodic_VerID },
                    { str_colName: 'Periodic_VerSrNo', value: periodicCalib.periodicMaster.Periodic_VerSrNo },
                    { str_colName: 'Periodic_Make', value: periodicCalib.periodicMaster.Periodic_Make },
                    { str_colName: 'Periodic_Model', value: periodicCalib.periodicMaster.Periodic_Model },
                    { str_colName: 'Periodic_Unit', value: periodicCalib.periodicMaster.Periodic_Unit },
                    { str_colName: 'Periodic_Dept', value: periodicCalib.periodicMaster.Periodic_Dept },
                    { str_colName: 'Periodic_LeastCnt', value: Number(periodicCalib.periodicMaster.Periodic_LeastCnt).toFixed(dp) },
                    { str_colName: `Periodic_MaxCap`, value: periodicCalib.periodicMaster.Periodic_MaxCap },
                    { str_colName: `Periodic_MinCap`, value: periodicCalib.periodicMaster.Periodic_MinCap },
                    { str_colName: `Periodic_UserID`, value: periodicCalib.periodicMaster.Periodic_UserID },
                    { str_colName: `Periodic_UserName`, value: periodicCalib.periodicMaster.Periodic_UserName },
                    { str_colName: `Periodic_VerifyID`, value: periodicCalib.periodicMaster.Periodic_VerifyID },
                    { str_colName: `Periodic_VerifyName`, value: periodicCalib.periodicMaster.Periodic_VerifyName },
                    { str_colName: `Periodic_PrintNo`, value: periodicCalib.periodicMaster.Periodic_PrintNo },
                    { str_colName: `Periodic_IsRecalib`, value: periodicCalib.periodicMaster.Periodic_IsRecalib[0] },
                    { str_colName: `Periodic_Location`, value: periodicCalib.periodicMaster.Periodic_Location },
                    { str_colName: `Periodic_CubicalNo`, value: periodicCalib.periodicMaster.Periodic_CubicalNo },
                    { str_colName: `Periodic_RoomNo`, value: periodicCalib.periodicMaster.Periodic_RoomNo },
                    { str_colName: `Periodic_DueDate`, value: date.format(periodicCalib.periodicMaster.Periodic_DueDate, 'YYYY-MM-DD') },
                    { str_colName: `Decimal_Point`, value: 2 },
                    { str_colName: `HMI_ID`, value: clientIp.split(':')[3].split('.')[3] },
                    { str_colName: `calibStatus`, value: result },
                ]
            }
            var storeMasterData = await database.save(insertPeriodicMaster);
            var detailData = periodicCalib.periodicdetail;
            var repSerNo = periodicCalib.periodicMaster.Periodic_RepNo;
            var detailTableName;
            if (reportType == 'Complete') {
                detailTableName = 'tbl_calibration_periodic_detail_vernier';
            } else {
                detailTableName = 'tbl_calibration_periodic_detail_vernier_incomplete';
            }
            for (var i = 0; i < detailData.length; i++) {

                var count = i + 1;
                //console.log(count);
                const data = await dbCon.execute(`SELECT ABS(ROUND(Periodic_StdBlock,${dp}) - (SELECT ROUND(Periodic_PosTol,${dp}) 
                FROM ${detailTableName}
                WHERE Periodic_RepNo = ${repSerNo} AND  Periodic_RecNo = ${count})) AS PeriodicVerTol
                FROM
                ${detailTableName}
                WHERE
                Periodic_RepNo = ${repSerNo} AND Periodic_RecNo =${count}`);

                const remarkData = data[0][0];
                const insertDetailData = {
                    str_tableName: 'tbl_calibration_periodic_detail_vernier_temp',
                    data: [
                        { str_colName: 'Periodic_RepNo', value: detailData[i].Periodic_RepNo },
                        { str_colName: 'Periodic_RecNo', value: detailData[i].Periodic_RecNo },
                        { str_colName: 'Periodic_StdBlock', value: detailData[i].Periodic_StdBlock },
                        { str_colName: 'Periodic_NegTol', value: detailData[i].Periodic_NegTol },
                        { str_colName: 'Periodic_PosTol', value: detailData[i].Periodic_PosTol },
                        { str_colName: 'Periodic_ActualWt', value: detailData[i].Periodic_ActualWt },
                        { str_colName: 'Periodic_BlockboxID', value: detailData[i].Periodic_BlockboxID },
                        { str_colName: 'Periodic_Block', value: detailData[i].Periodic_Block },
                        { str_colName: 'Periodic_BlockIdentification', value: detailData[i].Periodic_BlockIdentification },
                        { str_colName: 'Periodic_BlockboxCert', value: detailData[i].Periodic_BlockboxCert },
                        { str_colName: `PercentofCapacity`, value: detailData[i].PercentofCapacity },
                        { str_colName: 'Decimal_Point', value: detailData[i].Decimal_Point },
                        { str_colName: 'Periodic_BlockboxValidUpto', value: detailData[i].Periodic_BlockboxValidUpto },
                        { str_colName: 'HMI_ID', value: clientIp.split(':')[3].split('.')[3] },
                        // { str_colName: 'Periodic_BalTol', value: '+/-' + remarkData.PeriodicVerTol }
                    ]
                }
                var storeDetailData = await database.save(insertDetailData);
            }
            Object.assign(responseObj, { nextCalibDate: CalbDueDate }, { calibDate: CalbDate });
            return responseObj;
        } catch (error) {
            return error;
        }
    }

    async eccentricityCalibInsertData(eccentricityCalib, clientIp, reportType) {
        try {
            var masterData = eccentricityCalib.eccentricityMaster;
            var detailData = eccentricityCalib.eccentricityDetail;
            
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var insertPeriodicMaster = await models.tbl_calibration_eccentricity_master_temp.create({
                    Eccent_RepNo: masterData.Eccent_RepNo,
                    Eccent_CalbDate: masterData.Eccent_CalbDate,
                    Eccent_DueDate: masterData.Eccent_DueDate,
                    Eccent_CalbTime: date.format(masterData.Eccent_CalbTime, 'HH:mm:ss'),
                    Eccent_CubicalNo: masterData.Eccent_CubicalNo,
                    Eccent_CubicalName: masterData.Eccent_CubicalName,
                    Eccent_Area: masterData.Eccent_Area,
                    Eccent_IDSNo: masterData.Eccent_IDSNo,
                    Eccent_BalID: masterData.Eccent_BalID,
                    Eccent_Serial: masterData.Eccent_Serial,
                    Eccent_Make: masterData.Eccent_Make,
                    Eccent_Model: masterData.Eccent_Model,
                    Eccent_Unit: masterData.Eccent_Unit,
                    Eccent_Dept: masterData.Eccent_Dept,
                    Eccent_MassWeight: masterData.Eccent_MassWeight,
                    Eccent_LeastCnt: masterData.Eccent_LeastCnt,
                    Eccent_MaxCap: masterData.Eccent_MaxCap,
                    Eccent_MinCap: masterData.Eccent_MinCap,
                    Eccent_Bal_MinOR: masterData.Eccent_Bal_MinOR,
                    Eccent_Bal_MaxOR: masterData.Eccent_Bal_MaxOR,
                    Eccent_ZeroError: masterData.Eccent_ZeroError,
                    Eccent_SpritLevel: masterData.Eccent_SpritLevel,
                    Eccent_GeneralCare: masterData.Eccent_GeneralCare,
                    Eccent_UserID: masterData.Eccent_UserID,
                    Eccent_UserName: masterData.Eccent_UserName,
                    Eccent_VerifyID: masterData.Eccent_VerifyID,
                    Eccent_VerifyName: masterData.Eccent_VerifyName,
                    Eccent_VerifyDate: (masterData.Eccent_VerifyDate == null) ? "1992-12-08 00:00:00" : date.format(masterData.Eccent_VerifyDate, 'YYYY-MM-DD HH:mm:ss'),
                    Eccent_PrintNo: masterData.Eccent_PrintNo,
                    Eccent_IsRecalib: masterData.Eccent_IsRecalib,
                    Eccent_DP: masterData.Eccent_DP,
                    Eccent_StdWeight: masterData.Eccent_StdWeight,
                    Eccent_NegTol: masterData.Eccent_NegTol,
                    Eccent_PosTol: masterData.Eccent_PosTol,
                    Eccent_Remark: masterData.Eccent_Remark,
                    Eccent_AllWeightboxID: masterData.Eccent_AllWeightboxID,
                    Eccent_AllWeightboxCert: masterData.Eccent_AllWeightboxCert,
                    Eccent_AllWeightboxValidUpto: masterData.Eccent_AllWeightboxValidUpto,
                    Eccent_IsBinBalance: masterData.Eccent_IsBinBalance,
                    HMIID: clientIp.split(':')[3]
                }, {
                    transaction: t
                });


                for (var i = 0; i < detailData.length; i++) {
                    var insertPeriodicDetail = await models.tbl_calibration_eccentricity_detail_temp.create({
                        Eccent_RepNo: detailData[i].Eccent_RepNo,
                        Eccent_RecNo: detailData[i].Eccent_RecNo,
                        Eccent_BalStdWt: detailData[i].Eccent_BalStdWt,
                        Eccent_BalNegTol: detailData[i].Eccent_BalNegTol,
                        Eccent_BalPosTol: detailData[i].Eccent_BalPosTol,
                        Eccent_ActualWt: detailData[i].Eccent_ActualWt,
                        Eccent_WBID: detailData[i].Eccent_StdWtID,
                        Eccent_WBWeight: detailData[i].Eccent_StdWt,
                        Eccent_WBCertNo: detailData[i].Eccent_WeightBox_certfctNo,
                        Eccent_ValDate: detailData[i].Eccent_ValDate,
                        // Eccent_WBValid: detailData.,
                        // Eccent_ActualWt1: detailData.,
                        // Eccent_ActualWt2: detailData.,
                        // Eccent_ActualWt3: detailData.,
                        // Eccent_ActualWt4: detailData.,
                        // Eccent_ActualWt5: detailData.,
                        Eccent_Remark: detailData[i].Eccent_Remark,
                        Eccent_Deviation: detailData[i].Eccent_Deviation,
                        Eccent_DP: detailData.Eccent_DP,
                        HMIID: clientIp.split(':')[3]
                    }, {
                        transaction: t
                    });
                }
            });

            return true;

        } catch (error) {
            return error;
        }
    }

    async repetabilityCalibInsertData(repetabilityCalib, clientIp, reportType,std_wtVal) {
        try {
            var masterData = repetabilityCalib.repetabilityMaster;
            var detailData = repetabilityCalib.repetabilityDetail;
            
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var insertPeriodicMaster = await models.tbl_calibration_repetability_master_temp.create({
                    Repet_RepNo: masterData.Repet_RepNo,
                    Repet_CalbDate: masterData.Repet_CalbDate,
                    Rep_DueDate: masterData.Repet_DueDate,
                    Rep_CalbTime: date.format(masterData.Repet_CalbTime, 'HH:mm:ss'),
                    Rep_CubicalNo: masterData.Repet_CubicalNo,
                    Rep_CubicalName: masterData.Repet_CubicalName,
                    Rep_Area: masterData.Repet_Area,
                    Rep_IDSNo: masterData.Repet_IDSNo,
                    Rep_BalID: masterData.Repet_BalID,
                    Rep_Serial: masterData.Repet_Serial,
                    Rep_Make: masterData.Repet_Make,
                    Rep_Model: masterData.Repet_Model,
                    Rep_Unit: masterData.Repet_Unit,
                    Rep_Dept: masterData.Repet_Dept,
                    Rep_MassWeight: masterData.Repet_MassWeight,
                    Rep_LeastCnt: masterData.Repet_LeastCnt,
                    Rep_MaxCap: masterData.Repet_MaxCap,
                    Rep_MinCap: masterData.Repet_MinCap,
                    Rep_Bal_MinOR: masterData.Repet_Bal_MinOR,
                    Rep_Bal_MaxOR: masterData.Repet_Bal_MaxOR,
                    Rep_ZeroError: masterData.Repet_ZeroError,
                    Rep_SpritLevel: masterData.Repet_SpritLevel,
                    Rep_GeneralCare: masterData.Repet_GeneralCare,
                    Rep_UserID: masterData.Repet_UserID,
                    Rep_UserName: masterData.Repet_UserName,
                    Rep_VerifyID: masterData.Repet_VerifyID,
                    Rep_VerifyName: masterData.Repet_VerifyName,
                    Rep_VerifyDate: (masterData.Repet_VerifyDate == null)? "1992-12-08 00:00:00" : date.format(masterData.Repet_VerifyDate, 'YYYY-MM-DD HH:mm:ss'),
                    Rep_PrintNo: masterData.Repet_PrintNo,
                    Rep_IsRecalib: masterData.Repet_IsRecalib,
                    Rep_DP: masterData.Repet_DP,
                    Rep_StdWeight: masterData.Repet_StdWeight,
                    Rep_NegTol: masterData.Repet_NegTol,
                    Rep_PosTol: masterData.Repet_PosTol,
                    Rep_Remark: masterData.Repet_Remark,
                    Rep_AllWeightboxID: std_wtVal,
                    Rep_AllWeightboxCert: masterData.Repet_AllWeightboxCert,
                    Rep_AllWeightboxValidUpto: masterData.Repet_AllWeightboxValidUpto,
                    Rep_IsBinBalance: masterData.Repet_IsBinBalance,
                    Rep_Per: masterData.Repet_Per,
                    Rep_Deviation: masterData.Repet_Deviation,
                    Rep_Mean: masterData.Repet_Mean,
                    HMIID: clientIp.split(':')[3]
                }, {
                    transaction: t
                });

                for (var i = 0; i < detailData.length; i++) {
                    var insertPeriodicDetail = await models.tbl_calibration_repetability_detail_temp.create({
                        Repet_RepNo: detailData[i].Repet_RepNo,
                        Repet_RecNo: detailData[i].Repet_RecNo,
                        Repet_BalStdWt: detailData[i].Repet_BalStdWt,
                        Repet_BalNegTol: detailData[i].Repet_BalNegTol,
                        Repet_BalPosTol: detailData[i].Repet_BalPosTol,
                        Repet_ActualWt: detailData[i].Repet_ActualWt,
                        Repet_WBID: detailData[i].Repet_StdWtID,
                        Repet_WBWeight: detailData[i].Repet_StdWt,
                        Repet_WBCertNo: detailData[i].Repet_WeightBox_certfctNo,
                        Repet_ValDate: detailData[i].Repet_ValDate,
                        Repet_Remark: detailData[i].Repet_Remark,
                        Repet_DP: detailData[i].Repet_DP,
                        HMIID: clientIp.split(':')[3]
                    }, {
                        transaction: t
                    });
                }
                return "Success";
            });
            return true;

        } catch (error) {
            return error;
        }
    }

    async uncertinityCalibInsertData(uncertinityCalib, clientIp, reportType) {
        try {
            var masterData = uncertinityCalib.uncertinityMaster;
            var detailData = uncertinityCalib.uncertinityDetail;
            
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var insertPeriodicMaster = await models.tbl_calibration_uncertinity_master_temp.create({
                    Uncertinity_RepNo: masterData.Uncertinity_RepNo,
                    Uncertinity_CalbDate: masterData.Uncertinity_CalbDate,
                    Uncertinity_DueDate: masterData.Uncertinity_DueDate,
                    Uncertinity_CalbTime: date.format(masterData.Uncertinity_CalbTime, 'HH:mm:ss'),
                    Uncertinity_CubicalNo: masterData.Uncertinity_CubicalNo,
                    Uncertinity_CubicalName: masterData.Uncertinity_CubicalName,
                    Uncertinity_Area: masterData.Uncertinity_Area,
                    Uncertinity_IDSNo: masterData.Uncertinity_IDSNo,
                    Uncertinity_BalID: masterData.Uncertinity_BalID,
                    Uncertinity_Serial: masterData.Uncertinity_Serial,
                    Uncertinity_Make: masterData.Uncertinity_Make,
                    Uncertinity_Model: masterData.Uncertinity_Model,
                    Uncertinity_Unit: masterData.Uncertinity_Unit,
                    Uncertinity_Dept: masterData.Uncertinity_Dept,
                    Uncertinity_MassWeight: masterData.Uncertinity_MassWeight,
                    Uncertinity_LeastCnt: masterData.Uncertinity_LeastCnt,
                    Uncertinity_MaxCap: masterData.Uncertinity_MaxCap,
                    Uncertinity_MinCap: masterData.Uncertinity_MinCap,
                    Uncertinity_Bal_MinOR: masterData.Uncertinity_Bal_MinOR,
                    Uncertinity_Bal_MaxOR: masterData.Uncertinity_Bal_MaxOR,
                    Uncertinity_ZeroError: masterData.Uncertinity_ZeroError,
                    Uncertinity_SpritLevel: masterData.Uncertinity_SpritLevel,
                    Uncertinity_GeneralCare: masterData.Uncertinity_GeneralCare,
                    Uncertinity_UserID: masterData.Uncertinity_UserID,
                    Uncertinity_UserName: masterData.Uncertinity_UserName,
                    Uncertinity_VerifyID: masterData.Uncertinity_VerifyID,
                    Uncertinity_VerifyName: masterData.Uncertinity_VerifyName,
                    Uncertinity_VerifyDate: (masterData.Uncertinity_VerifyDate == null)? "1992-12-08 00:00:00" : date.format(masterData.Uncertinity_VerifyDate, 'YYYY-MM-DD HH:mm:ss'),
                    Uncertinity_PrintNo: masterData.Uncertinity_PrintNo,
                    Uncertinity_IsRecalib: masterData.Uncertinity_IsRecalib,
                    Uncertinity_DP: masterData.Uncertinity_DP,
                    Uncertinity_StdWeight: masterData.Uncertinity_StdWeight,
                    Uncertinity_NegTol: masterData.Uncertinity_NegTol,
                    Uncertinity_PosTol: masterData.Uncertinity_PosTol,
                    Uncertinity_Remark: masterData.Uncertinity_Remark,
                    Uncertinity_AllWeightboxID: masterData.Uncertinity_AllWeightboxID,
                    Uncertinity_AllWeightboxCert: masterData.Uncertinity_AllWeightboxCert,
                    Uncertinity_AllWeightboxValidUpto: masterData.Uncertinity_AllWeightboxValidUpto,
                    Uncertinity_IsBinBalance: masterData.Uncertinity_IsBinBalance,
                    HMIID: clientIp.split(':')[3],
                    Uncertinity_Percentage : masterData.Uncertinity_Percentage,
                    Uncertinity_Result : masterData.Uncertinity_Result,
                    Uncertinity_Deviation : masterData.Uncertinity_Deviation
                }, {
                    transaction: t
                });


                for (var i = 0; i < detailData.length; i++) {
                    var insertPeriodicDetail = await models.tbl_calibration_uncertinity_detail_temp.create({
                        Uncertinity_RepNo: detailData[i].Uncertinity_RepNo,
                        Uncertinity_RecNo: detailData[i].Uncertinity_RecNo,
                        Uncertinity_BalStdWt: detailData[i].Uncertinity_BalStdWt,
                        Uncertinity_BalNegTol: detailData[i].Uncertinity_BalNegTol,
                        Uncertinity_BalPosTol: detailData[i].Uncertinity_BalPosTol,
                        Uncertinity_ActualWt: detailData[i].Uncertinity_ActualWt,
                        Uncertinity_WBID: detailData[i].Uncertinity_StdWtID,
                        Uncertinity_WBWeight: detailData[i].Uncertinity_StdWt,
                        Uncertinity_WBCertNo: detailData[i].Uncertinity_WeightBox_certfctNo,
                        Uncertinity_ValDate: detailData[i].Uncertinity_ValDate,
                        Uncertinity_DP: detailData[i].Uncertinity_DP,
                        Uncertinity_Remark: detailData[i].Uncertinity_Remark,
                        HMIID: clientIp.split(':')[3]
                    }, {
                        transaction: t
                    });
                }
                return "Success";
            });
            return true;

        } catch (error) {
            return error;
        }
    }

    async linearityCalibInsertData(linearityCalib, clientIp, reportType) {
        try {
            var masterData = linearityCalib.linearityMaster;
            var dp = masterData.Decimal_Point;

            var detailTableName;
            if (reportType == 'Complete') {
                detailTableName = 'tbl_calibration_linearity_detail';
            } else {
                detailTableName = 'tbl_calibration_linearity_detail_failed';
            }
            var repSrNo = masterData.Linear_RepNo;
            var detailData = linearityCalib.linearityDetail;
            var arrPercentage = [];
            var arrResult = [];

            await models.tbl_temp_periodic_yearly.update({
                S_EndTime: masterData.Linear_EndTime
            },
                {
                    where: {
                        HMI_ID: clientIp.split(':')[3].split('.')[3]
                    }
                });


            for (var i = 0; i < detailData.length; i++) {
                var recNo = i + 1;
                var Per = (((Number(detailData[i].Linear_ActualWt) - Number(detailData[i].Linear_BalStdWt)) / Number(detailData[i].Linear_BalStdWt)) * 100);
                if (Math.abs(Number(math.roundUpPad(Per, dp))) > 0.05) {
                    arrResult.push('Fail');
                }
                else {
                    arrResult.push('Pass');
                }
                arrPercentage.push(Math.abs(Number(math.roundUpPad(Per, dp))));
                const insertDetailData = await models.tbl_temp_periodic_yearly.update({
                    ['L_StandardWeight_' + recNo]: detailData[i].Linear_BalStdWt,
                    ['L_ObservedWeight_' + recNo]: detailData[i].Linear_ActualWt
                },
                    {
                        where: {
                            HMI_ID: clientIp.split(':')[3].split('.')[3]
                        }
                    });
            }
            var finalLinearityResult;
            if (arrResult.includes('Fail')) {
                finalLinearityResult = "Fail";
            } else {
                finalLinearityResult = "Pass";
            }
            return {
                Per1: Number(arrPercentage[0]).toFixed(dp),
                Per2: Number(arrPercentage[1]).toFixed(dp),
                Per3: Number(arrPercentage[2]).toFixed(dp),
                Per4: Number(arrPercentage[3]).toFixed(dp),
                Per5: Number(arrPercentage[4]).toFixed(dp),
                Per6: Number(arrPercentage[5]).toFixed(dp),
                Per7: Number(arrPercentage[6]).toFixed(dp),
                Per8: Number(arrPercentage[7]).toFixed(dp),
                Per9: Number(arrPercentage[8]).toFixed(dp),
                RPer1: arrResult[0],
                RPer2: arrResult[1],
                RPer3: arrResult[2],
                RPer4: arrResult[3],
                RPer5: arrResult[4],
                RPer6: arrResult[5],
                RPer7: arrResult[6],
                RPer8: arrResult[7],
                RPer9: arrResult[8],
                finalLinearityResult: finalLinearityResult
            };
        } catch (error) {
            return error;
        }
    }
    async linearityCalibInsertDataForCM(linearityCalib, clientIp, reportType) {
        try {
            var masterData = linearityCalib.linearityMaster;
            var detailData = linearityCalib.linearityDetail;

            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var insertLinearityMaster = await models.tbl_calibration_linearity_master_temp.create({
                    Linear_RepNo : masterData.Linear_RepNo,
                    Linear_CalbDate : masterData.Linear_CalbDate,
                    Linear_DueDate : masterData.Linear_DueDate,
                    Linear_CalbTime : date.format(masterData.Linear_CalbTime, 'HH:mm:ss'),
                    Linear_CubicalNo : masterData.Linear_CubicalNo,
                    Linear_CubicalName : masterData.Linear_CubicalName,
                    Linear_Area : masterData.Linear_Area,
                    Linear_IDSNo : masterData.Linear_IDSNo,
                    Linear_BalID : masterData.Linear_BalID,
                    Linear_Serial : masterData.Linear_Serial,
                    Linear_Make : masterData.Linear_Make,
                    Linear_Model : masterData.Linear_Model,
                    Linear_Unit : masterData.Linear_Unit,
                    Linear_Dept : masterData.Linear_Dept,
                    Linear_MassWeight : masterData.Linear_MassWeight,
                    Linear_LeastCnt : masterData.Linear_LeastCnt,
                    Linear_MaxCap : masterData.Linear_MaxCap,
                    Linear_MinCap : masterData.Linear_MinCap,
                    Linear_Bal_MinOR : masterData.Linear_Bal_MinOR,
                    Linear_Bal_MaxOR : masterData.Linear_Bal_MaxOR,
                    Linear_ZeroError : masterData.Linear_ZeroError,
                    Linear_SpritLevel : masterData.Linear_SpritLevel,
                    Linear_GeneralCare : masterData.Linear_GeneralCare,
                    Linear_UserID : masterData.Linear_UserID,
                    Linear_UserName : masterData.Linear_UserName,
                    Linear_VerifyID : masterData.Linear_VerifyID,
                    Linear_VerifyName : masterData.Linear_VerifyName,
                    Linear_VerifyDate : date.format(masterData.Linear_VerifyDate, 'YYYY-MM-DD HH:mm:ss'),
                    Linear_PrintNo : masterData.Linear_PrintNo,
                    Linear_IsRecalib : masterData.Linear_IsRecalib,
                    Linear_DP : masterData.Decimal_Point,
                    Linear_StdWeight : masterData.Linear_StdWeight,
                    Linear_NegTol : masterData.Linear_NegTol,
                    Linear_PosTol : masterData.Linear_PosTol,
                    Linear_Remark : masterData.Linear_Remark,
                    Linear_AllWeightboxID : masterData.Linear_AllWeightboxID,
                    Linear_AllWeightboxCert : masterData.Linear_AllWeightboxCert,
                    Linear_AllWeightboxValidUpto : masterData.Linear_AllWeightboxValidUpto,
                    Linear_IsBinBalance : masterData.Linear_IsBinBalance,
                    HMIID : clientIp.split(':')[3],
                    Linear_Location : masterData.Linear_Location,
                    Linear_RoomNo : masterData.Linear_RoomNo,
                    Linear_calibStatus : masterData.Linear_calibStatus,
                    Linear_CalbReason : masterData.Linear_CalbReason,
                    Linear_Pattern : masterData.Linear_Pattern,
                    Linear_Frequency : masterData.Linear_Frequency,
                    Linear_Bal_Cert_No : masterData.Linear_Bal_Cert_No,
                    Linear_Percentage : masterData.Linear_Percentage,
                },{
                    transaction : t
                });
                for (let i = 0; i < detailData.length; i++) {
                    var insertLinearityDetail = await models.tbl_calibration_linearity_detail_temp.create({
                        Linear_RepNo : detailData[i].Linear_RepNo,
                        Linear_RecNo : detailData[i].Linear_RecNo,
                        Linear_BalStdWt : detailData[i].Linear_BalStdWt,
                        Linear_BalNegTol : detailData[i].Linear_BalNegTol,
                        Linear_BalPosTol : detailData[i].Linear_BalPosTol,
                        Linear_ActualWt : detailData[i].Linear_ActualWt,
                        Linear_StdWtBoxID : detailData[i].Linear_StdWtBoxID,
                        Linear_StdWt : detailData[i].Linear_StdWt,
                        Linear_WtIdentification : detailData[i].Linear_WtIdentification,
                        Linear_WeightBox_certfctNo : detailData[i].Linear_WeightBox_certfctNo,
                        Linear_DP : detailData[i].Linear_DP,
                        PercentofCapacity : detailData[i].PercentofCapacity,
                        Linear_ValDate : detailData[i].Linear_ValDate,
                        HMIID : clientIp.split(':')[3],
                        Linear_Tolerance : detailData[i].Linear_Tolerance,
                        Linear_Remark : detailData[i].Linear_Remark,
                        Linear_Diff : detailData[i].Linear_Diff
                    },{
                        transaction : t
                    });
                    
                }
                return 'Success';
            });
            return true;
        }catch(err) {
            console.log(err);
            return err;
        }
    }

    /**
    *Repeatablity Calculation @repeatabilityPercantage 
    * Logic : 
    * A) For balance having minimum operating range 310 gm or less than 310 gm (<=310gm)
    * Repeatability = if($SD<0.41d)?  0.41d : $SD
    * B) For balance having minimum operating range greater than 310 gm (>310gm)
    * Repeatability = if(0.41d > $SD)?  $SD * $count : 0.41d
    * 
    * @param type $BalanceCapacity Min OP Range
    * @param type $d Least Count
    * @param type $SD Standard Deviation
    * @param type $count 10 Default
    */


}

module.exports = PeriodicCalibReport;