/**
 * Coated
 */
var IterateObject = require('iterate-object');
serverConfig = require('../../DeveloperPanel-CP10G.json');
const Bln_Is_HardnessNMTNLT = (serverConfig.ProductMasterConf.find(x => x.Name === 'HardnessNMTNLT').Value == 1) ? true : false;

class NewProductAuditCoat {
    constructor() {
        const objResult = {};
        this.objResult = objResult;
    }

    validateIndividual(objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Nomenclature: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_IndStdCoat != "" && objProductNew.flt_IndStdCoat != null) {
                if ((objProductNew.flt_IndStdCoat != 99999) || (objProductNew.flt_IndStdCoat != undefined)) {
                    objIndividual.Individual.Nom = objProductNew.flt_IndStdCoat != "" ? objProductNew.flt_IndStdCoat : false;
                    objIndividual.Individual.T1Neg = objProductNew.flt_IndT1NegCoat != "" ? objProductNew.flt_IndT1NegCoat : false;
                    objIndividual.Individual.T1Pos = objProductNew.flt_IndT1PosCoat != "" ? objProductNew.flt_IndT1PosCoat : false;
                    objIndividual.Individual.T2Neg = objProductNew.flt_IndT2NegCoat != "" ? objProductNew.flt_IndT2NegCoat : false;
                    objIndividual.Individual.T2Pos = objProductNew.flt_IndT2PosCoat != "" ? objProductNew.flt_IndT2PosCoat : false;
                    objIndividual.Individual.NMT = objProductNew.int_IndNMTTabCntCoat != "" ? objProductNew.int_IndNMTTabCntCoat : false;
                    objIndividual.Individual.LimitOn = objProductNew.str_IndLimitOnCoat != "" ? objProductNew.str_IndLimitOnCoat : false;
                    objIndividual.Individual.ReportOn = objProductNew.str_IndGraphOnCoat != "" ? objProductNew.str_IndGraphOnCoat : false;
                    objIndividual.Individual.Nomenclature = objProductNew.str_indCoat_nomNomnclature != "" ? objProductNew.str_indCoat_nomNomnclature : false;
                    objIndividual.Individual.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        })


    }

    validateGroup(objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_GrpStdCoat != "" && objProductNew.flt_GrpStdCoat != null) {
                if ((objProductNew.flt_GrpStdCoat != 99999) || (objProductNew.flt_GrpStdCoat != undefined)) {
                    objGroup.Group.Nom = objProductNew.flt_GrpStdCoat != "" ? objProductNew.flt_GrpStdCoat : false;
                    objGroup.Group.T1Neg = objProductNew.flt_GrpT1NegCoat != "" ? objProductNew.flt_GrpT1NegCoat : false;
                    objGroup.Group.T1Pos = objProductNew.flt_GrpT1PosCoat != "" ? objProductNew.flt_GrpT1PosCoat : false;
                    objGroup.Group.T2Neg = objProductNew.flt_GrpT2NegCoat != "" ? objProductNew.flt_GrpT2NegCoat : false;
                    objGroup.Group.T2Pos = objProductNew.flt_GrpT2PosCoat != "" ? objProductNew.flt_GrpT2PosCoat : false;
                    objGroup.Group.NMT = objProductNew.int_GrpNMTTabCntCoat != "" ? objProductNew.int_GrpNMTTabCntCoat : false;
                    objGroup.Group.LimitOn = objProductNew.str_GrpLimitOnCoat != "" ? objProductNew.str_GrpLimitOnCoat : false;
                    objGroup.Group.ReportOn = objProductNew.str_GrpGraphOn != "" ? objProductNew.str_GrpGraphOn : false;
                    objGroup.Group.Unit = objProductNew.str_groupUnit != "" ? objProductNew.str_groupUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        })
    }

    validateThickness(objProductNew) {
        return new Promise((resolve, reject) => {
            const objThickness = {
                Thickness: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    T3Neg: "",
                    T3Pos: "",
                    NMT: "",
                    // GraphOn: "",
                    Unit:""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_ThkStdCoat != "" && objProductNew.flt_ThkStdCoat != null) {
                if ((objProductNew.flt_ThkStdCoat != 99999) || (objProductNew.flt_ThkStdCoat != undefined)) {
                    objThickness.Thickness.Nom = objProductNew.flt_ThkStdCoat != "" ? objProductNew.flt_ThkStdCoat : false;
                    objThickness.Thickness.T1Neg = objProductNew.flt_ThkT1NegCoat != "" ? objProductNew.flt_ThkT1NegCoat : false;
                    objThickness.Thickness.T1Pos = objProductNew.flt_ThkT1PosCoat != "" ? objProductNew.flt_ThkT1PosCoat : false;
                    objThickness.Thickness.T2Neg = objProductNew.flt_ThkT2NegCoat != "" ? objProductNew.flt_ThkT2NegCoat : false;
                    objThickness.Thickness.T2Pos = objProductNew.flt_ThkT2PosCoat != "" ? objProductNew.flt_ThkT2PosCoat : false;
                    objThickness.Thickness.T3Neg = objProductNew.flt_ThkT3NegCoat != "" ? objProductNew.flt_ThkT3NegCoat : false;
                    objThickness.Thickness.T3Pos = objProductNew.flt_ThkT3PosCoat != "" ? objProductNew.flt_ThkT3PosCoat : false;
                    objThickness.Thickness.NMT = objProductNew.int_ThkNMTTabCntCoat != "" ? objProductNew.int_ThkNMTTabCntCoat : false;
                    objThickness.Thickness.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    // objThickness.Thickness.GraphOn = objProductNew.str_ThkGraphOn;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objThickness);
            }
            resolve(IsChanged);
        })
    }

    validateBreadth(objProductNew) {
        return new Promise((resolve, reject) => {
            const objBreadth = {
                Breadth: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                  //  GraphOn: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_BrdStdCoat != "" && objProductNew.flt_BrdStdCoat != null) {
                if ((objProductNew.flt_BrdStdCoat != 99999) || (objProductNew.flt_BrdStdCoat != undefined)) {
                    objBreadth.Breadth.Nom = objProductNew.flt_BrdStdCoat != "" ? objProductNew.flt_BrdStdCoat : false;
                    objBreadth.Breadth.T1Neg = objProductNew.flt_BrdT1NegCoat != "" ? objProductNew.flt_BrdT1NegCoat : false;
                    objBreadth.Breadth.T1Pos = objProductNew.flt_BrdT1PosCoat != "" ? objProductNew.flt_BrdT1PosCoat : false;
                    objBreadth.Breadth.T2Neg = objProductNew.flt_BrdT2NegCoat != "" ? objProductNew.flt_BrdT2NegCoat : false;
                    objBreadth.Breadth.T2Pos = objProductNew.flt_BrdT2PosCoat != "" ? objProductNew.flt_BrdT2PosCoat : false;
                    objBreadth.Breadth.NMT = objProductNew.int_BrdNMTTabCntCoat != "" ? objProductNew.int_BrdNMTTabCntCoat : false;
                    objBreadth.Breadth.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    //objBreadth.Breadth.GraphOn = objProductNew.str_BrdGraphOn;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objBreadth);
            }
            resolve(IsChanged);
        })
    }

    validateLength(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    T3Neg: "",
                    T3Pos: "",
                    NMT: "",
                    // GraphOn: "",
                    Unit:""
                }
            };
            var IsChanged = false;
            if (objProductNew.flt_LenStdCoat != "" && objProductNew.flt_LenStdCoat != null) {
                if ((objProductNew.flt_LenStdCoat != 99999) || (objProductNew.flt_LenStdCoat != undefined)) {
                    objLength.Length.Nom = objProductNew.flt_LenStdCoat != "" ? objProductNew.flt_LenStdCoat : false;
                    objLength.Length.T1Neg = objProductNew.flt_LenT1NegCoat != "" ? objProductNew.flt_LenT1NegCoat : false;
                    objLength.Length.T1Pos = objProductNew.flt_LenT1PosCoat != "" ? objProductNew.flt_LenT1PosCoat : false;
                    objLength.Length.T2Neg = objProductNew.flt_LenT2NegCoat != "" ? objProductNew.flt_LenT2NegCoat : false;
                    objLength.Length.T2Pos = objProductNew.flt_LenT2PosCoat != "" ? objProductNew.flt_LenT2PosCoat : false;
                    objLength.Length.T3Neg = objProductNew.flt_LenT3NegCoat != "" ? objProductNew.flt_LenT3NegCoat : false;
                    objLength.Length.T3Pos = objProductNew.flt_LenT3PosCoat != "" ? objProductNew.flt_LenT3PosCoat : false;
                    objLength.Length.NMT = objProductNew.int_LenNMTTabCntCoat != "" ? objProductNew.int_LenNMTTabCntCoat : false;
                    objLength.Length.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    //objLength.Length.GraphOn = objProductNew.str_LenGraphOn;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }
            resolve(IsChanged);
        })
    }

    validateDiameter(objProductNew) {
        return new Promise((resolve, reject) => {
            const objDiameter = {
                Diameter: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    T3Neg: "",
                    T3Pos: "",
                    NMT: "",
                    // GraphOn: "",
                    Unit:""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_DiaStdCoat != "" && objProductNew.flt_DiaStdCoat != null) {
                if ((objProductNew.flt_DiaStdCoat != 99999) || (objProductNew.flt_DiaStdCoat != undefined)) {
                    objDiameter.Diameter.Nom = objProductNew.flt_DiaStdCoat != "" ? objProductNew.flt_DiaStdCoat : false;
                    objDiameter.Diameter.T1Neg = objProductNew.flt_DiaT1NegCoat != "" ? objProductNew.flt_DiaT1NegCoat : false;
                    objDiameter.Diameter.T1Pos = objProductNew.flt_DiaT1PosCoat != "" ? objProductNew.flt_DiaT1PosCoat : false;
                    objDiameter.Diameter.T2Neg = objProductNew.flt_DiaT2NegCoat != "" ? objProductNew.flt_DiaT2NegCoat : false;
                    objDiameter.Diameter.T2Pos = objProductNew.flt_DiaT2PosCoat != "" ? objProductNew.flt_DiaT2PosCoat : false;
                    objDiameter.Diameter.T3Neg = objProductNew.flt_DiaT3NegCoat != "" ? objProductNew.flt_DiaT3NegCoat : false;
                    objDiameter.Diameter.T3Pos = objProductNew.flt_DiaT3PosCoat != "" ? objProductNew.flt_DiaT3PosCoat : false;
                    objDiameter.Diameter.NMT = objProductNew.int_DiaNMTTabCntCoat != "" ? objProductNew.int_DiaNMTTabCntCoat : false;
                    objDiameter.Diameter.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    //objDiameter.Diameter.GraphOn = objProductNew.str_DiaGraphOn;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objDiameter);
            }
            resolve(IsChanged);
        })
    }

    validateHardness(objProductNew) {
        return new Promise((resolve, reject) => {
            let str_Tol_1_Neg = (Bln_Is_HardnessNMTNLT == true) ? "NLT" : "T1Neg";
            let str_Tol_1_Pos = (Bln_Is_HardnessNMTNLT == true) ? "NMT" : "T1Pos";
            const objHardness = {
                Hardness: {
                    Nom: "",
                    [str_Tol_1_Neg]: "",
                    [str_Tol_1_Pos]: "",
                    T2Neg: "",
                    T2Pos: "",
                    T3Neg: "",
                    T3Pos: "",
                    HrdUnit: "",
                    ReportOn: ""
                }
            };

            var IsChanged = false;

            if ((objProductNew.flt_HrdStdCoat != "" && objProductNew.flt_HrdStdCoat != null) || 
                (objProductNew.flt_HrdT1Coat != "" && objProductNew.flt_HrdT1Coat != null) ||
                (objProductNew.flt_HrdT2Coat != "" && objProductNew.flt_HrdT2Coat != null)
            ) {
                if ((objProductNew.flt_HrdStdCoat != 99999) || (objProductNew.flt_HrdStdCoat != undefined) ||
                    (objProductNew.flt_HrdT1Coat != 99999) || (objProductNew.flt_HrdT1Coat != undefined) ||
                    (objProductNew.flt_HrdT2Coat != 99999) || (objProductNew.flt_HrdT2Coat != undefined)
                ) {
                    objHardness.Hardness.Nom = objProductNew.flt_HrdStdCoat != "" ? objProductNew.flt_HrdStdCoat : false;
                    objHardness.Hardness[str_Tol_1_Neg] = objProductNew.flt_HrdT1Coat != "" ? objProductNew.flt_HrdT1Coat : false;
                    objHardness.Hardness[str_Tol_1_Pos] = objProductNew.flt_HrdT2Coat != "" ? objProductNew.flt_HrdT2Coat : false;
                    objHardness.Hardness.T2Neg = objProductNew.flt_HrdT1_2Coat != "" ? objProductNew.flt_HrdT1_2Coat : false;
                    objHardness.Hardness.T2Pos = objProductNew.flt_HrdT2_2Coat != "" ? objProductNew.flt_HrdT2_2Coat : false;
                    objHardness.Hardness.T3Neg = objProductNew.flt_HrdT1_3Coat != "" ? objProductNew.flt_HrdT1_3Coat : false;
                    objHardness.Hardness.T3Pos = objProductNew.flt_HrdT2_3Coat != "" ? objProductNew.flt_HrdT2_3Coat : false;
                    objHardness.Hardness.HrdUnit = objProductNew.str_HrdUnitCoat != "" ? objProductNew.str_HrdUnitCoat : false;
                    objHardness.Hardness.ReportOn = objProductNew.str_HrdGraphOnCoat != "" ? objProductNew.str_HrdGraphOnCoat : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objHardness);
            }
            resolve(IsChanged);
        })
    }

    validateDT(objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    DTTime: "",
                    DTMinTemp: "",
                    DTMaxTemp: ""
                }
            };
            var IsChanged = false;
            if (objProductNew.int_DTSSTimeCoat != "" && objProductNew.int_DTSSTimeCoat != null) {
                if ((objProductNew.int_DTSSTimeCoat != 99999) || (objProductNew.int_DTSSTimeCoat != undefined)) {
                    objDT.DT.DTTime = objProductNew.int_DTSSTimeCoat != "" ? objProductNew.int_DTSSTimeCoat : false;
                    objDT.DT.DTMinTemp = objProductNew.flt_DTMinTempCoat != "" ? objProductNew.flt_DTMinTempCoat : false;
                    objDT.DT.DTMaxTemp = objProductNew.flt_DTMaxTempCoat != "" ? objProductNew.flt_DTMaxTempCoat : false;
                    objDT.DT.DTTime = objProductNew.int_DTHHTimeCoat + ":" + objProductNew.int_DTMMTimeCoat + ":" + objProductNew.int_DTSSTimeCoat;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        })
    }

    validateLOD(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLOD = {
                LOD: {
                    MIN: "",
                    MAX: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_MAT1Coat != "" && objProductNew.flt_MAT1Coat != null) {
                if ((objProductNew.flt_MAT1Coat != 99999) || (objProductNew.flt_MAT1Coat != undefined)) {
                    objLOD.LOD.MIN = objProductNew.flt_MAT1Coat != "" ? objProductNew.flt_MAT1Coat : false;
                    objLOD.LOD.MAX = objProductNew.flt_MAT2Coat != "" ? objProductNew.flt_MAT2Coat : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objLOD);
            }

            resolve(IsChanged);
        })

    }
    validateYield(objProductNew) {
        return new Promise((resolve, reject) => {
            const objYield = {
                Yield: {
                    TheroticalYield: "",
                    YieldNLT: "",
                    TotalLossNMT: "",
                }
            };

            var IsChanged = false;

            /**
             * For Individual Nom
             */

            if (objProductNew.TheroticalYield != "" && objProductNew.TheroticalYield != null) {
                if ((objProductNew.TheroticalYield != 99999) || (objProductNew.TheroticalYield != undefined)) {
                    objYield.Yield.TheroticalYield = objProductNew.TheroticalYield != "" ? objProductNew.TheroticalYield : false;
                    //objYield.Yield.YieldNLT = objProductNew.YieldNLT != "" ? objProductNew.YieldNLT : false;
                    //objYield.Yield.TotalLossNMT = objProductNew.TotalLossNMT != "" ? objProductNew.TotalLossNMT : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objYield);
            }
            resolve(IsChanged);
        })


    }

    validateFri(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFriability = {
                Friability: {
                    FriNMT: "",
                    FriSetCnt: "",
                    FriSetRPM: "",
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_FriNMTCoat != "" && objProductNew.flt_FriNMTCoat != null) {
                if ((objProductNew.flt_FriNMTCoat != 99999) || (objProductNew.flt_FriNMTCoat != undefined)) {
                    objFriability.Friability.FriNMT = objProductNew.flt_FriNMTCoat != "" ? objProductNew.flt_FriNMTCoat : false;
                    objFriability.Friability.FriSetCnt = objProductNew.int_FriSetCntCoat != "" ? objProductNew.int_FriSetCntCoat : false;
                    objFriability.Friability.FriSetRPM = objProductNew.int_FriSetRPMCoat != "" ? objProductNew.int_FriSetRPMCoat : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFriability);
            }
            resolve(IsChanged);
        })


    }

    async newCoatedParams(objProductNew) {
        var Ind = await this.validateIndividual(objProductNew);
        var Grp = await this.validateGroup(objProductNew);
        var Thick = await this.validateThickness(objProductNew);
        var Brd = await this.validateBreadth(objProductNew);
        var Len = await this.validateLength(objProductNew);
        var Dia = await this.validateDiameter(objProductNew);
        var Hard = await this.validateHardness(objProductNew);
        var Fri = await this.validateFri(objProductNew);
        var DT = await this.validateDT(objProductNew);
        var LOD = await this.validateLOD(objProductNew);

        
        if (Ind != true && Grp != true && Thick != true && Brd != true &&
            Len != true && Dia != true && Hard != true && DT != true && LOD != true && Fri != true) {
            return "No Change";
        }
        else {
            //var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                var i = 1;
                var obj = value;
                IterateObject(obj, (value, key) => {
                    if (value !== false) {
                        if (i == 1) {
                            // strNewValue = strNewValue + "|" + key1;
                            strNewValue = strNewValue + " " + key1 + "-";
                        }

                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + value + ",";
                        //", ";
                        i = i + 1;
                    }

                })
            });

            return { newData: strNewValue };
        }
    }
}
module.exports = NewProductAuditCoat;