var IterateObject = require("iterate-object");

class clsEditMultihaler {
    constructor() {
        const objResult = {};
        this.objResult = objResult;
        this.strNullValue = "99999.00000";
        this.NMTValue = 99999;
    }

    validateNetMultihaler(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            
            const objNet = {
                Uniformity_of_Content: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" }
                }
            };
            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Net Nom
            */

            if (OldEmpty == true) {
                if (objProductNew.flt_NetStd != "") {
                    objNet.Uniformity_of_Content.Nom.oldValue = "NA";
                    objNet.Uniformity_of_Content.Nom.newValue = objProductNew.flt_NetStd;
                    IsChanged = true;
                }
                else {
                    objNet.Uniformity_of_Content.Nom.oldValue = false;
                    objNet.Uniformity_of_Content.Nom.newValue = false;
                    IsChanged = false;
                }

            }
            else
            {
                if(objProductOld.Param1_Nom == "" || 
                objProductOld.Param1_Nom == this.strNullValue || 
                objProductOld.Param1_Nom == undefined){
                    objProductOld.Param1_Nom = null
                }
                if (objProductNew.flt_NetStd == "" || 
                objProductNew.flt_NetStd == this.strNullValue) {
                    objProductNew.flt_NetStd = null
                }

                

                if (parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP) === parseFloat(objProductNew.flt_NetStd).toFixed(objProductNew.int_netDp)) {
                    objNet.Uniformity_of_Content.Nom.oldValue = false;
                    objNet.Uniformity_of_Content.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if(parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP) === "NaN"){
                        objNet.Uniformity_of_Content.Nom.oldValue = "NA";
                    }
                    else{
                        objNet.Uniformity_of_Content.Nom.oldValue = parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP);
                    }
                    
                    objNet.Uniformity_of_Content.Nom.newValue = objProductNew.flt_NetStd;
                    IsChanged = true;
                }
            }

            /**
             * For Net NegT1
             */

            if (OldEmpty) {
                if (objProductNew.flt_NetT1Neg != "") {
                    objNet.Uniformity_of_Content.T1Neg.oldValue = "NA";
                    objNet.Uniformity_of_Content.T1Neg.newValue = objProductNew.flt_NetT1Neg;
                    IsChanged = true;
                }
                else {
                    objNet.Uniformity_of_Content.T1Neg.oldValue = false;
                    objNet.Uniformity_of_Content.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                if (objProductOld.Param1_T1Neg == "" ||
                    objProductOld.Param1_T1Neg == this.strNullValue ||
                    objProductOld.Param1_T1Neg == undefined) {
                    objProductOld.Param1_T1Neg = null;
                }
               
                if (objProductNew.flt_NetT1Neg == "" ||
                    objProductNew.flt_NetT1Neg == this.strNullValue || 
                    objProductNew.flt_NetT1Neg == undefined) {
                    objProductNew.flt_NetT1Neg = null
                }
                


                if (parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP) === parseFloat(objProductNew.flt_NetT1Neg).toFixed(objProductNew.int_netDp)) {
                    objNet.Uniformity_of_Content.T1Neg.oldValue = false;
                    objNet.Uniformity_of_Content.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if(parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP) === "NaN"){
                        objNet.Uniformity_of_Content.T1Neg.oldValue = "NA";
                    }
                    else{
                        objNet.Uniformity_of_Content.T1Neg.oldValue = parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP);
                    }
                   
                    objNet.Uniformity_of_Content.T1Neg.newValue = objProductNew.flt_NetT1Neg;
                    IsChanged = true;
                }
            }

            /**
             * For Net PosT1
             */

            if (OldEmpty) {
                if (objProductNew.flt_NetT1Pos != "") {
                    objNet.Uniformity_of_Content.T1Pos.oldValue = "NA";
                    objNet.Uniformity_of_Content.T1Pos.newValue = objProductNew.flt_NetT1Pos;
                    IsChanged = true;
                }
                else {
                    objNet.Uniformity_of_Content.T1Pos.oldValue = false;
                    objNet.Uniformity_of_Content.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                if (objProductOld.Param1_T1Pos == "" ||
                    objProductOld.Param1_T1Pos == this.strNullValue ||
                    objProductOld.Param1_T1Pos == undefined) {
                    objProductOld.Param1_T1Pos = null;
                }
               
                if (objProductNew.flt_NetT1Pos == "" ||
                    objProductNew.flt_NetT1Pos == this.strNullValue || 
                    objProductNew.flt_NetT1Pos == undefined) {
                    objProductNew.flt_NetT1Pos = null
                }

               

                if (parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP) === parseFloat(objProductNew.flt_NetT1Pos).toFixed(objProductNew.int_netDp)) {
                    objNet.Uniformity_of_Content.T1Pos.oldValue = false;
                    objNet.Uniformity_of_Content.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if(parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP) === "NaN"){
                        objNet.Uniformity_of_Content.T1Pos.oldValue = "NA";
                    }
                    else{
                        objNet.Uniformity_of_Content.T1Pos.oldValue = parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP);
                    }
                   
                    objNet.Uniformity_of_Content.T1Pos.newValue = objProductNew.flt_NetT1Pos;
                    IsChanged = true;
                }
            }

             /**
            * For Net NegT2
            */
           if (OldEmpty) {
            if (objProductNew.flt_NetT2Neg != "") {
                objNet.Uniformity_of_Content.T2Neg.oldValue = "NA";
                objNet.Uniformity_of_Content.T2Neg.newValue = objProductNew.flt_NetT2Neg;
                IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.T2Neg.oldValue = false;
                objNet.Uniformity_of_Content.T2Neg.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
            }
            else
            {
                if (objProductOld.Param1_T2Neg == "" ||
                    objProductOld.Param1_T2Neg == this.strNullValue ||
                    objProductOld.Param1_T2Neg == undefined) {
                    objProductOld.Param1_T2Neg = null;
                }
            
                if (objProductNew.flt_NetT2Neg == "" ||
                    objProductNew.flt_NetT2Neg == this.strNullValue || 
                    objProductNew.flt_NetT2Neg == undefined) {
                    objProductNew.flt_NetT2Neg = null
                }
                

                if (parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP) === parseFloat(objProductNew.flt_NetT2Neg).toFixed(objProductNew.int_netDp)) {
                    objNet.Uniformity_of_Content.T2Neg.oldValue = false;
                    objNet.Uniformity_of_Content.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if(parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP) === "NaN"){
                        objNet.Uniformity_of_Content.T2Neg.oldValue ="NA";
                    }
                    else{
                        objNet.Uniformity_of_Content.T2Neg.oldValue = parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP);
                    }
                
                    objNet.Uniformity_of_Content.T2Neg.newValue = objProductNew.flt_NetT2Neg;
                    IsChanged = true;
                }
            }

            /**
            * For Net PosT2
            */
           if (OldEmpty) {
            if (objProductNew.flt_NetT2Pos != "") {
                objNet.Uniformity_of_Content.T2Pos.oldValue = "NA";
                objNet.Uniformity_of_Content.T2Pos.newValue = objProductNew.flt_NetT2Pos;
                IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.T2Pos.oldValue = false;
                objNet.Uniformity_of_Content.T2Pos.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
            }
            else
            {
                if (objProductOld.Param1_T2Pos == "" ||
                        objProductOld.Param1_T2Pos == this.strNullValue ||
                        objProductOld.Param1_T2Pos == undefined) {
                        objProductOld.Param1_T2Pos = null;
                    }
                
                    if (objProductNew.flt_NetT2Pos == "" ||
                        objProductNew.flt_NetT2Pos == this.strNullValue || 
                        objProductNew.flt_NetT2Pos == undefined) {
                        objProductNew.flt_NetT2Pos = null
                    }
                    

                    if (parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP) === parseFloat(objProductNew.flt_NetT2Pos).toFixed(objProductNew.int_netDp)) {
                        objNet.Uniformity_of_Content.T2Pos.oldValue = false;
                        objNet.Uniformity_of_Content.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        if(parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP) === "NaN"){
                            objNet.Uniformity_of_Content.T2Pos.oldValue = "NA";
                        }
                        else{
                            objNet.Uniformity_of_Content.T2Pos.oldValue = parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP);
                        }
                        
                        objNet.Uniformity_of_Content.T2Pos.newValue = objProductNew.flt_NetT2Pos;
                        IsChanged = true;
                    }
            }

            /**
            * For Net NMT
            */
        if (OldEmpty) {
            if (objProductNew.int_NetNMTCnt != "") {
                objNet.Uniformity_of_Content.NMT.oldValue = "NA";
                objNet.Uniformity_of_Content.NMT.newValue = objProductNew.int_NetNMTCnt;
                IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.NMT.oldValue = false;
                objNet.Uniformity_of_Content.NMT.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
        }
        else
        {
            if (objProductOld.Param1_NMTTab == 0 ||
                    objProductOld.Param1_NMTTab == this.NMTValue ||
                    objProductOld.Param1_NMTTab == undefined) {
                    objProductOld.Param1_NMTTab = 0;
                }
                objProductNew.int_NetNMTCnt = objProductNew.int_NetNMTCnt == "" ? this.strNullValue : objProductNew.int_NetNMTCnt;
                if (objProductNew.int_NetNMTCnt == "0" ||
                    objProductNew.int_NetNMTCnt == this.NMTValue || 
                    objProductNew.int_NetNMTCnt == undefined) {
                    objProductNew.int_NetNMTCnt = 0
                }

            if (parseInt(objProductOld.Param1_NMTTab) === parseInt(objProductNew.int_NetNMTCnt)) {
                objNet.Uniformity_of_Content.NMT.oldValue = false;
                objNet.Uniformity_of_Content.NMT.newValue = false;
                IsChanged != true ? IsChanged = false : IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.NMT.oldValue = objProductOld.Param1_NMTTab;
                objNet.Uniformity_of_Content.NMT.newValue = objProductNew.int_NetNMTCnt;
                IsChanged = true;
            }
        }

        /**
         * For Individual Limits On Actual / Percent
         */
        if (OldEmpty) {
            if (objProductNew.str_NetLimitOn!= "") {
                objNet.Uniformity_of_Content.LimitOn.oldValue = "NA";
                objNet.Uniformity_of_Content.LimitOn.newValue = objProductNew.str_NetLimitOn;
                IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.LimitOn.oldValue = false;
                objNet.Uniformity_of_Content.LimitOn.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
        }
        else
        {
            const strLimitOn = objProductOld.Param1_LimitOn.data[0] === 0 ? "Actual" : "Percentage";
            if (strLimitOn == objProductNew.str_NetLimitOn) {
                objNet.Uniformity_of_Content.LimitOn.oldValue = false;
                objNet.Uniformity_of_Content.LimitOn.newValue = false;
                IsChanged != true ? IsChanged = false : IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.LimitOn.oldValue = strLimitOn;
                objNet.Uniformity_of_Content.LimitOn.newValue = objProductNew.str_NetLimitOn;
                IsChanged = true;
            }
        }

         /**
         * For Standard or Average         */
        if (OldEmpty) {
            if (objProductNew.str_UCGraphOn!= "") {
                objNet.Uniformity_of_Content.ReportOn.oldValue = "NA";
                objNet.Uniformity_of_Content.ReportOn.newValue = objProductNew.str_UCGraphOn;
                IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.ReportOn.oldValue = false;
                objNet.Uniformity_of_Content.ReportOn.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
        }
        else
        {
            const strReportOn = objProductOld.Param1_IsOnStd.data[0] === 0 ? "Standard" : "Average";
            if (strReportOn == objProductNew.str_UCGraphOn) {
                objNet.Uniformity_of_Content.ReportOn.oldValue = false;
                objNet.Uniformity_of_Content.ReportOn.newValue = false;
                IsChanged != true ? IsChanged = false : IsChanged = true;
            }
            else {
                objNet.Uniformity_of_Content.ReportOn.oldValue = strReportOn;
                objNet.Uniformity_of_Content.ReportOn.newValue = objProductNew.str_UCGraphOn;
                IsChanged = true;
            }
        }

        if (IsChanged == true) {
            Object.assign(this.objResult, objNet);
        }
        resolve(IsChanged);
            
        })

    }

    validateGrpMultihaler(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGrp = {
                Sealed_Cartridge: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Group Nom
            */
            if (OldEmpty) {
                if (objProductNew.flt_GrpStd != "") {
                    objGrp.Sealed_Cartridge.Nom.oldValue = "NA";
                    objGrp.Sealed_Cartridge.Nom.newValue = objProductNew.flt_GrpStd;
                    IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.Nom.oldValue = false;
                    objGrp.Sealed_Cartridge.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                if (objProductOld.Param2_Nom == "" ||
                    objProductOld.Param2_Nom == this.strNullValue ||
                    objProductOld.Param2_Nom == undefined) {
                    objProductOld.Param2_Nom = null;
                }


                objProductNew.flt_GrpStd = objProductNew.flt_GrpStd == "" ? this.strNullValue : objProductNew.flt_GrpStd;

                if (objProductNew.flt_GrpStd == "" ||
                    objProductNew.flt_GrpStd == this.strNullValue ||
                    objProductNew.flt_GrpStd == undefined) {
                    objProductNew.flt_GrpStd = null;
                } 
                
                if (parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP) === parseFloat(objProductNew.flt_GrpStd).toFixed(objProductNew.int_grpDp)) {
                    objGrp.Sealed_Cartridge.Nom.oldValue = false;
                    objGrp.Sealed_Cartridge.Nom.newValue = false;
                    IsChanged = false;
                }
                else {
                    if(parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP) === "NaN"){
                        objGrp.Sealed_Cartridge.Nom.oldValue = "NA";  
                    }
                    else{
                        objGrp.Sealed_Cartridge.Nom.oldValue = parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP);
                    }
                  
                    objGrp.Sealed_Cartridge.Nom.newValue = objProductNew.flt_GrpStd;
                    IsChanged = true;
                }
            }

            /**
             * For Group NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1Neg != "") {
                    objGrp.Sealed_Cartridge.T1Neg.oldValue = "NA";
                    objGrp.Sealed_Cartridge.T1Neg.newValue = objProductNew.flt_GrpT1Neg;
                    IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.T1Neg.oldValue = false;
                    objGrp.Sealed_Cartridge.T1Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                if (objProductOld.Param2_T1Neg == "" ||
                    objProductOld.Param2_T1Neg == this.strNullValue ||
                    objProductOld.Param2_T1Neg == undefined) {
                    objProductOld.Param2_T1Neg = null;
                }

                objProductNew.flt_GrpT1Neg = objProductNew.flt_GrpT1Neg == "" ? this.strNullValue : objProductNew.flt_GrpT1Neg ;
                if (objProductNew.flt_GrpT1Neg == "" ||
                    objProductNew.flt_GrpT1Neg == this.strNullValue ||
                    objProductNew.flt_GrpT1Neg == undefined) {
                    objProductNew.flt_GrpT1Neg = null;
                } 
                
                if (parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP) === parseFloat(objProductNew.flt_GrpT1Neg).toFixed(objProductNew.int_grpDp)) {
                    objGrp.Sealed_Cartridge.T1Neg.oldValue = false;
                    objGrp.Sealed_Cartridge.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if(parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP) === "NaN"){
                        objGrp.Sealed_Cartridge.T1Neg.oldValue = "NA";
                    }
                    else{
                        objGrp.Sealed_Cartridge.T1Neg.oldValue = parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP);
                    }
                    objGrp.Sealed_Cartridge.T1Neg.newValue = objProductNew.flt_GrpT1Neg;
                    IsChanged = true;
                }
            }

            /**
             * For Group PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1Pos != "") {
                    objGrp.Sealed_Cartridge.T1Pos.oldValue = "NA";
                    objGrp.Sealed_Cartridge.T1Pos.newValue = objProductNew.flt_GrpT1Pos;
                    IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.T1Pos.oldValue = false;
                    objGrp.Grp.T1Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                if (objProductOld.Param2_T1Pos == "" ||
                    objProductOld.Param2_T1Pos == this.strNullValue ||
                    objProductOld.Param2_T1Pos == undefined) {
                    objProductOld.Param2_T1Pos = null;
                }

                objProductNew.flt_GrpT1Pos = objProductNew.flt_GrpT1Pos == "" ? this.strNullValue : objProductNew.flt_GrpT1Pos;
                if (objProductNew.flt_GrpT1Pos == "" ||
                    objProductNew.flt_GrpT1Pos == this.strNullValue ||
                    objProductNew.flt_GrpT1Pos == undefined) {
                    objProductNew.flt_GrpT1Pos = null;
                } 

                
                
                if (parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP) === parseFloat(objProductNew.flt_GrpT1Pos).toFixed(objProductNew.int_grpDp)) {
                    objGrp.Sealed_Cartridge.T1Pos.oldValue = false;
                    objGrp.Sealed_Cartridge.T1Pos.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if(parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP) === "NaN"){
                        objGrp.Sealed_Cartridge.T1Pos.oldValue = "NA";
                    }
                    else{
                        objGrp.Sealed_Cartridge.T1Pos.oldValue = parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP);
                    }
                    
                    objGrp.Sealed_Cartridge.T1Pos.newValue = objProductNew.flt_GrpT1Pos;
                    IsChanged = true;
                }
    
            }

            /**
            * For Group NegT2
            */
           if (OldEmpty) {
            if (objProductNew.flt_GrpT2Neg != "") {
                objGrp.Sealed_Cartridge.T2Neg.oldValue = "NA";
                objGrp.Sealed_Cartridge.T2Neg.newValue = objProductNew.flt_GrpT2Neg;
                IsChanged = true;
            }
            else {
                objGrp.Sealed_Cartridge.T2Neg.oldValue = false;
                objGrp.Sealed_Cartridge.T2Neg.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
            }
            else
            {
                if (objProductOld.Param2_T2Neg == "" ||
                    objProductOld.Param2_T2Neg == this.strNullValue ||
                    objProductOld.Param2_T2Neg == undefined) {
                    objProductOld.Param2_T2Neg = null;
                }

                objProductNew.flt_GrpT2Neg = objProductNew.flt_GrpT2Neg == "" ? this.strNullValue : objProductNew.flt_GrpT2Neg;

                if (objProductNew.flt_GrpT2Neg == "" ||
                    objProductNew.flt_GrpT2Neg == this.strNullValue ||
                    objProductNew.flt_GrpT2Neg == undefined) {
                    objProductNew.flt_GrpT2Neg = null;
                } 

                
                if (parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP) === parseFloat(objProductNew.flt_GrpT2Neg).toFixed(objProductNew.int_grpDp)) {
                    objGrp.Sealed_Cartridge.T2Neg.oldValue = false;
                    objGrp.Sealed_Cartridge.T2Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if(parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP) === "NaN"){
                        objGrp.Sealed_Cartridge.T2Neg.oldValue = "NA";
                    }
                    else{
                        objGrp.Sealed_Cartridge.T2Neg.oldValue = parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP);
                    }
                    objGrp.Sealed_Cartridge.T2Neg.newValue = objProductNew.flt_GrpT2Neg;
                    IsChanged = true;
                }
            }

            /**
            * For Group PosT2
            */
           if (OldEmpty) {
            if (objProductNew.flt_GrpT2Pos != "") {
                objGrp.Sealed_Cartridge.T2Pos.oldValue = "NA";
                objGrp.Sealed_Cartridge.T2Pos.newValue = objProductNew.flt_GrpT2Pos;
                IsChanged = true;
            }
            else {
                objGrp.Sealed_Cartridge.T2Pos.oldValue = false;
                objGrp.Sealed_Cartridge.T2Pos.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
        }
        else
        {
            if (objProductOld.Param2_T2Pos == "" ||
                objProductOld.Param2_T2Pos == this.strNullValue ||
                objProductOld.Param2_T2Pos == undefined) {
                objProductOld.Param2_T2Pos = null;
            }

            objProductNew.flt_GrpT2Pos = objProductNew.flt_GrpT2Pos == "" ? this.strNullValue : objProductNew.flt_GrpT2Pos;
            if (objProductNew.flt_GrpT2Pos == "" ||
                objProductNew.flt_GrpT2Pos == this.strNullValue ||
                objProductNew.flt_GrpT2Pos == undefined) {
                objProductNew.flt_GrpT2Pos = null;
            }  
            
            if (parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP) === parseFloat(objProductNew.flt_GrpT2Pos).toFixed(objProductNew.int_grpDp)) {
                objGrp.Sealed_Cartridge.T2Pos.oldValue = false;
                objGrp.Sealed_Cartridge.T2Pos.newValue = false;
                IsChanged != true ? IsChanged = false : IsChanged = true;
            }
            else {
                if(parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP) === "NaN"){
                    objGrp.Sealed_Cartridge.T2Pos.oldValue = "NA";
                }
                else{
                    objGrp.Sealed_Cartridge.T2Pos.oldValue = parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP);
                }
                objGrp.Sealed_Cartridge.T2Pos.oldValue = parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP);
                objGrp.Sealed_Cartridge.T2Pos.newValue = objProductNew.flt_GrpT2Pos;
                IsChanged = true;
            }
        }

        /**
        * For group NMT
        */
           if (OldEmpty) {
            if (objProductNew.int_GrpNMTCnt != "") {
                objGrp.Sealed_Cartridge.NMT.oldValue = "NA";
                objGrp.Sealed_Cartridge.NMT.newValue = objProductNew.int_GrpNMTCnt;
                IsChanged = true;
            }
            else {
                objGrp.Sealed_Cartridge.NMT.oldValue = false;
                objGrp.Sealed_Cartridge.NMT.newValue = false;
                IsChanged = IsChanged != true ? false : true;
            }
        }
        else
        {
            if (objProductOld.Param2_NMTTab == 0 ||
                objProductOld.Param2_NMTTab == this.NMTValue ||
                objProductOld.Param2_NMTTab == undefined) {
                objProductOld.Param2_NMTTab = 0;
            }
            objProductNew.int_GrpNMTCnt = objProductNew.int_GrpNMTCnt == "" ? this.strNullValue : objProductNew.int_GrpNMTCnt;
            
            if (objProductNew.int_GrpNMTCnt == "0" ||
                objProductNew.int_GrpNMTCnt == this.NMTValue ||
                objProductNew.int_GrpNMTCnt == undefined) {
                objProductNew.int_GrpNMTCnt = 0;
            } 
            if (parseInt(objProductOld.Param2_NMTTab) == parseInt(objProductNew.int_GrpNMTCnt)) {
                objGrp.Sealed_Cartridge.NMT.oldValue = false;
                objGrp.Sealed_Cartridge.NMT.newValue = false;
                IsChanged != true ? IsChanged = false : IsChanged = true;
            }
            else {
                objGrp.Sealed_Cartridge.NMT.oldValue = objProductOld.Param2_NMTTab;
                objGrp.Sealed_Cartridge.NMT.newValue = objProductNew.int_GrpNMTCnt;
                IsChanged = true;
            } 
        }

        /**
             * For group Limits On Actual / Percent
             */
            if (OldEmpty) {
                if (objProductNew.str_GrpLimitOn != "") {
                    objGrp.Sealed_Cartridge.LimitOn.oldValue = "NA";
                    objGrp.Sealed_Cartridge.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                    IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.LimitOn.oldValue = false;
                    objGrp.Sealed_Cartridge.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                const strLimitOn = objProductOld.Param2_LimitOn.data[0] == 0 ? "Actual" : "Percentage";
                if (strLimitOn == objProductNew.str_GrpLimitOn) {
                    objGrp.Sealed_Cartridge.LimitOn.oldValue = false;
                    objGrp.Sealed_Cartridge.LimitOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.LimitOn.oldValue = strLimitOn;
                    objGrp.Sealed_Cartridge.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                    IsChanged = true;
                }
            }

            /**
             * For Averge and standard
             */
            if (OldEmpty) {
                if (objProductNew.str_SCGraphOn != "") {
                    objGrp.Sealed_Cartridge.ReportOn.oldValue = "NA";
                    objGrp.Sealed_Cartridge.ReportOn.newValue = objProductNew.str_SCGraphOn;
                    IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.ReportOn.oldValue = false;
                    objGrp.Sealed_Cartridge.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else
            {
                const strReportOn = objProductOld.Param2_IsOnStd.data[0] == 0 ? "Standard" : "Average";
                if (strReportOn == objProductNew.str_SCGraphOn) {
                    objGrp.Sealed_Cartridge.ReportOn.oldValue = false;
                    objGrp.Sealed_Cartridge.ReportOn.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objGrp.Sealed_Cartridge.ReportOn.oldValue = strReportOn;
                    objGrp.Sealed_Cartridge.ReportOn.newValue = objProductNew.str_SCGraphOn;
                    IsChanged = true;
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGrp);
            }
            resolve(IsChanged);
 
        })
    }

    async editMultihalerParams(objProductOld, objProductNew) {
        var Net = await this.validateNetMultihaler(objProductOld, objProductNew);
        var Grp = await this.validateGrpMultihaler(objProductOld, objProductNew);
        

        if (Net != true && Grp != true) {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                var obj = value;
                IterateObject(obj, (value, key) => {
                    //console.log(value.oldValue);
                    if (value.oldValue !== false) {
                        strChanged = strChanged + key1 + ":";
                        strChanged = strChanged + key + ":";
                        strChanged = strChanged + value.oldValue + ", ";
                        ", ";

                        strNewValue = strNewValue + key1 + ":";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + value.newValue + ", ";
                        ", ";
                    }

                })
            });
            if(strChanged == ""){
                strChanged = 'NA';
            }
            if(strNewValue == ""){
                strNewValue = 'NA';
            }
            return { oldData: strChanged, newData: strNewValue };
        }
    }

}
module.exports = clsEditMultihaler;