const Database = require('../database/clsQueryProcess');
const database = new Database();
const clsQueryBuilder = require('../database/clsQueryTransactProcess');
const ObjQueryBuilder = new clsQueryBuilder();
const date = require('date-and-time')


class ContentModel {

  async getContent(){
        try{
            var responseObj = {};
            const contentObj = {
                str_tableName: 'tbl_content_type',
                data: '*'
            }
            var result = await database.select(contentObj);
            if(result[0].length > 0){
                Object.assign(responseObj, { status: 'success' }, { result: result[0] });
                return responseObj;
            }else{
                Object.assign(responseObj, { status: 'success' }, { result: 'Data Not Found' });
                return responseObj;
            }
        }catch(error){
            return error;
        }
    }

    async storeContent(value){
        try{
            const responseObj = {};
            const objTranactionQry = [];
            let now = new Date();
            const checkContentObj = {
                str_tableName: 'tbl_content_type',
                data: '*',
                condition: [
                    { str_colName: 'Content', value: value.ContentType,comp: 'eq' },
                ]  
            } 
            var result = await database.select(checkContentObj);
                if(result[0].length != 0){
                    Object.assign(responseObj, { status: 'success' }, { result: 'Content Type already exist' });
                    return responseObj;
                } else {
                    const objContent = {
                        str_tableName: 'tbl_content_type',
                        data: [
                            { str_colName: 'Content', value: value.ContentType }
                        ],
                        action: "in"
                    }

                    const objAudit = {
                        str_tableName: 'tbl_audit_content_type',
                        data: [
                            { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                            { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                            { str_colName: 'userid', value: value.userid },
                            { str_colName: 'username', value: value.username },
                            { str_colName: 'Content', value: value.ContentType },
                            { str_colName: 'Remark', value: value.Remark },
                            { str_colName: 'ACT', value: value.Action }
                        ],
                        action: "in"
                    }

                    const objActivity = {
                        str_tableName: 'tbl_activity_log',
                        data: [
                            { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                            { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                            { str_colName: 'userid', value: value.userid },
                            { str_colName: 'username', value: value.username },
                            { str_colName: 'activity', value: value.activity }
                        ],
                        action: "in"
                    }
                    objTranactionQry.push(objContent,objAudit,objActivity);
                    
                    var result = await ObjQueryBuilder.funMakeQueries(objTranactionQry);
                    Object.assign(responseObj, { status: 'success' }, { result: 'Content Type Added Successfully' });
                    return responseObj;

                }
            
        }catch(error){
            return error;
        }
    }
}

module.exports = ContentModel;