const dbCon = require('../Utills/db');
const Database = require('../database/clsQueryProcess');
const database = new Database();
const date = require('date-and-time');
//for tracking error
var fs = require('fs');
var util = require('util');
var log_file = fs.createWriteStream(__dirname + '/debug.log', {flags : 'w'});
var log_stdout = process.stdout;

class MultihalerModel {
 
    async getMultihaler(){
        try {
            var responseObj = {};
            const objMaster = {
                str_tableName:'tbl_product_master',
                data:'*',
                condition:[
                    { str_colName: 'ProductType', value: 3 }
                ] 
            }
            var resMaster = await database.select(objMaster);
            Object.assign(responseObj, { status: 'success' }, { result: resMaster[0] });
            return(responseObj);
        } catch (error) {

            return error;
        }
    }

    async storeMultihaler(value){
        try {
            var responseObj = {};
            const checkMultihaler = await this.checkMultihaler(value);
            if(checkMultihaler == false){
                Object.assign(responseObj, { status: 'success' }, { result: 'Multihaler Product Already Exist' });
                return(responseObj);
            }
            else{
                const addMultihaler = await this.addMultihaler(value);
                Object.assign(responseObj, { status: 'success' }, { result: 'Multihaler Product Added Successfully' });
                return(responseObj);
            }

        } catch(error){
            return error;
        }
    }

    async checkMultihaler(value){
        try{
            const objMaster = {
                str_tableName:'tbl_product_master',
                data:'*',
                condition:[
                    { str_colName: 'ProductId', value: value.str_BFGCode,comp: 'eq' },
                    { str_colName: 'ProductName', value: value.str_Prd, comp: 'eq' },
                    { str_colName: 'ProductVersion', value: value.str_PV, comp: 'eq' },
                    { str_colName: 'Version', value: value.str_V, comp: 'eq' }
                ] 
            }
            var result = await database.select(objMaster);
            if(result[0].length > 0)
            {
                return false;
            }
            else{
                return true;
            }

        } catch(error){
            return error;
        }
    }

    async getMultihalerProductDetails(value){
        try {
            var responseObj = {};
            const objMultihalerProduct = {
                str_tableName:'tbl_product_multihaler',
                data:'*',
                condition:[
                    { str_colName: 'ProductId', value: value.ProductId,comp: 'eq' },
                    { str_colName: 'ProductName', value: value.ProductName,comp: 'eq' },
                    { str_colName: 'ProductVersion', value: value.ProductVersion,comp: 'eq' },
                    { str_colName: 'Version', value: value.Version,comp: 'eq' }
                ] 
            }
            var resMultihalerProduct = await database.select(objMultihalerProduct);
            Object.assign(responseObj, { status: 'success' }, { result: resMultihalerProduct[0] });
            return(responseObj);
        } catch (error) {

            return error;
        }
    }

    async addMultihaler(value)
    {
        try{
            var now = new Date();
            const addMultihalerMasterObj = {
                str_tableName: 'tbl_product_master',
                    data: [
                        { str_colName: 'ProductId', value: value.str_BFGCode },
                        { str_colName: 'ProductName', value: value.str_Prd },
                        { str_colName: 'ProductType', value: 3 },
                        { str_colName: 'ProductVersion', value: value.str_PV },
                        { str_colName: 'Version', value: value.str_V },
                        { str_colName: 'IsActive', value: 0 },
                        { str_colName: 'isBinWeighing', value: 0 },
                        { str_colName: 'BatchSize', value: 0 },
                        { str_colName: 'BatchUnit', value: 0 },
                        { str_colName: 'IsBilayer', value: 0 },
                        { str_colName: 'IsBilayerLbl', value: 0 },
                        { str_colName: 'IsTrilayer', value: 0 },
                        { str_colName: 'IsTrilayerLbl', value: 0 },
                        { str_colName: 'IsCoated', value: 0 },
                        { str_colName: 'IsGranulation', value: 0 },
                        { str_colName: 'IsCompress', value: 0 },
                        { str_colName: 'NominalNomenclature', value: 0 },
                        { str_colName: 'locked', value: 0 },
                        { str_colName: 'userID', value: value.str_userId },
                        { str_colName: 'ISBfGChecked', value: value.int_chkBFG },
                        { str_colName: 'ISPrdVersionChecked', value: value.int_chkPrdVersion },
                        { str_colName: 'ISVersionChecked', value: value.int_chkVersion }
                    ]
            }
            var result1 = await database.save(addMultihalerMasterObj);
            var str1 = value.flt_NetStd;
            var str2 = value.flt_GrpStd;
            var dp1,dp2;
            if((str1 != null) && (str1 != undefined) && (str1 != '')){
                var a = str1.split('.');
                if(a.length == 1){
                    dp1 = 0;
                }else{
                    dp1 = a[1].length;
                }
            }
            else{
                dp1 = 0;
            }
            
            if((str2 != null) && (str2 != undefined) && (str2 != '')){
                var b = str2.split('.');
                if(b.length == 1){
                    dp2 = 0;
                }else{
                    dp2 = b[1].length;
                }
            }else{
                dp2 = 0;
            }
            
            const addMultihalerObj = {
                str_tableName: 'tbl_product_multihaler',
                    data: [
                        { str_colName: 'ProductId', value: value.str_BFGCode },
                        { str_colName: 'ProductName', value: value.str_Prd },
                        { str_colName: 'ProductVersion', value: value.str_PV },
                        { str_colName: 'Version', value: value.str_V },
                        { str_colName: 'MutihalerType', value: parseInt(value.multiHalerType) },
                        { str_colName: 'Param1_Nom', value: value.flt_NetStd  == '' || null ? 99999 : value.flt_NetStd },
                        { str_colName: 'Param1_T1Neg', value: value.flt_NetT1Neg == '' || null ? 99999 : value.flt_NetT1Neg },
                        { str_colName: 'Param1_T1Pos', value: value.flt_NetT1Pos  ==  '' || null ? 99999 : value.flt_NetT1Pos },
                        { str_colName: 'Param1_T2Neg', value: value.flt_NetT2Neg  ==  '' || null ? 99999 : value.flt_NetT2Neg },
                        { str_colName: 'Param1_T2Pos', value: value.flt_NetT2Pos  ==  '' || null ? 99999 : value.flt_NetT2Pos },
                        { str_colName: 'Param1_DP', value: dp1 },
                        { str_colName: 'Param1_LimitOn', value: value.str_NetLimitOn == 'Actual' ? 0 : 1 },
                        { str_colName: 'Param1_NMTTab', value: value.int_NetNMTCnt  ==  '' || null ? 99999 : value.int_NetNMTCnt},
                        { str_colName: 'Param2_Nom', value: value.flt_GrpStd  ==  '' || null ? 99999 : value.flt_GrpStd},
                        { str_colName: 'Param2_T1Neg', value: value.flt_GrpT1Neg  ==  '' || null ? 99999 : value.flt_GrpT1Neg},
                        { str_colName: 'Param2_T1Pos', value: value.flt_GrpT1Pos  ==  '' || null ? 99999 : value.flt_GrpT1Pos},
                        { str_colName: 'Param2_T2Neg', value: value.flt_GrpT2Neg  ==  '' || null ? 99999 : value.flt_GrpT2Neg},
                        { str_colName: 'Param2_T2Pos', value: value.flt_GrpT2Pos  ==  '' || null ? 99999 : value.flt_GrpT2Pos},
                        { str_colName: 'Param2_DP', value: dp2 },
                        { str_colName: 'Param2_LimitOn', value: value.str_GrpLimitOn == 'Actual' ? 0 : 1 },
                        { str_colName: 'Param2_NMTTab', value: value.int_GrpNMTCnt  ==  '' || null ? 99999 : value.int_GrpNMTCnt},
                        { str_colName: 'Param1_IsOnStd', value: value.str_UCGraphOn == 'Standard' ? 0 : 1 },
                        { str_colName: 'Param2_IsOnStd', value: value.str_SCGraphOn == 'Standard' ? 0 : 1 },
                        { str_colName: 'locked', value: 0 }
                        
                    ]
            }
            var result2 = await database.save(addMultihalerObj);
            const auditObj = {
                str_tableName: 'tbl_audit_product_multihaler',
                    data: [
                        { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                        { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                        { str_colName: 'userid', value: value.str_userId },
                        { str_colName: 'username', value: value.str_userName },
                        { str_colName: 'ACT', value: value.action },
                        { str_colName: 'Remark', value: value.remark },
                        { str_colName: 'ProductId', value: value.str_BFGCode },
                        { str_colName: 'ProductName', value: value.str_Prd },
                        { str_colName: 'PrdVersion', value: value.str_PV },
                        { str_colName: 'Version', value: value.str_V },
                        { str_colName: 'ProductType', value: 3 },
                        { str_colName: 'OldValue', value: 'NA' },
                        { str_colName: 'NewValue', value: value.auditObject.result.Multihaler.newData == undefined ? "NA" : value.auditObject.result.Multihaler.newData },
                        { str_colName: 'MultihalerType', value: parseInt(value.multiHalerType) }
                    ]
            }
            var result3 = await database.save(auditObj);
            const multihalerLog = {
                str_tableName: 'tbl_activity_log',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: value.str_userId },
                    { str_colName: 'username', value: value.str_userName },
                    { str_colName: 'activity', value: 'Product Added' }
                ]
            }
            var result4 = await database.save(multihalerLog);
            return true;
        } catch(error){
            return error;
        }
    }

    async activateMultihaler(value){
        try{
            let now = new Date();
            var responseObj = {};
            var action;
            var message;
            if(value.action == "Approve Product"){
                action = 1;
                message = 'Product Activate Successfully';
            }
            else{
                action = 0;
                message = 'Product Deactivate Successfully';
            }
            const objMaster = {
                str_tableName:'tbl_product_master',
                data:[
                    { str_colName: 'IsActive', value: action },
                    { str_colName: 'ActivateChance', value: 1 }  
                ],
                condition:[
                    { str_colName: 'ProductId', value: value.productID,comp: 'eq' },
                    { str_colName: 'ProductName', value: value.productName,comp: 'eq' },
                    { str_colName: 'ProductVersion', value: value.productVersion,comp: 'eq' },
                    { str_colName: 'Version', value: value.Version,comp: 'eq' },
                    { str_colName: 'ProductType', value: parseInt(value.productType),comp: 'eq' }                ] 
            }
            var result = await database.update(objMaster);
            const objaudit = {
                str_tableName: 'tbl_audit_product_multihaler',
                    data: [
                        { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                        { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                        { str_colName: 'userid', value: value.userId },
                        { str_colName: 'username', value: value.userName },
                        { str_colName: 'ACT', value: value.action },
                        { str_colName: 'Remark', value: value.remark },
                        { str_colName: 'ProductId', value: value.productID },
                        { str_colName: 'ProductName', value: value.productName },
                        { str_colName: 'PrdVersion', value: value.productVersion },
                        { str_colName: 'Version', value: value.Version },
                        { str_colName: 'ProductType', value: 3 },
                        { str_colName: 'OldValue', value: 'NA'  },
                        { str_colName: 'NewValue', value: 'NA' },
                        { str_colName: 'MultihalerType', value: value.multihalerType }
                    ]
            }
            var result1 = await database.save(objaudit);
            Object.assign(responseObj, { status: 'success' }, { result: message });
            return(responseObj);
        } catch(error){
            return error;
        }
    }

    async updateMultihaler(value){
        try{
            var responseObj = {};
            var now = new Date();
            if(value.auditObject.result.ProductDetail.result != "No Change")//detail change
            {
                const updateProductObj = {
                    str_tableName: 'tbl_product_master',
                    data: [
                        { str_colName: 'ProductName', value:value.str_Prd },
                        { str_colName: 'ProductId', value: value.str_BFGCode },
                        { str_colName: 'ProductVersion', value: value.str_PV },
                        { str_colName: 'Version', value: value.str_V },
                        { str_colName: 'locked', value: 0 },
                        { str_colName: 'IsActive', value: 0 }
                    ],
                    condition: [
                        { str_colName: 'ProductName', value: value.strOldPrd },
                        { str_colName: 'ProductId', value: value.strOldBFG },
                        { str_colName: 'ProductVersion', value: value.strOldPV },
                        { str_colName: 'Version', value: value.strOldV },
                    ]
                }

                var resultUpdate = await database.update(updateProductObj);

                const addMultihalerObj = {
                    str_tableName: 'tbl_product_multihaler',
                        data: [
                            { str_colName: 'MutihalerType', value: value.multiHalerType },
                            { str_colName: 'Param1_Nom', value: value.flt_NetStd  == '' || null ? 99999 : value.flt_NetStd },
                            { str_colName: 'Param1_T1Neg', value: value.flt_NetT1Neg == '' || null ? 99999 : value.flt_NetT1Neg },
                            { str_colName: 'Param1_T1Pos', value: value.flt_NetT1Pos  ==  '' || null ? 99999 : value.flt_NetT1Pos },
                            { str_colName: 'Param1_T2Neg', value: value.flt_NetT2Neg  ==  '' || null ? 99999 : value.flt_NetT2Neg },
                            { str_colName: 'Param1_T2Pos', value: value.flt_NetT2Pos  ==  '' || null ? 99999 : value.flt_NetT2Pos },
                            { str_colName: 'Param1_DP', value: value.int_netDp },
                            { str_colName: 'Param1_LimitOn', value: value.str_NetLimitOn == 'Actual' ? 0 : 1 },
                            { str_colName: 'Param1_IsOnStd', value: value.str_UCGraphOn == 'Standard' ? 0 : 1 },
                            { str_colName: 'Param1_NMTTab', value: value.int_NetNMTCnt  ==  '' || null ? 99999 : value.int_NetNMTCnt},
                            { str_colName: 'Param2_Nom', value: value.flt_GrpStd  ==  '' || null ? 99999 : value.flt_GrpStd},
                            { str_colName: 'Param2_T1Neg', value: value.flt_GrpT1Neg  ==  '' || null ? 99999 : value.flt_GrpT1Neg},
                            { str_colName: 'Param2_T1Pos', value: value.flt_GrpT1Pos  ==  '' || null ? 99999 : value.flt_GrpT1Pos},
                            { str_colName: 'Param2_T2Neg', value: value.flt_GrpT2Neg  ==  '' || null ? 99999 : value.flt_GrpT2Neg},
                            { str_colName: 'Param2_T2Pos', value: value.flt_GrpT2Pos  ==  '' || null ? 99999 : value.flt_GrpT2Pos},
                            { str_colName: 'Param2_DP', value: value.int_grpDp },
                            { str_colName: 'Param2_LimitOn', value: value.str_GrpLimitOn == 'Actual' ? 0 : 1 },
                            { str_colName: 'Param2_IsOnStd', value: value.str_SCGraphOn == 'Standard' ? 0 : 1 },
                            { str_colName: 'Param2_NMTTab', value: value.int_GrpNMTCnt  ==  '' || null ? 99999 : value.int_GrpNMTCnt},
                            { str_colName: 'locked', value: 0 },
                            { str_colName: 'ProductId', value: value.str_BFGCode },
                            { str_colName: 'ProductName', value: value.str_Prd },
                            { str_colName: 'ProductVersion', value: value.str_PV },
                            { str_colName: 'Version', value: value.str_V }
                            
                        ],
                        condition: [
                            { str_colName: 'ProductId', value: value.strOldBFG, comp: 'eq' },
                            { str_colName: 'ProductName', value: value.strOldPrd, comp: 'eq' },
                            { str_colName: 'ProductVersion', value: value.strOldPV, comp: 'eq' },
                            { str_colName: 'Version', value: value.strOldV, comp: 'eq' }
                        ]
                }
                var result2 = await database.update(addMultihalerObj);
            }
            else//no product detail change
            {

                const updateProductObj = {
                    str_tableName: 'tbl_product_master',
                    data: [
                        { str_colName: 'IsActive', value: 0 }
                    ],
                    condition: [
                        { str_colName: 'ProductName', value: value.strOldPrd },
                        { str_colName: 'ProductId', value: value.strOldBFG },
                        { str_colName: 'ProductVersion', value: value.strOldPV },
                        { str_colName: 'Version', value: value.strOldV },
                    ]
                }

                var resultUpdate = await database.update(updateProductObj);

                const addMultihalerObj = {
                    str_tableName: 'tbl_product_multihaler',
                        data: [
                            { str_colName: 'MutihalerType', value: value.multiHalerType },
                            { str_colName: 'Param1_Nom', value: value.flt_NetStd  == '' || null ? 99999 : value.flt_NetStd },
                            { str_colName: 'Param1_T1Neg', value: value.flt_NetT1Neg == '' || null ? 99999 : value.flt_NetT1Neg },
                            { str_colName: 'Param1_T1Pos', value: value.flt_NetT1Pos  ==  '' || null ? 99999 : value.flt_NetT1Pos },
                            { str_colName: 'Param1_T2Neg', value: value.flt_NetT2Neg  ==  '' || null ? 99999 : value.flt_NetT2Neg },
                            { str_colName: 'Param1_T2Pos', value: value.flt_NetT2Pos  ==  '' || null ? 99999 : value.flt_NetT2Pos },
                            { str_colName: 'Param1_DP', value: value.int_netDp },
                            { str_colName: 'Param1_LimitOn', value: value.str_NetLimitOn == 'Actual' ? 0 : 1 },
                            { str_colName: 'Param1_IsOnStd', value: value.str_UCGraphOn == 'Standard' ? 0 : 1 },
                            { str_colName: 'Param1_NMTTab', value: value.int_NetNMTCnt  ==  '' || null ? 99999 : value.int_NetNMTCnt},
                            { str_colName: 'Param2_Nom', value: value.flt_GrpStd  ==  '' || null ? 99999 : value.flt_GrpStd},
                            { str_colName: 'Param2_T1Neg', value: value.flt_GrpT1Neg  ==  '' || null ? 99999 : value.flt_GrpT1Neg},
                            { str_colName: 'Param2_T1Pos', value: value.flt_GrpT1Pos  ==  '' || null ? 99999 : value.flt_GrpT1Pos},
                            { str_colName: 'Param2_T2Neg', value: value.flt_GrpT2Neg  ==  '' || null ? 99999 : value.flt_GrpT2Neg},
                            { str_colName: 'Param2_T2Pos', value: value.flt_GrpT2Pos  ==  '' || null ? 99999 : value.flt_GrpT2Pos},
                            { str_colName: 'Param2_DP', value: value.int_grpDp },
                            { str_colName: 'Param2_LimitOn', value: value.str_GrpLimitOn == 'Actual' ? 0 : 1 },
                            { str_colName: 'Param2_IsOnStd', value: value.str_SCGraphOn == 'Standard' ? 0 : 1 },
                            { str_colName: 'Param2_NMTTab', value: value.int_GrpNMTCnt  ==  '' || null ? 99999 : value.int_GrpNMTCnt},
                            { str_colName: 'locked', value: 0 }
                            
                        ],
                        condition: [
                            { str_colName: 'ProductId', value: value.str_BFGCode },
                            { str_colName: 'ProductName', value: value.str_Prd },
                            { str_colName: 'ProductVersion', value: value.str_PV },
                            { str_colName: 'Version', value: value.str_V }
                        ]
                }
                var result2 = await database.update(addMultihalerObj);
            }

            var oldPrdVal = "",newPrdVal = "";
            (value.auditObject.result.ProductDetail.newData == undefined) ? newPrdVal = "NA" : newPrdVal = value.auditObject.result.ProductDetail.newData;
            (value.auditObject.result.ProductDetail.oldData == undefined) ? oldPrdVal = "NA" : oldPrdVal = value.auditObject.result.ProductDetail.oldData;

            const auditObj = {
                str_tableName: 'tbl_audit_product_multihaler',
                    data: [
                        { str_colName: 'DT', value: date.format(now, 'YYYY-MM-DD') },
                        { str_colName: 'TM', value: date.format(now, 'HH:mm:ss') },
                        { str_colName: 'userid', value: value.loggedUserId },
                        { str_colName: 'username', value: value.loggedUserName },
                        { str_colName: 'ACT', value: value.action },
                        { str_colName: 'Remark', value: value.remark },
                        { str_colName: 'ProductId', value: value.str_BFGCode },
                        { str_colName: 'ProductName', value: value.str_Prd },
                        { str_colName: 'PrdVersion', value: value.str_PV },
                        { str_colName: 'Version', value: value.str_V },
                        { str_colName: 'ProductType', value: 3 },
                        { str_colName: 'OldValue', value: value.auditObject.result.Multihaler.oldData == undefined ? "NA" : value.auditObject.result.Multihaler.oldData  },
                        { str_colName: 'NewValue', value: value.auditObject.result.Multihaler.newData == undefined ? "NA" : value.auditObject.result.Multihaler.newData },
                        { str_colName: 'MultihalerType', value: value.multiHalerType },
                        { str_colName: 'NewValuePrd', value: newPrdVal },
                        { str_colName: 'OldValuePrd', value: oldPrdVal }
                    ]
            }
            var result3 = await database.save(auditObj);
            const multihalerLog = {
                str_tableName: 'tbl_activity_log',
                data: [
                    { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                    { str_colName: 'userid', value: value.loggedUserId },
                    { str_colName: 'username', value: value.loggedUserName },
                    { str_colName: 'activity', value: 'Product Updated' }
                ]
            }
            var result4 = await database.save(multihalerLog);
            Object.assign(responseObj, { status: 'success' }, { result: 'Multihaler Product Updated Successfully' });
            return(responseObj);
        } catch(error){
            return error;
        }
    }

    async checkProductExistMultihaler(value)
    {
        try {
            const obj_getProduct ={
                str_tableName: 'tbl_product_master',
                data: 'count(*) as cnt',
                condition: [
                    { str_colName: 'ProductId', value: value.str_BFG },
                    { str_colName: 'ProductName', value: value.str_name },
                    { str_colName: 'ProductVersion', value: value.str_pversion },
                    { str_colName: 'Version', value: value.str_version }
                ]
            }

            let res = await database.select(obj_getProduct);
            if(res.length > 0)
            {
                return res[0][0];
            }
        } catch (error) {
            console.log(error);
        }   
    }

}

module.exports = MultihalerModel;