const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const clsCalibration = require('./clsCalibration.class');
const date = require('date-and-time');
const str_tableName = {
    Balance: 'tbl_recalibration_balance_status',
    BinBalance: 'tbl_recalibration_balance_status_bin',
    Vernier: 'tbl_recalibration_vernier_status'
};

class RecalibrationModel extends clsCalibration {
    async getRecalibration(req) {
        try {
            let result = await models[str_tableName[req.body.strInstType]].findAll();
            return result;
            
        } catch (error) {
            return error;
        } 
    }

     async getCalibrationMasterData(res) {
         try {
            var obj_calibrationStatus = [];

            const int_getWeighingStatus = await this.checkWeighingStatusStatus(res.int_cubicNo);
            const int_getCalibrationStatus = await this.checkCalibrationStatus(res.int_cubicNo);
            const int_getStatusFromRecalibration = await this.checkCalibrationStatusFromRecalibTbl(res);
            
            var resPeriodic = "";
            if(res.strSelectedInstrumentType != "Vernier")
            {
                resPeriodic = await this.checkPeriodicCalibrationStatus(res.id, date.format(res.dates, 'YYYY-MM-DD'),int_getWeighingStatus, int_getStatusFromRecalibration['PeriodicBalRecalib'],int_getCalibrationStatus);
                var resDaily;
    
                if(res.int_dailyPeriodic == 1) // Daily with periodic
                {
                     resDaily = await this.checkDailyCalibrationStatus(res.id, date.format(res.dates, 'YYYY-MM-DD'), int_getWeighingStatus, int_getStatusFromRecalibration['DailyBalRecalib'],int_getCalibrationStatus);
                }
                else
                {
                    /**if periodic then no daily */
                    resDaily = await this.checkDailyCalibrationStatusWithoutDaily(res.id, date.format(res.dates, 'YYYY-MM-DD'), int_getWeighingStatus, int_getStatusFromRecalibration['DailyBalRecalib'],resPeriodic.Message,res.strProjectName,int_getCalibrationStatus);
                }
            }
            else
            {
                 resPeriodic = await this.checkPeriodicCalibrationStatusVernier(res.id, date.format(res.dates, 'YYYY-MM-DD'),int_getWeighingStatus, int_getStatusFromRecalibration['PeriodicBalRecalib'],int_getCalibrationStatus);
            }
            
            
            obj_calibrationStatus.push(resPeriodic,resDaily);
            return obj_calibrationStatus; 
         } catch (error) {
             console.log("get Recalibration",error);
            return error; 
         }
    }

    async recalibrationUpdateStatus(Value){
        try {
            let obj_response = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();

                if(Value.strSelectedInstrumentType == "Vernier")
                {
                    await models[str_tableName.Vernier].update({
                        PeriodicVerRecalib: 1,
                        RecalibSetDt_periodic: date.format(now, 'YYYY-MM-DD')
                    },{where:
                        {Ver_ID: Value.equipmentId }
                    },{
                        transaction: t
                    });
                }
                else 
                {
                    let str_tabName = (Value.strSelectedInstrumentType == "Balance") ? str_tableName.Balance : str_tableName.BinBalance;
                    if (Value.calibType == "1") 
                    {
                        await models[str_tabName].update({
                            DailyBalRecalib: 1,
                            RecalibSetDt_daily: date.format(now, 'YYYY-MM-DD')
                        },{where:
                            {Bal_ID: Value.equipmentId }
                        },{
                            transaction: t
                        });
                    }
                    else if(Value.calibType == "2")
                    {
                        await models[str_tabName].update({
                            PeriodicBalRecalib: 1,
                            RecalibSetDt_periodic: date.format(now, 'YYYY-MM-DD')
                        },{where:
                            {Bal_ID: Value.equipmentId }
                        },{
                            transaction: t
                        });
                    }
                    else
                    {
                        await models[str_tabName].update({
                            YearBalRecalib: 1,
                            RecalibSetDt_Year: date.format(now, 'YYYY-MM-DD')
                        },{where:
                            {Bal_ID: Value.equipmentId }
                        },{
                            transaction: t
                        });
                    }
                   
                }

                await models.tbl_audit_recalibration.create({
                    DT: date.format(now, 'YYYY-MM-DD'),
                    TM: date.format(now, 'HH:mm:ss'),
                    userid: Value.userID,
                    username: Value.userName,
                    Remark: Value.remark,
                    ACT: Value.act,
                    idsIP: 0,
                    CalibType: (Value.calibType == 1) ? 'Daily' : (Value.calibType == 2) ? 'Periodic': "Yearly",
                    EquipmentID: Value.equipmentId,
                    EqpType: Value.strSelectedInstrumentType,
                });
            });

            Object.assign(obj_response, { status: 'success' }, { result: 'Recalibration Status Update' })
            return obj_response;

        } catch (error) {
            console.log("Add Recalibration",error);
            return error;
        }
    }
}
module.exports = RecalibrationModel;