const Database = require('../database/clsQueryProcess');
const database = new Database();
const date = require('date-and-time')
const seqTransaction = require("../dbConnection");
const sequelize = require('./../dbConnection').sequelize;
const { Op } = require("sequelize");

const models = require("../dbConnection").models;

class CalibrationModel 
{
    /**
     *This function is used to get all Calibration Standard weight box Details
     * @memberof CalibrationModel
     */
    async getCalibration()
    {
        try 
        {
            let obj_response = {};

            let result  = await models.tbl_calibrationbox.findAll
            ({
                order: [
                    ['CB_WTNo', 'ASC'],
                ],
            });

            Object.assign(obj_response, { status: 'success' }, { result: result });
            return obj_response;
        } 
        catch(error) 
        {
            console.log("getCalibration",error);
            return error;
        } 
    }

 async getCalibrationData()
    {
        try{
            let now = new Date();
            let result  = await models.tbl_calibrationbox.findAll
            ({
                where:{
                    CB_validDt:{[Op.gte]:date.format(now, 'YYYY-MM-DD')}
                },
                order: [
                    ['CB_WTNo', 'ASC'],
                ],
            });
            return result;
        }catch(error){
            return error;
        }
    }

    /**
     *This function is used to store the Calibration data
     * @param {*} req = Currnet Request to fetch the params from it 
     * @returns Object { status: 'success / Error' }, { result: 'Msg' } 
     * @memberof CalibrationModel
    */
    async storeCalibration(req)
    {
        try
        {
            let responseObj = {};
            let now = new Date();

            /** Get stage to check that weight box id is exist or not in table */
            let result = await models.tbl_calibrationbox.findAll
            ({
                where:
                { CB_ID: req.body.CB_ID }
            });

            if(result.length != 0)
            {
                Object.assign(responseObj, { status: 'success' }, { result: 'Calibration ID Already Exist' })
                return responseObj;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>
                {
                    var weight = req.body.CB_Wt; 
                    var weightParameter='';
                    var i = 0;
    
                    for(var wtVal of weight)
                    {
                        var wtno = i+1;
                        var wtValue = wtVal.weight;
                        var unitValue = wtVal.unit;
                        var dpValue = wtVal.Dp;
                        var identificationValue = (req.body.int_IdentificationNo == 1) ? wtVal.identification : (wtVal.identification + i);
                            
                        if(weightParameter == '') 
                        {
                            let CBType = (unitValue == "mm")? "Block:" : "Weight:";
                            if(req.body.int_IdentificationNo == 1)
                            {
                                weightParameter = CBType + wtValue + ",Unit:" + unitValue + ",Identification No.:" + identificationValue;
                            }
                            else
                            {
                                weightParameter = CBType + wtValue + ",Unit:" + unitValue;
                            } 
                        }
                        else 
                        {
                            let CBType = (unitValue == "mm")? "| Block:" : "| Weight:";
                            if(req.body.int_IdentificationNo == 1)
                            {
                                weightParameter += CBType + wtValue + ",Unit:" + unitValue + ",Identification No.:" + identificationValue;
                            }
                            else
                            {
                                weightParameter += CBType + wtValue + ",Unit:" + unitValue;
                            }
                        }
    
                        const insertCalibrationObj = await models.tbl_calibrationbox.create
                        ({
                            CB_Type : req.body.CB_Type,
                            CB_ID : req.body.CB_ID,
                            CB_CertNo : req.body.CB_CertNo,
                            CB_validDt : req.body.CB_validDt,
                            CB_WTNo : wtno,
                            CB_Wt : wtValue,
                            CB_unit : unitValue,
                            CB_identificationNo : identificationValue,
                            CB_DP : dpValue,
                            locked : 0,
                            CB_MassWeight:req.body.CB_MassWeight,
                            editCounter : 0,
                            CB_Is_UnderEdit : 0,
                            CB_CalibDt : req.body.CB_CalibDt
                        },{
                            transaction: t
                        });
    
                        i++;
                    }
    
                    const insertCalAuditObj = await models.tbl_audit_calibrationbox.create
                    ({
                        ACB_dt : date.format(now, 'YYYY-MM-DD'),
                        ACB_tm : date.format(now, 'HH:mm:ss'),
                        ACB_userid : req.body.userid,
                        ACB_username : req.body.username,
                        ACB_ACT : req.body.Action,
                        ACB_Remark : req.body.Remark,
                        ACB_Type : req.body.CB_Type,
                        ACB_ID : req.body.CB_ID,
                        ACB_oldValue : 'NA',
                        ACB_newValue : req.body.NewData,
                        ACB_OldWeight : 'NA',
                        ACB_NewWeight : weightParameter 
                    },{
                        transaction: t
                    });
    
                    await models.tbl_activity_log.create
                    ({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.body.userid,
                        username: req.body.username,
                        activity: req.body.activity
                    },
                    {
                        transaction: t
                    });
                });

                Object.assign(responseObj, { status: 'success' }, { result: 'Calibration Added Successfully' })
                return responseObj;
            }
            
        }catch(error){
            console.log("Add Calibration",error);
            return error;
        }
    }

    updateCalibrationLock(req){
        return new Promise((resolve, reject) =>{
            let responseObj = {};
            var lockType = req.body.Eqp_Locked;
            var lockValue = parseInt(lockType);
            if(lockValue == 1){
                const calibrationObj = {
                    str_tableName: 'tbl_calibrationbox',
                    data: '*',
                    condition: [
                        { str_colName: 'CB_ID', value: req.body.selectedValue, comp: 'eq' },
                    ]  
                }
                database.select(calibrationObj).then((result) => {
                    var actualLock = result[0][0].CB_locked;
                    var actualLockValue = actualLock;
                    if(actualLockValue == 1){
                        Object.assign(responseObj, { status: 'success' }, { result: 'Already In Use By Other User' })
                        resolve(responseObj)
                    } else {
                        const updatecalibrationObj = {
                            str_tableName: 'tbl_calibrationbox',
                            data: [
                                { str_colName: 'locked', value: 1 }
                               ],
                            condition: [
                                { str_colName: 'CB_ID', value: req.body.selectedValue},
                            ]  
                        }
                        database.update(updatecalibrationObj).catch(err => console.log(err));
                        Object.assign(responseObj, { status: 'success' }, { result: 'Calibrationbox Lock Updated Successfully' })
                        resolve(responseObj)
                    }
                })
            } else {
                const updatecalibrationObj = {
                    str_tableName: 'tbl_calibrationbox',
                    data: [
                        { str_colName: 'locked', value: 0 }
                       ],
                    condition: [
                        { str_colName: 'CB_ID', value: req.body.selectedValue},
                    ]  
                }
                database.update(updatecalibrationObj).catch(err => console.log(err));
                Object.assign(responseObj, { status: 'success' }, { result: 'Calibrationbox Lock Reset Successfully' })
                resolve(responseObj)
            }
        })
    }
    

    async updateCalibration(req)
    {
        let transaction;  
        var responseObj = {};

        try 
        {
            await seqTransaction.sequelize.transaction(async (t) =>
            {

            let now = new Date();

            var result = await models.tbl_calibrationbox.destroy({
                where: {
                    CB_ID: req.body.CB_ID
                }, transaction: t
            });

            var weight = req.body.CB_Wt;
            var count = weight.length;  
            var weightParameter='';
            var wtno = 0;

            for(var i = 0; i < count; i++)
            {
                var wtno = i+1;
                var wtValue = weight[i].weight;
                var unitValue = weight[i].unit;
                var dpValue = weight[i].Dp;
                var dpValue = weight[i].Dp;
                var identificationValue = (req.body.int_IdentificationNo == 1) ? weight[i].identification : ("NA"+i);

                if(weightParameter == '') 
                {
                    let CBType = (unitValue == "mm")? "Block:" : "Weight:";

                    if(req.body.int_IdentificationNo == 1)
                    {
                        weightParameter = CBType + wtValue + ",Unit:" + unitValue + ",Identification No :" + identificationValue;
                    }
                    else
                    {
                        weightParameter = CBType + wtValue + ",Unit:" + unitValue;
                    }
                }
                else 
                {
                    let CBType = (unitValue == "mm")? "| Block:" : "| Weight:";

                    if(req.body.int_IdentificationNo == 1)
                    {
                        weightParameter += CBType + wtValue + ",Unit:" + unitValue + ",Identification No :" + identificationValue;
                    }
                    else
                    {
                        weightParameter += CBType + wtValue + ",Unit:" + unitValue;
                    }
                }

                const insertCalibrationObj = await models.tbl_calibrationbox.create({
                    CB_Type : req.body.CB_Type,
                    CB_ID : req.body.CB_ID,
                    CB_CertNo : req.body.CB_CertNo,
                    CB_validDt : req.body.CB_validDt,
                    CB_WTNo : wtno,
                    CB_Wt : wtValue,
                    CB_unit : unitValue,
                    CB_identificationNo : identificationValue,
                    CB_DP : dpValue,
                    CB_MassWeight:req.body.CB_MassWeight,
                    locked : 0,
                    editCounter : 0,
                    CB_Is_UnderEdit : 0,
                    CB_CalibDt : req.body.CB_CalibDt
                }, {transaction: t});
            }
              
            var oldWeight = req.body.ACB_OldWeight;
            var newWeight = req.body.ACB_NewWeight;
            var oldWeightParameter,newWeightParameter;

            if(oldWeight == "NA")
            {
                oldWeightParameter = 'NA';
            } 
            else 
            {
                var oldcount = oldWeight.length;  
                oldWeightParameter='';

                for(var j = 0; j < oldcount; j++)
                {
                    var wtValue = oldWeight[j].weight;
                    var unitValue = oldWeight[j].unit;
                    var dpValue = oldWeight[j].Dp;

                    if (oldWeightParameter == '') 
                    {
                        let CBType = (unitValue == "mm")? "Block:" : "Weight:";

                        if(req.body.int_IdentificationNo == 1)
                        {
                            var identificationValue = oldWeight[j].identification;
                            oldWeightParameter += CBType + wtValue + ",Unit :" + unitValue + ",Identification No :" + identificationValue; 
                        }
                        else
                        {
                            oldWeightParameter += CBType + wtValue + ",Unit :" + unitValue;
                        }
                    }
                    else 
                    {
                        let CBType = (unitValue == "mm")? "| Block:" : "| Weight:";

                        if(req.body.int_IdentificationNo == 1)
                        {
                            var identificationValue = oldWeight[j].identification;
                            oldWeightParameter += CBType + wtValue + ",Unit :" + unitValue + ",Identification No :" + identificationValue;
                        }
                        else
                        {
                            oldWeightParameter += CBType + wtValue + ",Unit :" + unitValue;
                        }
                           
                    }
                }
            }

            if(newWeight == "NA")
            {
                newWeightParameter = 'NA';
            } 
            else 
            {
                var newcount = newWeight.length;  
                newWeightParameter='';

                for(var j = 0; j < newcount; j++)
                {
                    var wtValue = newWeight[j].weight;
                    var unitValue = newWeight[j].unit;
                    var dpValue = newWeight[j].Dp;

                    if (newWeightParameter == '') 
                    {
                        let CBType = (unitValue == "mm")? "Block:" : "Weight:";

                        if(req.body.int_IdentificationNo == 1)
                        {
                            var identificationValue = newWeight[j].identification;
                            newWeightParameter += CBType + wtValue + ",Unit :" + unitValue + ",Identification No :" + identificationValue;
                        }
                        else
                        {
                            newWeightParameter += CBType + wtValue + ",Unit :" + unitValue;
                        }  
                    }
                    else 
                    {
                        let CBType = (unitValue == "mm")? "| Block:" : "| Weight:";

                        if(req.body.int_IdentificationNo == 1)
                        {
                            var identificationValue = newWeight[j].identification;
                            newWeightParameter += CBType + wtValue + ",Unit :" + unitValue + ",Identification No :" + identificationValue;
                        }
                        else
                        {
                            newWeightParameter += CBType + wtValue + ",Unit :" + unitValue;
                        }
                    }   
                }   
            }

            const insertCalAuditObj = await models.tbl_audit_calibrationbox.create
            ({
                ACB_dt : date.format(now, 'YYYY-MM-DD'),
                ACB_tm : date.format(now, 'HH:mm:ss'),
                ACB_userid : req.body.userid,
                ACB_username : req.body.username,
                ACB_ACT : req.body.Action,
                ACB_Remark : req.body.Remark,
                ACB_Type : req.body.CB_Type,
                ACB_ID : req.body.CB_ID,
                ACB_oldValue : req.body.ACB_oldValue,
                ACB_newValue : req.body.ACB_newValue,
                ACB_OldWeight : oldWeightParameter,
                ACB_NewWeight : newWeightParameter 
            }, {transaction: t});
                            
            await models.tbl_activity_log.create
            ({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: req.body.userid,
                username: req.body.username,
                activity: req.body.activity
            }, {transaction: t});

        });
        
        Object.assign(responseObj, { status: 'success' }, { result: 'Calibration Edited Successfully' })
        return responseObj
        } 
        
        catch(error) 
        {
            console.log("error",error);
            return error;
        }

    }

    async getCalibrationForEdit()
    {
        try{
            var sarr_calibrationWtID = [], sarr_balanceID = [],sarr_tempCalibrationWtID = [],sarr_tempSplitingWt = [], sarr_final = [];

            let resultCalib  = await models.tbl_calibrationbox.findAll
            ({
                order: [
                    ['CB_WTNo', 'ASC'],
                ],
            });

            /*
            Code Commented Because it allow user to edit calibration box when user is not performing test. 
            but calibration box assigned to balance in weight assignment.
            */
            let resultBalance =  await models.tbl_cubical.findAll
            ({
                attributes: [[sequelize.fn('DISTINCT', sequelize.col('Sys_BalID')), 'Sys_BalID']],
                where:
                {
                    // Sys_CalibInProcess:['1'],
                    Sys_BalID:{[Op.ne]:'None'}
                }
            });

            if(resultBalance.length == 0)
            {
                return resultCalib;
            }
            else
            {
                resultBalance.forEach
                (element => 
                {
                    sarr_balanceID.push(element.Sys_BalID);
                });

                for(const i of ['daily','periodic','linearity','eccentricity','repeatability','uncertainty']) 
                {
                    for(let j of sarr_balanceID)
                    { 

                        let resultCalibrationWT = await models['tbl_precalibration_'+i].findAll({
                            attributes: ['CalibrationBox_ID'],
                            where: { Equipment_ID: j}
                        });

                        if(resultCalibrationWT.length != 0)
                        {
                            for(var k=0;k<=resultCalibrationWT.length-1;k++)
                            {
                                sarr_tempCalibrationWtID.push(resultCalibrationWT[k]['CalibrationBox_ID']);
                            }
                            
                        }
                    }

                } // for

                if(sarr_tempCalibrationWtID.length > 0)
                {
                    sarr_tempCalibrationWtID.forEach(element => 
                    {
                        if(element.includes(",") == true)
                        {
                            sarr_tempSplitingWt = element.split(","); 
                            sarr_tempSplitingWt.forEach(ele => 
                            {
                                if(sarr_calibrationWtID.includes(ele) == false)
                                {
                                    sarr_calibrationWtID.push(ele);
                                }
                            
                            });
                        }
                        else
                        {
                            if(sarr_calibrationWtID.includes(element) == false)
                            {
                                sarr_calibrationWtID.push(element);
                            }
                        }
                    });
                }

                for(var i=0;i<=resultCalib.length-1;i++)
                {
                    if(sarr_calibrationWtID.indexOf(resultCalib[i].CB_ID)==-1)
                    {
                        sarr_final.push(resultCalib[i]);
                    }
                }
                
                return sarr_final;
            }
        }catch(error){
            console.log(error);
            throw error;
        }
    }
}

module.exports = CalibrationModel;