const Database = require('../database/clsQueryProcess');
const clsStoredProcedure = require('./clsStoredProcedure');
const clsFormula = require('./clsFormulaModel');
const objFormula = new clsFormula();
const database = new Database();
const objStoredProcedure = new clsStoredProcedure();
const requestIp = require('request-ip');
const dbCon = require('../Utills/db');
const stats = require('stats-lite');
// var mysql = require('mysql2');
const serverConfig = require('../global/serverConfig');
const jsonfile = require('jsonfile');
const clsMathJS = require('./clsMathJS');
const math =  new clsMathJS();
const moment = require('moment-timezone');

class TabletModel {
    async getProductDetails(reqObj) {
        const selectDetailRpt = {
            str_tableName: 'tbl_rpt_path',
            data: '*',
        }
        var result1 = await database.select(selectDetailRpt);
        var proj_name = result1[0][0]['proj_name'];


        var reportOption = reqObj.body.reportOption;
        var fromDate = reqObj.body.fromDate;
        var toDate = reqObj.body.toDate;
        var testType = reqObj.body.testType;
        var reportType = reqObj.body.reportType;
        var recordFrom = reqObj.body.recordFrom;
        var responseObj = {};
        var masterTableName, detailTableName;
        if (testType == 'Regular') { //1:- Initial and 0:- Regular
            testType = 0;
        } else {
            testType = 1;
        }
       
        var reciveObj = await this.commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom, proj_name);


        masterTableName = reciveObj.masterTableName;
        detailTableName = reciveObj.detailTableName
        const selectMaster = {
            str_tableName: masterTableName,
            data: '*',
            condition: [
                { str_colName: 'ReportType', value: testType, comp: 'eq' },
                { str_colName: 'ProductType', value: '1' },
                {str_colName: 'PrDate', value: fromDate, value1: toDate, comp: 'btn'}
            ]
        }
        var result = await database.select(selectMaster);
        var data = result[0];
        if (reportOption == 'Moisture Analyzer') {
            selectMaster.condition.push(
                { str_colName: 'LossOnWt', value: 0, comp: 'ne' }
            )
        }
        if (reportOption == 'Friabilator') {
            var arrFriData = [];
            for (const element of data){
                var side = element.Side;
                var RepSerNo = element.RepSerNo;
                //console.log(element.Side);
                var dec = moment(element.PrDate);
                var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
                var PrDate = normalDate.split(" ")[0];
                const selectFriMaster = {
                    str_tableName: masterTableName,
                    data: '*',
                    condition: [
                        { str_colName: 'ReportType', value: testType, comp: 'eq' },
                        { str_colName: 'ProductType', value: '1' },
                        {str_colName: 'PrDate', value: PrDate, comp: 'eq'},
                        {str_colName: 'RepSerNo', value: RepSerNo, comp: 'eq'},
                    ]
                }
                if(side == "Double"){
                    selectFriMaster.condition.push({str_colName: 'LWtAfterTest', value: 0, comp: 'ne'},
                    {str_colName: 'RWtAfterTest', value: 0, comp: 'ne'}); 
                }else{
                    selectFriMaster.condition.push({str_colName: 'NWtAfterTest', value: 0, comp: 'ne'}); 
                }
                var resultFri = await database.select(selectFriMaster);
                //console.log(selectFriMaster);
                if(resultFri[0].length > 0){
                    var friMasterData = resultFri[0][0];
                    arrFriData.push(friMasterData);
                }
            }
            Object.assign(responseObj, { status: 'success' }, { result: arrFriData });
            return responseObj;
        }else{
            const selectDetail = {
                str_tableName: detailTableName,
                data: '*',
            }
            if (detailTableName != '') {
                let detailResult = await database.select(selectDetail);
                for (let i = 0; i < data.length; i++) {
                    let RepSerNo = data[i].RepSerNo;
                    let arrDetailArray = detailResult[0];
                    let details = arrDetailArray.find(k => k.RepSerNo == RepSerNo);
                    let detailsObj = { 'detail': details };
                    Object.assign(data[i], detailsObj);
                }
                Object.assign(responseObj, { status: 'success' }, { result: data });
                return responseObj;
    
            } else {
                Object.assign(responseObj, { status: 'success' }, { result: data });
                return responseObj;
            }
    
        }
        

    }

    /** calculation of lod %w/w */
    async calculationLOD(reqObj) {
        var strTblName = "", objResult = {},strRemark = "";
        (reqObj.body.recordFrom =="Current") ? strTblName = "tbl_lodmaster" : strTblName = "tbl_lodmaster_archived";
        let res = await dbCon.execute(`Select ROUND(CAST((((DryWt-LossOnWt)/DryWt)*100) AS DECIMAL(20,15)),2) AS lodPer from `+ strTblName +` where RepSerNo=${reqObj.body.RepSerNo}`);
        
        let resAll = await dbCon.execute(`Select * from `+ strTblName +` where RepSerNo=${reqObj.body.RepSerNo}`);
        var int_DP = 3;
        var minLmt = Number(resAll[0][0].MinLimit);
        var cal1 = (Number(resAll[0][0].DryWt)-Number(resAll[0][0].LossOnWt))*100/Number(resAll[0][0].DryWt);
        var cal1Val = math.roundUp(cal1,int_DP);
        var maxLmt = Number(resAll[0][0].MaxLimit);
        var cal2 = (Number(resAll[0][0].DryWt)-Number(resAll[0][0].LossOnWt))*100/Number(resAll[0][0].DryWt);
        var cal2Val = math.roundUp(cal2,int_DP);
        
        /*((Number(resAll[0][0].MinLimit) < Number((resAll[0][0].DryWt-resAll[0][0].LossOnWt)*100/resAll[0][0].DryWt).toFixed(3))  
        && (Number((resAll[0][0].DryWt-resAll[0][0].LossOnWt)*100/resAll[0][0].DryWt).toFixed(3) <= resAll[0][0].MaxLimit)) ? strRemark = "Complies" : strRemark="Not Complies";*/

        (minLmt < cal1Val) && (cal2Val <= maxLmt) ? strRemark = "Complies" : strRemark="Not Complies";
        Object.assign(objResult,{result:res[0][0]},{remark:strRemark},
            {minStdLimit:math.roundUpPad(resAll[0][0].MinLimit,2) },{maxStdLimit:math.roundUpPad(resAll[0][0].MaxLimit,2)},
            {setTemp:math.roundUpPad(resAll[0][0].SetTemp,1)},{dryWt:math.roundUpPad(resAll[0][0].DryWt,3) },{lossOnWt:math.roundUpPad(resAll[0][0].LossOnWt,3)});
        return objResult;
    }

    /**
     * 
     * @param {*} value Validated schema for model
     * @description Move data from current table to temporary table
     */
    async viewTabReport(value, req) {

        const selectDetailRpt = {
            str_tableName: 'tbl_rpt_path',
            data: '*',
        }
        var result1 = await database.select(selectDetailRpt);
        var proj_name = result1[0][0]['proj_name'];

        let clientIp = requestIp.getClientIp(req);
        let ip = clientIp.split(':')[3];
        if ((("idsNo" in value) == true)) {
            ip = `${serverConfig.strIpSeries}${value.idsNo}`;
        } else {
            if (ip === undefined) {
                ip = '127.0.0.1';
            } else {
                ip = ip;
            }
        }
        var reportOption = value.reportOption;
        var testType = value.testType;
        var reportType = value.reportType;
        var recordFrom = value.recordFrom;
        var RepSerNo = value.RepSerNo;

        var masterTableName, detailTableName;
        if (testType == 'Regular') {
            testType = 0;
        } else {
            testType = 1;
        }

        var reciveObj = await this.commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom, proj_name);

        masterTableName = reciveObj.masterTableName;
        detailTableName = reciveObj.detailTableName;
        var selectObj = {
            str_tableName: masterTableName,
            data: '*',
            condition: [
                { str_colName: 'RepSerNo', value: RepSerNo }
            ]
        }
        var masterRes = await database.select(selectObj);
        var int_sideForReport =  serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'SideSingleText').Value;// Text :- 1: Single 0: NA
        if(int_sideForReport == '1') 
        {
            masterRes[0][0].Side = (masterRes[0][0].Side== 'NA')? 'Single' : masterRes[0][0].Side;
        }
        /** 
         * @type Object
         */
        var insertVal = masterRes[0][0];
        var tbl_master = "",tbl_detail = "";
        var int_isHTD =  serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'Hardness_htdTable').Value;// 1 : table htd used  and 0 : 7 table used used
       if(int_isHTD == '0') 
       {
        tbl_master = "tbl_temp_master";
        tbl_detail= "tbl_temp_detail";
       }
       else
       {
        tbl_master = "tbl_temp_tab_masterhtd";
        tbl_detail= "tbl_temp_tab_detailhtd";
       }
        if (reportOption == 'Hardness') {
            var selectTempData = {
                str_tableName: tbl_master,
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        }
        else if (reportOption == 'Tablet Tester') {
            var selectTempData = {
                str_tableName: tbl_master,
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        }
        else if (reportOption == 'Disintegration Tester') {
            var selectTempData = {
                str_tableName: 'tbl_temp_masterdt',
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        } else {
            var selectTempData = {
                str_tableName: 'tbl_temp_master',
                data: '*',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
        }

        var tempRes = await database.select(selectTempData);

        let responseObj = {};
        // Checking if there is entry for respected HMI or not
        if (tempRes[0].length != 0) {
            // If entry is present then we have to delete and insert or directly insert
            if (reportOption == 'Hardness') {
                var deleteTempMaster = {
                    str_tableName: tbl_master,
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: tbl_detail,
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            }
           else if (reportOption == 'Tablet Tester') {
                var deleteTempMaster = {
                    str_tableName: tbl_master,
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: tbl_detail,
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            }
           else if (reportOption == 'Disintegration Tester') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_masterdt',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detaildt',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            } else if (reportOption == 'Group' || reportOption == 'Group Layer1' || reportOption == 'Group Layer2') {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detailgroup',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            } else {
                var deleteTempMaster = {
                    str_tableName: 'tbl_temp_master',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            }
            var res1 = await database.delete(deleteTempMaster);

            var int_isConsolidated =  0;
            var int_isHTD =  serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'Hardness_htdTable').Value; // htd table used if flag 1
          
            // Inserting data to temporary table
            var res2 = await database.delete(deleteTempDetail);

            // get NMt from nomenclature table - Applicable:1 (Not consider NMT) and NA:0 (consider NMT)
            var obj_getNMT = {
                str_tableName: 'tbl_nomenclature',
                data: 'IsNMT'
            }

            var str_resNMT = await database.select(obj_getNMT);

            if (reportOption == 'Hardness') {
                if(int_isConsolidated == '1'){
                    var res = await this.insertHDSunVapiTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName);
                    Object.assign(calRes,{ rptHeading:reportOption }); 
                    return calRes;
                }
                else if(int_isHTD == '0'){ 
                    var res = await this.insertHDSunVapiTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationHTDSunVapi(insertVal, RepSerNo, ip, value, reportType);
                    return calRes;
                } else {
                    var res = await this.insertHTDTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationHTD(insertVal, RepSerNo, ip, value, reportType);
                    return calRes;
                }

            }
            else if (reportOption == 'Tablet Tester') {
                var res = await this.insertHTDTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationHTD(insertVal, RepSerNo, ip, value, reportType);
                    return calRes;
            } 
            else if (reportOption == 'Particle Size') {
                var res = await this.insertParticalSizeTempTables(insertVal, ip, detailTableName, RepSerNo, 1);
                var calRes = await this.calculationParticleSize(insertVal, RepSerNo, ip, value);
                return calRes;

            } else if (reportOption == 'Friabilator') {
                var calRes = await this.calculationFriabilator(insertVal, RepSerNo, ip, value);
                return calRes;

            } else if (reportOption == 'Tapped Density') {
                var calRes = await this.calculationTabDensity(RepSerNo, masterTableName, value, ip);
                return calRes;
            }
            else if (reportOption == 'Fine %') {
                var res = await this.insertTempTables(insertVal, ip, detailTableName, RepSerNo,reportOption);
                var calRes = await this.calculationFinePer(insertVal, RepSerNo, ip, value, reportType);
                return calRes;

            } else if (reportOption == 'Disintegration Tester') {
                var res = await this.insertDTTempTables(insertVal, ip, detailTableName, RepSerNo, proj_name);
                var calRes = await this.calculationDT(insertVal, RepSerNo, ip, value, recordFrom);
                return calRes;

            } else if (reportOption == 'Group' || reportOption == 'Group Layer1' || reportOption == 'Group Layer2') {
                var res = await this.insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await this.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName);
                Object.assign(calRes,res)
                return calRes;

            } else if (reportOption == 'Individual' || reportOption == 'Individual Layer1' || reportOption == 'Individual Layer2' || reportOption == 'Individual Empty') {
                var res = await this.insertTempTables(insertVal, ip, detailTableName, RepSerNo,reportOption);
                var calRes = await this.calculation(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType);
                return calRes;

            }
            else {
                var res = await this.insertTempTables(insertVal, ip, detailTableName, RepSerNo,reportOption);
                var calRes = await this.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName);
                if(int_isConsolidated == '1'){ // only for ML
                Object.assign(calRes,{ rptHeading:reportOption }); 
                }
                return calRes;

            }

        } else {
            var int_isConsolidated =  0;
            // Inserting data to temporary table
           
            if (reportOption == 'Hardness') {
                if(int_isConsolidated == '1'){
                    var res = await this.insertHDSunVapiTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName);
                    Object.assign(calRes,{ rptHeading:reportOption }); 
                    return calRes;
                }
                else if(int_isHTD == '0'){ 
                    var res = await this.insertHDSunVapiTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationHTDSunVapi(insertVal, RepSerNo, ip, value, reportType);
                    return calRes;
                }else {
                    var res = await this.insertHTDTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationHTD(insertVal, RepSerNo, ip, value, reportType);
                    return calRes;
                }

            }
            else if (reportOption == 'Tablet Tester') {
                var res = await this.insertHTDTempTables(insertVal, ip, detailTableName, RepSerNo);
                    var calRes = await this.calculationHTD(insertVal, RepSerNo, ip, value, reportType);
                    return calRes;
            }  
            else if (reportOption == 'Particle Size') {
                var res = await this.insertParticalSizeTempTables(insertVal, ip, detailTableName, RepSerNo, 1);
                var calRes = await this.calculationParticleSize(insertVal, RepSerNo, ip, value);
                return calRes;

            } else if (reportOption == 'Friabilator') {
                var calRes = await this.calculationFriabilator(insertVal, RepSerNo, ip, value);
                return calRes;

            } else if (reportOption == 'Tapped Density') {
                var calRes = await this.calculationTabDensity(RepSerNo, masterTableName, value, ip);
                return calRes;

            }
            else if (reportOption == 'Fine %') {
                var res = await this.insertTempTables(insertVal, ip, detailTableName, RepSerNo,reportOption);
                var calRes = await this.calculationFinePer(insertVal, RepSerNo, ip, value, reportType);
                return calRes;

            } else if (reportOption == 'Disintegration Tester') {
                var res = await this.insertDTTempTables(insertVal, ip, detailTableName, RepSerNo, proj_name);
                var calRes = await this.calculationDT(insertVal, RepSerNo, ip, value, recordFrom);
                return calRes;

            } else if (reportOption == 'Group' || reportOption == 'Group Layer1' || reportOption == 'Group Layer2') {
                var res = await this.insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo);
                var calRes = await this.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName);
                Object.assign(calRes,res)
                return calRes;

            } else if (reportOption == 'Individual' || reportOption == 'Individual Layer1' || reportOption == 'Individual Layer2' || reportOption == 'Individual Empty') {
                var res = await this.insertTempTables(insertVal, ip, detailTableName, RepSerNo,reportOption);
                var calRes = await this.calculation(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType);
                return calRes;

            } else {
                var res = await this.insertTempTables(insertVal, ip, detailTableName, RepSerNo,reportOption);
                var calRes = await this.calculationGroupVernier(str_resNMT[0][0]['IsNMT'],insertVal, RepSerNo, ip, value, reportType, detailTableName);
                if(int_isConsolidated == '1'){
                Object.assign(calRes,{ rptHeading:reportOption }); 
                }
                return calRes;

            }
        }


    }
    /**
     * 
     * @param {*} insertVal Data to be inserted into Master table
     * @param {*} RepSerNo Report serial number of Report
     * @param {*} ip Ip of requesting resource
     * @param {*} value Data coming from client side
     * @param {*} strRptType Report type :- Complete and Incomplete
     */
    calculation(str_resNMT,insertVal, RepSerNo, ip, value, strRptType, intProductType = 1) {
        return new Promise((resolve, reject) => {
            const objData = {};
            /** Difference calculate ie nom +/- tolerance */
            let AbvLmt1NoSide = 0, BlwLmt1NoSide = 0, AbvLmt2NoSide = 0, BlwLmt2NoSide = 0;

            var str_mgDP = 0;

            /**
             *   This change is requested by client : SVP (CRF-40), ML 
             * If unit is "mg" then int_DP = From Developer Panel else as per balance DP
             */ 
           var int_DP = (insertVal.Unit == "mg") ? Number(str_mgDP) : Number(insertVal.DecimalPoint);

            var str_projectName =  serverConfig.developerPanelData.ProjectName[0].Name;
            
            objStoredProcedure.getIndividual(RepSerNo, value, intProductType).then((result) => {
                let T1Neg = math.roundUp(objFormula.calculateT1Neg(insertVal, result[1][0]['@average']),int_DP);
                let T1Pos = math.truncateDecimal(objFormula.calculateT1Pos(insertVal, result[1][0]['@average']),int_DP);
                let T2Neg = math.roundUp(objFormula.calculateT2Neg(insertVal, result[1][0]['@average']),int_DP);
                let T2Pos = math.truncateDecimal(objFormula.calculateT2Pos(insertVal, result[1][0]['@average']),int_DP);
                let selectDetailObj = {
                    str_tableName: 'tbl_temp_detail',
                    data: '*',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                database.select(selectDetailObj).then(response => {
                    for (const key in response[0]) {
                        if (response[0].hasOwnProperty(key)) {
                            const element = response[0][key];
                            //const elementValue = objFormula.convertToNumber(element.DataValue);
                            const elementValue = math.roundUp(element.DataValue,int_DP);
                            if (T1Neg == T1Pos)//if limits are same
                            {
                                if (elementValue < T2Neg) {
                                    BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                }
                                if (elementValue > T2Pos) {
                                    AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                }
                            }
                            else {
                                /*if (elementValue < T1Neg) {
                                    if (elementValue > T2Neg) {
                                        BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                    }
                                }
                                if (elementValue > T1Pos) {
                                    if (elementValue < T2Pos) {
                                        AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                    }
                                }
                                if (elementValue < T2Neg) {
                                    BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                }
                                if (elementValue > T2Pos) {
                                    AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                }*/

                                if (elementValue > T2Pos) {
                                    AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                }

                                if (elementValue > T1Pos) {
                                    if (elementValue <= T2Pos) {
                                        AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                    }
                                }

                                if (elementValue < T1Neg) {
                                    if (elementValue >= T2Neg) {
                                        BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                    }
                                }

                                if (elementValue < T2Neg) {
                                    BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                }
                            }

                        }
                    }

                    let int_sumT1 = (BlwLmt1NoSide + AbvLmt1NoSide);
                    let int_sumT2 = (BlwLmt2NoSide + AbvLmt2NoSide);
                    let str_Remark = "";

 
                    if(str_resNMT == 1)
                    {
                        // Above T2 limits will be considered as outof limit - Mail on 22/03/2021 - Client requirement- only for SVP
                        ((int_sumT1 > insertVal.T1NMTTab) || (int_sumT2 > 0)) ? str_Remark = "Not Complies" : str_Remark = "Complies";
                    }
                    else
                    {
                        (int_sumT2 > 0) ? str_Remark = "Not Complies" : str_Remark = "Complies";
                    }

                    //var t1NegNum = objFormula.convertToNumber(result[1][0]['@T1Neg']).toFixed(int_DP);
                    var t1NegNum = math.roundUpPad(result[1][0]['@T1Neg'],int_DP);
                    var t1PosNum = math.roundUpPad(result[1][0]['@T1Pos'],int_DP);//math.roundUpPad(result[1][0]['@T1Pos'],int_DP);
                    var t2NegNum = math.roundUpPad(result[1][0]['@T2Neg'],int_DP);
                    var t2PosNum = math.roundUpPad(result[1][0]['@T2Pos'],int_DP);
                    var nom = math.roundUpPad(result[1][0]['@nominal'],int_DP);

                    var stdLnt = objFormula.stdLnt1Calculate(nom, t1NegNum, t1PosNum, t2NegNum, t2PosNum, result[1][0]['@limiton'],
                        result[1][0]['@average'], result[1][0]['@standardDeviation'], result[1][0]['@graphType'], result[1][0]['@nmtTab'],
                        insertVal.Unit, T1Neg, T1Pos, T2Neg, T2Pos,int_DP);

                    var dbl_cal_Neg1 = math.roundUpPad(Math.abs(stdLnt.calNeg1),int_DP);
                    var dbl_cal_Pos1 = math.roundUpPad(stdLnt.calPos1,int_DP);
                    var dbl_cal_Neg2 = math.roundUpPad(Math.abs(stdLnt.calNeg2),int_DP);
                    var dbl_cal_Pos2 = math.roundUpPad(stdLnt.calPos2,int_DP);
                    // avg 1 digit hardcoded for SVP - Mail 22/02/2021
                    Object.assign(objData, { SelectedValue: RepSerNo }, { AbvLmt1NoSide: AbvLmt1NoSide }, { FromDate: "" },
                        { ToDate: "" }, { ReqMenu: "" }, { SelectedAction: "" }, { BlwLmt1NoSide: BlwLmt1NoSide },
                        { AverageValue: (str_projectName == "SVP") ? math.roundUpPad(result[1][0]['@average'], 1) : 
                        (str_projectName == "MVL") ? math.roundUpPad(result[1][0]['@average'], 2) : math.roundUpPad(result[1][0]['@average'], int_DP+1) }, 
                        { UserId: value.userId }, { UserName: value.username }, 
                        { CalStandDev: math.roundUpPad(result[1][0]['@standardDeviation'], int_DP+1) },
                        { lowT1: dbl_cal_Neg1 }, { uppT1: dbl_cal_Pos1 }, { lowT2: dbl_cal_Neg2 }, { uppT2: dbl_cal_Pos2 }, 
                        { minPercentage: math.roundUpPad(Math.abs(result[1][0]['@minPercentage']),2) }, 
                        { maxPercentage: math.roundUpPad(Math.abs(result[1][0]['@maxPercentage']),2) }, { nom: math.roundUpPad(result[1][0]['@nominal'],int_DP) }, 
                        {minWeight: (str_projectName == "MVL") ? math.roundUpPad(result[1][0]['@minWeight'],0) : math.roundUpPad(result[1][0]['@minWeight'],int_DP)}, 
                        { maxWeight: (str_projectName == "MVL") ? math.roundUpPad(result[1][0]['@maxWeight'],0) : math.roundUpPad(result[1][0]['@maxWeight'],int_DP) }, 
                        { rptHeading: result[1][0]['@rptHeading'] }, { HmiId: ip.split('.')[3] }, 
                        { AbvLmt2NoSide: AbvLmt2NoSide }, { BlwLmt2NoSide: BlwLmt2NoSide }, { Result: str_Remark },
                        { waterMark: true }, { stdLmt1Txt: stdLnt.strTxt1 }, { stdLmt2Txt: stdLnt.strTxt2 }, { ICReport: strRptType }, 
                        { printNo: Number(value.printNo) },
                        { RecSeqNo: result[1][0]['@RecSeqNo'] });
                    resolve(objData);
                })
            })
        })
    }

    async calculation_old(insertVal, RepSerNo, ip, value) {

        const objData = {};
        let T1Neg = objFormula.calculateT1Neg(insertVal);
        let T1Pos = objFormula.calculateT1Pos(insertVal);
        let T2Neg = objFormula.calculateT2Neg(insertVal);
        let T2Pos = objFormula.calculateT2Pos(insertVal);
        let AbvLmt1NoSide = 0, BlwLmt1NoSide = 0, AbvLmt2NoSide = 0, BlwLmt2NoSide = 0;

        let selectobj = {
            str_tableName: 'tbl_temp_detail',
            data: 'DataValue',
            condition: [
                { str_colName: 'RepSerNo', value: RepSerNo, comp: 'eq' },
                { str_colName: 'HMI_ID', value: ip.split('.')[3], comp: 'eq' },

            ],
            order: [
                { str_colName: 'RecSeqNo', value: 'ASC' }
            ]
        }
        var result = await database.select(selectobj);
        var newArray = [];
        newArray.push(...result[0].DataValue);
        //  newArray.fil
        var objAvg = {};
        Object.assign(objAvg, { AverageValue: result[0][0].average },
            { CalStandDev: result[0][0].standDev }, { HmiId: ip.split('.')[3] });

        // console.log(objAvg);

        let selectDetailObj = {
            str_tableName: 'tbl_temp_detail',
            data: 'DataValue',
            condition: [
                { str_colName: 'HMI_ID', value: ip.split('.')[3] }
            ]
        }
        var response = await database.select(selectDetailObj);


        for (const key in response[0]) {
            if (response[0].hasOwnProperty(key)) {
                const element = response[0][key];
                if (element.DataValue < T1Neg) {
                    if (element.DataValue > T2Neg) {
                        BlwLmt1NoSide = BlwLmt1NoSide + 1;
                    }
                }
                if (element.DataValue > T1Pos) {
                    if (element.DataValue < T2Pos) {
                        AbvLmt1NoSide = AbvLmt1NoSide + 1;
                    }
                }
                if (element.DataValue < T2Neg) {
                    BlwLmt2NoSide = BlwLmt2NoSide + 1;
                }
                if (element.DataValue > T2Pos) {
                    AbvLmt2NoSide = AbvLmt2NoSide + 1;
                }
            }
        }

        let int_sumT1 = (BlwLmt1NoSide + AbvLmt1NoSide);
        let int_sumT2 = (BlwLmt2NoSide + AbvLmt2NoSide);
        let str_Remark = "";

        ((int_sumT1 > insertVal.T1NMTTab) || (int_sumT2 > 0)) ? str_Remark = "Not Complies" : str_Remark = "Complies";

        Object.assign(objData, objAvg, { SelectedValue: RepSerNo }, { AbvLmt1NoSide: AbvLmt1NoSide }, { FromDate: "" },
            { ToDate: "" }, { ReqMenu: "" }, { SelectedAction: "" }, { BlwLmt1NoSide: BlwLmt1NoSide },
            { UserId: value.userId }, { UserName: value.username },
            { AbvLmt2NoSide: AbvLmt2NoSide }, { BlwLmt2NoSide: BlwLmt2NoSide }, { Result: str_Remark },
            { waterMark: true });

        return objData;

    }

    /**
     * 
     * @param {*} insertVal Data to be inserted into Master table
     * @param {*} RepSerNo Report serial number of Report
     * @param {*} ip Ip of requesting resource
     * @param {*} value Data coming from client side
     * @param {*} strRptType Report type :- Complete and Incomplete
     * @Modification 30/07/2021 :  change done as per client requirement - CRF(42)
     */
    calculationGroupVernier(str_resNMT,insertVal, RepSerNo, ip, value, strRptType, str_detailTableName, intProductType = 1) {
        return new Promise((resolve, reject) => {
            var str_projectName =  serverConfig.developerPanelData.ProjectName[0].Name;
            const objData = {};
            var int_DP = (Number(insertVal.DecimalPoint)==0)? 2 : Number(insertVal.DecimalPoint);
            if(insertVal.WgmtModeNo == 7)// hardness
            {
                var T1Neg7 = math.roundUp(insertVal.T1NegTol,int_DP);
                var T1Pos7 = math.roundUp(insertVal.T1PosTol,int_DP);
            }
            else if(insertVal.WgmtModeNo == 2)// Group
            {
                // This change done as per client requirement - CRF(42)
                int_DP = (str_projectName == "SVP") ? 3 : int_DP;
            }


            let T2Neg = math.roundUp(objFormula.calculateT2Neg(insertVal),int_DP);
            let T2Pos = math.roundUp(objFormula.calculateT2Pos(insertVal),int_DP);

            let AbvLmt1NoSide = 0, BlwLmt1NoSide = 0, AbvLmt2NoSide = 0, BlwLmt2NoSide = 0;
            let outOfLimitCount = 0;
            var strVernierRemark;

            let floatBalanceNeg1 = 0,floatBalancePos1 = 0,floatBalanceNeg2 = 0,floatBalancePos2 = 0;

            objStoredProcedure.getCalulationForGroupVernier(RepSerNo, value, intProductType,str_projectName).then((result) => {
                let selectDetailObj = {
                    str_tableName: str_detailTableName,
                    data: 'DataValue',
                    condition: [
                        { str_colName: 'RepSerNo', value: RepSerNo }
                    ]
                }
                database.select(selectDetailObj).then(response => {
                    for (const key in response[0]) {
                        if (response[0].hasOwnProperty(key)) {
                            const element = response[0][key];
                            //const elementValue = objFormula.convertToNumber(element.DataValue).toFixed(int_DP);
                            const elementValue = math.roundUp(element.DataValue,int_DP);
                            if ((value.reportOption == "Group") || (value.reportOption == "Group Layer1") || (value.reportOption == "Group Layer2")) {
                                // 12/03/2021 done as per client requirement
                                if(str_projectName == "SVP")
                                {
                                    floatBalanceNeg1 = (Number(result[1][0]['@Low1']) == 0)  ? 0 : Number(result[1][0]['@Low1']);
                                    floatBalancePos1 = (Number(result[1][0]['@Upp1']) == 0)  ? 0 : Number(result[1][0]['@Upp1']);
                                    floatBalanceNeg2 = Number(result[1][0]['@Low2']);
                                    floatBalancePos2 = Number(result[1][0]['@Upp2']);
    
                                    if(floatBalanceNeg1 == 0)
                                    {
                                        if (elementValue < floatBalanceNeg2) {
                                            BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                        }
                                        if (elementValue > floatBalancePos2) {
                                            AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                        }
                                    }
                                    else
                                    {
                                        if (elementValue < floatBalanceNeg1) {
                                            if (elementValue > floatBalanceNeg2) {
                                                BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                            }
                                        }
                                        if (elementValue > floatBalancePos1) {
                                            if (elementValue < floatBalancePos2) {
                                                AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                            }
                                        }
                                        if (elementValue < floatBalanceNeg2) {
                                            BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                        }
                                        if (elementValue > floatBalancePos2) {
                                            AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                        }
                                    }
                                }
                                else
                                {
                                    if (elementValue < T2Neg) {
                                        BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                    }
                                    if (elementValue > T2Pos) {
                                        AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                    }
                                }
                            }
                            else if(insertVal.WgmtModeNo == 7)// hardness
                            {
                                var T1Neg7 = math.roundUp(insertVal.T1NegTol,int_DP);
                                var T1Pos7 = math.roundUp(insertVal.T1PosTol,int_DP);

                                if (elementValue < T1Neg7) {
                                    BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                }
                                if (elementValue > T1Pos7) {
                                    AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                }

                            }
                            else {

                                let floatVernierNeg1 = Number(result[1][0]['@Low1']);
                                let floatVernierPos1 = Number(result[1][0]['@Upp1']);
                                let floatVernierNeg2 = Number(result[1][0]['@Low2']);
                                let floatVernierPos2 = Number(result[1][0]['@Upp2']);
                                var intNMT = Number(result[1][0]['@NMT']);
                                var T1Pos = Number(result[1][0]['@T1Pos']);
                                

                                if(T1Pos == 0)
                                {
                                    if (elementValue < floatVernierNeg2) {
                                        BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                    }
                                    if (elementValue > floatVernierPos2) {
                                        AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                    }
                                }
                                else
                                {
                                    if (elementValue < floatVernierNeg1) {
                                        if (elementValue > floatVernierNeg2) {
                                            BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                        }
                                    }
                                    if (elementValue > floatVernierPos1) {
                                        if (elementValue < floatVernierPos2) {
                                            AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                        }
                                    }
                                    if (elementValue < floatVernierNeg2) {
                                        BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                    }
                                    if (elementValue > floatVernierPos2) {
                                        AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                    }
                                }
                                
                            
                                
                                if (elementValue > floatVernierPos2 || elementValue < floatVernierNeg2) {
                                    outOfLimitCount += 1;
                                }
                                if((outOfLimitCount == 0) && (T1Pos != 0)){
                                    if (elementValue > floatVernierPos1 || elementValue < floatVernierNeg1) {
                                        outOfLimitCount += 1;
                                    }
                                }
                                
                            }
                        }
                    }
                    let str_Remark = "";
                    var dblLwr1 = 0,dblUpp1 = 0,dblLwr2 = 0,dblUpp2 = 0;

                    if(insertVal.WgmtModeNo == 7)// hardness
                    {
                        let int_sumT1_7 = (BlwLmt1NoSide + AbvLmt1NoSide);
        
                        (int_sumT1_7 > 0) ? strVernierRemark = "Not Complies" : strVernierRemark = "Complies";
                    }
                    else
                    {
                        if(str_resNMT == 0)
                        {
                            let int_sumT2 = (BlwLmt2NoSide + AbvLmt2NoSide);
        
                            (int_sumT2 > 0) ? str_Remark = "Not Complies" : str_Remark = "Complies";
        
                            //****************remark for vernier*******************//
                            (int_sumT2 > 0) ? strVernierRemark = "Not Complies" : strVernierRemark = "Complies";
    
                            dblLwr1 = objFormula.convertToNumber(result[1][0]['@TolN1']).toFixed(int_DP);
                            dblUpp1 = objFormula.convertToNumber(result[1][0]['@TolP1']).toFixed(int_DP);
                            dblLwr2 = objFormula.convertToNumber(result[1][0]['@TolN2']).toFixed(int_DP);
                            dblUpp2 = objFormula.convertToNumber(result[1][0]['@TolP2']).toFixed(int_DP);
                        }
                        else
                        {
                            let int_sumT1 = (BlwLmt1NoSide + AbvLmt1NoSide);
                            let int_sumT2 = (BlwLmt2NoSide + AbvLmt2NoSide);
    
                            // Allowed all tablets out of int_sumT1 for SunDadra
                            (int_sumT2 > 0) ? str_Remark = "Not Complies" : str_Remark = "Complies";
    
                            //****************remark for vernier*******************//
                            (int_sumT1 > intNMT || (int_sumT2 > 0)) ? strVernierRemark = "Not Complies" : strVernierRemark = "Complies";
                           
                            dblLwr1 = objFormula.convertToNumber(result[1][0]['@Low']).toFixed(int_DP);
                            dblUpp1 = objFormula.convertToNumber(result[1][0]['@Upp']).toFixed(int_DP);
                        }
                    }

                    

                    var dblMinVal = objFormula.convertToNumber(result[1][0]['@Mininum']).toFixed(int_DP);
                    var dblMaxVal = objFormula.convertToNumber(result[1][0]['@Maximum']).toFixed(int_DP);
                    var dblNom = objFormula.convertToNumber(result[1][0]['@Nom']).toFixed(int_DP);
                    var dblAvg = (str_projectName == "SVP") ? math.roundUpPad(result[1][0]['@Average'],3) : math.roundUpPad(result[1][0]['@Average'],int_DP+1);// Mail on 22/02/2021 by SVP
                    var dblAvg_Vernier = math.roundUpPad(result[1][0]['@Average'],2);// Mail on 22/02/2021 by SVP && Cipla 4 Indore 21/04/2021
                    var dblStdDev = math.roundUpPad(result[1][0]['@Stdev'],int_DP+1);
                    let str_lwrVal = 0, str_uppVal = 0;

                    if ((value.reportOption == "Group") || (value.reportOption == "Group Layer1") || (value.reportOption == "Group Layer2")) {
                        var stdLnt = objFormula.stdLimitCalculateGroup(dblNom, dblLwr1, dblUpp1, dblLwr2, dblUpp2, result[1][0]['@limiton'], dblAvg, result[1][0]['@graphType'],str_projectName,int_DP);
                        str_lwrVal = stdLnt.strTxt1;
                        str_uppVal = stdLnt.strTxt2;
                    }
                    else {
                        str_lwrVal = result[1][0]['@Low'];
                        str_uppVal = result[1][0]['@Upp'];
                    }

                    if ((value.reportOption == "Group") || (value.reportOption == "Group Layer1") || (value.reportOption == "Group Layer2")) {
                        if(str_projectName == "SVP")
                        {
                            Object.assign(objData, { SelectedValue: RepSerNo }, { AbvLmt1NoSide: AbvLmt1NoSide }, { FromDate: "" },
                            { ToDate: "" }, { ReqMenu: "" }, { SelectedAction: "" }, { BlwLmt1NoSide: BlwLmt1NoSide },
                            { AverageValue: dblAvg }, { UserId: value.userId }, { UserName: value.username }, { CalStandDev: dblStdDev },
                            { HmiId: ip.split('.')[3] }, { AbvLmt2NoSide: (str_projectName == "SVP") ? AbvLmt2NoSide : 0 }, { BlwLmt2NoSide: (str_projectName == "SVP") ? BlwLmt2NoSide : 0 }, { Result: str_Remark },
                            { waterMark: true }, { nom: dblNom }, 
                            { stdLmt1Txt: str_lwrVal }, { stdLmt2Txt: str_uppVal }, 
                            { lowT1: (insertVal.T1NegTol == 0) ? 0 : objFormula.convertToNumber(floatBalanceNeg1).toFixed(int_DP) },
                            { lowT2: objFormula.convertToNumber(floatBalanceNeg2).toFixed(int_DP) }, 
                            { uppT1: (insertVal.T1PosTol == 0) ? 0 : objFormula.convertToNumber(floatBalancePos1).toFixed(int_DP) },
                            { uppT2: objFormula.convertToNumber(floatBalancePos2).toFixed(int_DP) },
                            { minWeight: dblMinVal }, { maxWeight: dblMaxVal },
                            { ICReport: strRptType }, { printNo: Number(value.printNo) }, { RecSeqNo: result[1][0]['@RecSeqNo'] },
                            { RecSeqNoR: result[1][0]['@RecSeqNoR'] });
                        }
                        else
                        {
                            Object.assign(objData, { SelectedValue: RepSerNo }, { AbvLmt1NoSide: AbvLmt1NoSide }, { FromDate: "" },
                            { ToDate: "" }, { ReqMenu: "" }, { SelectedAction: "" }, { BlwLmt1NoSide: BlwLmt1NoSide },
                            { AverageValue: dblAvg }, { UserId: value.userId }, { UserName: value.username }, { CalStandDev: dblStdDev },
                            { HmiId: ip.split('.')[3] }, { AbvLmt2NoSide: (str_projectName == "SVP") ? AbvLmt2NoSide : 0 }, { BlwLmt2NoSide: (str_projectName == "SVP") ? BlwLmt2NoSide : 0 }, { Result: str_Remark },
                            { waterMark: true }, { nom: dblNom }, 
                            { lowT2: objFormula.convertToNumber(result[1][0]['@strLimitText1']).toFixed(int_DP) }, 
                            { uppT2: objFormula.convertToNumber(result[1][0]['@strLimitText2']).toFixed(int_DP) }, 
                            { minWeight: dblMinVal }, { maxWeight: dblMaxVal },
                            { ICReport: strRptType }, { printNo: Number(value.printNo) }, { RecSeqNo: result[1][0]['@RecSeqNo'] },
                            { RecSeqNoR: result[1][0]['@RecSeqNoR'] },{avgWeight : math.roundUpPad(result[1][0]['@AverageWT'],2)});
                        }
                        
                        resolve(objData);
                    }
                    else {
                        Object.assign(objData, { SelectedValue: RepSerNo }, 
                            { AbvLmt1NoSide: (str_projectName == "SVP") ? AbvLmt1NoSide : (AbvLmt1NoSide + AbvLmt2NoSide) }, 
                            { FromDate: "" },
                            { ToDate: "" }, { ReqMenu: "" }, { SelectedAction: "" }, 
                            { BlwLmt1NoSide: (str_projectName == "SVP") ? BlwLmt1NoSide :(BlwLmt1NoSide + BlwLmt2NoSide) },
                            { AverageValue: dblAvg_Vernier }, { UserId: value.userId }, { UserName: value.username },{ CalStandDev: math.roundUpPad(dblStdDev,int_DP + 1) },
                            { HmiId: ip.split('.')[3] }, { AbvLmt2NoSide: (str_projectName == "SVP") ? AbvLmt2NoSide : 0 }, 
                            { BlwLmt2NoSide: (str_projectName == "SVP") ? BlwLmt2NoSide : 0 }, { Result: strVernierRemark },
                            { waterMark: true }, { nom: math.roundUpPad(dblNom,int_DP) }, { lowT1: math.roundUpPad(result[1][0]['@Low1'],int_DP) }, { uppT1: math.roundUpPad(result[1][0]['@Upp1'],int_DP) },
                            { lowT2:(insertVal.WgmtModeNo == 7) ? T1Neg7 : (math.roundUpPad(result[1][0]['@Low2'],int_DP)) }, 
                            { uppT2: (insertVal.WgmtModeNo == 7) ? T1Pos7 : (math.roundUpPad(result[1][0]['@Upp2'],int_DP)) }, 
                            { minWeight: dblMinVal }, { maxWeight: dblMaxVal },
                            { ICReport: strRptType }, { minPercentage: result[1][0]['@MininumPer'] }, { maxPercentage: result[1][0]['@MaximumPer'] }, { printNo: Number(value.printNo) }, { RecSeqNo: result[1][0]['@RecSeqNo'] });
                        resolve(objData);
                    }


                })
            })
        })
    }

    /**
     * 
     * @param {*} insertVal Data to be inserted into Master table
     * @param {*} RepSerNo Report serial number of Report
     * @param {*} ip Ip of requesting resource
     * @param {*} value Data coming from client side
     */
    calculationGroup_old(insertVal, RepSerNo, ip, value) {
        return new Promise((resolve, reject) => {
            const objData = {};
            let T1Neg = objFormula.calculateT1Neg(insertVal);
            let T1Pos = objFormula.calculateT1Pos(insertVal);
            let T2Neg = objFormula.calculateT2Neg(insertVal);
            let T2Pos = objFormula.calculateT2Pos(insertVal);
            let AbvLmt1NoSide = 0, BlwLmt1NoSide = 0, AbvLmt2NoSide = 0, BlwLmt2NoSide = 0;
            // let selectobj = {
            //     str_tableName: 'tbl_temp_detailgroup',
            //     data: 'STDDEV_SAMP(DataValue) AS standDev, AVG(DataValue) AS average',
            //     condition: [
            //         { str_colName: 'RepSerNo', value: RepSerNo, comp: 'eq' },
            //         { str_colName: 'HMI_ID', value: ip.split('.')[3], comp: 'eq' }
            //     ]
            // }
            // database.select(selectobj).then(result => {
            let query = `SELECT ROUND(CAST(STDDEV_SAMP(DataValue) AS DECIMAL(20,15)),4)  AS standDev,ROUND(CAST(AVG(DataValue) AS DECIMAL(20,15)),4)  AS average FROM tbl_temp_detailgroup WHERE RepSerNo ='${RepSerNo}'  AND HMI_ID = '${ip.split('.')[3]}'`;
            dbCon.execute(query).then((result) => {
                let selectDetailObj = {
                    str_tableName: 'tbl_temp_detailgroup',
                    data: 'DataValue',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
                database.select(selectDetailObj).then(response => {
                    for (const key in response[0]) {
                        if (response[0].hasOwnProperty(key)) {
                            const element = response[0][key];
                            const elementValue = objFormula.convertToNumber(element.DataValue);
                            if (T1Neg == T1Pos) {
                                if (elementValue < T2Neg) {
                                    BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                }
                                if (elementValue > T2Pos) {
                                    AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                }
                            }
                            else {
                                if (elementValue < T1Neg) {
                                    if (elementValue > T2Neg) {
                                        BlwLmt1NoSide = BlwLmt1NoSide + 1;
                                    }
                                }
                                if (elementValue > T1Pos) {
                                    if (elementValue < T2Pos) {
                                        AbvLmt1NoSide = AbvLmt1NoSide + 1;
                                    }
                                }
                                if (elementValue < T2Neg) {
                                    BlwLmt2NoSide = BlwLmt2NoSide + 1;
                                }
                                if (elementValue > T2Pos) {
                                    AbvLmt2NoSide = AbvLmt2NoSide + 1;
                                }
                            }

                        }
                    }

                    let int_sumT1 = (BlwLmt1NoSide + AbvLmt1NoSide);
                    let int_sumT2 = (BlwLmt2NoSide + AbvLmt2NoSide);
                    let str_Remark = "";

                    ((int_sumT1 > Number(insertVal.T1NMTTab)) || (int_sumT2 > 0)) ? str_Remark = "Not Complies" : str_Remark = "Complies";

                    Object.assign(objData, { SelectedValue: RepSerNo }, { AbvLmt1NoSide: AbvLmt1NoSide }, { FromDate: "" },
                        { ToDate: "" }, { ReqMenu: "" }, { SelectedAction: "" }, { BlwLmt1NoSide: BlwLmt1NoSide },
                        { AverageValue: result[0][0].average }, { UserId: value.userId }, { UserName: value.username }, { CalStandDev:  result[0][0].standDev },
                        { HmiId: ip.split('.')[3] }, { AbvLmt2NoSide: AbvLmt2NoSide }, { BlwLmt2NoSide: BlwLmt2NoSide }, { Result: str_Remark },
                        { waterMark: true });
                    resolve(objData);
                })
            }).catch(err => {
                reject(err);
            })
        })
    }
    /**
    *
    * @param {*} insertVal Data to be inserted into Master table
    * @param {*} RepSerNo Report serial number of Report
    * @param {*} ip Ip of requesting resource
    * @param {*} value Data coming from client side
    * @description Calculation for Multiparameter hardness
    */
    calculationHTD(insertVal, RepSerNo, ip, value, strReportType) {
        return new Promise((resolve, reject) => {
            var ResultHard, ResultThk, ResultDOLOBO, ResultDiam="";
            var intHardDP = Number(insertVal.DecimalPoint); //from master
            const objData = {};

            objStoredProcedure.getCalculationForHTD(RepSerNo, value).then((result) => {
                let selectDetail = {
                    str_tableName: 'tbl_temp_tab_detailhtd',
                    data: '*',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3], comp: 'eq' }
                    ]
                }
                database.select(selectDetail).then(detailRes => {
                    let int_Hardness = 0, int_Thikness = 0, int_DOLOBO = 0, int_Diam = 0;
                    var floatHardNeg, floatHardPos;
                    if (result[1][0]['@Unit'] == 'N') {
                        floatHardNeg = math.roundUp(result[1][0]['@HardnessNegN'],intHardDP);
                        floatHardPos =  math.roundUp(result[1][0]['@HardnessPosN'],intHardDP);
                    } else {
                        floatHardNeg = math.roundUp(result[1][0]['@HardnessNegKp'],intHardDP);
                        floatHardPos = math.roundUp(result[1][0]['@HardnessPosKp'],intHardDP);
                    }
                    var cntHard = 0,cntThick = 0,cntDOLOB = 0,cntDiam = 0;

                        for (let i = 0; i < detailRes[0].length; i++) {

                        if(detailRes[0][i].DataValueThick == "NA" || detailRes[0][i].DataValueThick == "FL" 
                        || detailRes[0][i].DataValueThick == "--"  || detailRes[0][i].DataValueThick == "99999.00" || detailRes[0][i].DataValueThick == "99999"
                        || detailRes[0][i].DataValueThick == "99998.00" || detailRes[0][i].DataValueThick == "99998" || detailRes[0][i].DataValueThick =="0")
                        {
                            cntThick = cntThick + 1;
                        }
                        if(detailRes[0][i].DataValueHard == "NA" || detailRes[0][i].DataValueHard == "FL" 
                        || detailRes[0][i].DataValueHard == "--" || detailRes[0][i].DataValueHard == "99999.00" || detailRes[0][i].DataValueHard == "99999"
                        || detailRes[0][i].DataValueHard == "99998.00" || detailRes[0][i].DataValueHard == "99998" || detailRes[0][i].DataValueHard =="0")
                        {
                            cntHard = cntHard + 1;
                        }
                        if(detailRes[0][i].DataValueDOLOBO == "NA" || detailRes[0][i].DataValueDOLOBO == "FL" 
                        || detailRes[0][i].DataValueDOLOBO == "--" || detailRes[0][i].DataValueDOLOBO == "99999.00" || detailRes[0][i].DataValueDOLOBO == "99999"
                        || detailRes[0][i].DataValueDOLOBO == "99998.00" || detailRes[0][i].DataValueDOLOBO == "99998" || detailRes[0][i].DataValueDOLOBO =="0")
                        {
                            cntDOLOB = cntDOLOB + 1;
                        }
                        if(insertVal.HTMake == "ST50")
                        {
                            if(detailRes[0][i].DataValueDiam == "NA" || detailRes[0][i].DataValueDiam == "FL" 
                            || detailRes[0][i].DataValueDiam == "--" || detailRes[0][i].DataValueDiam == "99999.00" || detailRes[0][i].DataValueDiam == "99999"
                            || detailRes[0][i].DataValueDiam == "99998.00" || detailRes[0][i].DataValueDiam == "99998" || detailRes[0][i].DataValueDiam =="0")
                            {
                                cntDiam = cntDiam + 1;
                            }

                            if ((Number(result[1][0]['@DiameterNeg']) > Number(detailRes[0][i].DataValueDiam)) || (Number(result[1][0]['@DiameterPos']) < Number(detailRes[0][i].DataValueDiam))) {
                                int_Diam = int_Diam + 1;
                            }

                            (Number(result[1][0]['@DiameterAverage']) == 0) ? ResultDiam = 'NA' : (cntDiam > 0) ? ResultDiam = 'NA' : 
                            (int_Diam > 0) ? ResultDiam = 'Not Complies' : ResultDiam = 'Complies';
                        }
                        

                        if ((Number(floatHardNeg) > Number(detailRes[0][i].DataValueHard)) || (Number(floatHardPos) < Number(detailRes[0][i].DataValueHard))) {
                            int_Hardness = int_Hardness + 1;
                        }
                        if ((Number(result[1][0]['@ThicknessNeg']) > Number(detailRes[0][i].DataValueThick)) || (Number(result[1][0]['@ThicknessPos']) < Number(detailRes[0][i].DataValueThick))) {
                            int_Thikness = int_Thikness + 1;
                        }
                        if ((Number(result[1][0]['@DOLOBONeg']) > Number(detailRes[0][i].DataValueDOLOBO)) || (Number(result[1][0]['@DOLOBOPos']) < Number(detailRes[0][i].DataValueDOLOBO))) {
                            int_DOLOBO = int_DOLOBO + 1;
                        }
                    }


                    var dec_HardStdDev = 0, dec_HardAvg = 0, dec_HardMin = 0, dec_HardMax = 0, dec_HardMax = 0, dec_HardNom = 0,
                        dec_HardNeg = 0, dec_HardPos = 0, NAhardAverage = 0,cntResult=0;

                        if (result[1][0]['@Unit'] == 'N') {
                            dec_HardStdDev = math.roundUpPad(result[1][0]['@HardnessStdDevN'],intHardDP+1);
                            dec_HardAvg = math.roundUpPad(result[1][0]['@HardnessAverageN'],intHardDP+1);
                            dec_HardMin = Number(result[1][0]['@HardnessMinN']).toFixed(intHardDP) + ' N';
                            dec_HardMax = Number(result[1][0]['@HardnessMaxN']).toFixed(intHardDP) + ' N';
                            dec_HardNom = Number(result[1][0]['@HardnessNominalN']).toFixed(intHardDP);
                            dec_HardPos = Number(result[1][0]['@HardnessPosN']).toFixed(intHardDP);
                            dec_HardNeg = Number(result[1][0]['@HardnessNegN']).toFixed(intHardDP);
                            NAhardAverage = Number(result[1][0]['@HardnessAverageN']).toFixed(intHardDP+1);
                        }
                        else {
                            dec_HardStdDev = math.roundUpPad(result[1][0]['@HardnessStdDevKp'],intHardDP+1);
                            dec_HardAvg = math.roundUpPad(result[1][0]['@HardnessAverageKp'],intHardDP+1);
                            dec_HardMin = Number(result[1][0]['@HardnessMinKp']).toFixed(intHardDP) + ' Kp';
                            dec_HardMax = Number(result[1][0]['@HardnessMaxKp']).toFixed(intHardDP) + ' Kp';
                            dec_HardNom = Number(result[1][0]['@HardnessNominalKp']).toFixed(intHardDP);
                            dec_HardPos = Number(result[1][0]['@HardnessPosKp']).toFixed(intHardDP);
                            dec_HardNeg = Number(result[1][0]['@HardnessNegKp']).toFixed(intHardDP);
                            NAhardAverage = Number(result[1][0]['@HardnessAverageKp']).toFixed(intHardDP+1);
                        }
                    
                    //Result calculation for Hardness

                     //(int_Hardness > 0) ? ResultHard = 'Not Complies' : (result[1][0]['@-+'] == 0) ? ResultHard = 'NA' : ResultHard = 'Complies';
                   (NAhardAverage == 0) ? ResultHard = 'NA' : (cntHard > 0) ? ResultHard = 'NA' :  (int_Hardness > 0) ? ResultHard = 'Not Complies' : ResultHard = 'Complies';

                   //Result calculation for Thickness
                   //(int_Thikness > 0) ? ResultThk = 'Not Complies' : (result[1][0]['@ThicknessAverage'] == 0) ? ResultThk = 'NA' : ResultThk = 'Complies';
                   (Number(result[1][0]['@ThicknessAverage']) == 0) ? ResultThk = 'NA' : (cntThick > 0) ? ResultThk = 'NA' : 
                   (int_Thikness > 0) ? ResultThk = 'Not Complies' : ResultThk = 'Complies';

                   //Result calculation for DOLOBO
                   (Number(result[1][0]['@DOLOBOAverage']) == 0) ? ResultDOLOBO = 'NA' : (cntDOLOB > 0) ? ResultDOLOBO = 'NA' : (int_DOLOBO > 0) ? ResultDOLOBO = 'Not Complies' : ResultDOLOBO = 'Complies';
                        var cntForRemark = 0;
                        if(int_Hardness > 0)
                        {
                            cntForRemark = cntForRemark + 1;
                        }
                        if(int_Thikness > 0)
                        {
                            cntForRemark = cntForRemark + 1;
                        }
                        if(int_DOLOBO > 0)
                        {
                            cntForRemark = cntForRemark + 1;
                        }
                    Object.assign(objData, { HardAverage: dec_HardAvg }, { UserId: value.userId },
                        { UserName: value.username }, { HmiId: ip.split('.')[3] }, { ThikAverage: result[1][0]['@ThicknessAverage'] + ' mm' },
                        { DOLOBOAverage: result[1][0]['@DOLOBOAverage'] + ' mm' }, { HardStdDev: dec_HardStdDev }, { ThkStdDev: result[1][0]['@ThicknessStdDev'] },
                        { DOLOBOStdDev: result[1][0]['@DOLOBStdDev'] }, { waterMark: true }, { ResultHard: ResultHard },
                        { ResultThk: ResultThk }, { ResultDOLOBO: ResultDOLOBO }, { DOLOBOMax: result[1][0]['@DOLOBOMax'] + ' mm' }, { DOLOBOMin: result[1][0]['@DOLOBOMin'] + ' mm' },
                        { ThkMax: result[1][0]['@ThicknessMax'] + ' mm' }, { ThkMin: result[1][0]['@ThicknessMin'] + ' mm' }, { HardMax: dec_HardMax },
                        { HardMin: dec_HardMin }, { DOLOBONom: result[1][0]['@DOLOBONominal'] }, { ThkNom: result[1][0]['@ThicknessNominal'] },
                        { HardNom: dec_HardNom }, { DOLOBOUpp: result[1][0]['@DOLOBOPos'] }, { ThkUpp: result[1][0]['@ThicknessPos'] },
                        { HardUpp: dec_HardPos }, { DOLOBOLow: result[1][0]['@DOLOBONeg'] }, { ThkLow: result[1][0]['@ThicknessNeg'] },
                        { HardLow: dec_HardNeg }, { ICReport: strReportType }, { printNo: Number(value.printNo) },
                        {cntThick:cntThick},{cntHard:cntHard},{cntDOLOB:cntDOLOB},{RecSeqNo:result[1][0]['@RecSeqNo']},{str:"Consolidated"},
                        { DiaAverage: result[1][0]['@DiameterAverage'] + ' mm' }, { DiaStdDev: result[1][0]['@DiameterStdDev'] },
                        { ResultDia: ResultDiam },{ DiaMax: result[1][0]['@DiameterMax'] + ' mm' }, { DiaMin: result[1][0]['@DiameterMin'] + ' mm' },
                        { DiaNom: result[1][0]['@DiameterNominal'] }, { DiaUpp: result[1][0]['@DiameterPos'] }, { DiaLow: result[1][0]['@DiameterNeg'] },
                        {cntDia:cntDiam},{cntForRemark:cntForRemark}
                        )
                    resolve(objData)
                })
            })

        })
    }


    calculationHTDSunVapi(insertVal, RepSerNo, ip, value, strRptType, intProductType = 1) {
        return new Promise((resolve, reject) => {
            const objData = {};
            var intHardDP = Number(insertVal.DecimalPoint);
            objStoredProcedure.getCalculationForHTDSunVapi(RepSerNo, value).then(result => {

                var dec_HardStdDev = 0, dec_HardAvg = 0, dec_HardMin = 0, dec_HardMax = 0, dec_HardMax = 0, dec_HardNom = 0,
                dec_HardNeg = 0, dec_HardPos = 0, NAhardAverage = 0,cntResult=0;

                dec_HardStdDev = math.roundUpPad(result[1][0]['@CalStandDev'],intHardDP);
                dec_HardAvg = math.roundUpPad(result[1][0]['@average'],1);// Mail on 22/02/2021 by SVP
                dec_HardMin = Number(result[1][0]['@minWeight']).toFixed(intHardDP);
                dec_HardMax = Number(result[1][0]['@maxWeight']).toFixed(intHardDP);
                dec_HardNom = Number(result[1][0]['@nominal']).toFixed(intHardDP);
                dec_HardPos = Number(result[1][0]['@uppT1']).toFixed(intHardDP);
                dec_HardNeg = Number(result[1][0]['@lowT1']).toFixed(intHardDP);

                Object.assign(objData, {
                    UserName: value.username, UserId: value.userId, HmiId: ip.split('.')[3], nom: dec_HardNom,
                    lowT2: dec_HardNeg, uppT2: dec_HardPos,lowT1: dec_HardNeg, uppT1: dec_HardPos, 
                    AbvLmt1NoSide: result[1][0]['@AbvLmt1NoSide'], BlwLmt1NoSide: result[1][0]['@BlwLmt1NoSide'], 
                    minWeight: dec_HardMin, maxWeight: dec_HardMax, AverageValue: dec_HardAvg,
                     CalStandDev: dec_HardStdDev, printNo: Number(value.printNo),
                    "FromDate": "", "ToDate": "", "ReqMenu": "", "SelectedAction": "", "ICReport": value.reportType,
                    SelectedValue: value.RepSerNo, Result: result[1][0]['@result'],waterMark: true,str:"SVP"
                });
                resolve(objData);
            })
        })
    }

    /**
    *
    * @param {*} insertVal Data to be inserted into Master table
    * @param {*} RepSerNo Report serial number of Report
    * @param {*} ip Ip of requesting resource
    * @param {*} value Data coming from client side
    * @description Calculation for DT
    */
   calculationDT(insertVal, RepSerNo, ip, value, recordFrom) {
    return new Promise((resolve, reject) => {
        var intStdMinTemp = insertVal.T1NegTol;
        var intStdMaxTemp = insertVal.T1PosTol;
        var intDTMinTemp = insertVal.MinTemp;
        var intDTMaxTemp = insertVal.MaxTemp;
        var strStdDTTime = insertVal.Nom;
        var blnIsTimeExceed = false;
        var blnIsTimeBelowMin = false;
        var blnIsTimeBelowMax = false;
        var strResult, intCntFalse=0;
        // Note:-(11/07/2020)
        // Conditions for DT Report For Complies are as Below.
        // 1)DT run time should smaller then Nom then complies
        // 2)negetive val smaller then Mintemp OR positive greater then maxtemp (complies)

        if (math.roundUp(intStdMinTemp,1) <= math.roundUp(intDTMinTemp,1)) {
            blnIsTimeBelowMin = true;
        }
        if (math.roundUp(intStdMaxTemp,1) >= math.roundUp(intDTMaxTemp,1)) {
            blnIsTimeBelowMax = true;
        }
        var detailTableName;
        if (recordFrom == 'Current') { //current Complete
            //masterTableName = 'tbl_tab_master13';
            detailTableName = 'tbl_tab_detail13'
        } else {  //archive Complete
            //masterTableName = 'tbl_tab_master13_archived';
            detailTableName = 'tbl_tab_detail13_archived'
        }
        var detailData = {
            str_tableName: detailTableName,
            data: 'count(*) as RecSeqNo',
            condition: [
                { str_colName: 'RepSerNo', value: RepSerNo,comp:'eq' }
            ] 
        }
        database.select(detailData).then(Result1 => {
            var data1 = Result1[0][0];
            //console.log(data1.RecSeqNo);
        let selectDetail = {
            str_tableName: 'tbl_temp_detaildt',
            data: '*',
            condition: [
                { str_colName: 'HMI_ID', value: ip.split('.')[3] }
            ]
        }
        database.select(selectDetail).then(detResult => {
            let detailEntries = detResult[0];
            let objData = {};
            var regExp = /(\d{1,2})\:(\d{1,2})\:(\d{1,2})/;

            for (let i = 0; i < detailEntries.length; i++) {
                if (parseInt(detailEntries[i].DT_RunTime.replace(regExp, "$1$2$3")) <=
                    parseInt(strStdDTTime.replace(regExp, "$1$2$3"))) {
                    blnIsTimeExceed = true;
                }
                else{
                    intCntFalse = 1;
                }
            }
            if ((blnIsTimeBelowMin == true) && (blnIsTimeBelowMax == true) && (intCntFalse == 0)) { //check on both temp and time,on 09/01/2020
            // if (blnIsTimeExceed == true) { //check on time only
                strResult = 'Complies';
            } else {
                strResult = 'Not Complies';
            }
            Object.assign(objData, { UserId: value.userId },
                { UserName: value.username }, { HmiId: ip.split('.')[3] }, { Result: strResult },
                { waterMark: true },{printNo:Number(value.printNo)},{RecSeqNo:data1.RecSeqNo})
            resolve(objData)
        }).catch(err => console.log(err))
    })
    })
}
    /**
    *
    * @param {*} insertVal Data to be inserted into Master table
    * @param {*} RepSerNo Report serial number of Report
    * @param {*} ip Ip of requesting resource
    * @param {*} value Data coming from client side
    * @description Calculation for Particle sizing
    */
    async insertParticalSizeTempTables(insertVal, ip, detailTableName, RepSerNo, intDP) {
        try {
            var insertTempObj = {
                str_tableName: 'tbl_temp_master',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: parseFloat(Math.round(insertVal.T1NegTol * Math.pow(10, 1)) / Math.pow(10, 1)).toFixed(0) },
                    { str_colName: 'T1PosTol', value: parseFloat(Math.round(insertVal.T1PosTol * Math.pow(10, 1)) / Math.pow(10, 1)).toFixed(0) }, { str_colName: 'T2NegTol', value: insertVal.T2NegTol },
                    { str_colName: 'T2PosTol', value: insertVal.T2PosTol }, { str_colName: 'limitOn', value: insertVal.limitOn },
                    { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                    { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                    { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                    { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                    { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                    { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                    { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'CheckedByTime', value: insertVal.CheckedByTime }
                ]
            }
            var res = await database.save(insertTempObj);

            var selectDetailObj = {
                str_tableName: detailTableName,
                data: 'RepSerNo, MstSerNo, RecSeqNo, DataValue AS dataVal, DecimalPoint',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }
            var detailData = await database.select(selectDetailObj);
            //var detailData = await this.getIndividualDetail(RepSerNo,detailTableName);

            for (const v of detailData[0]) {
                var insertDetail = {
                    str_tableName: 'tbl_temp_detail',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'MstSerNo', value: v.MstSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DataValue', value: Number(v.dataVal).toFixed(intDP) },
                        { str_colName: 'DataValue1', value: 0 },
                        { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    ]
                }

                var result = await database.save(insertDetail);

            }

            return 'inserted1';
        } catch (error) {
            return error
        }
    }
    calculationParticleSize(insertVal, RepSerNo, ip, value) {
        return new Promise((resolve, reject) => {
            const objData = {};
            var ipVal = ip.split('.')[3];
            dbCon.execute(`SELECT * FROM tbl_temp_detail WHERE HMI_ID = ? ORDER BY RecSeqNo ASC`, [ipVal]).then((detRes) => {
                let TestSample; // Variable for Test Sample which is the first weight offcource
                let FinePercentageBelow60Mesh = 0; // We have to calculate from last 3 samples so we can start
                 var cntRemark = 0;
                // Calculating from sample (Length - 3)
                let detailLength = detRes[0].length;
                if (detailLength > 0) {
                    TestSample = detRes[0][0].DataValue;
                    for (let i = 0; i < detRes[0].length; i++) {

                        if (detailLength <= 4) {
                            let finePerce = (((detRes[0][i].DataValue) / Number(TestSample)) * 100);
                            FinePercentageBelow60Mesh = FinePercentageBelow60Mesh + finePerce;
                        } else {
                            // if (i >= detailLength - 4) {
                            //     let finePerce = (((detRes[0][i].DataValue) / TestSample) * 100);
                            //     FinePercentageBelow60Mesh = FinePercentageBelow60Mesh + finePerce;
                            //     FinePercentageBelow60Mesh = Math.round(FinePercentageBelow60Mesh * 10) / 10;
                            // }
                            if ((detRes[0][i].RecSeqNo == 5) || (detRes[0][i].RecSeqNo == 6) || (detRes[0][i].RecSeqNo == 7)) {
                                let finePerce = Number(((detRes[0][i].DataValue) / Number(TestSample)) * 100).toFixed(1);
                                FinePercentageBelow60Mesh = Number(FinePercentageBelow60Mesh) + Number(finePerce);
                                FinePercentageBelow60Mesh = Math.round(FinePercentageBelow60Mesh * 10) / 10;
                            }

                        }
                    }

                    var strRemark = "";
                    if(Number(FinePercentageBelow60Mesh) < Number(insertVal.T1NegTol))
                    {
                        cntRemark = cntRemark + 1;
                    }

                    if(Number(FinePercentageBelow60Mesh) > Number(insertVal.T1PosTol))
                    {
                        cntRemark = cntRemark + 1;
                    }

                    (cntRemark == 0) ? strRemark = "Complies" : strRemark = "Not Complies";

                    Object.assign(objData, { SelectedValue: RepSerNo }, { UserId: value.userId },
                        { UserName: value.username }, { HmiId: ip.split('.')[3] }, { CalStandDev: TestSample },
                        { waterMark: true },
                        { PerFineBelow60Mesh: Number(FinePercentageBelow60Mesh).toFixed(0)  },
                        { ICReport: value.reportType }, { printNo: Number(value.printNo) },{Result:strRemark})
                    resolve(objData)
                } else {
                    reject('No record found for Detail table')
                }
            }).catch(err => { reject(err) })
        })
    }
    /**
    *
    * @param {*} insertVal Data to be inserted into Master table
    * @param {*} RepSerNo Report serial number of Report
    * @param {*} ip Ip of requesting resource
    * @param {*} value Data coming from client side
    * @description Calculation for Fine %
    * @Modification as per client requirement 
    * 1) DP Change :- DP will be fetched from developer panel - ML-CRF(41-23/07/2021) 
    * 2) Percent value DP set to 2 - (CP4I- Ganesh 31/07/2021)
    */
    calculationFriabilator(insertVal, RepSerNo, ip, value) {
        return new Promise((resolve, reject) => {
            const objData = {};
            var ipVal = ip.split('.')[3];
            objStoredProcedure.getFriability(RepSerNo, value).then((result) => {
                var int_FriDP =  3;
                var str_ML =  0;

                var int_dp = Number(int_FriDP);
                var int_perDP = (str_ML == "ML") ? 3 : 2;
               
                    Object.assign(objData, { SelectedValue: RepSerNo },
                        { UserId: value.userId }, { UserName: value.username }, { Result: result[1][0]['@remark'] },
                        { waterMark: true }, {  FriNMTLimit: Number(result[1][0]['@FriNMTLimit']).toFixed(int_dp) }, { NWtBeforeTest: Number(result[1][0]['@NWtBeforeTest']).toFixed(int_dp) },
                        { NWtAfterTest: Number(result[1][0]['@NWtAfterTest']).toFixed(int_dp) }, { LWtBeforeTest: Number(result[1][0]['@LWtBeforeTest']).toFixed(int_dp) }, 
                        { LWtAfterTest: Number(result[1][0]['@LWtAfterTest']).toFixed(int_dp) },
                        { RWtBeforeTest: Number(result[1][0]['@RWtBeforeTest']).toFixed(int_dp) }, { RWtAfterTest: Number(result[1][0]['@RWtAfterTest']).toFixed(int_dp) },
                        { RHSFriabilityPer: Number(result[1][0]['@FriabilityPercentageRight']).toFixed(int_perDP) }, { LHSFriabilityPer: Number(result[1][0]['@FriabilityPercentageLeft']).toFixed(int_perDP) },
                        { NAFriabilityPer: Number(result[1][0]['@FriabilityPercentageNA']).toFixed(int_perDP) }, { printNo: Number(value.printNo) });

                resolve(objData);
            }).catch(err => {
                reject(err);
            })
        })
    }
    /**
     *
     * @param {*} RepSerNo Report serial number of Report
     * @param {*} ip Ip of requesting resource
     * @param {*} masterTableName table name
     * @description Calculation for TabDensity %
     */
    calculationTabDensity(RepSerNo, masterTableName, value, ip) {
        return new Promise((resolve, reject) => {
            const objData = {};
            var ipVal = ip.split('.')[3];
            objStoredProcedure.getTabDensity(RepSerNo, masterTableName).then((result) => {
                var cntBulkNeg = 0,cntBulkPos = 0,cntTapNeg = 0,cntTapPos = 0,cntTapBulk = 0;
                if(Number(result[1][0]['@bulkDensity']) < Number(result[1][0]['@bulkNegLimit']))
                {
                    cntBulkNeg = cntBulkNeg + 1;
                }
                if(Number(result[1][0]['@bulkDensity']) > Number(result[1][0]['@bulkPosLimit']))
                {
                    cntBulkPos = cntBulkPos + 1;
                }
                if(Number(result[1][0]['@tapDensity']) < Number(result[1][0]['@stdNeg']))
                {
                    cntTapNeg = cntTapNeg + 1;
                }
                if(Number(result[1][0]['@tapDensity']) > Number(result[1][0]['@stdPos']))
                {
                    cntTapPos = cntTapPos + 1;
                }

                /** code is commented bcoz value is checked with every parameter in above code. bcoz of below code remark is displayed wrong*/
                // if(((Number(result[1][0]['@bulkDensity']) > Number(result[1][0]['@bulkNegLimit'])) && (Number(result[1][0]['@bulkDensity']) < Number(result[1][0]['@bulkPosLimit']))) && 
                //     ((Number(result[1][0]['@tapDensity']) > Number(result[1][0]['@stdNeg'])) && (Number(result[1][0]['@tapDensity']) < Number(result[1][0]['@stdPos']))))
                //     {
                //         cntTapBulk = cntTapBulk + 1;
                //     }
                
                var remark = '';
                if(cntBulkNeg == 0 && cntBulkPos == 0 && cntTapNeg == 0 && cntTapPos == 0 && cntTapBulk == 0)
                {
                    remark = "Complies";
                }
                else
                {
                    remark = "Not Complies";
                }
                Object.assign(objData, { SelectedValue: RepSerNo },
                    { UserId: value.userId }, { UserName: value.username }, { result: result[1][0]['@remark'] },
                    { waterMark: true }, { stdLowLimit: result[1][0]['@stdNeg'] }, { stdUppLimit: result[1][0]['@stdPos'] },
                    { bulkStdLowLimit: result[1][0]['@bulkNegLimit'] }, { bulkStdUppLimit: result[1][0]['@bulkPosLimit'] },
                    { tapDensity: result[1][0]['@tapDensity'] }, { bulkDensity: result[1][0]['@bulkDensity'] }, { printNo: Number(value.printNo) });
                resolve(objData);
            }).catch(err => {
                reject(err);
            })
        })
    }
    /**
    *
    * @param {*} insertVal Data to be inserted into Master table
    * @param {*} RepSerNo Report serial number of Report
    * @param {*} ip Ip of requesting resource
    * @param {*} value Data coming from client side
    *  @param {*} value Incomplete complete
    * @description Calculation for Fine %
    */
   //calculationFinePer(insertVal, RepSerNo, ip, value, reportType)
   calculationFinePer(insertVal, RepSerNo, ip, value,reportType) {
    return new Promise((resolve, reject) => {
        const objData = {};
        var decimalPt = 1;
        this.getParticleSizeData(insertVal, RepSerNo, ip, value).then(resultParticalSize => {
            var PSRepSerNo = resultParticalSize;
                let selectDetail = {
                    str_tableName: 'tbl_temp_detail',
                    data: '*',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ],
                    order: [
                        { str_colName: 'RecSeqNo', value: 'ASC' }
                    ]
                }
                database.select(selectDetail).then((res) => {
                    if (res[0].length > 0) {
                        let length = res[0].length;
                        var PerFineBelow60Mesh;
                        let PerFineBelow60MeshObject = res[0][length - 1];
                        let QtyOfTestSmp = res[0][0].DataValue;
                        if(PSRepSerNo == 0){
                            if(reportType == "Incomplete")
                            {
                                PerFineBelow60Mesh = 0;
                            }
                            else
                            {
                                PerFineBelow60Mesh = PerFineBelow60MeshObject.DataValue;
                            }
                        }else{
                            PerFineBelow60Mesh =  PSRepSerNo;
                        }
                        
                        var finalval = (Number(PerFineBelow60Mesh)/Number(QtyOfTestSmp))*100;
                        /* here dp value is 0**/
                        var perFineVal = parseFloat(Math.round(finalval * Math.pow(10, 0)) / Math.pow(10, 0));
                        var strRemark ="",cntBelow=0,cntAbove=0;
                            
                            if(Number(perFineVal) < Number(insertVal.T1NegTol).toFixed(0))
                            {
                                cntBelow = cntBelow + 1;
                            }
                            if(Number(perFineVal) > Number(insertVal.T1PosTol).toFixed(0))
                            {
                                cntAbove = cntAbove + 1;
                            }
                            var sum = cntBelow + cntAbove;

                            (sum > 0) ? strRemark = "Not Complies" : strRemark = "Complies";
                        Object.assign(objData, { SelectedValue: RepSerNo }, { UserId: value.userId }, { UserName: value.username },
                            { HmiId: ip.split('.')[3] }, { waterMark: true }, { PerFineBelow60Mesh: PerFineBelow60Mesh }, { FinalValue: perFineVal },
                            { QtyOfTestSmp: QtyOfTestSmp }, {ICReport: reportType},{printNo:Number(value.printNo)},{Result:strRemark})
                        resolve(objData);
                    } else { console.log(err); reject(err) }
                }).catch(err => {
                    reject(err)
                })
        })
    })
}

async getParticleSizeData(insertVal, RepSerNo, ip, value){
try{
    var decimalPt = 1;
    var fineMasterTable,ParticalSizeDetailTable;
    if (value.reportType == 'Complete') {
        if (value.recordFrom == 'Current') { //current Complete
            fineMasterTable = 'tbl_tab_master17';
            ParticalSizeDetailTable = 'tbl_tab_detail18';
        } else {  //archive Complete
            fineMasterTable = 'tbl_tab_master17_archived';
            ParticalSizeDetailTable = 'tbl_tab_detail18_archived';
        }
    } else {
        if (value.recordFrom == 'Current') { // current Incomplete
            fineMasterTable = 'tbl_tab_master17_incomplete';
            ParticalSizeDetailTable = 'tbl_tab_detail18_incomplete';
        } else {
            // TO - DO for incomplete archive
        }
    }

    const fineMasterObj = {
        str_tableName:fineMasterTable,
        data:'*',
        condition:[
            { str_colName: 'RepSerNo', value: RepSerNo, comp:'eq' }
        ]
    }
    var result = await database.select(fineMasterObj);
    if(result[0].length > 0){
        var data = result[0][0];
        var pSizeRepSrNo = data.RepSerNo;
        if(pSizeRepSrNo == 0)
        {
            return 0;
        }else{
            var result2 = await dbCon.execute(`SELECT * FROM ${ParticalSizeDetailTable} WHERE RepSerNo = ${pSizeRepSrNo} ORDER BY RecSeqNo ASC `);
            var num = [];
            var i = 1;
            for(var val of result2[0]){
                if(i == 5){
                    //var num5 = parseFloat(Math.round(val.DataValue * Math.pow(10, decimalPt)) / Math.pow(10, decimalPt));
                    num.push(Number(val.DataValue));
                }
                if(i == 6){
                    //var num6 = parseFloat(Math.round(val.DataValue * Math.pow(10, decimalPt)) / Math.pow(10, decimalPt));
                    num.push(Number(val.DataValue));
                }
                if(i == 7){
                    //var num7 = parseFloat(Math.round(val.DataValue * Math.pow(10, decimalPt)) / Math.pow(10, decimalPt));
                    num.push(Number(val.DataValue));
                }
                i++;
            }
            var sum = num.reduce(function(a, b){ return a + b; }, 0);
            var finalval =parseFloat(Math.round(sum* Math.pow(10, decimalPt)) / Math.pow(10, decimalPt));
            return finalval;
        }

    }else{
        return false;
    }

}catch(error){
    return error;
}
}
    /**
     * 
     * @param {*} insertVal Data from master table
     * @param {*} ip Ip of requested hosst
     * @param {*} detailTableName Detail TableName
     * @param {*} RepSerNo Report serial number
     * @description Function inserts data in `temporary table` from `permanent tables`
     */

    async insertHDSunVapiTempTables(insertVal, ip, detailTableName, RepSerNo, intDP) {
        try {
            var NetT1 = 0, PosT1 = 0;
            (insertVal.T1NegTol == "99999.00000") ? NetT1 = 0 : NetT1 = insertVal.T1NegTol;
            (insertVal.T1PosTol == "99999.00000") ? PosT1 = 0 : PosT1 = insertVal.T1PosTol;
            var intDP = insertVal.DecimalPoint;
            var insertTempObj = {
                str_tableName: 'tbl_temp_master',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: insertVal.T1NegTol },
                    { str_colName: 'T1PosTol', value: insertVal.T1PosTol }, { str_colName: 'T2NegTol', value: (insertVal.T2NegTol == undefined) ? 'NULL' : insertVal.T2NegTol },
                    { str_colName: 'T2PosTol', value: (insertVal.T2PosTol == undefined) ? 'NULL' : insertVal.T2PosTol }, { str_colName: 'limitOn', value: insertVal.limitOn },
                    { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                    { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: (insertVal.T2NegEmpty == undefined) ? 'NULL' : insertVal.T2NegEmpty },
                    { str_colName: 'T2PosEmpty', value: (insertVal.T2PosEmpty == undefined) ? 'NULL' : insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                    { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                    { str_colName: 'T2NegNet', value: (insertVal.T2NegNet == undefined) ? 'NULL' : insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: (insertVal.T2PosNet == undefined) ? 'NULL' : insertVal.T2PosNet },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                    { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                    { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
            var res = await database.save(insertTempObj);

            var selectDetailObj = {
                str_tableName: detailTableName,
                data: 'RepSerNo, MstSerNo, RecSeqNo, DataValue AS dataVal, DecimalPoint',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }
            var detailData = await database.select(selectDetailObj);
            //var detailData = await this.getIndividualDetail(RepSerNo,detailTableName);

            for (const v of detailData[0]) {
                var insertDetail = {
                    str_tableName: 'tbl_temp_detail',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'MstSerNo', value: v.MstSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DataValue', value: Number(v.dataVal).toFixed(intDP) },
                        { str_colName: 'DataValue1', value: 0 },
                        { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    ]
                }

                var result = await database.save(insertDetail);

            }

            return 'inserted1';
        } catch (error) {
            return error
        }
    }


    async insertTempTables(insertVal, ip, detailTableName, RepSerNo, reportOption) {
        try {
            var NetT1 = 0, PosT1 = 0, int_dp =0;
            (insertVal.T1NegTol == "99999.00000") ? NetT1 = 0 : NetT1 = insertVal.T1NegTol;
            (insertVal.T1PosTol == "99999.00000") ? PosT1 = 0 : PosT1 = insertVal.T1PosTol;

            if(reportOption == "Fine %")
            {
                int_dp = 0;
            }
            else if(reportOption == 'Individual' || reportOption == 'Individual Layer1' || reportOption == 'Individual Layer2' || reportOption == 'Individual Empty')
            {
                int_dp = insertVal.DecimalPoint;
            }
            else // vernier
            {
                int_dp = 2;
            }

            var insertTempObj = {
                str_tableName: 'tbl_temp_master',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: Number(insertVal.T1NegTol).toFixed(int_dp) },
                    { str_colName: 'T1PosTol', value: Number(insertVal.T1PosTol).toFixed(int_dp) }, { str_colName: 'T2NegTol', value: Number(insertVal.T2NegTol).toFixed(int_dp) },
                    { str_colName: 'T2PosTol', value: Number(insertVal.T2PosTol).toFixed(int_dp) }, { str_colName: 'limitOn', value: insertVal.limitOn },
                    { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                    { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                    { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                    { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                    { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                    { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                    { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'CheckedByTime', value: insertVal.CheckedByTime },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'Lot', value: insertVal.Lot }
                ]
            }
            var res = await database.save(insertTempObj);

            var selectDetailObj = {
                str_tableName: detailTableName,
                data: 'RepSerNo, MstSerNo, RecSeqNo, DataValue AS dataVal, DecimalPoint',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }
            var detailData = await database.select(selectDetailObj);
            //var detailData = await this.getIndividualDetail(RepSerNo,detailTableName);
            if(reportOption == "Fine %")
            {
                int_dp = 2;
            }
            for (const v of detailData[0]) {
                var insertDetail = {
                    str_tableName: 'tbl_temp_detail',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'MstSerNo', value: v.MstSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DataValue', value: math.roundUpPad(v.dataVal,int_dp) },
                        { str_colName: 'DataValue1', value: 0 },
                        { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    ]
                }

                var result = await database.save(insertDetail);

            }

            return 'inserted1';
        } catch (error) {
            return error
        }
    }

    // getIndividualDetail(RepSerNo,detailTableName){
    //     return new Promise((resolve,reject) => {
    //         //console.log(`SELECT RepSerNo, MstSerNo, RecSeqNo, ROUND(DataValue,3) AS dataVal, DecimalPoint FROM ${detailTableName} WHERE RepSerNo = ?`,[RepSerNo]);
    //         dbCon.execute(`SELECT  FROM ${detailTableName} WHERE RepSerNo = ?`,[RepSerNo]).then((result)=>{
    //             resolve(result);
    //         }).catch(err => {
    //             reject(err);
    //         })
    //     })
    // }
    /**
         * 
         * @param {*} insertVal Data from master table
         * @param {*} ip Ip of requested hosst
         * @param {*} detailTableName Detail TableName
         * @param {*} RepSerNo Report serial number
         * @description Function inserts data in `temporary table` from `permanent tables`
         * @modification :- SVP(CRF-40) Hardcoded DP = 3 for Group Report
         */
    async insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo) {
        try {
            var NetT1 = 0, PosT1 = 0;
            var int_dp;
            var str_projectNames =  serverConfig.developerPanelData.ProjectName[0].Name;
            if(str_projectNames == "SVP")
            {
                int_dp = 3;
            }
            else if(insertVal.DecimalPoint == 0)
            {
                int_dp = 2;
            }
            else
            {
                int_dp = insertVal.DecimalPoint;
            }

            (insertVal.T1NegTol == "99999.00000") ? NetT1 = 0 : NetT1 = Number(insertVal.T1NegTol).toFixed(int_dp);
            (insertVal.T1PosTol == "99999.00000") ? PosT1 = 0 : PosT1 = Number(insertVal.T1PosTol).toFixed(int_dp);
            var insertTempObj = {
                str_tableName: 'tbl_temp_master',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: NetT1 },
                    { str_colName: 'T1PosTol', value: PosT1 }, { str_colName: 'T2NegTol', value: Number(insertVal.T2NegTol).toFixed(int_dp) },
                    { str_colName: 'T2PosTol', value: Number(insertVal.T2PosTol).toFixed(int_dp) }, { str_colName: 'limitOn', value: insertVal.limitOn },
                    { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                    { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                    { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                    { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                    { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                    { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                    { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }, { str_colName: 'Stage', value: insertVal.Stage },
                    { str_colName: 'Lot', value: insertVal.Lot },{ str_colName: 'CheckedByTime', value: insertVal.CheckedByTime }
                ]
            }
            var res = await database.save(insertTempObj);
            var selectDetailObj = {
                str_tableName: detailTableName,
                data: '*',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }
            var result = await database.select(selectDetailObj);

            for (const v of result[0]) {
                var insertDetail = {
                    str_tableName: 'tbl_temp_detailgroup',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'MstSerNo', value: v.MstSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DataValue', value: Number(v.DataValue).toFixed(int_dp) },
                        { str_colName: 'BatchNo', value: v.BatchNo },
                        { str_colName: 'BFGCode', value: v.BFGCode },
                        { str_colName: 'UserID', value: v.UserID },
                        { str_colName: 'UserName', value: v.UserName },
                        { str_colName: 'PrDate', value: v.PrDate },
                        { str_colName: 'PrTime', value: v.PrTime },
                        { str_colName: 'Side', value: v.Side },
                        { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                        { str_colName: 'PVersion', value: v.PVersion },
                        { str_colName: 'Version', value: v.Version },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                        { str_colName: 'Gavg', value: v.Gavg },
                        { str_colName: 'AvgWt', value: Number(v.AvgWt).toFixed(int_dp) },
                        { str_colName: 'InstrumentID', value: v.InstrumentID }
                    ]
                }
                var result = await database.save(insertDetail);
            }

            var dataVal = await dbCon.execute(`SELECT DataValue FROM ${detailTableName} WHERE RepSerNo = ${RepSerNo} ORDER BY RecSeqNo ASC`);
            var arrDataVal = [];
            for(const dVal of dataVal[0]){
                arrDataVal.push(dVal.DataValue);
            }
            var wtCount = dataVal[0].length;
            var startWeight = arrDataVal[0];
            var endWeight = arrDataVal[wtCount - 1];
            var countDataVal = await dbCon.execute(`SELECT COUNT(DataValue) as dataVCnt FROM ${detailTableName} WHERE RepSerNo = ${RepSerNo}`);
            var weightGain = ((Number(endWeight) - Number(startWeight))/countDataVal[0][0].dataVCnt);
            var objRes = {startWeight:Number(startWeight).toFixed(int_dp),endWeight:Number(endWeight).toFixed(int_dp),weightGain:Number(weightGain).toFixed(int_dp)}
            return objRes;

        } catch (error) {
            console.log(error);
            return error;
        }
    }
    /**
    * 
    * @param {*} insertVal Data from master table
    * @param {*} ip Ip of requested hosst
    * @param {*} detailTableName Detail TableName
    * @param {*} RepSerNo Report serial number
    * @description Function inserts data in `temporary table` from `permanent tables`
    */
    async insertHTDTempTables(insertVal, ip, detailTableName, RepSerNo) {
        try {
            var dblNom = 0, dblPos = 0, dblNeg = 0,intHardDP = 0;

            intHardDP = insertVal.DecimalPoint;

            (insertVal.NomHard == 99999.00000 || insertVal.NomHard == "99999.00000") ? dblNom = 0 : dblNom = insertVal.NomHard;
            (insertVal.PosTolHard == 99999.00000 || insertVal.PosTolHard == "99999.00000") ? dblPos = 0 : dblPos = insertVal.PosTolHard;
            (insertVal.NegTolHard == 99999.00000 || insertVal.NegTolHard == "99999.00000") ? dblNeg = 0 : dblNeg = insertVal.NegTolHard;
            var insertTempObj = {
                str_tableName: 'tbl_temp_tab_masterhtd',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'NomThick', value: insertVal.NomThick }, { str_colName: 'PosTolThick', value: insertVal.PosTolThick },
                    { str_colName: 'NegTolThick', value: insertVal.NegTolThick }, { str_colName: 'NomHard', value: dblNom },
                    { str_colName: 'PosTolHard', value: insertVal.PosTolHard }, { str_colName: 'NegTolHard', value: insertVal.NegTolHard },
                    { str_colName: 'NomDOLOBO', value: insertVal.NomDOLOBO }, { str_colName: 'PosTolDOLOBO', value: insertVal.PosTolDOLOBO },
                    { str_colName: 'NegTolDOLOBO', value: insertVal.NegTolDOLOBO }, { str_colName: 'ColHeadDOLOBO', value: insertVal.ColHeadDOLOBO },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'HardnessID', value: insertVal.HardnessID },
                    { str_colName: 'CubicleName', value: insertVal.CubicleName }, { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'Stage', value: insertVal.Stage }, { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    { str_colName: 'NomDiam', value: insertVal.NomDiam },{ str_colName: 'PosTolDiam', value: insertVal.PosTolDiam },
                    { str_colName: 'NegTolDiam', value: insertVal.NegTolDiam },{ str_colName: 'HTMake', value: insertVal.HTMake },
                    { str_colName: 'CheckedByTime', value: insertVal.CheckedByTime }
                ]
            }
            var res = await database.save(insertTempObj);

            var selectDetailObj = {
                str_tableName: detailTableName,
                data: '*',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }

            var result = await database.select(selectDetailObj);

            for (const v of result[0]) {
                var insertDetail = {
                    str_tableName: 'tbl_temp_tab_detailhtd',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'MstSerNo', value: v.MstSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DataValueThick', value:  (typeof(v.DataValueThick) == "string") ? v.DataValueThick : Number(v.DataValueThick).toFixed(2) },
                        { str_colName: 'DataValueDOLOBO', value: (typeof(v.DataValueDOLOBO) == "string") ? v.DataValueDOLOBO : Number(v.DataValueDOLOBO).toFixed(2) },
                        { str_colName: 'DataValueHard', value:(typeof(v.DataValueHard) == "string") ? v.DataValueHard : Number(v.DataValueHard).toFixed(intHardDP) },
                        { str_colName: 'DataValueDiam', value:(typeof(v.DataValueDiam) == "string") ? v.DataValueDiam : Number(v.DataValueDiam).toFixed(2) },
                        { str_colName: 'DecimalPointThick', value: v.DecimalPointThick },
                        { str_colName: 'DecimalPointDOLOBO', value: v.DecimalPointDOLOBO },
                        { str_colName: 'DecimalPointHard', value: v.DecimalPointHard },
                        { str_colName: 'DecimalPointDiam', value: v.DecimalPointDiam },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    ]
                }
                var result = await database.save(insertDetail);
            }
            return 'inserted';
        } catch (error) {
            console.log(error);
            return error;
        }
    }
    /**
    * 
    * @param {*} insertVal Data from master table
    * @param {*} ip Ip of requested hosst
    * @param {*} detailTableName Detail TableName
    * @param {*} RepSerNo Report serial number
    * @description Function inserts data in `temporary table` from `permanent tables`
    */
    async insertDTTempTables(insertVal, ip, detailTableName, RepSerNo, proj_name) {
        try {

            var insertTempObj = {
                str_tableName: 'tbl_temp_masterdt',
                data: [
                    { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                    { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                    { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                    { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                    { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                    { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                    { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                    { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                    { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                    { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                    { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                    { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                    { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                    { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'PosTol', value: Number(insertVal.T1PosTol).toFixed(1) },
                    { str_colName: 'NegTol', value: Number(insertVal.T1NegTol).toFixed(1) }, { str_colName: 'MinTemp', value: Number(insertVal.MinTemp).toFixed(1) },
                    { str_colName: 'MaxTemp', value: Number(insertVal.MaxTemp).toFixed(1) }, { str_colName: 'NomEmpty', value: insertVal.NomEmpty },
                    { str_colName: 'PosTolEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'NegTolEmpty', value: insertVal.T1NegEmpty },
                    { str_colName: 'NomNet', value: insertVal.NomNet }, { str_colName: 'PosTolNet', value: insertVal.T1PosNet },
                    { str_colName: 'NegTolNet', value: insertVal.T1NegNet }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                    { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                    { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                    { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'HardnessID', value: insertVal.HardnessID },
                    { str_colName: 'CubicleName', value: insertVal.CubicleName }, { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },

                    { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                    { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                    { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                    { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                    { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                    { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                    { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                    { str_colName: 'Media', value: insertVal.Media },{ str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'Lot', value: insertVal.Lot  },
                    { str_colName: 'DTID', value: insertVal.DTID  },{ str_colName: 'DT_Mode', value: insertVal.DT_Mode  },
                    { str_colName: 'DT_SetTemp', value: insertVal.DT_SetTemp  },{ str_colName: 'DT_Jar', value: insertVal.DT_Jar },
                    { str_colName: 'DT_BasketType', value: insertVal.DT_BasketType  },{ str_colName: 'CheckedByTime', value: insertVal.CheckedByTime }
                ]
            }
            var res = await database.save(insertTempObj);

            var selectDetailObj = {
                str_tableName: detailTableName,
                data: '*',
                condition: [
                    { str_colName: 'RepSerNo', value: RepSerNo }
                ]
            }
            var result = await database.select(selectDetailObj);
            var int_sideForReports =  serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'SideSingleText').Value;// Text :- 1: Single 0: NA
            for (const v of result[0]) {
                var side;
                if(int_sideForReports == '1'){
                    if((insertVal.Side == "NA") || (insertVal.Side == "Single")){
                        side = "Single"; 
                    }else{
                        side = v.DT_Side;
                    }
                }else{
                    side = v.DT_Side;
                }
                var insertDetail = {
                    str_tableName: 'tbl_temp_detaildt',
                    data: [
                        { str_colName: 'RepSerNo', value: v.RepSerNo },
                        { str_colName: 'MstSerNo', value: v.MstSerNo },
                        { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                        { str_colName: 'DT_StartDate', value: v.DT_StartDate },
                        { str_colName: 'DT_Side', value: side },
                        { str_colName: 'DT_BasketID', value: v.DT_BasketID },
                        { str_colName: 'DT_Temp', value: v.DT_Temp },
                        { str_colName: 'DT_StartTm', value: v.DT_StartTm },
                        { str_colName: 'DT_EndTm', value: v.DT_EndTm },
                        { str_colName: 'DT_TimeMinSec', value: v.DT_TimeMinSec },
                        { str_colName: 'DT_RunTime', value: v.DT_RunTime },
                        { str_colName: 'DT_Remark', value: v.DT_Remark },
                        { str_colName: 'DT_DoneByID', value: v.DT_DoneByID },
                        { str_colName: 'DT_DoneByName', value: v.DT_DoneByName },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                        { str_colName: 'DT_HaltDur', value: v.DT_HaltDur },
                    ]
                }
                var result = await database.save(insertDetail);
            }
            return 'inserted';

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async insertDiff(insertVal, ip, detailTableName, RepSerNo) {
        try {
            var bln_multiComponent = (serverConfig.developerPanelData.MultiComponent.find(x => x.Name === 'Content1').Value == 1)?true:false;
            if(bln_multiComponent) // Only For Capsule Multicomponent
            {
                var int_dp = insertVal.DecimalPoint;
                var insertTempObj = {
                    str_tableName: 'tbl_temp_masterdiff',
                    data: [
                        { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                        { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                        { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                        { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                        { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                        { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                        { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                        { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                        { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                        { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                        { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                        { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                        { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                        { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: insertVal.T1NegTol },
                        { str_colName: 'T1PosTol', value: insertVal.T1PosTol }, { str_colName: 'T2NegTol', value: Number(insertVal.T2NegTol).toFixed(1) },
                        { str_colName: 'T2PosTol', value: Number(insertVal.T2PosTol).toFixed(1) }, { str_colName: 'limitOn', value: insertVal.limitOn },
                        { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                        { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                        { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                        { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                        { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                        { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                        { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                        { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                        { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                        { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                        { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                        { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                        { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                        { str_colName: 'GraphType', value: insertVal.GraphType }, {str_colName: 'GraphTypeNet', value: insertVal.GraphTypeNet},
                         { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                        { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                        { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                        { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'CheckedByTime', value: insertVal.CheckedByTime },
                        { str_colName: 'Lot', value: insertVal.Lot },
                        { str_colName: 'Content1Desc', value: insertVal.Content1Desc },
                        { str_colName: 'Content2Desc', value: insertVal.Content2Desc },
                        { str_colName: 'Content3Desc', value: insertVal.Content3Desc },
                        { str_colName: 'Content4Desc', value: insertVal.Content4Desc },
                        { str_colName: 'Content1Type', value: insertVal.Content1Type },
                        { str_colName: 'Content2Type', value: insertVal.Content2Type },
                        { str_colName: 'Content3Type', value: insertVal.Content3Type },
                        { str_colName: 'Content4Type', value: insertVal.Content4Type },
                        { str_colName: 'NomContent1', value: insertVal.NomContent1 },
                        { str_colName: 'T1NegContent1', value: insertVal.T1NegContent1 },
                        { str_colName: 'T1PosContent1', value: insertVal.T1PosContent1 },
                        { str_colName: 'T2NegContent1', value: insertVal.T2NegContent1 },
                        { str_colName: 'T2PosContent1', value: insertVal.T2PosContent1 },
                        { str_colName: 'limitOnContent1', value: insertVal.limitOnContent1 },
                        { str_colName: 'NMTTabContent1', value: insertVal.NMTTabContent1 },
                        { str_colName: 'GraphTypeContent1', value: insertVal.GraphTypeContent1 },
                        { str_colName: 'NomContent2', value: insertVal.NomContent2 },
                        { str_colName: 'T1NegContent2', value: insertVal.T1NegContent2 },
                        { str_colName: 'T1PosContent2', value: insertVal.T1PosContent2 },
                        { str_colName: 'T2NegContent2', value: insertVal.T2NegContent2 },
                        { str_colName: 'T2PosContent2', value: insertVal.T2PosContent2 },
                        { str_colName: 'limitOnContent2', value: insertVal.limitOnContent2 },
                        { str_colName: 'NMTTabContent2', value: insertVal.NMTTabContent2 },
                        { str_colName: 'GraphTypeContent2', value: insertVal.GraphTypeContent2 },
                        { str_colName: 'NomContent3', value: insertVal.NomContent3 },
                        { str_colName: 'T1NegContent3', value: insertVal.T1NegContent3 },
                        { str_colName: 'T1PosContent3', value: insertVal.T1PosContent3 },
                        { str_colName: 'T2NegContent3', value: insertVal.T2NegContent3 },
                        { str_colName: 'T2PosContent3', value: insertVal.T2PosContent3 },
                        { str_colName: 'limitOnContent3', value: insertVal.limitOnContent3 },
                        { str_colName: 'NMTTabContent3', value: insertVal.NMTTabContent3 },
                        { str_colName: 'GraphTypeContent3', value: insertVal.GraphTypeContent3 },
                        { str_colName: 'NomContent4', value: insertVal.NomContent4 },
                        { str_colName: 'T1NegContent4', value: insertVal.T1NegContent4 },
                        { str_colName: 'T1PosContent4', value: insertVal.T1PosContent4 },
                        { str_colName: 'T2NegContent4', value: insertVal.T2NegContent4 },
                        { str_colName: 'T2PosContent4', value: insertVal.T2PosContent4 },
                        { str_colName: 'limitOnContent4', value: insertVal.limitOnContent4 },
                        { str_colName: 'NMTTabContent4', value: insertVal.NMTTabContent4 },
                        { str_colName: 'GraphTypeContent4', value: insertVal.GraphTypeContent4 }
                    ]
                }
                var res = await database.save(insertTempObj);
                var selectDetailObj = {
                    str_tableName: detailTableName,
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: RepSerNo }
                    ]
                }
                var result = await database.select(selectDetailObj);
                for (const v of result[0]) {
                    var insertDetail = {
                        str_tableName: 'tbl_temp_detaildiff',
                        data: [
                            { str_colName: 'RepSerNo', value: v.RepSerNo },
                            { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                            { str_colName: 'DataValue', value: Number(v.DataValue).toFixed(int_dp) },
                            { str_colName: 'DataValue1', value: Number(v.DataValue1).toFixed(int_dp) },
                            { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                            { str_colName: 'NetWeight', value: Number(v.NetWeight).toFixed(int_dp) },
                            { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                            { str_colName: 'Content1', value: Number(v.Content1).toFixed(int_dp) },
                            { str_colName: 'Content2', value: Number(v.Content2).toFixed(int_dp) },
                            { str_colName: 'Content3', value: Number(v.Content3).toFixed(int_dp) },
                            { str_colName: 'Content4', value: Number(v.Content4).toFixed(int_dp) }
                        ]
                    }
                    var result = await database.save(insertDetail);
                }
            }
            else // Only For Capsule Differencial
            {
                var int_dp = insertVal.DecimalPoint;
                var insertTempObj = {
                    str_tableName: 'tbl_temp_masterdiff',
                    data: [
                        { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                        { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                        { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                        { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                        { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                        { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                        { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                        { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                        { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                        { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                        { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                        { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                        { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                        { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: insertVal.T1NegTol },
                        { str_colName: 'T1PosTol', value: insertVal.T1PosTol }, { str_colName: 'T2NegTol', value: Number(insertVal.T2NegTol).toFixed(1) },
                        { str_colName: 'T2PosTol', value: Number(insertVal.T2PosTol).toFixed(1) }, { str_colName: 'limitOn', value: insertVal.limitOn },
                        { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                        { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                        { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                        { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                        { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                        { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                        { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                        { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                        { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                        { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                        { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                        { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                        { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                        { str_colName: 'GraphType', value: insertVal.GraphType }, {str_colName: 'GraphTypeNet', value: insertVal.GraphTypeNet}, 
                        { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                        { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                        { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                        { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'CheckedByTime', value: insertVal.CheckedByTime },
                        { str_colName: 'Lot', value: insertVal.Lot }
                    ]
                }
                var res = await database.save(insertTempObj);
    
                var selectDetailObj = {
                    str_tableName: detailTableName,
                    data: '*',
                    condition: [
                        { str_colName: 'RepSerNo', value: RepSerNo }
                    ]
                }
                var result = await database.select(selectDetailObj);
    
                for (const v of result[0]) {
                    var insertDetail = {
                        str_tableName: 'tbl_temp_detaildiff',
                        data: [
                            { str_colName: 'RepSerNo', value: v.RepSerNo },
                            { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                            { str_colName: 'DataValue', value: Number(v.DataValue).toFixed(int_dp) },
                            { str_colName: 'DataValue1', value: Number(v.DataValue1).toFixed(int_dp) },
                            { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                            { str_colName: 'NetWeight', value: Number(v.NetWeight).toFixed(int_dp) },
                            { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                        ]
                    }
                    var result = await database.save(insertDetail);
                }
            }
            return 'inserted';
        } catch (error) {
            console.log(error);
            return error;
        }
    }

    commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom) {
        var masterTableName, detailTableName, intWeighmentSrNo, strPrintTableName;
        var int_isHTD =  serverConfig.developerPanelData.IncrencyCommon.find(x => x.Name === 'Hardness_htdTable').Value;// 1 : htd table , 0 : 7 table
        switch (reportOption) {
            case 'Individual':
                intWeighmentSrNo = 1;
                strPrintTableName = "tbl_tab_print1";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master1';
                        detailTableName = 'tbl_tab_detail1';
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master1_archived';
                        detailTableName = 'tbl_tab_detail1_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master1_incomplete';
                        detailTableName = 'tbl_tab_detail1_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Group':
                intWeighmentSrNo = 2;
                strPrintTableName = "tbl_tab_print2";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master2';
                        detailTableName = 'tbl_tab_detail2'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master2_archived';
                        detailTableName = 'tbl_tab_detail2_archived'
                    }
                }
                break;
            case 'Thickness':
                intWeighmentSrNo = 3;
                strPrintTableName = "tbl_tab_print3";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master3';
                        detailTableName = 'tbl_tab_detail3'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master3_archived';
                        detailTableName = 'tbl_tab_detail3_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master3_incomplete';
                        detailTableName = 'tbl_tab_detail3_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Diameter':
                intWeighmentSrNo = 6;
                strPrintTableName = "tbl_tab_print6";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master6';
                        detailTableName = 'tbl_tab_detail6'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master6_archived';
                        detailTableName = 'tbl_tab_detail6_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master6_incomplete';
                        detailTableName = 'tbl_tab_detail6_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Breadth':
                intWeighmentSrNo = 4;
                strPrintTableName = "tbl_tab_print4";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master4';
                        detailTableName = 'tbl_tab_detail4'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master4_archived';
                        detailTableName = 'tbl_tab_detail4_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master4_incomplete';
                        detailTableName = 'tbl_tab_detail4_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Length':
                intWeighmentSrNo = 5;
                strPrintTableName = "tbl_tab_print5";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master5';
                        detailTableName = 'tbl_tab_detail5'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master5_archived';
                        detailTableName = 'tbl_tab_detail5_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master5_incomplete';
                        detailTableName = 'tbl_tab_detail5_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Individual Layer1':
                intWeighmentSrNo = 9;
                strPrintTableName = "tbl_tab_print9";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master9';
                        detailTableName = 'tbl_tab_detail9'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master9_archived';
                        detailTableName = 'tbl_tab_detail9_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master9_incomplete';
                        detailTableName = 'tbl_tab_detail9_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Individual Empty': //RB
                intWeighmentSrNo = 9;
                strPrintTableName = "tbl_tab_print9";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master9';
                        detailTableName = 'tbl_tab_detail9'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master9_archived';
                        detailTableName = 'tbl_tab_detail9_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master9_incomplete';
                        detailTableName = 'tbl_tab_detail9_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Group Layer1':
                intWeighmentSrNo = 10;
                strPrintTableName = "tbl_tab_print10";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master10';
                        detailTableName = 'tbl_tab_detail10'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master10_archived';
                        detailTableName = 'tbl_tab_detail10_archived'
                    }
                }
                break;
            case 'Individual Layer2':
                intWeighmentSrNo = 11;
                strPrintTableName = "tbl_tab_print11";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master11';
                        detailTableName = 'tbl_tab_detail11'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master11_archived';
                        detailTableName = 'tbl_tab_detail11_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master11_incomplete';
                        detailTableName = 'tbl_tab_detail11_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Group Layer2':
                intWeighmentSrNo = 12;
                strPrintTableName = "tbl_tab_print12";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master12';
                        detailTableName = 'tbl_tab_detail12'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master12_archived';
                        detailTableName = 'tbl_tab_detail12_archived'
                    }
                }
                break;
            case 'Disintegration Tester':
                intWeighmentSrNo = 13;
                strPrintTableName = "tbl_tab_print13";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master13';
                        detailTableName = 'tbl_tab_detail13'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master13_archived';
                        detailTableName = 'tbl_tab_detail13_archived'
                    }
                }
                break;
            case 'Hardness':
                    var intWeighmentSrNo = 7;
                    var strPrintTableName = "tbl_tab_print7";
                if(int_isHTD == '0')
                {
                    if (reportType == 'Complete') {
                        if (recordFrom == 'Current') { //current Complete
                            masterTableName = 'tbl_tab_master7';
                            detailTableName = 'tbl_tab_detail7'
                        } else {  //archive Complete
                            masterTableName = 'tbl_tab_master7_archived';
                            detailTableName = 'tbl_tab_detail7_archived'
                        }
                    } else {
                        if (recordFrom == 'Current') { // current Incomplete
                            masterTableName = 'tbl_tab_master7_incomplete';
                            detailTableName = 'tbl_tab_detail7_incomplete'
                        } else {
                            // TO - DO for incomplete archive
                        }
                    }
                }
                else
                {
                    if (reportType == 'Complete') {
                        if (recordFrom == 'Current') { //current Complete
                            masterTableName = 'tbl_tab_masterhtd';
                            detailTableName = 'tbl_tab_detailhtd'
                        } else {  //archive Complete
                            masterTableName = 'tbl_tab_masterhtd_archived';
                            detailTableName = 'tbl_tab_detailhtd_archived'
                        }
                    } else {
                        if (recordFrom == 'Current') { // current Incomplete
                            masterTableName = 'tbl_tab_masterhtd_incomplete';
                            detailTableName = 'tbl_tab_detailhtd_incomplete'
                        } else {
                            // TO - DO for incomplete archive
                        }
                    }
                }
                
                break;
            case 'Friabilator':
                intWeighmentSrNo = 8;
                strPrintTableName = "tbl_tab_print8";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_friability';
                        detailTableName = ''
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_friability_archived';
                        detailTableName = ''
                    }
                }
                break;
            case 'Moisture Analyzer':
                intWeighmentSrNo = 16;
                strPrintTableName = "tbl_tab_print16";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_lodmaster';
                        detailTableName = ''
                    } else {  //archive Complete
                        masterTableName = 'tbl_lodmaster_archived';
                        detailTableName = ''
                    }
                }
                break;
            case 'Tapped Density':
                intWeighmentSrNo = 15;
                strPrintTableName = "tbl_tab_print15";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_tapdensity';
                        detailTableName = ''
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_tapdensity_archived';
                        detailTableName = ''
                    }
                }
                break;
            case 'Particle Size':
                intWeighmentSrNo = 18;
                strPrintTableName = "tbl_tab_print18";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master18';
                        detailTableName = 'tbl_tab_detail18'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master18_archived';
                        detailTableName = 'tbl_tab_detail18_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master18_incomplete';
                        detailTableName = 'tbl_tab_detail18_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Fine %':
                intWeighmentSrNo = 17;
                strPrintTableName = "tbl_tab_print17";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_master17';
                        detailTableName = 'tbl_tab_detail17'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_master17_archived';
                        detailTableName = 'tbl_tab_detail17_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_master17_incomplete';
                        detailTableName = 'tbl_tab_detail17_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            case 'Dosa Dry Syrup':
            intWeighmentSrNo = 19;
            strPrintTableName = "tbl_tab_print19";
            if (reportType == 'Complete') {
                if (recordFrom == 'Current') { //current Complete
                    masterTableName = 'tbl_tab_master19';
                    detailTableName = 'tbl_tab_detail19'
                } else {  //archive Complete
                    masterTableName = 'tbl_tab_master19_archived';
                    detailTableName = 'tbl_tab_detail19_archived'
                }
            } else {
                if (recordFrom == 'Current') { // current Incomplete
                    masterTableName = 'tbl_tab_master19_incomplete';
                    detailTableName = 'tbl_tab_detail19_incomplete'
                } else {
                    // TO - DO for incomplete archive
                }
            }
            break;
            case 'Tablet Tester':
                intWeighmentSrNo = 7;
                strPrintTableName = "tbl_tab_printtt";
                if (reportType == 'Complete') {
                    if (recordFrom == 'Current') { //current Complete
                        masterTableName = 'tbl_tab_masterhtd';
                        detailTableName = 'tbl_tab_detailhtd'
                    } else {  //archive Complete
                        masterTableName = 'tbl_tab_masterhtd_archived';
                        detailTableName = 'tbl_tab_detailhtd_archived'
                    }
                } else {
                    if (recordFrom == 'Current') { // current Incomplete
                        masterTableName = 'tbl_tab_masterhtd_incomplete';
                        detailTableName = 'tbl_tab_detailhtd_incomplete'
                    } else {
                        // TO - DO for incomplete archive
                    }
                }
                break;
            default:
                break;
        }
        return {
            masterTableName: masterTableName, detailTableName: detailTableName,
            intWeighmentSrNo: intWeighmentSrNo, strPrintTableName: strPrintTableName
        }
    }
}
module.exports = TabletModel