const requestIp = require('request-ip');
const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const sequelize = require("../dbConnection").sequelize;
const { QueryTypes } = require('sequelize');
const { Op } = require("sequelize");
serverConfig = require('../../DeveloperPanel-CP10G.json');

class TabletCapsuleModel {

    async viewSeparateReport(value, req) {
        try {
            const responseObj = {};
            const int_ReportFormat = value.int_ReportFormat;
            const clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3];
            if ((("idsNo" in value) == true)) {
                ip = `${serverConfig.strIpSeries}${value.idsNo}`;
            } else if (ip === undefined) {
                ip = '127.0.0.1';
            }

            if (value.str_source == "Auto") {
                ip = value.str_hmi;
                console.log("Autoip", ip);
            }

            const int_hmiID = ip;
            const reportOption = value.reportOption;
            const reportType = value.reportType;
            const recordFrom = value.recordFrom;
            const repSerNo = value.RepSerNo;
            const userId = value.userId;
            const userName = value.username;
            const productType = (value.str_url == 'Tablet') ? 1 : 2;
            let testType = value.testType;
            let masterTableName = "", detailTableName = "", WeighmentModeNo = 0;
            if (testType == 'Regular') {
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;
            WeighmentModeNo = ObjTables.intWeighmentSrNo;
            const tbl_TempMaster = ObjTables.MstTempTbl;
            const tbl_TempDetail = ObjTables.DetTempTbl;

            const selectMasterData = await models[masterTableName].findAll({
                where: {
                    RepSerNo: repSerNo
                }
            });

            if (ObjTables.blnIsTempTable == true) {
                // Start Deleting previous Data from temporary Tables.
                await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail);
                // Completed Deleting previous Data from temporary Tables.

                /**getHeading for report */
                var str_heading = await this.headingForReport(value,selectMasterData[0]);

                // Start Inserting records of permanent table into temporary Tables.
                if (reportOption == 'Individual' || reportOption == 'Group' || 
                    reportOption == 'Thickness' || reportOption == 'Breadth' ||  
                    reportOption == 'Width' || reportOption == 'Length' || reportOption == 'Locked Length' || 
                    reportOption == 'Diameter' || 
                    reportOption == 'Individual Layer 1' || reportOption == 'Individual Layer 2' ||
                    reportOption == 'Group Layer 1' || reportOption == 'Group Layer 2' || reportOption == 'Appearance' || reportOption == 'Differential') 
                {
                    const res_Obj = await this.insertIndividualTempTables(value, selectMasterData[0], int_hmiID, 
                        detailTableName, repSerNo, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail,str_heading);
                    Object.assign(responseObj, res_Obj);
                
                } else if (reportOption == 'DT' || reportOption == 'DT Layer 1' || reportOption == 'DT Layer 2') 
                {
                    const res_Obj = await this.insertDisintegrationTestTempTables(value, selectMasterData[0], int_hmiID, 
                        detailTableName, repSerNo, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail,str_heading);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Particle Size' || reportOption == 'Particle Size Layer 1' || 
                    reportOption == 'Particle Size Layer 2' || reportOption == 'Fine %' ||
                    reportOption == '% Fine' || reportOption == '% Fine Layer 1' || reportOption == '% Fine Layer 2') 
                {
                    const res_Obj = await this.insertParticleSizeTempTable(value, selectMasterData[0], int_hmiID, 
                        detailTableName, repSerNo, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail,str_heading);
                    Object.assign(responseObj, res_Obj);

                }
                else if(reportOption == 'Hardness'){
                    const res_Obj = await this.insertHardnessTempTables_Con(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail,str_heading);
                    Object.assign(responseObj, res_Obj);
                }
                // Completed Inserting records of permanent table into temporary Tables.
            }

            if (reportOption == 'Friability' || reportOption == 'LOD' || reportOption == 'LOD Layer 1' || 
                reportOption == 'LOD Layer 2' || reportOption == 'Tapped Density' || 
                reportOption == 'Tapped Density Layer 1' || reportOption == 'Tapped Density Layer 2') 
            {
                var str_heading = await this.headingForReport(value,selectMasterData[0]);
                let RptRemark = 'NA';
                if (selectMasterData.length > 0) {
                    RptRemark = selectMasterData[0].Remark;
                }
                Object.assign(responseObj, {
                    waterMark: true,
                    printNo: value.printNo,
                    UserId: userId,
                    UserName: userName,
                    SelectedValue: repSerNo,
                    HmiId: int_hmiID,
                    WgmtModeNo: WeighmentModeNo,
                    ProductType: productType,
                    ICReport: reportType,
                    ReportRemark: RptRemark,
                    batchNo: value.batchNo,
                    cubicleType: value.cubicleType,
                    Side:value.Side,
                    heading: str_heading.str_head
                });
            }
            return responseObj;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async headingForReport(values,str_masterData)
    {
        try {
            var str_head = ""; 
            
            if(values.reportOption == "Individual")
            {
                str_head = (values.testType == "Regular") ?
                 (values.reportType == 'Complete')? "REGULAR INDIVIDUAL WEIGHT VARIATION REPORT" : "INCOMPLETE REGULAR INDIVIDUAL WEIGHT VARIATION REPORT" 
                 : 
                 (values.reportType == 'Complete')? "INITIAL INDIVIDUAL WEIGHT VARIATION REPORT" : "INCOMPLETE INITIAL INDIVIDUAL WEIGHT VARIATION REPORT";
            }
            else if(values.reportOption == "Group")
            {
                str_head = (values.testType == "Regular") ? "REGULAR GROUP WEIGHT VARIATION REPORT" : "INITIAL GROUP WEIGHT VARIATION REPORT" ;
            }
            else if(values.reportOption == "Locked Length")
            {
                str_head = (values.testType == "Regular") ?
                (values.reportType == 'Complete')? "REGULAR LOCKED LENGTH VARIATION REPORT" : "INCOMPLETE REGULAR LOCKED LENGTH VARIATION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL LOCKED LENGTH VARIATION REPORT" : "INCOMPLETE INITIAL LOCKED LENGTH VARIATION REPORT";
            }
            else if(values.reportOption == "Hardness")
            {
                str_head = (values.testType == "Regular") ? 
                (values.reportType == 'Complete')? "REGULAR HARDNESS & DIMENSION REPORT" : "INCOMPLETE REGULAR HARDNESS & DIMENSION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL HARDNESS & DIMENSION REPORT" : "INCOMPLETE INITIAL HARDNESS & DIMENSION REPORT";
            }
            else if(values.reportOption == "Thickness")
            {
                str_head = (values.testType == "Regular") ?
                (values.reportType == 'Complete')? "REGULAR THICKNESS VARIATION REPORT" : "INCOMPLETE REGULAR THICKNESS VARIATION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL THICKNESS VARIATION REPORT" : "INCOMPLETE INITIAL THICKNESS VARIATION REPORT";
            }
            else if(values.reportOption == "Diameter")
            {
                str_head = (values.testType == "Regular") ? 
                (values.reportType == 'Complete')? "REGULAR DIAMETER VARIATION REPORT" : "INCOMPLETE REGULAR DIAMETER VARIATION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL DIAMETER VARIATION REPORT" : "INCOMPLETE INITIAL DIAMETER VARIATION REPORT";
            }
            else if(values.reportOption == "Length")
            {
                str_head = (values.testType == "Regular") ? 
                (values.reportType == 'Complete')? "REGULAR LENGTH VARIATION REPORT" : "INCOMPLETE REGULAR LENGTH VARIATION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL LENGTH VARIATION REPORT" : "INCOMPLETE INITIAL LENGTH VARIATION REPORT";
            }
            else if(values.reportOption == "Breadth")
            {
                str_head = (values.testType == "Regular") ? 
                (values.reportType == 'Complete')? "REGULAR BREADTH VARIATION REPORT" : "INCOMPLETE REGULAR BREADTH VARIATION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL BREADTH VARIATION REPORT" : "INCOMPLETE INITIAL BREADTH VARIATION REPORT";
            }
            else if(values.reportOption == "Differential")
            {
                str_head = (values.testType == "Regular") ? 
                (values.reportType == 'Complete')? "REGULAR DIFFERENTIAL WEIGHT VARIATION REPORT" : "INCOMPLETE REGULAR DIFFERENTIAL WEIGHT VARIATION REPORT"
                : 
                (values.reportType == 'Complete')? "INITIAL DIFFERENTIAL WEIGHT VARIATION REPORT" : "INCOMPLETE INITIAL DIFFERENTIAL WEIGHT VARIATION REPORT";
            }
            else if(values.reportOption == "LOD")
            {
                str_head = "LOSS ON DRYING (LOD) TEST REPORT";
            }
            else if(values.reportOption == "Friability")
            {
                str_head = (values.testType == "Regular") ? "REGULAR FRIABILITY REPORT" : "INITIAL FRIABILITY REPORT";
            }
            else if(values.reportOption == "DT")
            {
                str_head = (values.testType == "Regular") ? "REGULAR DISINTEGRATION TEST REPORT" : "INITIAL DISINTEGRATION TEST REPORT";
            }
            else if(values.reportOption == "Fine %" || values.reportOption == "% Fine")
            {
                str_head = (values.reportType == 'Complete')? "%FINES BELOW 60 MESH TEST REPORT" : "INCOMPLETE %FINES BELOW 60 MESH TEST REPORT";
            }
            else if(values.reportOption == "Particle Size")
            {
                str_head = (values.reportType == 'Complete')? "PARTICLE SIZE DISTRIBUTION TEST REPORT" : "INCOMPLETE PARTICLE SIZE DISTRIBUTION TEST REPORT";
            }
            else if(values.reportOption == "Tapped Density")
            {
                str_head = "BULK / TAPPED DENSITY TEST REPORT";
            }
            else
            {
                str_head = "";
            }

            var resd = {};
            Object.assign(resd,{str_head:str_head})
            return resd;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    // Deleting previous Data from temporary Tables.
    async DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail) {
        try {
            const deleteTempMaster = await models[tbl_TempMaster].destroy({
                where: {
                    HMIID: int_hmiID
                }
            });
            console.log(`Deleted Rows from Temp Master(${tbl_TempMaster}) for ${int_hmiID} ==> ${deleteTempMaster} affectedRows`);

            const deleteTempDetail = await models[tbl_TempDetail].destroy({
                where: { HMIID: int_hmiID }
            });
            console.log(`Deleted Rows from Temp Detail(${tbl_TempDetail}) for ${int_hmiID} ==> ${deleteTempDetail} affectedRows`);

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    //  Inserting records of permanent table into temporary Tables. 
    async insertIndividualTempTables(value, selectMasterData, int_hmiID, detailTableName, repSerNo, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail, str_heading) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const insertTempMater = {
                    RepSerNo: selectMasterData.RepSerNo,
                    MstSerNo: selectMasterData.MstSerNo,
                    WgmtModeNo: selectMasterData.WgmtModeNo,
                    ProductType: selectMasterData.ProductType,
                    Area: selectMasterData.Area,
                    CubicalNo: selectMasterData.CubicalNo,
                    CubicleName: selectMasterData.CubicleName,
                    CubicleType: selectMasterData.CubicleType,
                    IPQCType: selectMasterData.IPQCType,
                    CoatingType: selectMasterData.CoatingType,
                    MachineCode: selectMasterData.MachineCode,
                    Department: selectMasterData.Department,
                    BFGCode: selectMasterData.BFGCode,
                    ProductName: selectMasterData.ProductName,
                    PVersion: selectMasterData.PVersion,
                    Version: selectMasterData.Version,
                    BatchNo: selectMasterData.BatchNo,
                    BatchSize: selectMasterData.BatchSize,
                    BMRNo: selectMasterData.BMRNo,
                    GraphType: selectMasterData.GraphType,
                    Qty: selectMasterData.Qty,
                    GrpQty: selectMasterData.GrpQty,
                    GrpFreq: selectMasterData.GrpFreq,
                    Idsno: selectMasterData.Idsno,
                    BalanceId: selectMasterData.BalanceId,
                    VernierId: selectMasterData.VernierId,
                    FriabilityID: selectMasterData.FriabilityID,
                    HardnessID: selectMasterData.HardnessID,
                    UserId: selectMasterData.UserId,
                    UserName: selectMasterData.UserName,
                    PrDate: selectMasterData.PrDate,
                    PrTime: date.format(selectMasterData.PrTime, 'HH:mm:ss'),
                    PrEndDate: (selectMasterData.PrEndDate == null) ? 'NULL' : selectMasterData.PrEndDate,
                    PrEndTime: (selectMasterData.PrEndTime == null) ? 'NULL' : date.format(selectMasterData.PrEndTime, 'HH:mm:ss'),
                    SideNo: selectMasterData.SideNo,
                    Side: selectMasterData.Side,
                    Stage: selectMasterData.Stage,
                    Unit: selectMasterData.Unit,
                    DecimalPoint: selectMasterData.DecimalPoint,
                    LimitOn: selectMasterData.LimitOn,
                    NMT: selectMasterData.NMT,
                    Nom: selectMasterData.Nom,
                    T1NegTol: selectMasterData.T1NegTol,
                    T1PosTol: selectMasterData.T1PosTol,
                    T2NegTol: selectMasterData.T2NegTol,
                    T2PosTol: selectMasterData.T2PosTol,
                    T1NegTolActual: selectMasterData.T1NegTolActual,
                    T1PosTolActual: selectMasterData.T1PosTolActual,
                    T2NegTolActual: selectMasterData.T2NegTolActual,
                    T2PosTolActual: selectMasterData.T2PosTolActual,
                    NomEmpty: selectMasterData.NomEmpty,
                    T1NegEmpty: selectMasterData.T1NegEmpty,
                    T1PosEmpty: selectMasterData.T1PosEmpty,
                    T2NegEmpty: selectMasterData.T2NegEmpty,
                    T2PosEmpty: selectMasterData.T2PosEmpty,
                    NomNet: selectMasterData.NomNet,
                    T1NegNet: selectMasterData.T1NegNet,
                    T1PosNet: selectMasterData.T1PosNet,
                    T2NegNet: selectMasterData.T2NegNet,
                    T2PosNet: selectMasterData.T2PosNet,
                    T1NegNetActual: selectMasterData.T1NegNetActual,
                    T1PosNetActual: selectMasterData.T1PosNetActual,
                    T2NegNetActual: selectMasterData.T2NegNetActual,
                    T2PosNetActual: selectMasterData.T2PosNetActual,
                    ReportType: selectMasterData.ReportType,
                    PrintNo: selectMasterData.PrintNo,
                    IsArchived: selectMasterData.IsArchived,
                    BatchComplete: selectMasterData.BatchComplete,
                    CheckedByID: selectMasterData.CheckedByID,
                    CheckedByName: selectMasterData.CheckedByName,
                    CheckedByDate: selectMasterData.CheckedByDate,
                    CheckedByTime: date.format(selectMasterData.CheckedByTime, 'HH:mm:ss'),
                    Lot: selectMasterData.Lot,
                    StdLimit1: selectMasterData.StdLimit1,
                    StdLimit2: selectMasterData.StdLimit2,
                    NoOfAbove1: selectMasterData.NoOfAbove1,
                    NoOfBelow1: selectMasterData.NoOfBelow1,
                    NoOfAbove2: selectMasterData.NoOfAbove2,
                    NoOfBelow2: selectMasterData.NoOfBelow2,
                    MinPer: selectMasterData.MinPer,
                    MaxPer: selectMasterData.MaxPer,
                    GroupWeight: selectMasterData.GroupWeight,
                    AvgWeight: selectMasterData.AvgWeight,
                    AvgEmpty: selectMasterData.AvgEmpty,
                    AvgNet: selectMasterData.AvgNet,
                    MinWeight: selectMasterData.MinWeight,
                    MaxWeight: selectMasterData.MaxWeight,
                    MinWeightEmpty: selectMasterData.MinWeightEmpty,
                    MaxWeightEmpty: selectMasterData.MaxWeightEmpty,
                    MinWeightNet: selectMasterData.MinWeightNet,
                    MaxWeightNet: selectMasterData.MaxWeightNet,
                    StdDev: selectMasterData.StdDev,
                    Remark: selectMasterData.Remark,
                    FailedRemark: selectMasterData.FailedRemark,
                    FailedRemarkTSH: selectMasterData.FailedRemarkTSH,
                    Inprocess: selectMasterData.Inprocess,
                    Deviation: selectMasterData.Deviation,
                    LayerName: selectMasterData.LayerName,
                    Layer: selectMasterData.Layer,
                    HMIID: int_hmiID,
                    Nom_stdtarget: selectMasterData.Nom_stdtarget
                };

                if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                    value.reportOption == 'Group Layer 2') 
                {
                    insertTempMater.MinGrpWeight = selectMasterData.MinGrpWeight;
                    insertTempMater.MaxGrpWeight = selectMasterData.MaxGrpWeight;
                    insertTempMater.AvgGrpWeight = selectMasterData.AvgGrpWeight;
                    insertTempMater.Weight_Gain = selectMasterData.Weight_Gain;
                    insertTempMater.Start_Weight = selectMasterData.Start_Weight;
                    insertTempMater.End_Weight = selectMasterData.End_Weight;
                }
                if(value.reportOption == 'Appearance') {
                    insertTempMater.Upper_Surface = selectMasterData.Upper_Surface;
                    insertTempMater.Lower_Surface = selectMasterData.Lower_Surface;
                    insertTempMater.Appearance_Desc = selectMasterData.Appearance_Desc;
                    insertTempMater.Comp_MC_Speed = selectMasterData.Comp_MC_Speed;
                }

                await models[tbl_TempMaster].create(insertTempMater, {
                    transaction: t
                });

                const detailData = await models[detailTableName].findAll({
                    where: { RepSerNo: repSerNo }
                });

                for (const data of detailData) {
                    const insertTempDetail = {
                        RecNo: data.RecNo,
                        RepSerNo: data.RepSerNo,
                        MstSerNo: data.MstSerNo,
                        RecSeqNo: data.RecSeqNo,
                        DataValue: data.DataValue,
                        DataValue1: data.DataValue1,
                        NetValue: data.NetValue,
                        AvgWeight: data.AvgWeight,
                        Deviation: data.Deviation,
                        DP: data.DP,
                        UserId: data.UserId,
                        UserName: data.UserName,
                        PrDate: data.PrDate,
                        PrTime: date.format(data.PrTime, 'HH:mm:ss'),
                        PrEndDate: data.PrEndDate,
                        PrEndTime: date.format(data.PrEndTime, 'HH:mm:ss'),
                        BFGCode: data.BFGCode,
                        ProductName: data.ProductName,
                        Version: data.Version,
                        PVersion: data.PVersion,
                        Side: data.Side,
                        BatchNo: data.BatchNo,
                        InstrumentID: data.InstrumentID,
                        Remark: data.Remark,
                        WeighmentMode: WeighmentModeNo,
                        ProductType: productType,
                        HMIID: int_hmiID,
                        IPC_Code: data.IPC_Code
                    };

                    if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                        value.reportOption == 'Group Layer 2') 
                    {
                        insertTempDetail.NoOfSample = data.NoOfSample;
                    }
                    if(value.reportOption == 'Appearance') {
                        insertTempDetail.Actual_Speed = data.Actual_Speed;
                        insertTempDetail.TestResult = data.TestResult;
                    }

                    await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                }
                return "Success";
            });

            recSeqCount = await models[detailTableName].count({
                where: { RepSerNo: repSerNo }
            });

            if ((value.reportOption.includes("Group") == true) && selectMasterData.Side == 'LHS') {
                recSeqCount = await models[detailTableName].count({
                    where: {
                        RepSerNo: repSerNo,
                        Side: {
                            [Op.or]: ['LHS']
                        }
                    }
                });
            }

            if ((value.reportOption.includes("Group") == true) && selectMasterData.Side == 'LHS') {
                recSeqCountR = await models[detailTableName].count({
                    where: {
                        RepSerNo: repSerNo,
                        Side: {
                            [Op.or]: ['RHS']
                        }
                    }
                });
            }
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: Number(selectMasterData.PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: repSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: selectMasterData.Remark,
                heading: str_heading.str_head
            });
            return obj_res;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    // Inserting DT records of permanent table into temporary tables.
    async insertDisintegrationTestTempTables(value, selectMasterData, int_hmiID, detailTableName, repSerNo, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail, str_heading) 
    {
        try {
            const response = {};
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const insertDTTempMaster = await models[tbl_TempMaster].create({
                    RepSerNo: selectMasterData.RepSerNo,
                    MstSerNo: selectMasterData.MstSerNo,
                    WgmtModeNo: selectMasterData.WgmtModeNo,
                    ProductType: selectMasterData.ProductType,
                    Area: selectMasterData.Area,
                    CubicalNo: selectMasterData.CubicalNo,
                    CubicleName: selectMasterData.CubicleName,
                    CubicleType: selectMasterData.CubicleType,
                    IPQCType: selectMasterData.IPQCType,
                    CoatingType: selectMasterData.CoatingType,
                    MachineCode: selectMasterData.MachineCode,
                    Department: selectMasterData.Department,
                    BFGCode: selectMasterData.BFGCode,
                    ProductName: selectMasterData.ProductName,
                    PVersion: selectMasterData.PVersion,
                    Version: selectMasterData.Version,
                    BatchNo: selectMasterData.BatchNo,
                    BatchSize: selectMasterData.BatchSize,
                    BMRNo: selectMasterData.BMRNo,
                    GraphType: selectMasterData.GraphType,
                    Qty: selectMasterData.Qty,
                    GrpQty: selectMasterData.GrpQty,
                    GrpFreq: selectMasterData.GrpFreq,
                    Idsno: selectMasterData.Idsno,
                    InstrumentID: selectMasterData.InstrumentID,
                    UserId: selectMasterData.UserId,
                    UserName: selectMasterData.UserName,
                    PrDate: selectMasterData.PrDate,
                    PrTime: date.format(selectMasterData.PrTime, 'HH:mm:ss'),
                    PrEndDate: (selectMasterData.PrEndDate == null) ? 'NULL' : selectMasterData.PrEndDate,
                    PrEndTime: (selectMasterData.PrEndTime == null) ? 'NULL' : date.format(selectMasterData.PrEndTime, 'HH:mm:ss'),                   
                    SideNo: selectMasterData.SideNo,
                    Side: selectMasterData.Side,
                    Unit: selectMasterData.Unit,
                    DecimalPoint: selectMasterData.DecimalPoint,
                    LimitOn: selectMasterData.LimitOn,
                    T1NegTol: selectMasterData.T1NegTol,
                    T1PosTol: selectMasterData.T1PosTol,
                    Nom: selectMasterData.Nom,
                    ReportType: selectMasterData.ReportType,
                    PrintNo: selectMasterData.PrintNo,
                    IsArchived: selectMasterData.IsArchived,
                    BatchComplete: selectMasterData.BatchComplete,
                    CheckedByID: selectMasterData.CheckedByID,
                    CheckedByName: selectMasterData.CheckedByName,
                    CheckedByDate: selectMasterData.CheckedByDate,
                    CheckedByTime: date.format(selectMasterData.CheckedByTime, 'HH:mm:ss'),   
                    Media: selectMasterData.Media,
                    Lot: selectMasterData.Lot,
                    MinTemp: selectMasterData.MinTemp,
                    MaxTemp: selectMasterData.MaxTemp,
                    MinTime: selectMasterData.MinTime,
                    Jar: selectMasterData.Jar,
                    Remark: selectMasterData.Remark,
                    FailedRemark: selectMasterData.FailedRemark,
                    FailedRemarkTSH: selectMasterData.FailedRemarkTSH,
                    Inprocess: selectMasterData.Inprocess,
                    HMIID: int_hmiID,
                    MaxTime: selectMasterData.MaxTime,
                    Bath_Temp: selectMasterData.Bath_Temp,
                    Media_Temp: selectMasterData.Media_Temp,
                    Apparatus_Type: selectMasterData.Apparatus_Type,
                    MeshSize_Bolus: selectMasterData.MeshSize_Bolus,
                    TempRange: selectMasterData.TempRange
                }, { transaction: t });

                const tempDetailData = await models[detailTableName].findAll({
                    where: { RepSerNo: repSerNo }
                });

                for (const element of tempDetailData) {
                    await models[tbl_TempDetail].create({
                        RecNo: element.RecNo,
                        RepSerNo: element.RepSerNo,
                        MstSerNo: element.MstSerNo,
                        RecSeqNo: element.RecSeqNo,
                        DT_Side: element.DT_Side,
                        DT_Jar: element.DT_Jar,
                        DT_Temp: element.DT_Temp,
                        DT_StartDate: element.DT_StartDate,
                        DT_StartTm: element.DT_StartTm,
                        DT_EndTm: element.DT_EndTm,
                        DT_RunTime: element.DT_RunTime,
                        DT_Remark: element.DT_Remark,
                        DT_DoneByID: element.DT_DoneByID,
                        DT_DoneByName: element.DT_DoneByName,
                        DT_HaltDur: element.DT_HaltDur,
                        Layer: element.Layer,
                        LayerName: element.LayerName,
                        HMIID: int_hmiID,
                        WgmtModeNo: WeighmentModeNo,
                        ProductType: productType,
                    }, { transaction: t });
                }
                return "Success";
            });

            const cnt_recSeqNo = await models[detailTableName].count({
                where: { RepSerNo: repSerNo }
            });
            
            Object.assign(response, {
                waterMark: true,
                printNo: Number(selectMasterData.PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: repSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: cnt_recSeqNo,
                ReportRemark: selectMasterData.Remark,
                heading:str_heading.str_head
            });
            return response;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    // Inserting Paricle Size records of permanent table into temporary tables.       
    async insertParticleSizeTempTable(value, selectMasterData, int_hmiID, detailTableName, repSerNo, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail, str_heading) 
    {
        try {
            const obj_res = {};
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const insertTempData = await models[tbl_TempMaster].create({
                    RepSerNo: selectMasterData.RepSerNo,
                    MstSerNo: selectMasterData.MstSerNo,
                    WgmtModeNo: selectMasterData.WgmtModeNo,
                    ProductType: selectMasterData.ProductType,
                    Area: selectMasterData.Area,
                    CubicalNo: selectMasterData.CubicalNo,
                    CubicleName: selectMasterData.CubicleName,
                    CubicleType: selectMasterData.CubicleType,
                    IPQCType: selectMasterData.IPQCType,
                    CoatingType: selectMasterData.CoatingType,
                    MachineCode: selectMasterData.MachineCode,
                    Department: selectMasterData.Department,
                    BFGCode: selectMasterData.BFGCode,
                    ProductName: selectMasterData.ProductName,
                    PVersion: selectMasterData.PVersion,
                    Version: selectMasterData.Version,
                    BatchNo: selectMasterData.BatchNo,
                    BatchSize: selectMasterData.BatchSize,
                    BMRNo: selectMasterData.BMRNo,
                    GraphType: selectMasterData.GraphType,
                    Qty: selectMasterData.Qty,
                    GrpQty: selectMasterData.GrpQty,
                    GrpFreq: selectMasterData.GrpFreq,
                    Idsno: selectMasterData.Idsno,
                    BalanceId: selectMasterData.BalanceId,
                    VernierId: selectMasterData.VernierId,
                    FriabilityID: selectMasterData.FriabilityID,
                    HardnessID: selectMasterData.HardnessID,
                    UserId: selectMasterData.UserId,
                    UserName: selectMasterData.UserName,
                    PrDate: selectMasterData.PrDate,
                    PrTime: date.format(selectMasterData.PrTime, "HH:mm:ss"),
                    PrEndDate: selectMasterData.PrEndDate,
                    PrEndTime: date.format(selectMasterData.PrEndTime, "HH:mm:ss"),
                    SideNo: selectMasterData.SideNo,
                    Side: selectMasterData.Side,
                    Unit: selectMasterData.Unit,
                    DecimalPoint: selectMasterData.DecimalPoint,
                    LimitOn: selectMasterData.LimitOn,
                    NMT: selectMasterData.NMT,
                    Nom: selectMasterData.Nom,
                    T1NegTol: selectMasterData.T1NegTol,
                    T1PosTol: selectMasterData.T1PosTol,
                    T2NegTol: selectMasterData.T2NegTol,
                    T2PosTol: selectMasterData.T2PosTol,
                    T1NegTolActual: selectMasterData.T1NegTolActual,
                    T1PosTolActual: selectMasterData.T1PosTolActual,
                    T2NegTolActual: selectMasterData.T2NegTolActual,
                    T2PosTolActual: selectMasterData.T2PosTolActual,
                    NomEmpty: selectMasterData.NomEmpty,
                    T1NegEmpty: selectMasterData.T1NegEmpty,
                    T1PosEmpty: selectMasterData.T1PosEmpty,
                    T2NegEmpty: selectMasterData.T2NegEmpty,
                    T2PosEmpty: selectMasterData.T2PosEmpty,
                    NomNet: selectMasterData.NomNet,
                    T1NegNet: selectMasterData.T1NegNet,
                    T1PosNet: selectMasterData.T1PosNet,
                    T2NegNet: selectMasterData.T2NegNet,
                    T2PosNet: selectMasterData.T2PosNet,
                    T1NegNetActual: selectMasterData.T1NegNetActual,
                    T1PosNetActual: selectMasterData.T1PosNetActual,
                    T2NegNetActual: selectMasterData.T2NegNetActual,
                    T2PosNetActual: selectMasterData.T2PosNetActual,
                    ReportType: selectMasterData.ReportType,
                    PrintNo: selectMasterData.PrintNo,
                    IsArchived: selectMasterData.IsArchived,
                    BatchComplete: selectMasterData.BatchComplete,
                    CheckedByID: selectMasterData.CheckedByID,
                    CheckedByName: selectMasterData.CheckedByName,
                    CheckedByDate: selectMasterData.CheckedByDate,
                    CheckedByTime: date.format(selectMasterData.CheckedByTime,"HH:mm:ss"),
                    Lot: selectMasterData.Lot,
                    NoOfAbove1: selectMasterData.NoOfAbove1,
                    NoOfBelow1: selectMasterData.NoOfBelow1,
                    NoOfAbove2: selectMasterData.NoOfAbove2,
                    NoOfBelow2: selectMasterData.NoOfBelow2,
                    MinPer: selectMasterData.MinPer,
                    MaxPer: selectMasterData.MaxPer,
                    GroupWeight: selectMasterData.GroupWeight,
                    AvgWeight: selectMasterData.AvgWeight,
                    AvgEmpty: selectMasterData.AvgEmpty,
                    AvgNet: selectMasterData.AvgNet,
                    MinWeight: selectMasterData.MinWeight,
                    MaxWeight: selectMasterData.MaxWeight,
                    MinWeightEmpty: selectMasterData.MinWeightEmpty,
                    MaxWeightEmpty: selectMasterData.MaxWeightEmpty,
                    MinWeightNet: selectMasterData.MinWeightNet,
                    MaxWeightNet: selectMasterData.MaxWeightNet,
                    StdDev: selectMasterData.StdDev,
                    Remark: selectMasterData.Remark,
                    FailedRemark: selectMasterData.FailedRemark,
                    FailedRemarkTSH: selectMasterData.FailedRemarkTSH,
                    Inprocess: selectMasterData.Inprocess,
                    Layer: selectMasterData.Layer,
                    Stage: selectMasterData.Stage,
                    LayerName: selectMasterData.LayerName,
                    HMIID: int_hmiID,
                    StdLimit1: selectMasterData.StdLimit1,
                    StdLimit2: selectMasterData.StdLimit2
                }, { transaction: t });

                const tempDetailData = await models[detailTableName].findAll({
                    where: {
                        RepSerNo: repSerNo
                    }
                });

                for (const datavalue of tempDetailData) {
                    const insertTempDetail = {
                        RecNo: datavalue.RecNo,
                        RepSerNo: datavalue.RepSerNo,
                        MstSerNo: datavalue.MstSerNo,
                        RecSeqNo: datavalue.RecSeqNo,
                        DataValue: datavalue.DataValue,
                        DP: datavalue.DP,
                        MeshValue: datavalue.MeshValue,
                        QuantityRetained: datavalue.QuantityRetained,
                        HMIID: int_hmiID,
                        ProductType: productType,
                        WgmtModeNo: WeighmentModeNo,
                        T2NegTol: datavalue.T2NegTol,
                        T2PosTol: datavalue.T2PosTol,
                        SampleQuantity: datavalue.SampleQuantity,
                        FinePer: datavalue.FinePer
                    };

                    if (value.reportOption == '% Fine' || value.reportOption == 'Fine %' || 
                        value.reportOption == '% Fine Layer 1' || value.reportOption == '% Fine Layer 2') 
                    {
                        insertTempDetail.T2NegTol = datavalue.T2NegTol;
                        insertTempDetail.T2PosTol = datavalue.T2PosTol;
                        insertTempDetail.SampleQuantity = datavalue.SampleQuantity;
                        insertTempDetail.FinePer = datavalue.FinePer;
                    }

                    if(value.reportOption == 'Particle Size' || value.reportOption == 'Particle Size Layer 1' || 
                        value.reportOption == 'Particle Size Layer 2'){
                            Object.assign(insertTempDetail,{ MeshPer:datavalue.MeshPer })
                    }
    
                    await models[tbl_TempDetail].create(insertTempDetail, {
                        transaction: t
                    });
                }
                return "Success";
            });

            const cnt_recSeq = await models[detailTableName].count({
                where: { RepSerNo: repSerNo }
            });

            Object.assign(obj_res, {
                waterMark: true,
                printNo: Number(selectMasterData.PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: repSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: cnt_recSeq,
                ReportRemark: selectMasterData.Remark,
                heading:str_heading.str_head
            });
            return obj_res;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    //  Inserting records of permanent table into temporary Tables for Hardness Consolidated Report. 
    async insertHardnessTempTables_Con(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail, str_heading) 
    {
        try {
            const obj_res = {};
            var recSeqCount = 0,cntT = 0,cntH = 0,cntLD = 0,intRepSerNo = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        BLName: MasterData.BLName,
                        NomHard: (Number(MasterData.Nom_stdtarget) >= 999) ? 0 : (MasterData.Nom_stdtarget == "NA") ? 0 : MasterData.Nom_stdtarget,
                        NomThick: (Number(MasterData.NomThick) >= 999) ? 0 : (MasterData.NomThick == "NA") ? 0 : MasterData.NomThick,
                        NomBL: (Number(MasterData.NomBL) >= 999) ? 0 : (MasterData.NomBL == "NA") ? 0 : MasterData.NomBL,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        AvgHard: MasterData.AvgHard,
                        AvgThick: MasterData.AvgThick,
                        AvgBL: MasterData.AvgBL,
                        MinWeightHard: MasterData.MinWeightHard,
                        MaxWeightHard: MasterData.MaxWeightHard,
                        MinWeightThick: MasterData.MinWeightThick,
                        MaxWeightThick: MasterData.MaxWeightThick,
                        MinWeightBL: MasterData.MinWeightBL,
                        MaxWeightBL: MasterData.MaxWeightBL,
                        StdDevHard: MasterData.StdDevHard,
                        StdDevThick: MasterData.StdDevThick,
                        StdDevBL:  MasterData.StdDevBL,
                        RemarkHard: MasterData.RemarkHard,
                        RemarkThick: MasterData.RemarkThick,
                        RemarkBL: MasterData.RemarkBL,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        HMIID: int_hmiID,
                        Layer: MasterData.Layer,
                        LayerName: MasterData.LayerName,
                        Nom_stdtarget: (MasterData.Nom_stdtarget == "NA") ? 0 : MasterData.Nom_stdtarget,
                        T2NegTolHard: (Number(MasterData.T2NegTolHard) >= 999) ? 0 : (MasterData.T2NegTolHard == "NA") ? 0 :  MasterData.T2NegTolHard,
                        T2PosTolHard: (Number(MasterData.T2PosTolHard) >= 999) ? 0 : (MasterData.T2PosTolHard == "NA") ? 0 : MasterData.T2PosTolHard,
                        T2NegTolThick: (Number(MasterData.T2NegTolThick) >= 999) ? 0 : (MasterData.T2NegTolThick == "NA") ? 0 : MasterData.T2NegTolThick,
                        T2PosTolThick: (Number(MasterData.T2PosTolThick) >= 999) ? 0 : (MasterData.T2PosTolThick == "NA") ? 0 : MasterData.T2PosTolThick,
                        T2NegTolBL: (Number(MasterData.T2NegTolBL) >= 999) ? 0 : (MasterData.T2NegTolBL == "NA") ? 0 : MasterData.T2NegTolBL,
                        T2PosTolBL: (Number(MasterData.T2PosTolBL) >= 999) ? 0 : (MasterData.T2PosTolBL == "NA") ? 0 : MasterData.T2PosTolBL,
                        T2NegTolActualHard: MasterData.T2NegTolActualHard,
                        T2PosTolActualHard: MasterData.T2PosTolActualHard,
                        T2NegTolActualThick: MasterData.T2NegTolActualThick,
                        T2PosTolActualThick: MasterData.T2PosTolActualThick,
                        T2NegTolActualBL: MasterData.T2NegTolActualBL,
                        T2PosTolActualBL:  MasterData.T2PosTolActualBL,
                        MinPerHard: MasterData.MinPerHard,
                        MaxPerHard: MasterData.MaxPerHard,
                        MinPerThick: MasterData.MinPerThick,
                        MaxPerThick: MasterData.MaxPerThick,
                        MinPerBL:  MasterData.MinPerBL,
                        MaxPerBL:  MasterData.MaxPerBL
                    };
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (var data of detailData) {
                        /** if ">999" -> "NA", "NA" -> "NA", "--" -> "--","FL" -> "FL" */
                        var resValuesT = await this.ValidationForHardness(data.DataValueThick);
                        var resValuesH = await this.ValidationForHardness(data.DataValueHard);
                        var resValuesLD = await this.ValidationForHardness(data.DataValueBL);

                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValueHard: resValuesH.int_table,
                            DataValueThick: resValuesT.int_table,
                            DataValueBL: resValuesLD.int_table,
                            DataValueHardG: resValuesH.int_ForGraph,
                            DataValueThickG: resValuesT.int_ForGraph,
                            DataValueBLG: resValuesLD.int_ForGraph,
                            HMIID: int_hmiID,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType
                        };

                       
                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            //Final Remark Calculation
            if (selectMasterData[0].RemarkThick == "Not Complies") { cntT++ };
            if (selectMasterData[0].RemarkHard == "Not Complies") { cntH++ };
            if (selectMasterData[0].RemarkBL == "Not Complies") { cntLD++ };

            var Result = "";
            if(cntT > 0 || cntH > 0 || cntLD > 0)
            {
                Result = "Not Complies";
            }
            else 
            {
                Result = "Complies";
            }

            
            var recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: selectMasterData[0].RepSerNo
                }
            });
           
            Object.assign(obj_res, {
                waterMark: true,
                printNo:  Number(selectMasterData[0].PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: selectMasterData[0].RepSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                ReportRemark: Result,
                heading:str_heading.str_head 
            });
            return obj_res;

        } catch (error) {
            console.log("insertHardnessTempTables_Consolidated() : ", error);
            throw error;
        }
    }

        ValidationForHardness(v)
    {
        try {
             var int_ForGraph = 0,int_table = 0;
                if(Number(v) >= 999)
                {
                    int_table = 'NA';
                    int_ForGraph = '0';
                }
                else if(["--","FL","NA"].includes(v) == true)
                {
                    int_table = 'NA';
                    int_ForGraph = '0';
                }
                else 
                {
                    int_table = v;
                    int_ForGraph = v;
                }

             return{
                int_table:int_table,
                int_ForGraph:int_ForGraph
             }   
        } catch (error) {
             console.log(error);
            return error;
        }
    }

    async increasePrintNo(objPrintCount) {
        try {
            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const productType = (objPrintCount.str_url == "Tablet") ? 1 : 2;
                const reportOption = objPrintCount.reportOption;
                const reportType = objPrintCount.reportType;
                const recordFrom = objPrintCount.recordFrom;
                const int_ReportFormat = objPrintCount.int_ReportFormat;
                const now = new Date();

                const str_tableName = await this.getWeighmentsTableName(productType, reportOption, reportType, 
                    recordFrom, int_ReportFormat);
                
                const objTabletGet = await models[str_tableName.masterTableName].findAll({
                    attributes: ['PrintNo'],
                    where:  { RepSerNo: objPrintCount.intReportSerNo }
                });

                objPrintCount.intPrintCount = objTabletGet[0].PrintNo + 1;

                await models[str_tableName.masterTableName].update({
                    PrintNo: objPrintCount.intPrintCount
                }, {
                    where:
                        { RepSerNo: objPrintCount.intReportSerNo }, 
                    transaction: t
                });

                await models[str_tableName.strPrintTableName].create({
                    RepSrNo: objPrintCount.intReportSerNo,
                    MstSerNo: objPrintCount.intMasterSerNo,
                    PrintNo: objPrintCount.intPrintCount,
                    Reason: objPrintCount.strReason,
                    Title: str_tableName.intWeighmentSrNo,
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    IsIncomplete: objPrintCount.reportType == "Complete" ? 1 : 0
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: objPrintCount.str_url + " - " + objPrintCount.reportOption + ' Report Printed'
                }, {
                    transaction: t
                });
                return "Success";
            });
            return "Insert";

        } catch (error) {
            console.log("Print Count", error);
            throw error;
        }
    }

    async printReasonReport(value, req) {
        try {
            const clientIp = requestIp.getClientIp(req);
            const productType = value.str_url;
            const reportOption = value.reportOption;
            const reportType = value.reportType;
            const recordFrom = value.recordFrom;
            const int_ReportFormat = value.int_ReportFormat;

            const str_printTableName = await this.getWeighmentsTableName(productType, reportOption, reportType, 
                recordFrom, int_ReportFormat);

            const res = await models[str_printTableName.strPrintTableName].findAll({
                where:
                    { RepSrNo: value.RepSrNo }
            });

            if (res.length > 0) {
                const resPrintExist = await models.tbl_printoutreason_weighingreport.findAll({
                    where:
                        { HMIID: clientIp.split(':')[3] }
                });

                if (resPrintExist.length > 0) {
                    await models.tbl_printoutreason_weighingreport.destroy({
                        where:
                            { HMIID: clientIp.split(':')[3] }
                    });

                    return this.insertInPrintTable(res, clientIp,reportOption);
                }
                else {
                    return this.insertInPrintTable(res, clientIp,reportOption);
                }
            }
            else {
                return { status: 'success', data: 'No record Found' };
            }

        } catch (error) {
            console.log("Print Reason For Printout", error);
            throw error;
        }
    }

    async insertInPrintTable(res, clientIp,reportOption) {
        try {
            const data = {};
            for (const obj of res) {
                await models.tbl_printoutreason_weighingreport.create({
                    RepSrNo: obj.RepSrNo,
                    PrintNo: obj.PrintNo,
                    Reason: obj.Reason,
                    Title: obj.Title,
                    UserID: obj.UserID,
                    UserName: obj.UserName,
                    Print_Dt: obj.Print_Dt,
                    Print_Tm: date.format(obj.Print_Tm, 'HH:mm:ss'),
                    IsIncomplete: obj.IsIncomplete,
                    HMIID: clientIp.split(':')[3]
                });
            }
            Object.assign(data, { HmiId: clientIp.split(':')[3] ,reportOption : reportOption});
            return data;

        } catch (error) {
            console.log("insertInPrintTable() : ", error);
            throw error;
        }
    }

    async checkReportIsVerified(objReport) {
        try {
            const TableName = await this.getWeighmentsTableName(objReport.productType, objReport.reportOption, 
                objReport.reportType, objReport.recordFrom, objReport.int_ReportFormat);

            const res = await models[TableName.masterTableName].findAll({
                attributes: ['CheckedByID'],
                where: { RepSerNo: objReport.intReportSerNo }
            });
            return res.CheckedByID;

        } catch (error) {
            console.log("checkReportIsVerified() : ", error);
            throw error;
        }
    }

    async verifyReport(objReport) {
        try {
            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const now = new Date();
                const str_tableName = await this.getWeighmentsTableName(objReport.productType, objReport.reportOption, 
                    objReport.reportType, objReport.recordFrom, objReport.int_ReportFormat);

                const update = {
                    CheckedByID: objReport.strUserId,
                    CheckedByName: objReport.strUserName,
                    CheckedByDate: date.format(now, 'YYYY-MM-DD'),
                    CheckedByTime: date.format(now, 'HH:mm:ss'),
                    FailedRemark: objReport.strReason
                };

                /* As for Uganda system, Within Limit and Out of Limit reports both will have checked by remark as per DS. */
                // if (objReport.outOfLimit == false)//if out of limit then store remark
                // {
                //     Object.assign(update, { FailedRemark: objReport.strReason });
                // }

                await models[str_tableName.masterTableName].update(update, {
                    where:
                        { RepSerNo: objReport.intReportSerNo },
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objReport.strUserId,
                    username: objReport.strUserName,
                    activity: (objReport.reportOption == 'Fine %')? '% Fine Report Verified' : objReport.reportOption + ' Report Verified'
                }, {
                    transaction: t
                });
            });
            return "Success";

        } catch (error) {
            console.log("Verify", error);
            throw error;
        }
    }

    async getWeighmentReportDetails(reqObj) {
        try {
            const obj_response = {};
            const int_ReportFormat = reqObj.body.int_ReportFormat;
            const reportOption = reqObj.body.reportOption;
            const fromDate = reqObj.body.fromDate;
            const toDate = reqObj.body.toDate;
            const productType = (reqObj.body.str_tabletCapsule == 'Tablet') ? 1 : 2;
            const reportType = reqObj.body.reportType;
            const recordFrom = reqObj.body.recordFrom;
            let testType = reqObj.body.testType;
            let masterTableName = "", detailTableName = "", query = "";
            if (testType == 'Regular') { //1:- Initial and 0:- Regular
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;

            if (detailTableName != '') {

                if ((reportOption.includes("Layer 1") == true) && (!reportOption.includes("Individual") == true) && 
                    (!reportOption.includes("Group") == true)) 
                {
                    query = `SELECT DISTINCT m.* FROM  ${masterTableName} m JOIN  ${detailTableName} d ON m.RepSerNo = d.RepSerNo 
                        WHERE m.ReportType = ${testType} AND m.ProductType = ${productType} AND m.Inprocess = 0 
                        AND m.PrDate  BETWEEN '${fromDate}' AND '${toDate}' AND m.Layer = 'Layer 1'`;

                } else if ((reportOption.includes("Layer 2") == true) && (!reportOption.includes("Individual") == true) && 
                    (!reportOption.includes("Group") == true)) 
                {
                    query = `SELECT DISTINCT m.* FROM  ${masterTableName} m JOIN  ${detailTableName} d ON m.RepSerNo = d.RepSerNo 
                        WHERE m.ReportType = ${testType} AND m.ProductType = ${productType} AND m.Inprocess = 0 
                        AND m.PrDate  BETWEEN '${fromDate}' AND '${toDate}' AND m.Layer = 'Layer 2'`;

                } else {
                    let str_timeColumn = "";
                    if (reportOption.includes("DT") == true) str_timeColumn = ", d.DT_StartTm";
                    query = `SELECT DISTINCT m.* ${str_timeColumn} FROM  ${masterTableName} m JOIN  ${detailTableName} d ON m.RepSerNo = d.RepSerNo 
                        WHERE m.ReportType = ${testType} AND m.ProductType = ${productType} AND m.Inprocess = 0 
                        AND m.PrDate  BETWEEN '${fromDate}' AND '${toDate}' AND (m.Layer is NULL OR m.Layer = 'NA')`;
                }

            } else {
                if (reportOption.includes("Friability") == true){ 
                    query = `SELECT * FROM ${masterTableName} WHERE RepSerNo IN (SELECT RepSerNo FROM ${masterTableName} where ReportType = ${testType} AND Inprocess = 0 
                    AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' )`;
                
                } else if (reportOption.includes("Layer 1") == true){
                    query = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                        AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND Layer = 'Layer 1'`;
                
                } else if (reportOption.includes("Layer 2") == true){
                    query = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                        AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND Layer = 'Layer 2'`;
                
                } else { 
                    query = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                        AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND (Layer is NULL OR Layer = 'NA')`;
                }
            }

            query = query + " ORDER BY RepSerNo ";
            
            const result = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            if (result.length > 0) {
                Object.assign(obj_response, { status: 'success' }, { result: result });
            } else {
                Object.assign(obj_response, { status: 'success' }, { result: [] });
            }
            return obj_response;

        } catch (error) {
            console.log("getWeighmentReportDetail", error);
            throw error;
        }
    }

    async getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat) {
        try {
            let masterTableName = "", detailTableName = "", strPrintTableName = "", intWeighmentSrNo = 0;
            let MstTempTbl = "tbl_temp_master", DetTempTbl = "tbl_temp_detail";
            let strPrefix = "", blnIsIncomplete = true, blnIsDetailTable = true, blnIsTempTable = true;
            if (productType == 1) strPrefix = "tab";
            else if (productType == 2) strPrefix = "cap";

            switch (reportOption) {
                case 'Individual':
                    intWeighmentSrNo = 1;
                    break;
                case 'Group':
                    intWeighmentSrNo = 2;
                    MstTempTbl = "tbl_temp_mastergroup";
                    DetTempTbl = "tbl_temp_detailgroup";
                    blnIsIncomplete = false;
                    break;
                case 'Differential':
                case 'Filled Content Weight':
                    intWeighmentSrNo = 3;
                    MstTempTbl = "tbl_temp_masterdiff";
                    DetTempTbl = "tbl_temp_detaildiff";
                    break;
                case 'Thickness':
                    intWeighmentSrNo = 3;
                    break;
                case 'Breadth':
                case 'Width':
                    intWeighmentSrNo = 4;
                    break;
                case 'Length':
                case 'Locked Length':
                case 'Seal Length':
                    intWeighmentSrNo = 5;
                    break;
                case 'Diameter':
                    intWeighmentSrNo = 6;
                    break;
                case 'Hardness':
                    intWeighmentSrNo = 7;
                    masterTableName = "tbl_tab_masterhtd";
                    detailTableName = "tbl_tab_detailhtd";
                    MstTempTbl = "tbl_temp_masterhtd";
                    DetTempTbl = "tbl_temp_detailhtd";
                    strPrintTableName = "tbl_tab_print7";
                    if (reportType == 'Incomplete') {
                        masterTableName = masterTableName + "_incomplete";
                        detailTableName = detailTableName + "_incomplete";
                    } else if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                        detailTableName = detailTableName + "_archived";
                    }
                    break;
                    //
                    case 'Appearance':
                        intWeighmentSrNo = 14;
                        masterTableName = "tbl_tab_masterapp";
                        detailTableName = "tbl_tab_detailapp";
                        MstTempTbl = "tbl_temp_mastergroup";
                        DetTempTbl = "tbl_temp_detailgroup";
                        strPrintTableName = "tbl_tab_printapp";
                        if (reportType == 'Incomplete') {
                            masterTableName = masterTableName + "_incomplete";
                            detailTableName = detailTableName + "_incomplete";
                        } else if (recordFrom == 'Archive') {
                            masterTableName = masterTableName + "_archived";
                            detailTableName = detailTableName + "_archived";
                        }
                        break;
                case 'Friability':
                    intWeighmentSrNo = 8;
                    blnIsIncomplete = false;
                    if (int_ReportFormat == 1) { //Only for Separate Report Format.
                        strPrintTableName = "tbl_tab_print8";
                        masterTableName = 'tbl_tab_friability';
                        if (recordFrom == 'Archive') {
                            masterTableName = masterTableName + "_archived";
                        }
                        blnIsDetailTable = false;
                        blnIsTempTable = false;

                    } else if (int_ReportFormat == 2) { //Only for Consolidated Report Format.
                        MstTempTbl = "tbl_temp_masterfriability";
                        DetTempTbl = "tbl_temp_detailfriability";
                    }
                    break;
                case 'DT':
                    if (productType == 1) intWeighmentSrNo = 13;
                    else if (productType == 2) intWeighmentSrNo = 6;
                    MstTempTbl = "tbl_temp_masterdt";
                    DetTempTbl = "tbl_temp_detaildt";
                    blnIsIncomplete = false;
                    break;
                case 'DT Layer 1':
                    intWeighmentSrNo = 19;
                    MstTempTbl = "tbl_temp_masterdt";
                    DetTempTbl = "tbl_temp_detaildt";
                    blnIsIncomplete = false;
                    break;
                case 'DT Layer 2':
                    intWeighmentSrNo = 20;
                    MstTempTbl = "tbl_temp_masterdt";
                    DetTempTbl = "tbl_temp_detaildt";
                    blnIsIncomplete = false;
                    break;
                case 'Individual Layer 1':
                    intWeighmentSrNo = 9;
                    break;
                case 'Group Layer 1':
                    intWeighmentSrNo = 10;
                    MstTempTbl = "tbl_temp_mastergroup";
                    DetTempTbl = "tbl_temp_detailgroup";
                    blnIsIncomplete = false;
                    break;
                case 'Individual Layer 2':
                    intWeighmentSrNo = 11;
                    break;
                case 'Group Layer 2':
                    intWeighmentSrNo = 12;
                    MstTempTbl = "tbl_temp_mastergroup";
                    DetTempTbl = "tbl_temp_detailgroup";
                    blnIsIncomplete = false;
                    break;
                //Granulation
                case 'LOD':
                case 'LOD Layer 1':
                case 'LOD Layer 2':
                    intWeighmentSrNo = 16;
                    // strPrintTableName = "tbl_tab_printlod";
                    if (productType == 1) strPrintTableName = "tbl_tab_printlod";
                    else if (productType == 2) strPrintTableName = "tbl_cap_printlod";
                    masterTableName = 'tbl_lodmaster';
                    detailTableName = '';
                    if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                    }
                    blnIsIncomplete = false;
                    blnIsDetailTable = false;
                    blnIsTempTable = false;
                    break;
                case 'Tapped Density':
                case 'Tapped Density Layer 1':
                case 'Tapped Density Layer 2':
                    intWeighmentSrNo = 15;
                    // strPrintTableName = "tbl_tab_printtd";
                    if (productType == 1) strPrintTableName = "tbl_tab_printtd";
                    else if (productType == 2) strPrintTableName = "tbl_cap_printtd";
                    masterTableName = 'tbl_tapdensity';
                    detailTableName = '';
                    if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                    }
                    blnIsIncomplete = false;
                    blnIsDetailTable = false;
                    blnIsTempTable = false;
                    break;
                case 'Fine %':
                case '% Fine':
                case '% Fine Layer 1':
                case '% Fine Layer 2':
                    intWeighmentSrNo = 17;
                    MstTempTbl = "tbl_temp_masterfine";
                    DetTempTbl = "tbl_temp_detailfine";
                    // strPrintTableName = "tbl_tab_printfine";
                    if (productType == 1) strPrintTableName = "tbl_tab_printfine";
                    else if (productType == 2) strPrintTableName = "tbl_cap_printfine";
                    break;
                case 'Particle Size':
                case 'Particle Size Layer 1':
                case 'Particle Size Layer 2':
                    intWeighmentSrNo = 18;
                    MstTempTbl = "tbl_temp_masterpsd";
                    DetTempTbl = "tbl_temp_detailpsd";
                    // strPrintTableName = "tbl_tab_printpsd";
                    if (productType == 1) strPrintTableName = "tbl_tab_printpsd";
                    else if (productType == 2) strPrintTableName = "tbl_cap_printpsd";
                    break;
            }

            if (masterTableName == "") {
                strPrintTableName = (strPrintTableName == "") ? `tbl_${strPrefix}_print${intWeighmentSrNo}` : strPrintTableName;
                masterTableName = `tbl_${strPrefix}_master${intWeighmentSrNo}`;
                detailTableName = `tbl_${strPrefix}_detail${intWeighmentSrNo}`;

                if ((reportType == 'Incomplete') && (blnIsIncomplete == true)) {
                    masterTableName = masterTableName + "_incomplete";
                    detailTableName = detailTableName + "_incomplete";

                } else if (recordFrom == 'Archive') {
                    masterTableName = masterTableName + "_archived";
                    detailTableName = detailTableName + "_archived";
                }
            }

            return {
                masterTableName: masterTableName,
                detailTableName: detailTableName,
                strPrintTableName: strPrintTableName,
                MstTempTbl: MstTempTbl,
                DetTempTbl: DetTempTbl,
                intWeighmentSrNo: intWeighmentSrNo,
                blnIsIncomplete: blnIsIncomplete,
                blnIsDetailTable: blnIsDetailTable,
                blnIsTempTable: blnIsTempTable
            };

        } catch (error) {
            console.log("getWeighmentsTableName() : ", error);
            throw error;
        }
    }

    async getWeighmentReportDetails_Consolidated(reqObj) {
        try {
            const obj_response = {};
            const int_ReportFormat = reqObj.body.int_ReportFormat;
            const reportOption = reqObj.body.reportOption;
            const fromDate = reqObj.body.fromDate;
            const toDate = reqObj.body.toDate;
            const productType = (reqObj.body.str_tabletCapsule == 'Tablet') ? 1 : 2;
            const reportType = reqObj.body.reportType;
            const recordFrom = reqObj.body.recordFrom;
            let testType = reqObj.body.testType;
            let masterTableName = "", detailTableName = "", query = "";
            let strMainQuery = "", strSubQuery = "", strSubCond = "", strGroupBy = "";
            if (testType == 'Regular') { //1:- Initial and 0:- Regular
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;

            strMainQuery = `SELECT M.RepSerNo, M.MstSerNo, M.BatchNo, M.BFGCode, M.ProductName, M.PrDate,
                M.PVersion, M.Version, M.PrTime, M.Side, M.UserId, M.UserName, M.PrintNo, 
                M.CheckedByID, M.CheckedByName, M.CheckedByDate, M.BatchComplete, M.CubicleType
                FROM ${masterTableName} M WHERE M.ReportType = ${testType} AND M.Inprocess = 0 
                AND M.ProductType = ${productType} AND M.PrDate BETWEEN '${fromDate}' AND '${toDate}'`;

            if ((reportOption.includes("Layer 1") == true) && (ObjTables.intWeighmentSrNo != 9) && 
                (ObjTables.intWeighmentSrNo != 10)) 
            {
                strSubCond = "AND M.Layer = 'Layer 1'";

            } else if ((reportOption.includes("Layer 2") == true) && (ObjTables.intWeighmentSrNo != 11) && 
                (ObjTables.intWeighmentSrNo != 12)) 
            {
                strSubCond = "AND M.Layer = 'Layer 2'";

            } else {
                strSubCond = "AND (M.Layer IS NULL OR M.Layer = 'NA')";
            }

            if (ObjTables.blnIsDetailTable == true) {
                if ((reportOption !== 'Hardness') && (reportOption !== 'Particle Size') && (reportOption !== 'Particle Size Layer 1')
                    && (reportOption !== 'Particle Size Layer 2') && (reportOption !== '% Fine') && (reportOption !== 'Fine %')
                    && (reportOption !== '% Fine Layer 1') && (reportOption !== '% Fine Layer 2')) 
                {
                    strGroupBy = "GROUP BY M.BatchNo, M.BFGCode, M.ProductName, M.PVersion, M.Version, M.MstSerNo, M.CubicleType";
                } else { // Added for non-consolidated reports.
                    strGroupBy = "GROUP BY M.RepSerNo";
                }
                strSubQuery = `AND M.RepSerNo IN (SELECT DISTINCT MIN(M.RepSerNo) AS RepSerNo 
                    FROM ${masterTableName} M JOIN ${detailTableName} D ON M.RepSerNo = D.RepSerNo
                    WHERE M.ReportType = ${testType} AND M.ProductType = ${productType} AND M.Inprocess = 0 
                    AND M.PrDate BETWEEN '${fromDate}' AND '${toDate}' ${strSubCond} 
                    ${strGroupBy})`;

                query = `${strMainQuery} ${strSubQuery} ${strSubCond}`;

            } else {
                query = `${strMainQuery} ${strSubCond}`;
            }

            query = query + " ORDER BY M.RepSerNo ";
            const result = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            if (result.length > 0) {
                Object.assign(obj_response, { status: 'success' }, { result: result });
            } else {
                Object.assign(obj_response, { status: 'success' }, { result: [] });
            }
            return obj_response;

        } catch (error) {
            console.log("getWeighmentReportDetails_Consolidated() : ", error);
            throw error;
        }
    }

    async viewConsolidateReport(value, req) {
        try {
            const responseObj = {};
            const int_ReportFormat = value.int_ReportFormat;
            const clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3];
            if ((("idsNo" in value) == true)) {
                ip = `${serverConfig.strIpSeries}${value.idsNo}`;
            } else if (ip === undefined) {
                ip = '127.0.0.1';
            }

            if (value.str_source == "Auto") {
                ip = value.str_hmi;
                console.log("Autoip", ip);
            }

            const int_hmiID = ip;
            const reportOption = value.reportOption;
            const reportType = value.reportType;
            const recordFrom = value.recordFrom;
            const repSerNo = value.RepSerNo;
            const userId = value.userId;
            const userName = value.username;
            const productType = (value.str_url == 'Tablet') ? 1 : 2;
            let masterTableName = "", detailTableName = "", WeighmentModeNo = 0;
            let testType = value.testType;
            if (testType == 'Regular') {
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;
            WeighmentModeNo = ObjTables.intWeighmentSrNo;
            const tbl_TempMaster = ObjTables.MstTempTbl;
            const tbl_TempDetail = ObjTables.DetTempTbl;
            let query = "", strMainQuery = "", strSubCond = "";

            strMainQuery = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                AND ProductType = ${productType} AND BFGCode = '${value.ProdID}' AND ProductName = '${value.ProdName}'
                AND PVersion = '${value.ProdVersion}' AND Version = '${value.Version}' AND BatchNo = '${value.BatchNo}'
                AND CubicleType = '${value.CubicleType}'`;

            if ((ObjTables.blnIsDetailTable == true) && ((reportOption !== 'Hardness') && (reportOption !== 'Particle Size') 
                && (reportOption !== 'Particle Size Layer 1') && (reportOption !== 'Particle Size Layer 2') 
                && (reportOption !== '% Fine') && (reportOption !== 'Fine %')
                && (reportOption !== '% Fine Layer 1') && (reportOption !== '% Fine Layer 2')))
            {
                strMainQuery = `${strMainQuery} AND MstSerNo = ${value.MstSerNo}`;
            } else {
                strMainQuery = `${strMainQuery} AND RepSerNo = ${repSerNo}`;
            }

            if ((reportOption.includes("Layer 1") == true) && (ObjTables.intWeighmentSrNo != 9) && 
                (ObjTables.intWeighmentSrNo != 10)) 
            {
                strSubCond = " AND Layer = 'Layer 1'";

            } else if ((reportOption.includes("Layer 2") == true) && (ObjTables.intWeighmentSrNo != 11) && 
                (ObjTables.intWeighmentSrNo != 12)) 
            {
                strSubCond = " AND Layer = 'Layer 2'";

            } else {
                strSubCond = " AND (Layer IS NULL OR Layer = 'NA')";
            }

            query = `${strMainQuery} ${strSubCond} ORDER BY RepSerNo`;
            const selectMasterData = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            if (ObjTables.blnIsTempTable == true) {
                // Start Deleting previous Data from temporary Tables.
                await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail);
                // Completed Deleting previous Data from temporary Tables.

                // Start Inserting records of permanent table into temporary Tables.
                if (reportOption == 'Individual' || reportOption == 'Group' || reportOption == 'Thickness' || 
                    reportOption == 'Breadth' || reportOption == 'Width' || reportOption == 'Length' || reportOption == 'Diameter' ||
                    reportOption == 'Locked Length' || reportOption == 'Seal Length' ||
                    reportOption == 'Individual Layer 1' || reportOption == 'Individual Layer 2' ||
                    reportOption == 'Group Layer 1' || reportOption == 'Group Layer 2' ||
                    reportOption == 'Differential' || reportOption == 'Filled Content Weight') 
                {
                    const res_Obj = await this.insertIndividualTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Hardness') 
                {
                    const res_Obj = await this.insertHardnessTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Friability') 
                {
                    const res_Obj = await this.insertFriabilityTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'DT' || reportOption == 'DT Layer 1' || reportOption == 'DT Layer 2') 
                {
                    const res_Obj = await this.insertDisintegrationTestTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Particle Size' || reportOption == 'Particle Size Layer 1' || 
                    reportOption == 'Particle Size Layer 2' || reportOption == 'Fine %' ||
                    reportOption == '% Fine' || reportOption == '% Fine Layer 1' || reportOption == '% Fine Layer 2') 
                {
                    const res_Obj = await this.insertParticleSizeTempTable_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                }
                // Completed Inserting records of permanent table into temporary Tables.
            }

            if (reportOption == 'LOD' || reportOption == 'LOD Layer 1' || reportOption == 'LOD Layer 2' || 
                reportOption == 'Tapped Density' || reportOption == 'Tapped Density Layer 1' || reportOption == 'Tapped Density Layer 2') 
            {
                let RptRemark = 'NA';
                if (selectMasterData.length > 0) {
                    RptRemark = selectMasterData[0].Remark;
                }
                Object.assign(responseObj, {
                    waterMark: true,
                    printNo: value.printNo,
                    UserId: userId,
                    UserName: userName,
                    SelectedValue: repSerNo,
                    HmiId: int_hmiID,
                    WgmtModeNo: WeighmentModeNo,
                    ProductType: productType,
                    ICReport: reportType,
                    ReportRemark: RptRemark
                });
            }
            return responseObj;

        } catch (error) {
            console.log("viewConsolidateReport() : ", error);
            throw error;
        }
    }

    //  Inserting records of permanent table into temporary Tables for major Balance & Vernier parameters. 
    async insertIndividualTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        BalanceId: MasterData.BalanceId,
                        VernierId: MasterData.VernierId,
                        FriabilityID: MasterData.FriabilityID,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Stage: MasterData.Stage,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        NMT: MasterData.NMT,
                        Nom: MasterData.Nom,
                        T1NegTol: MasterData.T1NegTol,
                        T1PosTol: MasterData.T1PosTol,
                        T2NegTol: MasterData.T2NegTol,
                        T2PosTol: MasterData.T2PosTol,
                        T1NegTolActual: MasterData.T1NegTolActual,
                        T1PosTolActual: MasterData.T1PosTolActual,
                        T2NegTolActual: MasterData.T2NegTolActual,
                        T2PosTolActual: MasterData.T2PosTolActual,
                        NomEmpty: MasterData.NomEmpty,
                        T1NegEmpty: MasterData.T1NegEmpty,
                        T1PosEmpty: MasterData.T1PosEmpty,
                        T2NegEmpty: MasterData.T2NegEmpty,
                        T2PosEmpty: MasterData.T2PosEmpty,
                        NomNet: MasterData.NomNet,
                        T1NegNet: MasterData.T1NegNet,
                        T1PosNet: MasterData.T1PosNet,
                        T2NegNet: MasterData.T2NegNet,
                        T2PosNet: MasterData.T2PosNet,
                        T1NegNetActual: MasterData.T1NegNetActual,
                        T1PosNetActual: MasterData.T1PosNetActual,
                        T2NegNetActual: MasterData.T2NegNetActual,
                        T2PosNetActual: MasterData.T2PosNetActual,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        StdLimit1: MasterData.StdLimit1,
                        StdLimit2: MasterData.StdLimit2,
                        NoOfAbove1: MasterData.NoOfAbove1,
                        NoOfBelow1: MasterData.NoOfBelow1,
                        NoOfAbove2: MasterData.NoOfAbove2,
                        NoOfBelow2: MasterData.NoOfBelow2,
                        MinPer: MasterData.MinPer,
                        MaxPer: MasterData.MaxPer,
                        GroupWeight: MasterData.GroupWeight,
                        AvgWeight: MasterData.AvgWeight,
                        AvgEmpty: MasterData.AvgEmpty,
                        AvgNet: MasterData.AvgNet,
                        MinWeight: MasterData.MinWeight,
                        MaxWeight: MasterData.MaxWeight,
                        MinWeightEmpty: MasterData.MinWeightEmpty,
                        MaxWeightEmpty: MasterData.MaxWeightEmpty,
                        MinWeightNet: MasterData.MinWeightNet,
                        MaxWeightNet: MasterData.MaxWeightNet,
                        StdDev: MasterData.StdDev,
                        Remark: MasterData.Remark,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        Deviation: MasterData.Deviation,
                        LayerName: MasterData.LayerName,
                        Layer: MasterData.Layer,
                        HMIID: int_hmiID,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        TotalWeight: MasterData.TotalWeight
                    };
    
                    if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                        value.reportOption == 'Group Layer 2') 
                    {
                        insertTempMater.MinGrpWeight = MasterData.MinGrpWeight;
                        insertTempMater.MaxGrpWeight = MasterData.MaxGrpWeight;
                        insertTempMater.AvgGrpWeight = MasterData.AvgGrpWeight;
                    }
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValue: data.DataValue,
                            DataValue1: data.DataValue1,
                            NetValue: data.NetValue,
                            AvgWeight: data.AvgWeight,
                            Deviation: data.Deviation,
                            DP: data.DP,
                            UserId: data.UserId,
                            UserName: data.UserName,
                            PrDate: data.PrDate,
                            PrTime: date.format(data.PrTime, 'HH:mm:ss'),
                            PrEndDate: data.PrEndDate,
                            PrEndTime: date.format(data.PrEndTime, 'HH:mm:ss'),
                            BFGCode: data.BFGCode,
                            ProductName: data.ProductName,
                            Version: data.Version,
                            PVersion: data.PVersion,
                            Side: data.Side,
                            BatchNo: data.BatchNo,
                            InstrumentID: data.InstrumentID,
                            Remark: data.Remark,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType,
                            HMIID: int_hmiID
                        };

                        if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                            value.reportOption == 'Group Layer 2') 
                        {
                            insertTempDetail.NoOfSample = data.NoOfSample;
                        }

                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertIndividualTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    //  Inserting records of permanent table into temporary Tables for Hardness Consolidated Report. 
    async insertHardnessTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            let cntHard = 0, cntThick = 0, cntDiam = 0, cntDOLOB = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        BLName: MasterData.BLName,
                        NomHard: MasterData.NomHard,
                        NomThick: MasterData.NomThick,
                        NomDiam: MasterData.NomDiam,
                        NomBL: MasterData.NomBL,
                        T1NegTolHard: MasterData.T1NegTolHard,
                        T1PosTolHard: MasterData.T1PosTolHard,
                        T1NegTolThick: MasterData.T1NegTolThick,
                        T1PosTolThick: MasterData.T1PosTolThick,
                        T1NegTolDiam: MasterData.T1NegTolDiam,
                        T1PosTolDiam: MasterData.T1PosTolDiam,
                        T1NegTolBL: MasterData.T1NegTolBL,
                        T1PosTolBL: MasterData.T1PosTolBL,
                        T1NegTolActualHard: MasterData.T1NegTolActualHard,
                        T1PosTolActualHard: MasterData.T1PosTolActualHard,
                        T1NegTolActualThick: MasterData.T1NegTolActualThick,
                        T1PosTolActualThick: MasterData.T1PosTolActualThick,
                        T1NegTolActualDiam: MasterData.T1NegTolActualDiam,
                        T1PosTolActualDiam: MasterData.T1PosTolActualDiam,
                        T1NegTolActualBL: MasterData.T1NegTolActualBL,
                        T1PosTolActualBL: MasterData.T1PosTolActualBL,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        AvgHard: MasterData.AvgHard,
                        AvgThick: MasterData.AvgThick,
                        AvgDiam: MasterData.AvgDiam,
                        AvgBL: MasterData.AvgBL,
                        MinWeightHard: MasterData.MinWeightHard,
                        MaxWeightHard: MasterData.MaxWeightHard,
                        MinWeightThick: MasterData.MinWeightThick,
                        MaxWeightThick: MasterData.MaxWeightThick,
                        MinWeightDiam: MasterData.MinWeightDiam,
                        MaxWeightDiam: MasterData.MaxWeightDiam,
                        MinWeightBL: MasterData.MinWeightBL,
                        MaxWeightBL: MasterData.MaxWeightBL,
                        StdDevHard: MasterData.StdDevHard,
                        StdDevThick: MasterData.StdDevThick,
                        StdDevDiam: MasterData.StdDevDiam,
                        StdDevBL: MasterData.StdDevBL,
                        RemarkHard: MasterData.RemarkHard,
                        RemarkDiam: MasterData.RemarkDiam,
                        RemarkThick: MasterData.RemarkThick,
                        RemarkBL: MasterData.RemarkBL,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        HMIID: int_hmiID,
                        Layer: MasterData.Layer,
                        LayerName: MasterData.LayerName,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        T2NegTolHard: MasterData.T2NegTolHard,
                        T2PosTolHard: MasterData.T2PosTolHard,
                        T2NegTolThick: MasterData.T2NegTolThick,
                        T2PosTolThick: MasterData.T2PosTolThick,
                        T2NegTolDiam: MasterData.T2NegTolDiam,
                        T2PosTolDiam: MasterData.T2PosTolDiam,
                        T2NegTolBL: MasterData.T2NegTolBL,
                        T2PosTolBL: MasterData.T2PosTolBL,
                        T2NegTolActualHard: MasterData.T2NegTolActualHard,
                        T2PosTolActualHard: MasterData.T2PosTolActualHard,
                        T2NegTolActualThick: MasterData.T2NegTolActualThick,
                        T2PosTolActualThick: MasterData.T2PosTolActualThick,
                        T2NegTolActualDiam: MasterData.T2NegTolActualDiam,
                        T2PosTolActualDiam: MasterData.T2PosTolActualDiam,
                        T2NegTolActualBL: MasterData.T2NegTolActualBL,
                        T2PosTolActualBL: MasterData.T2PosTolActualBL,
                        T3NegTolHard: MasterData.T3NegTolHard,
                        T3PosTolHard: MasterData.T3PosTolHard,
                        T3NegTolThick: MasterData.T3NegTolThick,
                        T3PosTolThick: MasterData.T3PosTolThick,
                        T3NegTolDiam: MasterData.T3NegTolDiam,
                        T3PosTolDiam: MasterData.T3PosTolDiam,
                        T3NegTolBL: MasterData.T3NegTolBL,
                        T3PosTolBL: MasterData.T3PosTolBL,
                        T3NegTolActualHard: MasterData.T3NegTolActualHard,
                        T3PosTolActualHard: MasterData.T3PosTolActualHard,
                        T3NegTolActualThick: MasterData.T3NegTolActualThick,
                        T3PosTolActualThick: MasterData.T3PosTolActualThick,
                        T3NegTolActualDiam: MasterData.T3NegTolActualDiam,
                        T3PosTolActualDiam: MasterData.T3PosTolActualDiam,
                        T3NegTolActualBL: MasterData.T3NegTolActualBL,
                        T3PosTolActualBL: MasterData.T3PosTolActualBL
                    };
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValueHard: data.DataValueHard,
                            DataValueThick: data.DataValueThick,
                            DataValueDiam: data.DataValueDiam,
                            DataValueBL: data.DataValueBL,
                            HMIID: int_hmiID,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType
                        };

                        if (this.IsDataValueValid(data.DataValueHard) === true) {
                            cntHard = cntHard + 1;
                        }
                        if (this.IsDataValueValid(data.DataValueThick) === true) {
                            cntThick = cntThick + 1;
                        }
                        if (this.IsDataValueValid(data.DataValueDiam) === true) {
                            cntDiam = cntDiam + 1;
                        }
                        if (this.IsDataValueValid(data.DataValueBL) === true) {
                            cntDOLOB = cntDOLOB + 1;
                        }

                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist,
                cntHard: cntHard,
                cntThick: cntThick,
                cntDiam: cntDiam,
                cntDOLOB: cntDOLOB
            });
            return obj_res;

        } catch (error) {
            console.log("insertHardnessTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    //  Inserting records of permanent table into temporary Tables for Friability Consolidated Report. 
    async insertFriabilityTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        SrNo: MasterData.SrNo,
                        Area: MasterData.Area,
                        CubicleName: MasterData.CubicleName,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        ProductType: MasterData.ProductType,
                        ReportType: MasterData.ReportType,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BMRNo: MasterData.BMRNo,
                        BatchSize: MasterData.BatchSize,
                        MachineCode: MasterData.MachineCode,
                        BalanceId: MasterData.BalanceId,
                        FriabilityID: MasterData.FriabilityID,
                        Idsno: MasterData.Idsno,
                        Qty: MasterData.Qty,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        Side: MasterData.Side,
                        Stage: MasterData.Stage,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        NMT: MasterData.NMT,
                        SetCount: MasterData.SetCount,
                        SetRPM: MasterData.SetRPM,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        LayerName: MasterData.LayerName,
                        Layer: MasterData.Layer,
                        Inprocess: MasterData.Inprocess,
                        Remark: MasterData.Remark,
                        WeighmentMode: WeighmentModeNo,
                        HMIID: int_hmiID                       
                    };
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            InitialWt: data.InitialWt,
                            FinalWt: data.FinalWt,
                            FriabVal: data.FriabVal,
                            DP: data.DP,
                            UserId: data.UserId,
                            UserName: data.UserName,
                            PrDate: data.PrDate,
                            PrTime: date.format(data.PrTime, 'HH:mm:ss'),
                            PrEndDate: data.PrEndDate,
                            PrEndTime: date.format(data.PrEndTime, 'HH:mm:ss'),
                            Side: data.Side,
                            BalanceID: data.BalanceID,
                            IdsNo: data.IdsNo,
                            Remark: data.Remark,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType,
                            HMIID: int_hmiID
                        };

                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertFriabilityTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    // Inserting DT records of permanent table into temporary tables for Consolidated reports.
    async insertDisintegrationTestTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertDTTempMaster = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        InstrumentID: MasterData.InstrumentID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        T1NegTol: MasterData.T1NegTol,
                        T1PosTol: MasterData.T1PosTol,
                        Nom: MasterData.Nom,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        Media: MasterData.Media,
                        Lot: MasterData.Lot,
                        MinTemp: MasterData.MinTemp,
                        MaxTemp: MasterData.MaxTemp,
                        MinTime: MasterData.MinTime,
                        Jar: MasterData.Jar,
                        Remark: MasterData.Remark,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        HMIID: int_hmiID,
                        MaxTime: MasterData.MaxTime,
                        StdTime: MasterData.StdTime,
                        TempRange: MasterData.TempRange,
                        LayerName: MasterData.LayerName,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        Layer: MasterData.Layer,
                        MeshSize_Bolus: MasterData.MeshSize_Bolus,
                        Media_Temp: MasterData.Media_Temp,
                        Bath_Temp: MasterData.Bath_Temp,
                        Apparatus_Type: MasterData.Apparatus_Type,
                        Program_No: MasterData.Program_No,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss')
                    };

                    await models[tbl_TempMaster].create(insertDTTempMaster, { 
                        transaction: t 
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertDTTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DT_Side: data.DT_Side,
                            DT_Jar: data.DT_Jar,
                            DT_Temp: data.DT_Temp,
                            DT_StartDate: data.DT_StartDate,
                            DT_StartTm: data.DT_StartTm,
                            DT_EndTm: data.DT_EndTm,
                            DT_RunTime: data.DT_RunTime,
                            DT_Remark: data.DT_Remark,
                            DT_DoneByID: data.DT_DoneByID,
                            DT_DoneByName: data.DT_DoneByName,
                            DT_HaltDur: data.DT_HaltDur,
                            Layer: data.Layer,
                            LayerName: data.LayerName,
                            HMIID: int_hmiID,
                            WgmtModeNo: WeighmentModeNo,
                            ProductType: productType,
                        };

                        await models[tbl_TempDetail].create(insertDTTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });

            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertDisintegrationTestTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    // Inserting Paricle Size records of permanent table into temporary tables for Consolidated reports.       
    async insertParticleSizeTempTable_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempData = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        BalanceId: MasterData.BalanceId,
                        VernierId: MasterData.VernierId,
                        FriabilityID: MasterData.FriabilityID,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, "HH:mm:ss"),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        NMT: MasterData.NMT,
                        Nom: MasterData.Nom,
                        T1NegTol: MasterData.T1NegTol,
                        T1PosTol: MasterData.T1PosTol,
                        T2NegTol: MasterData.T2NegTol,
                        T2PosTol: MasterData.T2PosTol,
                        T1NegTolActual: MasterData.T1NegTolActual,
                        T1PosTolActual: MasterData.T1PosTolActual,
                        T2NegTolActual: MasterData.T2NegTolActual,
                        T2PosTolActual: MasterData.T2PosTolActual,
                        NomEmpty: MasterData.NomEmpty,
                        T1NegEmpty: MasterData.T1NegEmpty,
                        T1PosEmpty: MasterData.T1PosEmpty,
                        T2NegEmpty: MasterData.T2NegEmpty,
                        T2PosEmpty: MasterData.T2PosEmpty,
                        NomNet: MasterData.NomNet,
                        T1NegNet: MasterData.T1NegNet,
                        T1PosNet: MasterData.T1PosNet,
                        T2NegNet: MasterData.T2NegNet,
                        T2PosNet: MasterData.T2PosNet,
                        T1NegNetActual: MasterData.T1NegNetActual,
                        T1PosNetActual: MasterData.T1PosNetActual,
                        T2NegNetActual: MasterData.T2NegNetActual,
                        T2PosNetActual: MasterData.T2PosNetActual,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        Lot: MasterData.Lot,
                        NoOfAbove1: MasterData.NoOfAbove1,
                        NoOfBelow1: MasterData.NoOfBelow1,
                        NoOfAbove2: MasterData.NoOfAbove2,
                        NoOfBelow2: MasterData.NoOfBelow2,
                        MinPer: MasterData.MinPer,
                        MaxPer: MasterData.MaxPer,
                        GroupWeight: MasterData.GroupWeight,
                        AvgWeight: MasterData.AvgWeight,
                        AvgEmpty: MasterData.AvgEmpty,
                        AvgNet: MasterData.AvgNet,
                        MinWeight: MasterData.MinWeight,
                        MaxWeight: MasterData.MaxWeight,
                        MinWeightEmpty: MasterData.MinWeightEmpty,
                        MaxWeightEmpty: MasterData.MaxWeightEmpty,
                        MinWeightNet: MasterData.MinWeightNet,
                        MaxWeightNet: MasterData.MaxWeightNet,
                        StdDev: MasterData.StdDev,
                        Remark: MasterData.Remark,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        Layer: MasterData.Layer,
                        LayerName: MasterData.LayerName,
                        HMIID: int_hmiID,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        TotalWeight: MasterData.TotalWeight,
                        MinGrpWeight: MasterData.MinGrpWeight,
                        MaxGrpWeight: MasterData.MaxGrpWeight,
                        AvgGrpWeight: MasterData.AvgGrpWeight,
                        Stage: MasterData.Stage,
                        StdLimit1: MasterData.StdLimit1,
                        StdLimit2: MasterData.StdLimit2,
                        Deviation: MasterData.Deviation,
                        SieveID: MasterData.SieveID,
                        CheckedByTime: date.format(MasterData.CheckedByTime, "HH:mm:ss")
                    };

                    await models[tbl_TempMaster].create(insertTempData, { 
                        transaction: t 
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });
    
                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValue: data.DataValue,
                            DP: data.DP,
                            MeshValue: data.MeshValue,
                            QuantityRetained: data.QuantityRetained,
                            HMIID: int_hmiID,
                            ProductType: productType,
                            WgmtModeNo: WeighmentModeNo,
                            T2NegTol: data.T2NegTol,
                            T2PosTol: data.T2PosTol,
                            SampleQuantity:data.SampleQuantity,
                            FinePer:data.FinePer
                        };
    
                        if (value.reportOption == '% Fine' || value.reportOption == 'Fine %' || 
                            value.reportOption == '% Fine Layer 1' || value.reportOption == '% Fine Layer 2') 
                        {
                            insertTempDetail.T2NegTol = data.T2NegTol;
                            insertTempDetail.T2PosTol = data.T2PosTol;
                            insertTempDetail.SampleQuantity = data.SampleQuantity;
                            insertTempDetail.FinePer = data.FinePer;
                        }
        
                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });

            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertParticleSizeTempTable_Consolidated() : ", error);
            throw error;
        }
    }

    IsDataValueValid(DataValue) {
        try {
            let int_cnt = 0;
            let strArr_InvalidChars = ["NA", "FL", "--", "99999.00", "99999", 
                "99998.00", "99998", "0", "9999", "9999.00"];
            
            if (strArr_InvalidChars.includes(DataValue)) {
                int_cnt = int_cnt + 1;
            }
            if (int_cnt > 0) {
                return true;
            } else {
                return false;
            }

        } catch (error) {
            console.log("IsDataValueValid() : ", error);
            throw error;
        }
    }

}

module.exports = TabletCapsuleModel;