var IterateObject = require("iterate-object");
const clsNewCompressed = require('./clsNewProductAuditComp.class');

class clsNewCapsule extends clsNewCompressed {

    validateIndividual(objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                   Nomenclature: "",
                    Unit: ""
                }
            };

            var IsChanged = false;

            /**
             * For Individual Nom
             */

            if (objProductNew.flt_IndT1Neg != "" && objProductNew.flt_IndT1Neg != null) {
                if ((objProductNew.flt_IndT1Neg != 99999) || (objProductNew.flt_IndT1Neg != undefined)) {
                    objIndividual.Individual.Nom = objProductNew.flt_IndStd != "" ? objProductNew.flt_IndStd : false;
                    objIndividual.Individual.T1Neg = objProductNew.flt_IndT1Neg != "" ? objProductNew.flt_IndT1Neg : false;
                    objIndividual.Individual.T1Pos = objProductNew.flt_IndT1Pos != "" ? objProductNew.flt_IndT1Pos : false;
                    objIndividual.Individual.T2Neg = objProductNew.flt_IndT2Neg != "" ? objProductNew.flt_IndT2Neg : false;
                    objIndividual.Individual.T2Pos = objProductNew.flt_IndT2Pos != "" ? objProductNew.flt_IndT2Pos : false;
                    objIndividual.Individual.NMT = objProductNew.int_IndNMTTabCnt != "" ? objProductNew.int_IndNMTTabCnt : false;
                    objIndividual.Individual.LimitOn = objProductNew.str_IndLimitOn != "" ? objProductNew.str_IndLimitOn : false;
                    objIndividual.Individual.ReportOn = objProductNew.str_IndGraphOn != "" ? objProductNew.str_IndGraphOn : false;
                   objIndividual.Individual.Nomenclature = objProductNew.str_ind_nomNomnclature != "" ? objProductNew.str_ind_nomNomnclature : false;
                    objIndividual.Individual.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        })
    }

    
    validateGourp(objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Unit: ""
                }
            };

            var IsChanged = false;


            if (objProductNew.flt_GrpT1Neg != "" && objProductNew.flt_GrpT1Neg != null) {
                if ((objProductNew.flt_GrpT1Neg != 99999) || (objProductNew.flt_GrpT1Neg != undefined)) {
                    objGroup.Group.Nom = objProductNew.flt_GrpStd != "" ? objProductNew.flt_GrpStd : false;
                    objGroup.Group.T1Neg = objProductNew.flt_GrpT1Neg != "" ? objProductNew.flt_GrpT1Neg : false;
                    objGroup.Group.T1Pos = objProductNew.flt_GrpT1Pos != "" ? objProductNew.flt_GrpT1Pos : false;
                    objGroup.Group.T2Neg = objProductNew.flt_GrpT2Neg != "" ? objProductNew.flt_GrpT2Neg : false;
                    objGroup.Group.T2Pos = objProductNew.flt_GrpT2Pos != "" ? objProductNew.flt_GrpT2Pos : false;
                    objGroup.Group.NMT = objProductNew.int_GrpNMTTabCnt != "" ? objProductNew.int_GrpNMTTabCnt : false;
                    objGroup.Group.LimitOn = objProductNew.str_GrpLimitOn != "" ? objProductNew.str_GrpLimitOn : false;
                    objGroup.Group.ReportOn = objProductNew.str_GrpGraphOn != "" ? objProductNew.str_GrpGraphOn : false;
                    objGroup.Group.Unit = objProductNew.str_groupUnit != "" ? objProductNew.str_groupUnit : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        })
    }

    validateNet(objProductNew) {
        return new Promise((resolve, reject) => {
            const objNet = {
                Net: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    // NMT: "",
                    //LimitOn: "",
                    // ReportOn: "",
                    //Nomenclature: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            /**
             * For Net Nom
             */

            if (objProductNew.flt_DiffNetT1Neg != "" && objProductNew.flt_DiffNetT1Neg != null) {
                if ((objProductNew.flt_DiffNetT1Neg != 99999) || (objProductNew.flt_DiffNetT1Neg != undefined)) {
                    objNet.Net.Nom = objProductNew.flt_DiffNet != "" ? objProductNew.flt_DiffNet : false;
                    objNet.Net.T1Neg = objProductNew.flt_DiffNetT1Neg != "" ? objProductNew.flt_DiffNetT1Neg : false;
                    objNet.Net.T1Pos = objProductNew.flt_DiffNetT1Pos != "" ? objProductNew.flt_DiffNetT1Pos : false;
                    objNet.Net.T2Neg = objProductNew.flt_DiffNetT2Neg != "" ? objProductNew.flt_DiffNetT2Neg : false;
                    objNet.Net.T2Pos = objProductNew.flt_DiffNetT2Pos != "" ? objProductNew.flt_DiffNetT2Pos : false;
                    // objNet.Net.NMT = objProductNew.flt_DiffNetNMTCnt != "" ? objProductNew.flt_DiffNetNMTCnt : false;
                    //objNet.Net.LimitOn = objProductNew.flt_DiffNetLimitOn != "" ? objProductNew.flt_DiffNetLimitOn : false;
                    // objNet.Net.ReportOn = objProductNew.flt_DiffNetGraphOn != "" ? objProductNew.flt_DiffNetGraphOn : false;
                    objNet.Net.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objNet);
            }
            resolve(IsChanged);
        })


    }

    validateEmpty(objProductNew) {
        return new Promise((resolve, reject) => {
            const objEmpty = {
                Empty: {
                    //Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    //LimitOn: "",
                    ReportOn: "",
                    //Nomenclature: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            /**
             * For Empty Nom
             */

            if (objProductNew.flt_EmptyT1Neg != "" && objProductNew.flt_EmptyT1Neg != null) {
                if ((objProductNew.flt_EmptyT1Neg != 99999) || (objProductNew.flt_EmptyT1Neg != undefined)) {
                    //objEmpty.Empty.Nom = objProductNew.flt_Emptystd != "" ? objProductNew.flt_Emptystd : false;
                    objEmpty.Empty.T1Neg = objProductNew.flt_EmptyT1Neg != "" ? objProductNew.flt_EmptyT1Neg : false;
                    objEmpty.Empty.T1Pos = objProductNew.flt_EmptyT1Pos != "" ? objProductNew.flt_EmptyT1Pos : false;
                    objEmpty.Empty.T2Neg = objProductNew.flt_EmptyT2Neg != "" ? objProductNew.flt_EmptyT2Neg : false;
                    objEmpty.Empty.T2Pos = objProductNew.flt_EmptyT2Pos != "" ? objProductNew.flt_EmptyT2Pos : false;
                    objEmpty.Empty.NMT = objProductNew.flt_EmptyNMTCnt != "" ? objProductNew.flt_EmptyNMTCnt : false;
                    //objEmpty.Empty.LimitOn = objProductNew.flt_EmptyLimitOn != "" ? objProductNew.flt_EmptyLimitOn : false;
                    objEmpty.Empty.ReportOn = objProductNew.flt_EmptyGraphOn != "" ? objProductNew.flt_EmptyGraphOn : false;
                    objEmpty.Empty.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objEmpty);
            }
            resolve(IsChanged);
        })


    }

    validateContent1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent1 = {
                Content1: {
                    //Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Type: "",
                    Name: "",
                    Unit:""
                }
            };
            var IsChanged = false;

            /**
             * For Empty Nom
             */

            if (objProductNew.flt_Content1Std != "" && objProductNew.flt_Content1Std != null) {
                if ((objProductNew.flt_Content1Std != 99999) || (objProductNew.flt_Content1Std != undefined)) {
                    objContent1.Content1.Nom = objProductNew.flt_Content1Std != "" ? objProductNew.flt_Content1Std : false;
                    objContent1.Content1.T1Neg = objProductNew.flt_Content1T1Neg != "" ? objProductNew.flt_Content1T1Neg : false;
                    objContent1.Content1.T1Pos = objProductNew.flt_Content1T1Pos != "" ? objProductNew.flt_Content1T1Pos : false;
                    objContent1.Content1.T2Neg = objProductNew.flt_Content1T2Neg != "" ? objProductNew.flt_Content1T2Neg : false;
                    objContent1.Content1.T2Pos = objProductNew.flt_Content1T2Pos != "" ? objProductNew.flt_Content1T2Pos : false;
                    objContent1.Content1.NMT = objProductNew.int_Content1NMTTabCnt != "" ? objProductNew.int_Content1NMTTabCnt : false;
                    objContent1.Content1.LimitOn = objProductNew.str_Content1LimitOn != "" ? objProductNew.str_Content1LimitOn : false;
                    objContent1.Content1.ReportOn = objProductNew.str_Content1GraphOn != "" ? objProductNew.str_Content1GraphOn : false;
                    objContent1.Content1.Type = objProductNew.str_content1_type != "" ? objProductNew.str_content1_type : false;
                    objContent1.Content1.Name = objProductNew.str_content1_Name != "" ? objProductNew.str_content1_Name : false;
                    objContent1.Content1.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objContent1);
            }
            resolve(IsChanged);
        })
    }

    validateContent2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent2 = {
                Content2: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Type: "",
                    Name: "",
                    Unit:""
                }
            };
            var IsChanged = false;

            /**
             * For Empty Nom
             */

            if (objProductNew.flt_Content2Std != "" && objProductNew.flt_Content2Std != null) {
                if ((objProductNew.flt_Content2Std != 99999) || (objProductNew.flt_Content2Std != undefined)) {
                    objContent2.Content2.Nom = objProductNew.flt_Content2Std != "" ? objProductNew.flt_Content2Std : false;
                    objContent2.Content2.T1Neg = objProductNew.flt_Content2T1Neg != "" ? objProductNew.flt_Content2T1Neg : false;
                    objContent2.Content2.T1Pos = objProductNew.flt_Content2T1Pos != "" ? objProductNew.flt_Content2T1Pos : false;
                    objContent2.Content2.T2Neg = objProductNew.flt_Content2T2Neg != "" ? objProductNew.flt_Content2T2Neg : false;
                    objContent2.Content2.T2Pos = objProductNew.flt_Content2T2Pos != "" ? objProductNew.flt_Content2T2Pos : false;
                    objContent2.Content2.NMT = objProductNew.int_Content2NMTTabCnt != "" ? objProductNew.int_Content2NMTTabCnt : false;
                    objContent2.Content2.LimitOn = objProductNew.str_Content2LimitOn != "" ? objProductNew.str_Content2LimitOn : false;
                    objContent2.Content2.ReportOn = objProductNew.str_Content2GraphOn != "" ? objProductNew.str_Content2GraphOn : false;
                    objContent2.Content2.Type = objProductNew.str_content2_type != "" ? objProductNew.str_content2_type : false;
                    objContent2.Content2.Name = objProductNew.str_content2_Name != "" ? objProductNew.str_content2_Name : false;
                    objContent2.Content2.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objContent2);
            }
            resolve(IsChanged);
        })
    }

    validateContent3(objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent3 = {
                Content3: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Type: "",
                    Name: "",
                    Unit:""
                }
            };
            var IsChanged = false;

            /**
             * For Empty Nom
             */

            if (objProductNew.flt_Content3Std != "" && objProductNew.flt_Content3Std != null) {
                if ((objProductNew.flt_Content3Std != 99999) || (objProductNew.flt_Content3Std != undefined)) {
                    objContent3.Content3.Nom = objProductNew.flt_Content3Std != "" ? objProductNew.flt_Content3Std : false;
                    objContent3.Content3.T1Neg = objProductNew.flt_Content3T1Neg != "" ? objProductNew.flt_Content3T1Neg : false;
                    objContent3.Content3.T1Pos = objProductNew.flt_Content3T1Pos != "" ? objProductNew.flt_Content3T1Pos : false;
                    objContent3.Content3.T2Neg = objProductNew.flt_Content3T2Neg != "" ? objProductNew.flt_Content3T2Neg : false;
                    objContent3.Content3.T2Pos = objProductNew.flt_Content3T2Pos != "" ? objProductNew.flt_Content3T2Pos : false;
                    objContent3.Content3.NMT = objProductNew.int_Content3NMTTabCnt != "" ? objProductNew.int_Content3NMTTabCnt : false;
                    objContent3.Content3.LimitOn = objProductNew.str_Content3LimitOn != "" ? objProductNew.str_Content3LimitOn : false;
                    objContent3.Content3.ReportOn = objProductNew.str_Content3GraphOn != "" ? objProductNew.str_Content3GraphOn : false;
                    objContent3.Content3.Type = objProductNew.str_content3_type != "" ? objProductNew.str_content3_type : false;
                    objContent3.Content3.Name = objProductNew.str_content3_Name != "" ? objProductNew.str_content3_Name : false;
                    objContent3.Content3.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objContent3);
            }
            resolve(IsChanged);
        })
    }

    validateContent4(objProductNew) {
        return new Promise((resolve, reject) => {
            const objContent4 = {
                Content4: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Type: "",
                    Name: "",
                    Unit:""
                }
            };
            var IsChanged = false;

            /**
             * For Empty Nom
             */

            if (objProductNew.flt_Content4Std != "" && objProductNew.flt_Content4Std != null) {
                if ((objProductNew.flt_Content4Std != 99999) || (objProductNew.flt_Content4Std != undefined)) {
                    objContent4.Content4.Nom = objProductNew.flt_Content4Std != "" ? objProductNew.flt_Content4Std : false;
                    objContent4.Content4.T1Neg = objProductNew.flt_Content4T1Neg != "" ? objProductNew.flt_Content4T1Neg : false;
                    objContent4.Content4.T1Pos = objProductNew.flt_Content4T1Pos != "" ? objProductNew.flt_Content4T1Pos : false;
                    objContent4.Content4.T2Neg = objProductNew.flt_Content4T2Neg != "" ? objProductNew.flt_Content4T2Neg : false;
                    objContent4.Content4.T2Pos = objProductNew.flt_Content4T2Pos != "" ? objProductNew.flt_Content4T2Pos : false;
                    objContent4.Content4.NMT = objProductNew.int_Content4NMTTabCnt != "" ? objProductNew.int_Content4NMTTabCnt : false;
                    objContent4.Content4.LimitOn = objProductNew.str_Content4LimitOn != "" ? objProductNew.str_Content4LimitOn : false;
                    objContent4.Content4.ReportOn = objProductNew.str_Content4GraphOn != "" ? objProductNew.str_Content4GraphOn : false;
                    objContent4.Content4.Type = objProductNew.str_content4_type != "" ? objProductNew.str_content4_type : false;
                    objContent4.Content4.Name = objProductNew.str_content4_Name != "" ? objProductNew.str_content4_Name : false;
                    objContent4.Content4.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objContent4);
            }
            resolve(IsChanged);
        })
    }

    async newCapsuleParams(objProductNew) {
        var Ind = await this.validateIndividual(objProductNew);
        var Grp = await this.validateGourp(objProductNew);
        var net = await this.validateNet(objProductNew);
        var empty = await this.validateEmpty(objProductNew);
        var Len = await this.validateLengthCap(objProductNew);
        var Dia = await this.validateDiameter(objProductNew);
        var dt = await this.validateDT(objProductNew);
        var Content1 = await this.validateContent1(objProductNew);
        var Content2 = await this.validateContent2(objProductNew);
        var Content3 = await this.validateContent3(objProductNew);
        var Content4 = await this.validateContent4(objProductNew);

        if (Ind != true && Grp != true && Len != true && net != true && empty != true && dt != true && 
            Dia != true && Content1 != true && Content2 != true && Content3 != true && Content4 != true) {
            //return  { newData: 'NA' };
            return { result: 'No Change' };
        }
        else {
            //var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {

                var i = 1;
                var obj = value;
                IterateObject(obj, (value, key) => {
                    //console.log(value);
                    if (value !== false) {
                        if (i == 1) {
                            key1 = (key1 === 'Net' ? 'Filled Content Weight' : ( key1 === 'Length' ? 'Seal Length' : key1));
                            //strNewValue = strNewValue + "|" + key1;
                            strNewValue = strNewValue + " " + key1 + "-";
                           
                        }
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + value + ",";
                        // ", ";
                        i = i + 1;
                    }

                })
            });

            return { newData: strNewValue };
        }
    }

}
module.exports = clsNewCapsule;