
const requestIp = require('request-ip');
const date = require('date-and-time');
//const ReportModel = require('../model/clsReportModel');
const models = require("../dbConnection").models;
const sequelize = require('./../dbConnection').sequelize;
const { Op } = require("sequelize");
const moment = require('moment');

class Instrument
{
   async saveTempData(req) {
        try {
            const objResult = [];
            var mainData = req.body.data;
            let Ip = requestIp.getClientIp(req);
            var ClientIp = Ip.split(':')[3]
            if (ClientIp === undefined) {
                ClientIp = '127.0.0.1'
            } else {
                ClientIp = ClientIp
            }
            //var ipVal = ClientIp.split('.')[3];
            var ipVal = ClientIp;
            var formDate = mainData.FromDate;
            var toDate = mainData.ToDate;
            var selectedValue = mainData.SelectedValue;
            var selectedAction = mainData.SelectedAction; 
            //var selectedValue = mainData.SelectedValue;
            var str_query;
            if (selectedValue == "Balance")
            {
                //strTableName = 'tbl_instrumentlog_balance';
                str_query  = await models.tbl_instrumentlog_balance.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Disintegration Tester")
            {
                //strTableName = 'tbl_instrumentlog_dt';
                str_query  = await models.tbl_instrumentlog_dt.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Friabilator")
            {
                //strTableName = 'tbl_instrumentlog_friability';
                str_query  = await models.tbl_instrumentlog_friability.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Hardness")
            {
                //strTableName = 'tbl_instrumentlog_hardness';
                str_query  = await models.tbl_instrumentlog_hardness.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Tablet Tester")
            {
                //strTableName = 'tbl_instrumentlog_hardness';
                str_query  = await models.tbl_instrumentlog_hardness.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Moisture Analyzer")
            {
                //strTableName = 'tbl_instrumentlog_lod';
                str_query  = await models.tbl_instrumentlog_lod.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Sieve Shaker")
            {
                //strTableName = 'tbl_instrumentlog_sieveshaker';
                str_query  = await models.tbl_instrumentlog_sieveshaker.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Tap Density")
            {
                //strTableName = 'tbl_instrumentlog_tapdensity';
                str_query  = await models.tbl_instrumentlog_tapdensity.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            else if (selectedValue == "Vernier")
            {
                str_query  = await models.tbl_instrumentlog_vernier.findAll({
                    where: {
                        EqpID:{[Op.eq]:selectedAction},
                        FromDT:{[Op.gte]:formDate},
                        ToDT:{[Op.lte]:toDate}
                    },
                    order: [
                        ['FromDT', 'DESC'],
                        ['FromTM', 'DESC'],
                    ],
                });
            }
            const instrumentVal = await this.insertTempData(req, str_query, ipVal);
            objResult.push(instrumentVal);
            return objResult 
        } catch (error) {
            return error;
        }
    }

   async insertTempData(req, str_query, ipVal) {
        try {
            let responseObj = {}; 
            var mainData = req.body.data;
            var result = str_query;
            var selectedValue = mainData.SelectedValue;
            var userId = mainData.UserId;
            var userName = mainData.UserName;
            var selectedAction = mainData.SelectedAction; 
            var formDate = mainData.FromDate;
            var toDate = mainData.ToDate;
            var waterMark = mainData.waterMark
            
            if(result.length == 0)
                {
                    Object.assign(responseObj, { status: 'success' }, { result: 'Data not exist' });
                    return responseObj;
                }
                else
                {
                    var resultData = result;
                    const deleteData = await models.tbl_temp_usage_instrument.destroy({
                        where: {
                            HMI_ID: ipVal
                        }
                    });
                   
                    for (let i = 0; i < resultData.length; i++)
                    {
                        
                        const tempData = await models.tbl_temp_usage_instrument.create({
                            Instru_RecNo : resultData[i].RecNo,
                            EqpID : resultData[i].EqpID,
                            FromDT : resultData[i].FromDT,
                            ToDT : resultData[i].ToDT,
                            FromTM : moment(resultData[i].FromTM).format('HH:mm:ss'),
                            ToTM : moment(resultData[i].ToTM).format('HH:mm:ss'),
                            BatchNo : resultData[i].BatchNo,
                            BFGCode : resultData[i].BFGCode,
                            Activity : resultData[i].Activity,
                            UserId : resultData[i].UserId,
                            UserName : resultData[i].UserName,
                            Instrument_Type : selectedValue,
                            department_name : resultData[i].department_name,
                            HMI_ID : ipVal 
                        });

                    }
                    let objData = {};
                    Object.assign(objData, { SelectedValue: selectedValue }, { UserId: userId }, { UserName: userName },
                    { HmiId: ipVal }, { SelectedAction: selectedAction },{ FromDate: formDate },{ ToDate: toDate },
                    { waterMark: waterMark });
                    return objData;
                }
        } catch (error) {
            return error;
        }
    }

  async getEqpIdFromInstrumentLog(req) {
       try {
        var str_eqpType = req.body.eqpType;
        var obj_instLog;
        switch(str_eqpType)
        {
            case 'Balance':
                    //str_tableName = "tbl_instrumentlog_balance";
                    obj_instLog =  await models.tbl_instrumentlog_balance.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                        
                    });
            break;
            case 'Vernier':
                    //str_tableName = "tbl_instrumentlog_vernier";
                    obj_instLog =  await models.tbl_instrumentlog_vernier.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                       
                    });
            break;
            case 'Disintegration Tester':
                    //str_tableName = "tbl_instrumentlog_dt";
                    obj_instLog =  await models.tbl_instrumentlog_dt.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                        
                    });
            break;
            case 'Hardness':
                    //str_tableName = "tbl_instrumentlog_hardness";
                    obj_instLog =  await models.tbl_instrumentlog_hardness.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                       
                    });
            break;
            case 'Tablet Tester':
                    //str_tableName = "tbl_instrumentlog_hardness";
                    obj_instLog =  await models.tbl_instrumentlog_hardness.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                       
                    });
            break;
            case 'Friabilator':
                    //str_tableName = "tbl_instrumentlog_friability";
                    obj_instLog =  await models.tbl_instrumentlog_friability.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                        
                    });
            break;
            case 'Moisture Analyzer':
                    //str_tableName = "tbl_instrumentlog_lod";
                    obj_instLog =  await models.tbl_instrumentlog_lod.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                        
                    });
            break;
            case 'Tap Density':
                    //str_tableName = "tbl_instrumentlog_tapdensity";
                    obj_instLog =  await models.tbl_instrumentlog_tapdensity.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                        
                    });
            break;
            case 'Sieve Shaker':
                    //str_tableName = "tbl_instrumentlog_sieveshaker";
                    obj_instLog =  await models.tbl_instrumentlog_sieveshaker.findAll({
                        attributes: [[sequelize.fn('DISTINCT', sequelize.col('EqpID')), 'EqpID']],
                        
                    });
            break;
            default:
            break;
        }
        var result = obj_instLog;
        return result;
       } catch (error) {
          return error;
       }
    }
}
module.exports = Instrument;
