const date = require('date-and-time')
const Database = require('../database/clsQueryProcess');
const database = new Database();
const requestIp = require('request-ip');
const moment = require('moment-timezone');
var dateFormat = require('dateformat');
const jsonfile = require('jsonfile');
const loginmodel = require('./clsloginModel');
const loginobj = new loginmodel;
const serverConfig = require('../global/serverConfig');

// var mysql = require('mysql2');
var models = require("../dbConnection").models;
const { Op, JSON } = require("sequelize");
const { QueryTypes } = require('sequelize');
const sequelize = require('./../dbConnection').sequelize;
const seqTransaction = require("../dbConnection");

class DailyCalibReport {
    /**
     * Modification on 09/06/2022 - if balance is not used/calibrated then ask for no reason in failure section. 
     * balance list should be displayed from area setting
     */
    async getBalanceID(req) {
        try {
            let obj_response = {};
            var str_tableName = "", sarr_notused = [];

            var dt_day = moment(req.body.date, 'YYYY-MM').daysInMonth();
            var dt_from = req.body.date + '-01';
            var dt_to = req.body.date + '-' + dt_day;

            (req.body.reportType == "Complete") ? str_tableName = "tbl_calibration_daily_master" :
                str_tableName = "tbl_calibration_daily_master_incomplete";

            let obj_getBalID = await models['' + str_tableName].findAll
                ({
                    attributes: [[sequelize.fn('DISTINCT', sequelize.col('Daily_BalID')), 'Daily_BalID']],
                    where:
                    {
                        Daily_CalbDate: { [Op.between]: [dt_from, dt_to] }
                    }

                });
                
                var result = obj_getBalID;

            Object.assign(obj_response, { status: 'success' }, { result: result }, { sarr_notused: sarr_notused });
            console.log("3", sarr_notused);
            return obj_response;
        }
        catch (error) {
            console.log(error);
            throw error;
        }
    }
    /** get balances from incomplete and cubicle - No use*/
    async getBalanceListNotUsed(dt_from, dt_to) {
        try {
            var sarr_noUse = [], sarr_Cubicle = [], sarr_Cubicle_obj = [], sarr_incomplete = [];

            let obj_balID_Setting = await models.tbl_cubical.findAll({
                attributes: [[sequelize.fn('DISTINCT', sequelize.col('Sys_BalID')), 'Sys_BalID']],
                where:
                {
                    Sys_BalID: { [Op.ne]: 'None' },
                }
            });

            for (var i of obj_balID_Setting) {
                sarr_Cubicle.push(i.Sys_BalID);
                sarr_Cubicle_obj.push(Object.assign({ "Daily_BalID": i.Sys_BalID }));
            }

            let query1 = `SELECT DISTINCT Daily_BalID FROM tbl_calibration_daily_master_incomplete where Daily_CalbDate between '${dt_from}' and '${dt_to}'`;
            var result_balance = await sequelize.query(query1, { type: QueryTypes.SELECT });
            if (result_balance.length > 0) {
                for (var i of result_balance) {
                    sarr_incomplete.push(i.Daily_BalID);
                }
            }

            if (result_balance.length > 0) {
                var sarr = sarr_Cubicle.concat(sarr_incomplete);
                let uniqueChars = [...new Set(sarr)];

                for (const k of uniqueChars) {
                    sarr_noUse.push(Object.assign({ "Daily_BalID": k }));
                }

                return sarr_noUse;
            }
            else {
                return sarr_Cubicle_obj;
            }

        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async getBalanceListNotUsed_Cubicle(str) {
        try {
            var sarr_cubicle = [], sarr_cubicle1 = [];
            let obj_balID_Setting = await models.tbl_cubical.findAll({
                attributes: [[sequelize.fn('DISTINCT', sequelize.col('Sys_BalID')), 'Sys_BalID']],
                where:
                {
                    Sys_BalID: { [Op.ne]: 'None' },
                }
            });

            for (var i of obj_balID_Setting) {
                // sarr_cubicle.push(Object.assign({ "Daily_BalID": i.Sys_BalID }));
                sarr_cubicle1.push(i.Sys_BalID);
            }


            if (str != "NA") {
                var sarr_bal = [];
                for (var m of str) {
                    sarr_bal.push(m.Daily_BalID);
                }
                var sarr_val = [];

                for (const k of sarr_bal) {
                    var findIn = sarr_cubicle1.indexOf(k);
                    sarr_cubicle1.splice(findIn, 1);
                }


                // sarr_bal.forEach(strEle => {
                //     sarr_cubicle1.forEach(ele => {
                //         if (strEle !== ele) {
                //             if(sarr_val.includes(ele) == false)
                //             {
                //                 sarr_val.push(ele);
                //             }

                //         }
                //     });

                // })

                // sarr_cubicle = [];
                for (const l of sarr_cubicle1) {
                    sarr_val.push(Object.assign({ "Daily_BalID": l }));
                }

            }

            return sarr_val;
        } catch (error) {
            console.log(error);
            return error;
        }
    }

    async getDailyReportPrintCount(req) {
        try {
            let obj_response = {};

            var obj_getPrintCount = await models.tbl_calibration_daily_print.findAll
                ({
                    attributes:
                        [
                            [sequelize.fn('MAX', sequelize.col("PrintNo")), "PrintNo"],
                        ],
                    where:
                    {
                        'BalanceID': req.body.balId,
                        'Title': req.body.title,
                        'Rept_Month': req.body.month,
                        'Rept_Year': req.body.year,
                        'Daily_CalibChange': req.body.calibChange,
                        'Incomplete': (req.body.reportType == "Complete") ? 0 : 1,
                    },
                    raw: true
                })

            let result = obj_getPrintCount;

            Object.assign(obj_response, { status: 'success' }, { result: result[0] })
            return obj_response;
        }
        catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getDailyCalibrationFailedRemark(req) {
        try {
            let obj_response = {};
            let now = new Date();
            var year = req.body.date.split('-')[0];
            var month = req.body.date.split('-')[1];
            var day = moment(req.body.date, 'YYYY-MM').daysInMonth();
            var fromDate = req.body.date + '-01';
            var tDate = date.addDays(now, 1);
            var dec = moment(tDate);

            // getting date in IST format
            var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
            var toDate = normalDate.split(" ")[0];
            var arrMonth = [], arr_noCalibDate = [];

            for (var i = 1; i <= day; i++) {
                var datecount;

                if (i.toString().length == 1) {
                    datecount = '0' + i;
                }
                else {
                    datecount = i;
                }
                var monthDate = year + "-" + month + "-" + datecount;

                if (monthDate <= toDate) {
                    arrMonth.push(monthDate);
                }
            }

            let obj_getCalibDate = await models.tbl_calibration_daily_master_incomplete.findAll
                ({
                    attributes: [[sequelize.fn('DISTINCT', sequelize.col('Daily_CalbDate')), 'Daily_CalbDate']],
                    where:
                    {
                        Daily_CalbDate: { [Op.between]: [fromDate, toDate] },
                        Daily_BalID: req.body.balId,
                        CalibrationStatus: 'NULL',
                        Daily_CalibChange: req.body.calibChange
                    }
                });
            var result = obj_getCalibDate;

            if (result.length != 0) {
                for (var k = 0; k < result.length; k++) {
                    var dt_noCalibDate = dateFormat(result[k].Daily_CalbDate, "yyyy-mm-dd");
                    arr_noCalibDate.push(dt_noCalibDate);
                }

                Object.assign(obj_response, { status: 'success' }, { result: arr_noCalibDate })
                return obj_response;
            }
            else {
                Object.assign(obj_response, { status: 'success' }, { result: 'No Records Found' })
                return obj_response;
            }
        }
        catch (error) {
            console.log("getDailyCalibrationFailedRemark", error);
            return error;
        }
    }

    async getDailyCalibrationFailedTime(req) {
        try {
            let obj_response = {};
            let now = new Date();
            var year = req.body.date.split('-')[0];
            var month = req.body.date.split('-')[1];
            var day = moment(req.body.date, 'YYYY-MM').daysInMonth();
            var fromDate = req.body.date + '-01';
            var tDate = date.addDays(now, 1);
            var dec = moment(tDate);
            // getting date in IST format
            var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
            var toDate = normalDate.split(" ")[0];
            var arrMonth = [];
            var arr_noCalibTime = [];

            for (var i = 1; i <= day; i++) {
                var datecount;

                if (i.toString().length == 1) {
                    datecount = '0' + i;
                }
                else {
                    datecount = i;
                }
                var monthDate = year + "-" + month + "-" + datecount;

                if (monthDate <= toDate) {
                    arrMonth.push(monthDate);
                }
            }

            let obj_getCalibTime = await models.tbl_calibration_daily_master_incomplete.findAll
                ({
                    attributes: ['Daily_CalbTime', 'Daily_CalbDate'],
                    where:
                    {
                        Daily_CalbDate: req.body.date,
                        Daily_BalID: req.body.balId,
                        CalibrationStatus: 'NULL',
                        Daily_CalibChange: req.body.calibChange
                    }
                });
            var result = obj_getCalibTime;

            if (result.length != 0) {
                for (var k = 0; k < result.length; k++) {
                    var tm_calibTime = date.format(result[k].Daily_CalbTime, 'HH:mm:ss');
                    arr_noCalibTime.push(tm_calibTime);

                }

                Object.assign(obj_response, { status: 'success' }, { result: { time: arr_noCalibTime } })
                return obj_response;
            }
            else {
                Object.assign(obj_response, { status: 'success' }, { result: 'No Record Found' })
                return obj_response;
            }
        }
        catch (error) {
            console.log("getDailyCalibrationFailedTime", error);
            return error;
        }
    }

    async setNoCalibrationRemarkForDailyCalibration(req) {
        try {
            let obj_response = {};
            let now = new Date();

            // const obj_insertNoRemark = 
            // {
            //     str_tableName: 'tbl_calibration_daily_noremark',
            //     data: 
            //     [
            //         { str_colName: 'NDCR_BalanceID', value: req.body.balId },
            //         { str_colName: 'NDCR_Reason', value: req.body.reason },
            //         { str_colName: 'NDCR_DT', value: req.body.date },
            //         { str_colName: 'NDCR_AddedByID', value: req.body.UserId },
            //         { str_colName: 'NDCR_AddedByName', value: req.body.UserName },
            //         { str_colName: 'NDCR_AddedOn', value: date.format(now, 'YYYY-MM-DD') }
            //     ]
            // }
            // let result = await database.save(obj_insertNoRemark);

            const obj_insertNoRemark = await models.tbl_calibration_daily_noremark.create
                ({
                    NDCR_BalanceID: req.body.balId,
                    NDCR_Reason: req.body.reason,
                    NDCR_DT: req.body.date,
                    NDCR_AddedByID: req.body.UserId,
                    NDCR_AddedByName: req.body.UserName,
                    NDCR_AddedOn: date.format(now, 'YYYY-MM-DD'),
                    Daily_CalibChange: req.body.calibChange
                });
            let result = obj_insertNoRemark;

            Object.assign(obj_response, { status: 'success' }, { result: 'No Remark Added Successfully' })
            return obj_response;
        }
        catch (error) {
            console.log("setNoCalibrationRemarkForDailyCalibration", error);
            return error;
        }
    }

    async getNoCalibrationDatesForDailyCalibration(req) {
        try {
            let obj_response = {};
            let now = new Date();
            var year = req.body.date.split('-')[0];
            var month = req.body.date.split('-')[1];
            var day = moment(req.body.date, 'YYYY-MM').daysInMonth();
            var fromDate = req.body.date + '-01';
            var tDate = date.addDays(now, 0); //Current date should be displayed
            var dec = moment(tDate);
            // getting date in IST format
            var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
            var toDate = normalDate.split(" ")[0];
            var arrMonth = [];
            var arr_noCalibDate = [];
            var arr_calibDoneDate = [];

            for (var i = 1; i <= day; i++) {
                var datecount;

                if (i.toString().length == 1) {
                    datecount = '0' + i;
                }
                else {
                    datecount = i;
                }
                var monthDate = year + "-" + month + "-" + datecount;

                if (monthDate < toDate) {
                    arrMonth.push(monthDate);
                }
            }
            toDate = (monthDate <= toDate)? monthDate : toDate;

            const obj_getCalibDate = await models.tbl_calibration_daily_master.findAll
                ({
                    where:
                    {
                        Daily_BalID: req.body.balId,
                        Daily_CalbDate: { [Op.between]: [fromDate, toDate] },
                        Daily_CalibChange: req.body.calibChange
                    }
                });
            var str_masterResult = obj_getCalibDate;

            if (str_masterResult.length != 0) {
                for (var j = 0; j < str_masterResult.length; j++) {
                    var masterDate = str_masterResult[j].Daily_CalbDate;
                    var dec = moment(masterDate);
                    var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
                    var newDate = normalDate.split(" ")[0];
                    arr_calibDoneDate.push(newDate);
                }

                const obj_noCalibDate = await models.tbl_calibration_daily_noremark.findAll
                    ({
                        attributes: ['NDCR_DT'],
                        where:
                        {
                            NDCR_BalanceID: req.body.balId,
                            NDCR_DT: { [Op.between]: [fromDate, toDate] },
                            Daily_CalibChange: req.body.calibChange
                        }
                    });
                var obj_remarkResult = obj_noCalibDate;

                if (obj_remarkResult.length != 0) {
                    for (var k = 0; k < obj_remarkResult.length; k++) {
                        var dt_calibDateRemark = obj_remarkResult[k].NDCR_DT;
                        arr_noCalibDate.push(dt_calibDateRemark);
                    }

                    for (var l = 0; l < arr_noCalibDate.length; l++) {
                        var index = arrMonth.indexOf(arr_noCalibDate[l]);
                        if (index > -1) {
                            arrMonth.splice(index, 1);
                        }
                    }

                    for (var l = 0; l < arr_calibDoneDate.length; l++) {
                        var index = arrMonth.indexOf(arr_calibDoneDate[l]);
                        if (index > -1) {
                            arrMonth.splice(index, 1);
                        }
                    }

                    Object.assign(obj_response, { status: 'success' }, { result: arrMonth })
                    return obj_response;
                }
                else {
                    for (var l = 0; l < arr_calibDoneDate.length; l++) {
                        var index = arrMonth.indexOf(arr_calibDoneDate[l]);

                        if (index > -1) {
                            arrMonth.splice(index, 1);
                        }
                    }
                    Object.assign(obj_response, { status: 'success' }, { result: arrMonth })
                    return obj_response;
                }
            }
            else {
                // if (req.body.str_status == "Not") {
                //     var obj_getNoCalibDate = await models.tbl_calibration_daily_noremark.findAll
                //         ({
                //             attributes: ['NDCR_DT'],
                //             where:
                //             {
                //                 NDCR_DT: { [Op.between]: [fromDate, toDate] },
                //                 NDCR_BalanceID: req.body.balId
                //             }
                //         });
                // }
                // else {
                    var obj_getNoCalibDate = await models.tbl_calibration_daily_noremark.findAll
                        ({
                            attributes: ['NDCR_DT'],
                            where:
                            {
                                NDCR_DT: { [Op.between]: [fromDate, toDate] },
                            }
                        });
                // }

                var obj_remarkResult = obj_getNoCalibDate;

                if (obj_remarkResult.length != 0) {
                    for (var k = 0; k < obj_remarkResult.length; k++) {
                        var dt_remarkDate = obj_remarkResult[k].NDCR_DT;
                        arr_noCalibDate.push(dt_remarkDate);
                    }

                    for (var m = 0; m < arr_noCalibDate.length; m++) {
                        var index = arrMonth.indexOf(arr_noCalibDate[m]);

                        if (index > -1) {
                            arrMonth.splice(index, 1);
                        }

                        if (arr_calibDoneDate.length > 0) {
                            for (var m = 0; m < arr_calibDoneDate.length; m++) {
                                var index = arrMonth.indexOf(arr_calibDoneDate[m]);
                                if (index > -1) {
                                    arrMonth.splice(index, 1);
                                }
                            }
                        }

                    }
                    Object.assign(obj_response, { status: 'success' }, { result: arrMonth })
                    return obj_response;
                }
                else {
                    Object.assign(obj_response, { status: 'success' }, { result: arrMonth });
                    return obj_response;
                }
            }
        }
        catch (error) {
            console.log("getNoCalibrationDatesForDailyCalibration", error);
            return error;
        }
    }

    async setRemarkForFailedDailyCalibration(req) {
        try {
            var obj_response = {};

            const obj_getCalibData = await models.tbl_calibration_daily_master_incomplete.findAll
                ({
                    where:
                    {
                        Daily_CalbTime: req.body.time,
                    }
                });
            var result = obj_getCalibData;

            if (result.length != 0) {

                const obj_updateCalib = await models.tbl_calibration_daily_master_incomplete.update
                    (
                        {
                            CalibrationStatus: req.body.reason,
                            Daily_VerifyName: req.body.UserName,
                            Daily_VerifyID: req.body.UserId
                           
                        },
                        {
                            where: { Daily_RepNo: result[0].Daily_RepNo }
                        }
                    );
                let str_rescalib = obj_updateCalib;

                Object.assign(obj_response, { status: 'success' }, { result: 'Added Successfully' })
            }
            else {
                Object.assign(obj_response, { status: 'success' }, { result: 'No Record Found' })
            }
            return obj_response;
        }
        catch (error) {
            console.log("setRemarkForFailedDailyCalibration()", error);
            return error;
        }
    }

    async getMonthFromDate(int_month) {
        try {
            var str_month = "";
            var sarr_month = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
            (int_month == "01") ? str_month = sarr_month[0] : (int_month == "02") ? str_month = sarr_month[1] : (int_month == "03") ? str_month = sarr_month[2] :
                (int_month == "04") ? str_month = sarr_month[3] : (int_month == "05") ? str_month = sarr_month[4] : (int_month == "06") ? str_month = sarr_month[5] :
                    (int_month == "07") ? str_month = sarr_month[6] : (int_month == "08") ? str_month = sarr_month[7] : (int_month == "09") ? str_month = sarr_month[8] :
                        (int_month == "10") ? str_month = sarr_month[9] : (int_month == "11") ? str_month = sarr_month[10] : str_month = sarr_month[11];

            return str_month;
        } catch (error) {
            return error;
        }

    }

    async viewDailyCalibrationReportOld(req) {
        try {
            var arrMonth = [];
            var obj_response = {};
            var arr_calibMasterData = [];
            var str_stdWtBoxID = "", str_certificationNo = "", str_allStdWtBoxCertNo = "", str_allStdWtBoxValUpDt = "", str_allStdWtBoxCalUpDt = "";
            var checkCalibrationDone = false;
            const selectDetailRpt = await models.tbl_rpt_path.findAll({});
            var result = selectDetailRpt;

            var str_projectName = result[0]['proj_name'];

            let int_clientIP = requestIp.getClientIp(req);

            var str_date = req.body.date;
            var y = str_date.split('-')[0];
            var m = str_date.split('-')[1];
            // var day = moment(req.body.date, 'YYYY-MM').daysInMonth();
            if (req.body.startDate != undefined && req.body.endDate != -1) {
                day = Number(req.body.endDate);
                // start = req.body.calibChange == 0 ? 1 : Number(req.body.startDate.split("-")[2]);
            } else {
                day = moment(req.body.date, 'YYYY-MM').daysInMonth();
                // start = req.body.startDate != undefined ?  Number(req.body.startDate.split("-")[2]) : 1;
            }
            var start = (req.body.id == 1 || req.body.startDate == undefined) ? 1 : Number(req.body.startDate.split("-")[2]);
            var str_getMonth = await this.getMonthFromDate(m);
            var str_monthAndYear = str_getMonth + "-" + y

            for (var i = 1; i <= day; i++) {
                var datecount;
                if (i.toString().length == 1) {
                    datecount = '0' + i;
                }
                else {
                    datecount = i;
                }
                var monthDate = y + "-" + m + "-" + datecount;
                arrMonth.push(monthDate);
            }

            let completeData = await this.getDatFromMater(arrMonth, req.body.balId, req.body.reportType);
            let reCalibData = await this.getRecalibData(arrMonth, req.body.balId, req.body.reportType);
            let noRemarkData = await this.getNoRemarkData(arrMonth, req.body.balId);

            if ((completeData == false) && (reCalibData == false) && (noRemarkData == false)) {
                Object.assign(obj_response, { status: 'Wrong' }, { data: 'Data Not Found' })
                return obj_response;
            }
            else {
                if (completeData != false) {
                    if (completeData.length > 0) {
                        for (var i = 0; i < completeData.length; i++) {
                            arr_calibMasterData.push(completeData[i]);
                        }
                    }
                }

                if (reCalibData != false) {
                    if (reCalibData.length > 0) {
                        for (var j = 0; j < reCalibData.length; j++) {
                            arr_calibMasterData.push(reCalibData[j]);
                        }
                    }
                }

                if (noRemarkData != false) {
                    if (noRemarkData.length > 0) {
                        for (var k = 0; k < noRemarkData.length; k++) {
                            arr_calibMasterData.push(noRemarkData[k]);
                        }
                    }
                }

                var arr_masterData = await this.getMasterRecord(arrMonth, arr_calibMasterData);
                var arr_detailData = await this.getDetailRecord(arr_masterData, req.body.reportType);

                if (str_projectName != "SH") {
                    var deleteData = await this.deleteEntriesTemp(int_clientIP, str_projectName);
                    // if(req.body.reportType != "Complete")
                    // {
                    //     checkCalibrationDone = await this.checkIncomplete(arrMonth,req.body.balId);
                    // }

                    if (req.body.str_status_notUsed == "Used") {
                        var balCalculation = await this.balCalculation(arrMonth, req.body.balId, req.body.reportType);
                        var certificateData = await this.getCertificateData(arr_detailData);
                    }

                    // if(checkCalibrationDone == true)
                    // {
                    //     var balCalculation = await this.balCalculation(arrMonth, req.body.balId, req.body.reportType, str_projectName);
                    //     var certificateData = await this.getCertificateData(arr_detailData);
                    // }

                    let str_insertResult = await this.insertDailyToTemp(arr_detailData, int_clientIP, req.body.reportType, str_projectName);

                    str_stdWtBoxID = (balCalculation == undefined) ? "" : certificateData.stdWTNo;
                    // str_certificationNo = certificateData.cetificateNo;
                    str_certificationNo = (balCalculation == undefined) ? "" : certificateData.cetificate;

                    str_allStdWtBoxCertNo = (balCalculation == undefined) ? "" : certificateData.certNo;

                    str_allStdWtBoxValUpDt = (balCalculation == undefined) ? "" : certificateData.certValDt;
                    str_allStdWtBoxCalUpDt = (balCalculation == undefined) ? "" : certificateData.certCalDt;
                }
                else {
                    let str_balWeights = "";
                    var deleteData = await this.deleteEntriesTemp(int_clientIP, str_projectName);
                    let str_weightBoxIDSValidDate = await this.getWeightBoxIDSAndValidDate(arr_detailData, int_clientIP);
                    var dt_nextCalibDate = await this.getNextCalibDate(arr_detailData)
                    if (req.body.reportType != "Complete") {
                        str_balWeights = await this.getBalaWeightForIncomplete(arr_masterData);
                    }

                    let str_insertResultSH = await this.insertDailyToTempSoftShell(arr_detailData, int_clientIP,
                        req.body.reportType, str_weightBoxIDSValidDate, str_monthAndYear, dt_nextCalibDate.nextCalibDate, str_balWeights);

                    var deleteDataWeightValid = await this.deleteEntriesTempWeightValid(int_clientIP);
                }

                var str_or_min = 0, str_or_max = 0;
                // if (req.body.str_status_notUsed == "Not" || checkCalibrationDone == true) {
                if (req.body.str_status_notUsed == "Not") {
                    const obj_getBalanceData =
                        await models.tbl_balance.findAll
                            ({
                                where:
                                {
                                    Bal_ID: req.body.balId
                                }
                            });
                    str_or_min = parseFloat(obj_getBalanceData[0].Bal_MinoptRange).toFixed(obj_getBalanceData[0].Bal_DP);
                    str_or_max = parseFloat(obj_getBalanceData[0].Bal_MaxoptRange).toFixed(obj_getBalanceData[0].Bal_DP);
                }

                Object.assign
                    (
                        obj_response,
                        { status: 'success' },
                        {
                            data:
                            {
                                HmiId: int_clientIP.split(':')[3].split('.')[3],
                                waterMark: true,

                                minOptRange: (balCalculation == undefined) ? str_or_min : balCalculation.minoptrang,
                                maxOptRange: (balCalculation == undefined) ? str_or_max : balCalculation.maxoptrang,

                                MaxCap: (balCalculation == undefined) ? "NA" : balCalculation.maxcap,
                                MinCap: (balCalculation == undefined) ? "NA" : balCalculation.mincap,

                                leastCnt: (balCalculation == undefined) ? "NA" : balCalculation.leastcount,

                                calibWeightBoxId: str_stdWtBoxID,
                                certificateNo: str_allStdWtBoxCertNo,
                                calibDateWeigtBox: str_allStdWtBoxCalUpDt, //str_allStdWtBoxValUpDt,
                                calibDueDate: str_allStdWtBoxValUpDt, //str_allStdWtBoxCalUpDt,

                                balStdWt1: (balCalculation == undefined) ? "NA" : balCalculation.lower,
                                balNegTol1: (balCalculation == undefined) ? "NA" : balCalculation.lowerwtneglmt,
                                balPosTol1: (balCalculation == undefined) ? "NA" : balCalculation.lowerwtposlmt,
                                toleranceLimit1: (balCalculation == undefined) ? "NA" : balCalculation.lowerVal,

                                balStdWt2: (balCalculation == undefined) ? "NA" : balCalculation.mid1Wt,
                                balPosTol2: (balCalculation == undefined) ? "NA" : balCalculation.mid1WtPosLmt,
                                balNegTol2: (balCalculation == undefined) ? "NA" : balCalculation.mid1WtNegLmt,
                                toleranceLimit2: (balCalculation == undefined) ? "NA" : balCalculation.mid1Tol,

                                balStdWt3: (balCalculation == undefined) ? "NA" : balCalculation.upper,
                                balNegTol3: (balCalculation == undefined) ? "NA" : balCalculation.upperwtneglmt,
                                balPosTol3: (balCalculation == undefined) ? "NA" : balCalculation.upperwtposlmt,
                                toleranceLimit3: (balCalculation == undefined) ? "NA" : balCalculation.upperVal,

                                calibWtsUsedCnt: (balCalculation == undefined) ? "0" : balCalculation.balCalWtCtrlCount,
                                UserName: req.body.username,
                                UserId: req.body.userId,
                                printNo: Number(req.body.printNo),
                                ICReport: req.body.reportType,
                                instrumentId: req.body.balId,
                                // str_status_notUsed: (checkCalibrationDone == true) ? "Used" : req.body.str_status_notUsed
                                str_status_notUsed: req.body.str_status_notUsed
                            }
                        }
                    )
                return obj_response;
            }

        }
        catch (error) {
            console.log("viewDailyCalibrationReport", error);
            return error;
        }
    }

    async viewDailyCalibrationReport(req) {
        try {
            var arrMonth = [];
            var obj_response = {};
            var arr_calibMasterData = [];
            const selectDetailRpt = await models.tbl_rpt_path.findAll({});
            var result = selectDetailRpt;
            var str_projectName = result[0]['proj_name'];
            let int_clientIP = requestIp.getClientIp(req);
            var str_date = req.body.date;
            var y = str_date.split('-')[0];
            var m = str_date.split('-')[1];
            var day;
            if (req.body.startDate != undefined && req.body.endDate != -1) {
                day = Number(req.body.endDate);
            } else {
                day = moment(req.body.date, 'YYYY-MM').daysInMonth();
            }
            var str_getMonth = await this.getMonthFromDate(m);
            var start = (req.body.id == 1 || req.body.startDate == undefined) ? 1 : Number(req.body.startDate.split("-")[2]);
            for (var i = start; i <= day; i++) {
                var datecount;
                if (i.toString().length == 1) {
                    datecount = '0' + i;
                }
                else {
                    datecount = i;
                }
                var monthDate = y + "-" + m + "-" + datecount;
                arrMonth.push(monthDate);
            }

            let completeData = await this.getDatFromMater(arrMonth, req.body.balId, req.body.reportType,req.body.calibChange);
            let reCalibData = await this.getRecalibData(arrMonth, req.body.balId, req.body.reportType,req.body.calibChange);
            let noRemarkData = await this.getNoRemarkData(arrMonth, req.body.balId, req.body.calibChange);
            var arrRepSerNo = [];

            if(completeData.length > 0) {
                for(let element of completeData) {
                    arrRepSerNo.push(element.Daily_RepNo);
                }
            }

            if(reCalibData.length  > 0) {
                for(let element of reCalibData) {
                    arrRepSerNo.push(element.Daily_RepNo);
                }
            }


            if ((completeData == false) && (reCalibData == false) && (noRemarkData == false)) {
                Object.assign(obj_response, { status: 'Wrong' }, { data: 'Data Not Found' })
                return obj_response;
            }
            else {
                if (completeData != false) {
                    if (completeData.length > 0) {
                        for (var i = 0; i < completeData.length; i++) {
                            arr_calibMasterData.push(completeData[i]);
                        }
                    }
                }

                if (reCalibData != false) {
                    if (reCalibData.length > 0) {
                        for (var j = 0; j < reCalibData.length; j++) {
                            arr_calibMasterData.push(reCalibData[j]);
                        }
                    }
                }

                if (noRemarkData != false  && req.body.reportType != 'Failure') {
                    if (noRemarkData.length > 0) {
                        for (var k = 0; k < noRemarkData.length; k++) {
                            arr_calibMasterData.push(noRemarkData[k]);
                        }
                    }
                }
                var arr_masterData = await this.getMasterRecord(arrMonth, arr_calibMasterData);
                var arr_detailData = await this.getDetailRecord(arr_masterData, req.body.reportType);
                var deleteData = await this.deleteEntriesTemp(int_clientIP, str_projectName);
                var balCalculation = await this.balCalculation(arrMonth, req.body.balId, req.body.reportType,req.body.calibChange);
                let str_insertResult = await this.insertDailyToTemp(arr_detailData, int_clientIP, req.body.reportType, str_projectName,arrRepSerNo);

                Object.assign(obj_response, { status: 'success' }, {
                    data: {
                        HmiId: int_clientIP.split(':')[3],
                        waterMark: true,
                        MinOptRange: balCalculation.minoptrang,
                        MaxOptRange: balCalculation.maxoptrang,
                        MaxCap: balCalculation.maxcap,
                        MinCap: balCalculation.mincap,
                        leastCnt: balCalculation.leastcount,

                        lowTol: balCalculation.lowerVal,
                        uppTol: balCalculation.upperVal,
                        lowWt: balCalculation.lower,
                        uppWt: balCalculation.upper,
                        lowWtNegLmt: balCalculation.lowerwtneglmt,
                        lowWtPosLmt: balCalculation.lowerwtposlmt,
                        uppWtNegLmt: balCalculation.upperwtneglmt,
                        uppWtPosLmt: balCalculation.upperwtposlmt,

                        mid1Wt: balCalculation.mid1Wt,
                        mid1Tol: balCalculation.mid1Tol,
                        mid1WtNegLmt: balCalculation.mid1WtNegLmt,
                        mid1WtPosLmt: balCalculation.mid1WtPosLmt,

                        mid2Wt: balCalculation.mid2Wt,
                        mid2Tol: balCalculation.mid2Tol,
                        mid2WtPosLmt: balCalculation.mid2WtPosLmt,
                        mid2WtNegLmt: balCalculation.mid2WtNegLmt,

                        mid3Wt: balCalculation.mid3Wt,
                        mid3Tol: balCalculation.mid3Tol,
                        mid3WtPosLmt: balCalculation.mid3WtPosLmt,
                        mid3WtNegLmt: balCalculation.mid3WtNegLmt,

                        mid4Wt: balCalculation.mid4Wt,
                        mid4Tol: balCalculation.mid4Tol,
                        mid4WtPosLmt: balCalculation.mid4WtPosLmt,
                        mid4WtNegLmt: balCalculation.mid4WtNegLmt,

                        mid5Wt: balCalculation.mid5Wt,
                        mid5Tol: balCalculation.mid5Tol,
                        mid5WtPosLmt: balCalculation.mid5WtPosLmt,
                        mid5WtNegLmt: balCalculation.mid5WtNegLmt,

                        mid6Wt: balCalculation.mid6Wt,
                        mid6Tol: balCalculation.mid6Tol,
                        mid6WtPosLmt: balCalculation.mid6WtPosLmt,
                        mid6WtNegLmt: balCalculation.mid6WtNegLmt,

                        calibWtsUsedCnt: balCalculation.balCalWtCtrlCount,
                        StdWtBoxId: balCalculation.stdWtBoxID,
                        UserName: req.body.username,
                        UserId: req.body.userId,
                        printNo: Number(req.body.printNo),
                        reportType: req.body.reportType
                    }
                })

                return obj_response;

            }


        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getDailyCalibrationChange(req) {
        try {
            let obj_response = {}
            var dec = moment(req.body.month)
            var toDate = `${req.body.month}-${moment(req.body.month, 'YYYY-MM').daysInMonth()}`;
            var str_tableName;
            (req.body.reportType == "Complete") ? str_tableName = "tbl_calibration_daily_master" : str_tableName = "tbl_calibration_daily_master_incomplete";

            const checkMasterDataObj = await models[str_tableName].findAll({
                where: {
                    Daily_BalID: req.body.balId,
                    Daily_CalbDate: { [Op.between]: [dec.tz('Asia/Kolkata').format('YYYY-MM-DD'), toDate] }
                },
                order: [
                    ['Daily_RepNo', 'ASC'],
                    ['Daily_CalibChange', 'ASC']
                ]
            });
            var result = checkMasterDataObj;
            var uniqueDate = result.reduce((arr, curr) => {
                if (arr.filter(e => e.calibChange === curr.Daily_CalibChange).length < 1) {
                    arr.push({ id: (arr.length + 1), date: moment(curr.Daily_CalbDate).format('YYYY-MM-DD'), calibChange: curr.Daily_CalibChange, printCount: curr.Daily_PrintNo });
                }
                return arr;
            }, [])

            Object.assign(obj_response, { status: 'success' }, { result: uniqueDate })
            return obj_response;


        }
        catch (error) {
            console.log(error);
            throw error
        }
    }

    async checkIncomplete(arrMonth, balId) {
        try {
            var day = arrMonth.length;
            var lastday = day - 1;
            const checkData = await models.tbl_calibration_daily_master_incomplete.findAll
                ({
                    where:
                    {
                        Daily_BalID: balId,
                        Daily_CalbDate: { [Op.between]: [arrMonth[0], arrMonth[lastday]] },
                    }
                });
            var result = checkData;
            var res = (result.length > 0) ? true : false;
            return res;
        } catch (error) {
            console.log("checkIncomplete", error);
            return error;
        }
    }

    async getBalaWeightForIncomplete(sarr_masterData) {
        try {
            let obj_response = {};
            var sarr_weight = [], sarr_neg = [], sarr_pos = [];
            var sarr_weight6 = [], sarr_weight7 = [], sarr_weight8 = [];
            var sarr_neg6 = [], sarr_neg7 = [], sarr_neg8 = [];
            var sarr_pos6 = [], sarr_pos7 = [], sarr_pos8 = [];

            for (const str_dataMaster of sarr_masterData) {
                if (str_dataMaster.hasOwnProperty('Daily_RepNo')) {
                    if (str_dataMaster.Daily_RepNo != "NULL") {
                        sarr_weight = str_dataMaster.Daily_StdWeight.split(",");
                        sarr_neg = str_dataMaster.Daily_NegTol.split(",");
                        sarr_pos = str_dataMaster.Daily_PosTol.split(",");

                        sarr_weight6.push(sarr_weight[1]);
                        sarr_weight7.push(sarr_weight[2]);
                        sarr_weight8.push(sarr_weight[3]);
                        sarr_neg6.push(sarr_neg[1]);
                        sarr_neg7.push(sarr_neg[2]);
                        sarr_neg8.push(sarr_neg[3]);
                        sarr_pos6.push(sarr_pos[1]);
                        sarr_pos7.push(sarr_pos[2]);
                        sarr_pos8.push(sarr_pos[3]);


                        Object.assign(obj_response, {
                            stdWt6: sarr_weight6.join(), stdWt7: sarr_weight7.join(),
                            stdWt8: sarr_weight8.join(), negWt6: sarr_neg6.join(), negWt7: sarr_neg7.join(),
                            negWt8: sarr_neg8.join(), posWt6: sarr_pos6.join(), posWt7: sarr_pos7.join(), posWt8: sarr_pos8.join()
                        });

                        return obj_response;
                    }
                }
            }// for
        } catch (error) {
            return error;
        }
    }

    async getNextCalibDate(sarr_detail) {
        try {
            var int_cnt = 0, dt_nextCalibDates = "NULL";
            let obj_response = {};

            for (const str_dataDetail of sarr_detail) {
                if (str_dataDetail.hasOwnProperty('Daily_RepNo')) {
                    if (str_dataDetail.Daily_RepNo != "NULL") {

                        if (int_cnt == 0) {
                            dt_nextCalibDates = "";
                            dt_nextCalibDates = dateFormat(str_dataDetail.Daily_NextPeriodicDate, "dd/mm/yy");
                        }
                        int_cnt = int_cnt + 1;
                    }
                }
            }

            Object.assign(obj_response, { nextCalibDate: dt_nextCalibDates });
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    async getDatFromMater(arrMonth, balId, reportType, calibChange) {
        try {
            var day = arrMonth.length;
            var lastday = day - 1;
            let str_tableName;

            (reportType == 'Complete') ? str_tableName = 'tbl_calibration_daily_master' :
                str_tableName = 'tbl_calibration_daily_master_incomplete';

            const checkMasterDataObj = await models['' + str_tableName].findAll
                ({
                    where:
                    {
                        Daily_BalID: balId,
                        Daily_IsRecalib: 0,
                        Daily_CalbDate: { [Op.between]: [arrMonth[0], arrMonth[lastday]] },
                        Daily_CalibChange: calibChange
                    }
                });
            var result = checkMasterDataObj;

            var masterArr = [];
            if (result.length > 0) {
                for (var i = 0; i < result.length; i++) {
                    var arrObj = result[i];
                    var masterDate = arrObj.Daily_CalbDate;
                    var dec = moment(masterDate);
                    var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
                    var newDate = normalDate.split(" ")[0];
                    arrObj.Daily_CalbDate = newDate;
                    masterArr.push(arrObj);
                }
                return masterArr;
            }
            else {
                return false;
            }
        }
        catch (error) {
            return error;
        }
    }

    async getRecalibData(arrMonth, balId, reportType,calibChange) {
        try {
            var day = arrMonth.length;
            var lastday = day - 1;
            let str_tableName;
            (reportType == 'Complete') ? str_tableName = 'tbl_calibration_daily_master' :
                str_tableName = 'tbl_calibration_daily_master_incomplete';

            const recalibDataObj = await models['' + str_tableName].findAll
                ({
                    where:
                    {
                        Daily_BalID: balId,
                        Daily_IsRecalib: 1,
                        Daily_CalbDate: { [Op.between]: [arrMonth[0], arrMonth[lastday]] },
                        Daily_CalibChange:calibChange
                    }
                });
            var result = recalibDataObj;

            var masterArrRecalib = [];

            if (result.length > 0) {
                for (var i = 0; i < result.length; i++) {
                    var arrObj = result[i];
                    var masterDate = arrObj.Daily_CalbDate;
                    var dec = moment(masterDate);
                    var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
                    var newDate = normalDate.split(" ")[0];
                    arrObj.Daily_CalbDate = newDate;
                    masterArrRecalib.push(arrObj);
                }
                return masterArrRecalib;
            }
            else {
                return false;
            }
        }
        catch (error) {
            console.log("getRecalibData()", error);
            return error;
        }
    }

    async getNoRemarkData(arrMonth, balId, calibChange) {
        try {
            var day = arrMonth.length;
            var lastday = day - 1;

            const noRemarkObj = await models.tbl_calibration_daily_noremark.findAll
                ({
                    where:
                    {
                        NDCR_BalanceID: balId,
                        NDCR_DT: { [Op.between]: [arrMonth[0], arrMonth[lastday]]},
                        Daily_CalibChange: calibChange 
                    }
                });
            var result = noRemarkObj;

            if (result.length > 0) {
                return result;
            }
            else {
                return false;
            }
        }
        catch (error) {
            console.log("getNoRemarkData", error);
            return error;
        }
    }

    async getMasterRecord(arrMonth, arrCalibMasterData) {
        try {
            var arrMaster = [];

            for (let date of arrMonth) {
                let masterData = arrCalibMasterData.filter(k => (k.Daily_CalbDate == date || k.NDCR_DT == date));

                if (masterData.length == 0) {
                    var RetObj = {};
                    Object.assign(RetObj, { Daily_RepNo: 'NULL', Daily_CalbDate: date });
                    arrMaster.push(RetObj)
                }
                else {
                    for (let obj of masterData) {
                        arrMaster.push(obj);
                    }
                }
            }
            return arrMaster;
        }
        catch (error) {
            console.log("getMasterRecord()", error);
            return error;
        }
    }

    async getDetailRecord(arr_masterData, reportType) {
        try {
            var arrCalibData = [];

            for (const master of arr_masterData) {
                if (master.hasOwnProperty('NDCR_SrNo')) {
                    arrCalibData.push(master);
                }
                else if (master.hasOwnProperty('Daily_RepNo')) {
                    if (master.Daily_RepNo == "NULL") {
                        arrCalibData.push(master);
                    }
                    else {
                        let str_tableName;
                        (reportType == 'Complete') ? str_tableName = 'tbl_calibration_daily_detail' :
                            str_tableName = 'tbl_calibration_daily_detail_incomplete';

                        const checkDetailDataObj = await models['' + str_tableName].findAll
                            ({
                                where:
                                {
                                    Daily_RepNo: master.Daily_RepNo
                                }
                            });
                        var result = checkDetailDataObj;

                        if (result.length > 0) {
                            var detail = Object.assign(master, { detailArry: result[0] });
                            arrCalibData.push(detail);
                        }
                    }
                }
            }
            return arrCalibData;
        }
        catch (error) {
            console.log("getDetailRecord", error);
            return error;
        }
    }

    async getBalanceCount(str_balID) {
        try {
            const obj_getBalCount =
                await models.tbl_balance_weights.findAndCountAll
                    ({
                        where:
                        {
                            Bal_Daily: 1,
                            Bal_ID: str_balID
                        }
                    });

            var result = obj_getBalCount;

            if (result.rows.length > 0) {
                return result['count'];
            }
            else {
                return 0;
            }
        }
        catch (error) {
            console.log("getBalanceCount()", error);
            return error;
        }
    }

    async balCalculation(arrMonth, balId, reportType,calibChange) {
        try {
            var file = await loginobj.getDeveloperFile();
            var jsonData = jsonfile.readFileSync(file);

            const balCalWtCtrlCount = await this.getBalanceCount(balId);

            var day = arrMonth.length;
            var lastday = day - 1;
            var str_masterTableName, str_detailTableName;

            if (reportType == 'Complete') {
                str_masterTableName = 'tbl_calibration_daily_master';
                str_detailTableName = 'tbl_calibration_daily_detail';
            }
            else {
                str_masterTableName = 'tbl_calibration_daily_master_incomplete';
                str_detailTableName = 'tbl_calibration_daily_detail_incomplete';
            }

            const masterObj = await models['' + str_masterTableName].findAll
                ({
                    where:
                    {
                        Daily_CalbDate: { [Op.between]: [arrMonth[0], arrMonth[lastday]] },
                        Daily_BalID: balId,
                        Daily_StdWeight: { [Op.ne]: ['0'] },
                        Daily_NegTol: { [Op.ne]: ['0'] },
                        Daily_PosTol: { [Op.ne]: ['0'] },
                        Daily_CalibChange : calibChange
                    }
                });
            var data = masterObj[0];
            var dpVal = data.Decimal_Point;
            var strStdWt = data.Daily_StdWeight;
            var strPosWt = data.Daily_PosTol;
            var strNegWt = data.Daily_NegTol;
            var tolerance = data.Tolerance;
            var stdWt = strStdWt.split(',');
            var pos = strPosWt.split(',');
            var neg = strNegWt.split(',');
            var Tol = tolerance.split(',')

            var min, max;
            var maxNeg, maxPos, minNeg, minPos;

            var mid1St = 0, mid2St = 0, midNeg1 = 0, midNeg2 = 0, midPos1 = 0, midPos2 = 0;
            var stdArr = []; // Array for 2 weights accept lower and upperi.e mid1 and mid2

            // code for 8 weights
            var lowSt = 0, upperSt = 0, mid1St = 0, mid2St = 0, mid3St = 0, mid4St = 0, mid5St = 0, mid6St = 0;
            var lowDiff = 0, upperDiff = 0, mid1Diff = 0, mid2Diff = 0, mid3Diff = 0, mid4Diff = 0, mid5Diff = 0, mid6Diff = 0;
            var lowPos = 0, upperPos = 0, mid1Pos = 0, mid2Pos = 0, mid3Pos = 0, mid4Pos = 0, mid5Pos = 0, mid6Pos = 0;
            var lowNeg = 0, upperNeg = 0, mid1Neg = 0, mid2Neg = 0, mid3Neg = 0, mid4Neg = 0, mid5Neg = 0, mid6Neg = 0;

            for (var i = 0; i < stdWt.length; i++) {
                if (stdWt.length == 1) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                }
                if (stdWt.length == 2) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }

                if (stdWt.length == 3) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        mid1St = stdWt[i];
                        mid1Diff = Tol[i];
                        mid1Pos = pos[i];
                        mid1Neg = neg[i];
                    }
                    if (i == 2) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }

                if (stdWt.length == 4) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        mid1St = stdWt[i];
                        mid1Diff = Tol[i];
                        mid1Pos = pos[i];
                        mid1Neg = neg[i];
                    }
                    if (i == 2) {
                        mid2St = stdWt[i];
                        mid2Diff = Tol[i];
                        mid2Pos = pos[i];
                        mid2Neg = neg[i];
                    }
                    if (i == 3) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }

                if (stdWt.length == 5) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        mid1St = stdWt[i];
                        mid1Diff = Tol[i];
                        mid1Pos = pos[i];
                        mid1Neg = neg[i];
                    }
                    if (i == 2) {
                        mid2St = stdWt[i];
                        mid2Diff = Tol[i];
                        mid2Pos = pos[i];
                        mid2Neg = neg[i];
                    }
                    if (i == 3) {
                        mid3St = stdWt[i];
                        mid3Diff = Tol[i];
                        mid3Pos = pos[i];
                        mid3Neg = neg[i];
                    }
                    if (i == 4) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }
                if (stdWt.length == 6) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        mid1St = stdWt[i];
                        mid1Diff = Tol[i];
                        mid1Pos = pos[i];
                        mid1Neg = neg[i];
                    }
                    if (i == 2) {
                        mid2St = stdWt[i];
                        mid2Diff = Tol[i];
                        mid2Pos = pos[i];
                        mid2Neg = neg[i];
                    }
                    if (i == 3) {
                        mid3St = stdWt[i];
                        mid3Diff = Tol[i];
                        mid3Pos = pos[i];
                        mid3Neg = neg[i];
                    }
                    if (i == 4) {
                        mid4St = stdWt[i];
                        mid4Diff = Tol[i];
                        mid4Pos = pos[i];
                        mid4Neg = neg[i];
                    }
                    if (i == 5) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }
                if (stdWt.length == 7) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        mid1St = stdWt[i];
                        mid1Diff = Tol[i];
                        mid1Pos = pos[i];
                        mid1Neg = neg[i];
                    }
                    if (i == 2) {
                        mid2St = stdWt[i];
                        mid2Diff = Tol[i];
                        mid2Pos = pos[i];
                        mid2Neg = neg[i];
                    }
                    if (i == 3) {
                        mid3St = stdWt[i];
                        mid3Diff = Tol[i];
                        mid3Pos = pos[i];
                        mid3Neg = neg[i];
                    }
                    if (i == 4) {
                        mid4St = stdWt[i];
                        mid4Diff = Tol[i];
                        mid4Pos = pos[i];
                        mid4Neg = neg[i];
                    }
                    if (i == 5) {
                        mid5St = stdWt[i];
                        mid5Diff = Tol[i];
                        mid5Pos = pos[i];
                        mid5Neg = neg[i];
                    }
                    if (i == 6) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }
                if (stdWt.length == 8) {
                    if (i == 0) {
                        lowSt = stdWt[i];
                        lowDiff = Tol[i];
                        lowPos = pos[i];
                        lowNeg = neg[i];
                    }
                    if (i == 1) {
                        mid1St = stdWt[i];
                        mid1Diff = Tol[i];
                        mid1Pos = pos[i];
                        mid1Neg = neg[i];
                    }
                    if (i == 2) {
                        mid2St = stdWt[i];
                        mid2Diff = Tol[i];
                        mid2Pos = pos[i];
                        mid2Neg = neg[i];
                    }
                    if (i == 3) {
                        mid3St = stdWt[i];
                        mid3Diff = Tol[i];
                        mid3Pos = pos[i];
                        mid3Neg = neg[i];
                    }
                    if (i == 4) {
                        mid4St = stdWt[i];
                        mid4Diff = Tol[i];
                        mid4Pos = pos[i];
                        mid4Neg = neg[i];
                    }
                    if (i == 5) {
                        mid5St = stdWt[i];
                        mid5Diff = Tol[i];
                        mid5Pos = pos[i];
                        mid5Neg = neg[i];
                    }
                    if (i == 6) {
                        mid6St = stdWt[i];
                        mid6Diff = Tol[i];
                        mid6Pos = pos[i];
                        mid6Neg = neg[i];
                    }
                    if (i == 7) {
                        upperSt = stdWt[i];
                        upperDiff = Tol[i];
                        upperPos = pos[i];
                        upperNeg = neg[i];
                    }
                }
            }

            return {
                lowerVal: lowDiff,
                lower: lowSt,
                lowerwtneglmt: lowNeg,
                lowerwtposlmt: lowPos,

                upperVal: upperDiff,
                upperwtneglmt: upperNeg,
                upperwtposlmt: upperPos,
                upper: upperSt,

                mid1Tol: mid1Diff,
                mid1Wt: mid1St,
                mid1WtPosLmt: mid1Pos,
                mid1WtNegLmt: mid1Neg,

                mid2Tol: mid2Diff,
                mid2Wt: mid2St,
                mid2WtPosLmt: mid2Pos,
                mid2WtNegLmt: mid2Neg,

                mid3Tol: mid3Diff,
                mid3Wt: mid3St,
                mid3WtPosLmt: mid3Pos,
                mid3WtNegLmt: mid3Neg,

                mid4Tol: mid4Diff,
                mid4Wt: mid4St,
                mid4WtPosLmt: mid4Pos,
                mid4WtNegLmt: mid4Neg,

                mid5Tol: mid5Diff,
                mid5Wt: mid5St,
                mid5WtPosLmt: mid5Pos,
                mid5WtNegLmt: mid5Neg,

                mid6Tol: mid6Diff,
                mid6Wt: mid6St,
                mid6WtPosLmt: mid6Pos,
                mid6WtNegLmt: mid6Neg,

                minoptrang: data.Daily_Bal_MinoptRange,
                maxoptrang: data.Daily_Bal_MaxoptRange,
                mincap: data.Daily_MinCap,
                maxcap: data.Daily_MaxCap,
                leastcount: data.Daily_LeastCnt,
                dpVal: dpVal,
                balCalWtCtrlCount: balCalWtCtrlCount,
                stdWtBoxID: strStdWt
            };
        }
        catch (error) {
            console.log("balCalculation()", error);
            return (error);
        }
    }

    async getWeightBoxIDSAndValidDate(sarr_detail, HMIIP) {
        try {
            var arrWeight = [], arrValidDate = [];
            var sarr_tempStdWeightID = [], sarr_stdWeightID1 = [], sarr_stdWeightID2 = [], sarr_stdWeightID3 = [], sarr_stdWeightID4 = [];
            var sarr_tempValidDate = [], sarr_validDate1 = [], sarr_validDate2 = [], sarr_validDate3 = [], sarr_validDate4 = [];
            let obj_response = {};
            var srnoWT = 0, srnoValid = 0;

            for (const str_dataDetail of sarr_detail) {
                if (str_dataDetail.hasOwnProperty('Daily_RepNo')) {
                    if (str_dataDetail.Daily_RepNo != "NULL") {

                        for (let i of [1, 2, 3, 4, 5, 6, 7, 8]) {
                            if (str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != null && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != undefined
                                && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != "" && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != "NULL") {
                                arrWeight = str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i].split(",");
                                for (let i of arrWeight) {
                                    srnoWT = srnoWT + 1;
                                    const objInsertWts = {
                                        str_tableName: 'tbl_temp_daily_wtidvaliddate',
                                        data: [
                                            { str_colName: 'SrNo', value: srnoWT },
                                            { str_colName: 'WtID', value: i },
                                            { str_colName: 'HMI_ID', value: HMIIP.split(':')[3].split('.')[3] }
                                        ]
                                    }

                                    let result = await database.save(objInsertWts);
                                }

                            }

                            if (str_dataDetail.detailArry[0]["Daily_ValDate" + i] != null && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != undefined
                                && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != "" && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != "NULL") {
                                arrValidDate = str_dataDetail.detailArry[0]["Daily_ValDate" + i].split(",");
                                for (let i of arrValidDate) {
                                    srnoValid = srnoValid + 1;
                                    const objInsertDate = {
                                        str_tableName: 'tbl_temp_daily_wtidvaliddate',
                                        data: [
                                            { str_colName: 'ValidDate', value: i },

                                        ],
                                        condition: [
                                            { str_colName: 'SrNo', value: srnoValid },
                                            { str_colName: 'HMI_ID', value: HMIIP.split(':')[3].split('.')[3] }
                                        ]
                                    }

                                    let result = await database.update(objInsertDate);
                                }
                            }
                        }

                        /**get distinct data from tbl_temp_daily_wtidvaliddate  table*/
                        const objGetData = {
                            str_tableName: 'tbl_temp_daily_wtidvaliddate',
                            data: "distinct WtID,ValidDate",
                            condition: [
                                { str_colName: 'HMI_ID', value: HMIIP.split(':')[3].split('.')[3] }
                            ]
                        }

                        let result = await database.select(objGetData);

                        /** Display index wise data- in report there are 4 columns */
                        for (let j = 0; j < result[0].length; j++) {
                            if (j == 0 || j == 4 || j == 8) {
                                if (j == 0) {
                                    sarr_stdWeightID1 = [];
                                    sarr_validDate1 = [];
                                }
                                sarr_stdWeightID1.push(result[0][j].WtID);
                                sarr_validDate1.push(dateFormat(result[0][j].ValidDate, "dd/mm/yy"));
                            }
                            if (j == 1 || j == 5 || j == 9) {
                                if (j == 1) {
                                    sarr_stdWeightID2 = [];
                                    sarr_validDate2 = [];
                                }
                                sarr_stdWeightID2.push(result[0][j].WtID);
                                sarr_validDate2.push(dateFormat(result[0][j].ValidDate, "dd/mm/yy"));
                            }
                            if (j == 2 || j == 6 || j == 10) {
                                if (j == 2) {
                                    sarr_stdWeightID3 = [];
                                    sarr_validDate3 = [];
                                }
                                sarr_stdWeightID3.push(result[0][j].WtID);
                                sarr_validDate3.push(dateFormat(result[0][j].ValidDate, "dd/mm/yy"));
                            }
                            if (j == 3 || j == 7 || j == 11) {
                                if (j == 3) {
                                    sarr_stdWeightID4 = [];
                                    sarr_validDate4 = [];
                                }
                                sarr_stdWeightID4.push(result[0][j].WtID);
                                sarr_validDate4.push(dateFormat(result[0][j].ValidDate, "dd/mm/yy"));
                            }
                        }

                        Object.assign(obj_response, {
                            weightBox1: sarr_stdWeightID1.join(), weightBox2: sarr_stdWeightID2.join(),
                            weightBox3: sarr_stdWeightID3.join(), weightBox4: sarr_stdWeightID4.join(), validUpto1: sarr_validDate1.join(),
                            validUpto2: sarr_validDate2.join(), validUpto3: sarr_validDate3.join(), validUpto4: sarr_validDate4.join()
                        });

                    }
                }
            }
            return obj_response;
        } catch (error) {
            return error;
        }
    }

    async getWeightBoxIDSAndValidDateOLD(sarr_detail, HMIIP) {
        try {
            var arrWeight = [], arrValidDate = [];
            var sarr_tempStdWeightID = [], sarr_stdWeightID1 = [], sarr_stdWeightID2 = [], sarr_stdWeightID3 = [], sarr_stdWeightID4 = [];
            var sarr_tempValidDate = [], sarr_validDate1 = [], sarr_validDate2 = [], sarr_validDate3 = [], sarr_validDate4 = [];
            let obj_response = {};

            for (const str_dataDetail of sarr_detail) {
                if (str_dataDetail.hasOwnProperty('Daily_RepNo')) {
                    if (str_dataDetail.Daily_RepNo != "NULL") {
                        for (let i of [1, 2, 3, 4, 5, 6, 7, 8]) {
                            if (str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != null && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != undefined
                                && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != "" && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != "NULL") {
                                arrWeight = str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i].split(",");
                                arrWeight.forEach(element => {
                                    /** Push all weights except duplicate  */
                                    if (sarr_tempStdWeightID.includes(element) == false) {
                                        sarr_tempStdWeightID.push(element);
                                    }
                                });
                            }

                            if (str_dataDetail.detailArry[0]["Daily_ValDate" + i] != null && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != undefined
                                && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != "" && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != "NULL") {
                                arrValidDate = str_dataDetail.detailArry[0]["Daily_ValDate" + i].split(",");
                                arrValidDate.forEach(element => {
                                    /** Push all Valid Date except duplicate  */
                                    if (sarr_tempValidDate.includes(element) == false) {
                                        sarr_tempValidDate.push(element);
                                    }
                                });
                            }
                        }

                        for (let i of [1, 2, 3, 4, 5, 6, 7, 8]) {
                            if (str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != null && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != undefined
                                && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != "" && str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i] != "NULL") {
                                arrWeight = str_dataDetail.detailArry[0]["Daily_StdWtBoxID" + i].split(",");
                                arrWeight.forEach(element => {

                                    if (str_dataDetail.detailArry[0]["Daily_ValDate" + i] != null && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != undefined
                                        && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != "" && str_dataDetail.detailArry[0]["Daily_ValDate" + i] != "NULL") {
                                        arrValidDate = str_dataDetail.detailArry[0]["Daily_ValDate" + i].split(",");
                                        arrValidDate.forEach(element => {
                                            /** Push all Valid Date except duplicate  */
                                            if (sarr_tempValidDate.includes(element) == false) {
                                                sarr_tempValidDate.push(element);
                                            }
                                        });
                                    }
                                });
                            }
                        }


                        /** Display index wise data- in report there are 4 columns */
                        for (let j = 0; j < sarr_tempStdWeightID.length; j++) {
                            if (j == 0 || j == 4 || j == 8) { sarr_stdWeightID1.push(sarr_tempStdWeightID[j]) };
                            if (j == 1 || j == 5 || j == 9) { sarr_stdWeightID2.push(sarr_tempStdWeightID[j]) };
                            if (j == 2 || j == 6 || j == 10) { sarr_stdWeightID3.push(sarr_tempStdWeightID[j]) };
                            if (j == 3 || j == 7 || j == 11) { sarr_stdWeightID4.push(sarr_tempStdWeightID[j]) };
                        }

                        for (let j = 0; j < sarr_tempValidDate.length; j++) {
                            if (j == 0 || j == 4 || j == 8) { sarr_validDate1.push(dateFormat(sarr_tempValidDate[j], "dd/mm/yy")) };
                            if (j == 1 || j == 5 || j == 9) { sarr_validDate2.push(dateFormat(sarr_tempValidDate[j], "dd/mm/yy")) };
                            if (j == 2 || j == 6 || j == 10) { sarr_validDate3.push(dateFormat(sarr_tempValidDate[j], "dd/mm/yy")) };
                            if (j == 3 || j == 7 || j == 11) { sarr_validDate4.push(dateFormat(sarr_tempValidDate[j], "dd/mm/yy")) };
                        }


                        Object.assign(obj_response, {
                            weightBox1: sarr_stdWeightID1.join(), weightBox2: sarr_stdWeightID2.join(),
                            weightBox3: sarr_stdWeightID3.join(), weightBox4: sarr_stdWeightID4.join(), validUpto1: sarr_validDate1.join(),
                            validUpto2: sarr_validDate2.join(), validUpto3: sarr_validDate3.join(), validUpto4: sarr_validDate4.join()
                        });

                        return obj_response;
                    }
                }
            }
        } catch (error) {
            return error;
        }
    }

    async getCertificateData(sarr_detail) {
        try {
            var responseObj = {};

            var stdwt = [];
            var certificateNo = [];

            var certNo = [];
            var certDate = [];
            var certCalDt = [];

            var dateFormate = await this.getDateFormate();

            for (const master of sarr_detail) {
                if (master.hasOwnProperty('Daily_RepNo')) {
                    if (master.Daily_RepNo != "NULL") {
                        stdwt.push(master.detailArry.Daily_StdWtBoxID1, master.detailArry.Daily_StdWtBoxID2, master.detailArry.Daily_StdWtBoxID3);

                        certNo.push(master.detailArry.Daily_WeightBox_certfctNo1, master.detailArry.Daily_WeightBox_certfctNo2,
                            master.detailArry.Daily_WeightBox_certfctNo3);

                        certDate.push(master.detailArry.Daily_ValDate1, master.detailArry.Daily_ValDate2,
                            master.detailArry.Daily_ValDate3);

                        certCalDt.push(master.detailArry.Daily_WTCalibDate1, master.detailArry.Daily_WTCalibDate2,
                            master.detailArry.Daily_WTCalibDate3);

                        var date1 = master.detailArry.Daily_ValDate1;
                        var dateVal1 = date1.split(',');
                        var certificat1 = master.detailArry.Daily_WeightBox_certfctNo1;
                        var certificatval1 = certificat1.split(',');
                        var dateFinalVal1;

                        if (dateVal1.length == 1) {
                            var dateFinalVal1 = date.format(new Date(date1), dateFormate);
                            certificateNo.push(certificat1 + '|' + dateFinalVal1);
                        }
                        else {
                            var n = 0;
                            for (var d of dateVal1) {
                                var dateFinalVal1 = date.format(new Date(d), dateFormate);
                                certificateNo.push(certificatval1[n] + '|' + dateFinalVal1);
                                n++;
                            }
                        }

                        if (master.detailArry.Daily_ValDate2 != "NULL") {
                            var date2 = master.detailArry.Daily_ValDate2;
                            var dateVal2 = date2.split(',');
                            var certificat2 = master.detailArry.Daily_WeightBox_certfctNo2;
                            var certificatval2 = certificat2.split(',');
                            var dateFinalVal2;

                            if (dateVal2.length == 1) {
                                var dateFinalVal2 = date.format(new Date(date2), dateFormate);
                                certificateNo.push(certificat2 + '|' + dateFinalVal2);
                            }
                            else {
                                var m = 0;
                                for (var d of dateVal2) {
                                    var dateFinalVal2 = date.format(new Date(d), dateFormate);
                                    certificateNo.push(certificatval2[m] + '|' + dateFinalVal2);
                                    m++;
                                }
                            }
                        }

                        if (master.detailArry.Daily_ValDate3 != "NULL") {
                            var date3 = master.detailArry.Daily_ValDate3;
                            var dateVal3 = date3.split(',');
                            var certificat3 = master.detailArry.Daily_WeightBox_certfctNo3;
                            var certificatval3 = certificat3.split(',');
                            var dateFinalVal3;

                            if (dateVal3.length == 1) {
                                var dateFinalVal3 = date.format(new Date(date3), dateFormate);
                                certificateNo.push(certificat3 + '|' + dateFinalVal3);
                            }
                            else {
                                var m = 0;
                                for (var d of dateVal3) {
                                    var dateFinalVal3 = date.format(new Date(d), dateFormate);
                                    certificateNo.push(certificatval3[m] + '|' + dateFinalVal3);
                                    m++;
                                }
                            }
                        }
                    }
                }
            }

            var finalStdWT = [];

            for (var stdVal of stdwt) {
                var resultWT = stdVal.split(',');

                if (resultWT.length > 1) {
                    for (var i = 0; i < resultWT.length; i++) {
                        finalStdWT.push(resultWT[i]);
                    }
                }
                else {
                    finalStdWT.push(resultWT[0]);
                }
            }

            var finalCertNo = [];

            for (var certVal of certNo) {
                var resCert = certVal.split(',');

                if (resCert.length > 1) {
                    for (var i = 0; i < resCert.length; i++) {
                        finalCertNo.push(resCert[i]);
                    }
                }
                else {
                    finalCertNo.push(resCert[0]);
                }
            }

            var flCertValDt = [], splitDate1 = [];

            for (var certValDt of certDate) {
                if (certValDt != 'NULL') {
                    var reslCertValDt = certValDt.split(',');

                    if (reslCertValDt.length > 1) {
                        for (var i = 0; i < reslCertValDt.length; i++) {
                            splitDate1 = reslCertValDt[i].split("-");
                            flCertValDt.push(splitDate1[2] + "-" + splitDate1[1] + "-" + splitDate1[0]);
                        }
                    }
                    else {
                        splitDate1 = reslCertValDt[0].split("-");
                        flCertValDt.push(splitDate1[2] + "-" + splitDate1[1] + "-" + splitDate1[0]);
                    }
                }

            }

            var flCertDueDt = [], splitDate = [];

            for (var wtBoxCalDt of certCalDt) {
                if (wtBoxCalDt != 'NULL') {
                    var reslWtBoxDt = wtBoxCalDt.split(',');

                    if (reslWtBoxDt.length > 1) {
                        for (var i = 0; i < reslWtBoxDt.length; i++) {
                            splitDate = reslWtBoxDt[i].split("-");
                            flCertDueDt.push(splitDate[2] + "-" + splitDate[1] + "-" + splitDate[0]);
                        }
                    }
                    else {
                        splitDate = reslWtBoxDt[0].split("-");
                        flCertDueDt.push(splitDate[2] + "-" + splitDate[1] + "-" + splitDate[0]);
                    }
                }

            }

            if ((certificateNo.length > 0) || (stdwt.length > 0)) {
                var stdWTVal = [...new Set(finalStdWT)];
                var certificateNoVal = [...new Set(certificateNo)];

                var certNoVal = [...new Set(finalCertNo)];
                var flStdValDt = [...new Set(flCertValDt)];

                var certCalDt = [...new Set(flCertDueDt)];

                var finalcertificateNoVal = certificateNoVal.filter(e => e !== 'NULL/NULL');
                var finalcertificateNoVal1 = finalcertificateNoVal.filter(e => e !== '/undefined.undefined.');
                var finalcertificateNoVal2 = finalcertificateNoVal1.filter(e => e !== 'NULL/undefined.undefined.NULL');

                var stdWTValues = stdWTVal.filter(e => e !== 'NULL');
                var certNoValues = certNoVal.filter(e => e !== 'NULL');

                var stdValDt = flStdValDt.filter(e => e !== 'NULL');
                var stdCalDt = certCalDt.filter(e => e !== 'NULL');

                var cetificate = finalcertificateNoVal2.toString();

                var finalstdWTValues = stdWTValues.toString();
                var finalCertNoValues = certNoValues.toString();

                var fnStdValDt = stdValDt.toString();
                var fnStdCalDt = stdCalDt.toString();

                return Object.assign
                    (
                        responseObj,
                        {
                            cetificateNo: cetificate, stdWTNo: finalstdWTValues, certNo: finalCertNoValues,
                            certValDt: fnStdValDt, certCalDt: fnStdCalDt
                        }
                    );
            }
            else {
                return false;
            }
        }
        catch (error) {
            console.log("getCertificateData()", error)
            return error;
        }
    }

    async getDateFormate() {
        try {
            const dateFormateObject = await models.tbl_nomenclature.findAll({});
            var result = dateFormateObject;

            if (result.length > 0) {
                var date = result[0].dateFormat.toUpperCase();
                return date;
            }
            else {
                return 'DD/MM/YY';
            }
        }
        catch (error) {
            console.log("getDateFormate()", error);
            return error;
        }
    }

    async deleteEntriesTemp(HMIIP, str_ProjectName) {
        try {
            //delete from temp daily calibration table
            var deleteObject = await models.tbl_temp_calbdailydetail.destroy({
                where:
                    { HMI_ID: HMIIP.split(':')[3] }
            });

            //delete from temp daily calibration table
            var deleteObject1 = await models.tbl_temp_daily_wtidvaliddate.destroy({
                where:
                    { HMI_ID: HMIIP.split(':')[3] }
            });

            return 'data deleted';
        } catch (error) {
            return error;
        }
    }

    async deleteEntriesTempWeightValid(HMIIP) {
        try {
            var deleteObject1 = {
                str_tableName: "tbl_temp_daily_wtidvaliddate",
                condition: [
                    { str_colName: 'HMI_ID', value: HMIIP.split(':')[3].split('.')[3] }
                ]
            }
            var result1 = await database.delete(deleteObject1);

            return 'data deleted';
        } catch (error) {
            return error;
        }
    }


    async insertDailyToTemp(MasterDetailArray, clientIp, reportType, str_projectName,arrRepSerNo) {
        try {
            var arrCalibData = [];
            var calibStatus, str_masterTableName= '',str_detailTableName='';
            if (reportType == 'Complete') {
                str_masterTableName = 'tbl_calibration_daily_master';
                str_detailTableName = 'tbl_calibration_daily_detail';
            }
            else {
                str_masterTableName = 'tbl_calibration_daily_master_incomplete';
                str_detailTableName = 'tbl_calibration_daily_detail_incomplete';
            }
            if(arrRepSerNo.length > 0) {   // select weightbox ID as per RepSerNo
                let str_query = `select Daily_RepNo, STRING_AGG(splitValue, ' , ') as DailyCalibWtBox from
                (select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID1, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID1 != 'NULL'
                union
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID2, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID2 != 'NULL'
                union
                
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID3, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID3 != 'NULL'
                union
                
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID4, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID4 != 'NULL'
                union
                
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID5, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID5 != 'NULL'
                union
                
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID6, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID6 != 'NULL'
                union
                
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID7, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID7 != 'NULL'
                union
                
                select Daily_RepNo, Split.value as splitValue 
                from ${str_detailTableName}
                CROSS APPLY STRING_SPLIT(Daily_StdWtBoxID8, ',') as Split 
                where Daily_RepNo IN (${arrRepSerNo}) and Daily_StdWtBoxID8 != 'NULL'
                ) as D
                group by Daily_RepNo`
            var result = await sequelize.query(str_query);
            }
            
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
            for (const master of MasterDetailArray) {
                if (master.hasOwnProperty('NDCR_SrNo')) {
                    const noRemakObj = await models.tbl_temp_calbdailydetail.create
                        ({
                            Daily_RepNo: 0,
                            Daily_RecNo: 0,
                            Daily_CalbDate: master.NDCR_DT,
                            Daily_SpiritLevel: 0,
                            Daily_ZeroError: 0,
                            Daily_GeneralCare: 0,
                            Daily_Reason: master.NDCR_Reason,
                            Daily_UserID: master.NDCR_AddedByName,
                            Daily_VerifyID: 'NULL',
                            HMI_ID: clientIp.split(':')[3],
                            CalibrationStatus: master.NDCR_Reason
                        },{
                            transaction: t
                        });
                    var resultNoRemark = noRemakObj;
                }
                else if (master.hasOwnProperty('Daily_RepNo')) {
                    if (master.Daily_RepNo == "NULL") {
                        const nocaliObj = await models.tbl_temp_calbdailydetail.create({
                            Daily_RepNo: 0,
                            Daily_RecNo: 0,
                            Daily_CalbDate: master.Daily_CalbDate,
                            Daily_SpiritLevel: 0,
                            Daily_ZeroError: 0,
                            Daily_GeneralCare: 0,
                            Daily_Reason: 'NULL',
                            Daily_UserID: 'NULL',
                            Daily_VerifyID: 'NULL',
                            HMI_ID: clientIp.split(':')[3],
                            CalibrationStatus: 'NULL',
                            Daily_StdWtBoxID1: result[0][0].DailyCalibWtBox
                        }, {
                            transaction: t
                        });
                        var resultNoRemark = nocaliObj;
                    }
                    else {
                        if (reportType == 'Complete') {
                            calibStatus = 'Complies';
                        }
                        else {
                            calibStatus = master.CalibrationStatus;
                        }

                        arrCalibData.push(master);
                        var userName = master.Daily_UserName;
                        console.log(master);

                        const ObjDAilyMaster = await models.tbl_temp_calbdailydetail.create
                            ({
                                Daily_RepNo: master.Daily_RepNo,
                                Daily_RecNo: 1,
                                Daily_Location: master.Daily_Location,
                                Daily_Dept: master.Daily_Dept,
                                Daily_Status: master.Daily_Status,
                                Daily_Make: master.Daly_Make,
                                Daily_Model: master.Daily_Model,
                                Daily_FormNo: master.Daily_FormNo,
                                Daily_VersionNo: master.Daily_VersionNo,
                                Daily_CubicalNo: master.Daily_CubicalNo,
                                Daily_BalID: master.Daily_BalID,
                                Daily_MinCap: master.Daily_MinCap,
                                Daily_MaxCap: master.Daily_MaxCap,
                                Daily_LeastCnt: master.Daily_LeastCnt,
                                Daily_Bal_MinoptRange: master.Daily_Bal_MinoptRange,
                                Daily_Bal_MaxoptRange: master.Daily_Bal_MaxoptRange,
                                Daily_CalbDate: master.Daily_CalbDate,
                                Daily_CalbTime: date.format(master.Daily_CalbTime, 'HH:mm:ss'),    //date.format(now, 'HH:mm:ss')
                                Daily_SpiritLevel: master.Daily_SpiritLevel,
                                Daily_ZeroError: master.Daily_ZeroError,
                                Daily_GeneralCare: master.Daily_GeneralCare,
                                Daily_Reason: master.Daily_Remark,
                                Daily_UserID: userName,
                                Daily_UserName: userName,
                                Daily_VerifyID: master.Daily_VerifyName,
                                HMI_ID: clientIp.split(':')[3],
                                Daily_RoomNo: 0,
                                Decimal_Point: master.Decimal_Point,
                                CalibrationStatus: calibStatus,
                                Daily_IsBinBalance: master.Daily_IsBinBalance,
                                Daily_Unit: master.Daily_Unit,
                                Daily_Bal_Cert_No:master.Daily_Bal_Cert_No,
                                Daily_StdWtBoxID1: result[0].filter((elt) => elt.Daily_RepNo == master.Daily_RepNo).map((elt) => elt.DailyCalibWtBox).toString(),  // changes done for insert weightboxID as per weights for daily and monthly calibration.
                                Daily_BalStdWt1: master.detailArry.Daily_BalStdWt1,
                                Daily_BalNegTol1: master.detailArry.Daily_BalPosTol1,
                                Daily_BalPosTol1: master.detailArry.Daily_BalNegTol1,
                                Daily_ActualWt1 : master.detailArry.Daily_ActualWt1,
                                Daily_StdWtIDNo1: master.detailArry.Daily_StdWtIDNo1,
                                Daily_StdWt1: master.detailArry.Daily_StdWt1,
                                Daily_WeightBox_certfctNo1: master.detailArry.Daily_WeightBox_certfctNo1,
                                Daily_ValDate1: master.detailArry.Daily_ValDate1,
                                PercentofCapacity1: master.detailArry.PercentofCapacity1,

                                Daily_BalStdWt2: master.detailArry.Daily_BalStdWt2,
                                Daily_BalNegTol2: master.detailArry.Daily_BalPosTol2,
                                Daily_BalPosTol2: master.detailArry.Daily_BalNegTol2,
                                Daily_ActualWt2 : master.detailArry.Daily_ActualWt2,
                                Daily_StdWtIDNo2: master.detailArry.Daily_StdWtIDNo2,
                                Daily_StdWt2: master.detailArry.Daily_StdWt2,
                                Daily_WeightBox_certfctNo2: master.detailArry.Daily_WeightBox_certfctNo2,
                                Daily_ValDate2: master.detailArry.Daily_ValDate2,
                                PercentofCapacity2: master.detailArry.PercentofCapacity2,

                                Daily_BalStdWt3: master.detailArry.Daily_BalStdWt3,
                                Daily_BalNegTol3: master.detailArry.Daily_BalPosTol3,
                                Daily_BalPosTol3: master.detailArry.Daily_BalNegTol3,
                                Daily_ActualWt3 : master.detailArry.Daily_ActualWt3,
                                Daily_StdWtIDNo3: master.detailArry.Daily_StdWtIDNo3,
                                Daily_StdWt3: master.detailArry.Daily_StdWt3,
                                Daily_WeightBox_certfctNo3: master.detailArry.Daily_WeightBox_certfctNo3,
                                Daily_ValDate3: master.detailArry.Daily_ValDate3,
                                PercentofCapacity3: master.detailArry.PercentofCapacity3,

                                Daily_BalStdWt4: master.detailArry.Daily_BalStdWt4,
                                Daily_BalNegTol4: master.detailArry.Daily_BalPosTol4,
                                Daily_BalPosTol4: master.detailArry.Daily_BalNegTol4,
                                Daily_ActualWt4 : master.detailArry.Daily_ActualWt4,
                                Daily_StdWtIDNo4: master.detailArry.Daily_StdWtIDNo4,
                                Daily_StdWt4: master.detailArry.Daily_StdWt4,
                                Daily_WeightBox_certfctNo4: master.detailArry.Daily_WeightBox_certfctNo4,
                                Daily_ValDate4: master.detailArry.Daily_ValDate4,
                                PercentofCapacity4: master.detailArry.PercentofCapacity4,

                                Daily_BalStdWt5: master.detailArry.Daily_BalStdWt5,
                                Daily_BalNegTol5: master.detailArry.Daily_BalPosTol5,
                                Daily_BalPosTol5: master.detailArry.Daily_BalNegTol5,
                                Daily_ActualWt5 : master.detailArry.Daily_ActualWt5,
                                Daily_StdWtIDNo5: master.detailArry.Daily_StdWtIDNo5,
                                Daily_StdWt5: master.detailArry.Daily_StdWt5,
                                Daily_WeightBox_certfctNo5: master.detailArry.Daily_WeightBox_certfctNo5,
                                Daily_ValDate5: master.detailArry.Daily_ValDate5,
                                PercentofCapacity5: master.detailArry.PercentofCapacity5,

                                Daily_BalStdWt6: master.detailArry.Daily_BalStdWt6,
                                Daily_BalNegTol6: master.detailArry.Daily_BalPosTol6,
                                Daily_BalPosTol6: master.detailArry.Daily_BalNegTol6,
                                Daily_ActualWt6 : master.detailArry.Daily_ActualWt6,
                                Daily_StdWtIDNo6: master.detailArry.Daily_StdWtIDNo6,
                                Daily_StdWt6: master.detailArry.Daily_StdWt6,
                                Daily_WeightBox_certfctNo6: master.detailArry.Daily_WeightBox_certfctNo6,
                                Daily_ValDate6: master.detailArry.Daily_ValDate6,
                                PercentofCapacity6: master.detailArry.PercentofCapacity6,

                                Daily_BalStdWt7: master.detailArry.Daily_BalStdWt7,
                                Daily_BalNegTol7: master.detailArry.Daily_BalPosTol7,
                                Daily_BalPosTol7: master.detailArry.Daily_BalNegTol7,
                                Daily_ActualWt7 : master.detailArry.Daily_ActualWt7,
                                Daily_StdWtIDNo7: master.detailArry.Daily_StdWtIDNo7,
                                Daily_StdWt7: master.detailArry.Daily_StdWt7,
                                Daily_WeightBox_certfctNo7: master.detailArry.Daily_WeightBox_certfctNo7,
                                Daily_ValDate7: master.detailArry.Daily_ValDate7,
                                PercentofCapacity7: master.detailArry.PercentofCapacity7,

                                Daily_BalStdWt8: master.detailArry.Daily_BalStdWt8,
                                Daily_BalNegTol8: master.detailArry.Daily_BalPosTol8,
                                Daily_BalPosTol8: master.detailArry.Daily_BalNegTol8,
                                Daily_ActualWt8 : master.detailArry.Daily_ActualWt8,
                                Daily_StdWtIDNo8: master.detailArry.Daily_StdWtIDNo8,
                                Daily_StdWt8: master.detailArry.Daily_StdWt8,
                                Daily_WeightBox_certfctNo8: master.detailArry.Daily_WeightBox_certfctNo8,
                                Daily_ValDate8: master.detailArry.Daily_ValDate8,
                                PercentofCapacity8: master.detailArry.PercentofCapacity8,
                            }, {
                                transaction: t
                            });
                        var masterResult = ObjDAilyMaster.dataValues;
                    }
                }
            }

            if (arrCalibData.length > 0) {
                var repeatData = arrCalibData[0];

                let updatenoCalib = await models.tbl_temp_calbdailydetail.update
                    ({
                        Daily_Location: repeatData.Daily_Location,
                        Daily_CubicalNo: repeatData.Daily_CubicalNo,
                        Daily_BalID: repeatData.Daily_BalID,
                        Daily_Make: repeatData.Daly_Make,
                        Daily_Model: repeatData.Daily_Model,
                        Daily_MinCap: repeatData.Daily_MinCap,
                        Daily_MaxCap: repeatData.Daily_MaxCap,
                        Daily_LeastCnt: repeatData.Daily_LeastCnt,
                        Daily_Bal_MinoptRange: repeatData.Daily_Bal_MinoptRange,
                        Daily_Bal_MaxoptRange: repeatData.Daily_Bal_MaxoptRange,
                        Daily_RoomNo: 0,
                        Daily_Dept: repeatData.Daily_Dept,
                        Daily_Status: repeatData.Daily_Status,
                        Daily_FormNo: repeatData.Daily_FormNo,
                        Daily_VersionNo: repeatData.Daily_VersionNo,
                        Decimal_Point: repeatData.Decimal_Point,
                        Daily_Unit: repeatData.Daily_Unit,
                        Daily_IsBinBalance: repeatData.Daily_IsBinBalance,
                        Daily_Bal_Cert_No: repeatData.Daily_Bal_Cert_No,
                        // Daily_StdWtBoxID1: repeatData.Daily_AllWeightboxID
                    }, {
                        where:
                        {
                            Daily_RepNo: 0,
                            HMI_ID: clientIp.split(':')[3],
                            
                        },
                        transaction: t
                    })

                var noCalib = updatenoCalib;


                    let obj_weightData = await models.tbl_temp_calbdailydetail.update
                        ({
                            'Daily_BalStdWt1' : repeatData.detailArry.Daily_BalStdWt1,
                            'Daily_BalNegTol1' : repeatData.detailArry.Daily_BalNegTol1,
                            'Daily_BalPosTol1' : repeatData.detailArry.Daily_BalPosTol1,
                            'Daily_ActualWt1' : 0,
                            'Daily_StdWtIDNo1' : repeatData.detailArry.Daily_StdWtIDNo1,
                            'Daily_StdWt1' : repeatData.detailArry.Daily_StdWt1,
                            'Daily_WeightBox_certfctNo1' : repeatData.detailArry.Daily_WeightBox_certfctNo1,
                            'Daily_ValDate1' : repeatData.detailArry.Daily_ValDate1,
                            'PercentofCapacity1': repeatData.detailArry.PercentofCapacity1,
                            
                            'Daily_BalStdWt2' : repeatData.detailArry.Daily_BalStdWt2,
                            'Daily_BalNegTol2' : repeatData.detailArry.Daily_BalNegTol2,
                            'Daily_BalPosTol2' : repeatData.detailArry.Daily_BalPosTol2,
                            'Daily_ActualWt2' : 0,
                            'Daily_StdWtIDNo2' : repeatData.detailArry.Daily_StdWtIDNo2,
                            'Daily_StdWt2' : repeatData.detailArry.Daily_StdWt2,
                            'Daily_WeightBox_certfctNo2' : repeatData.detailArry.Daily_WeightBox_certfctNo2,
                            'Daily_ValDate2' : repeatData.detailArry.Daily_ValDate2,
                            'PercentofCapacity2': repeatData.detailArry.PercentofCapacity2,

                            'Daily_BalStdWt3' : repeatData.detailArry.Daily_BalStdWt3,
                            'Daily_BalNegTol3' : repeatData.detailArry.Daily_BalNegTol3,
                            'Daily_BalPosTol3' : repeatData.detailArry.Daily_BalPosTol3,
                            'Daily_ActualWt3' : 0,
                            'Daily_StdWtIDNo3' : repeatData.detailArry.Daily_StdWtIDNo3,
                            'Daily_StdWt3' : repeatData.detailArry.Daily_StdWt3,
                            'Daily_WeightBox_certfctNo3' : repeatData.detailArry.Daily_WeightBox_certfctNo3,
                            'Daily_ValDate3' : repeatData.detailArry.Daily_ValDate3,
                            'PercentofCapacity3': repeatData.detailArry.PercentofCapacity3,

                            'Daily_BalStdWt4' : repeatData.detailArry.Daily_BalStdWt4,
                            'Daily_BalNegTol4' : repeatData.detailArry.Daily_BalNegTol4,
                            'Daily_BalPosTol4' : repeatData.detailArry.Daily_BalPosTol4,
                            'Daily_ActualWt4' : 0,
                            'Daily_StdWtIDNo4' : repeatData.detailArry.Daily_StdWtIDNo4,
                            'Daily_StdWt4' : repeatData.detailArry.Daily_StdWt4,
                            'Daily_WeightBox_certfctNo4' : repeatData.detailArry.Daily_WeightBox_certfctNo4,
                            'Daily_ValDate4' : repeatData.detailArry.Daily_ValDate4,
                            'PercentofCapacity4': repeatData.detailArry.PercentofCapacity4,

                            'Daily_BalStdWt5' : repeatData.detailArry.Daily_BalStdWt5,
                            'Daily_BalNegTol5' : repeatData.detailArry.Daily_BalNegTol5,
                            'Daily_BalPosTol5' : repeatData.detailArry.Daily_BalPosTol5,
                            'Daily_ActualWt5' : 0,
                            'Daily_StdWtIDNo5' : repeatData.detailArry.Daily_StdWtIDNo5,
                            'Daily_StdWt5' : repeatData.detailArry.Daily_StdWt5,
                            'Daily_WeightBox_certfctNo5' : repeatData.detailArry.Daily_WeightBox_certfctNo5,
                            'Daily_ValDate5' : repeatData.detailArry.Daily_ValDate5,
                            'PercentofCapacity5': repeatData.detailArry.PercentofCapacity5,
                            
                            'Daily_BalStdWt6' : repeatData.detailArry.Daily_BalStdWt6,
                            'Daily_BalNegTol6' : repeatData.detailArry.Daily_BalNegTol6,
                            'Daily_BalPosTol6' : repeatData.detailArry.Daily_BalPosTol6,
                            'Daily_ActualWt6' : 0,
                            'Daily_StdWtIDNo6' : repeatData.detailArry.Daily_StdWtIDNo6,
                            'Daily_StdWt6' : repeatData.detailArry.Daily_StdWt6,
                            'Daily_WeightBox_certfctNo6' : repeatData.detailArry.Daily_WeightBox_certfctNo6,
                            'Daily_ValDate6' : repeatData.detailArry.Daily_ValDate6,
                            'PercentofCapacity6': repeatData.detailArry.PercentofCapacity6,

                            'Daily_BalStdWt7' : repeatData.detailArry.Daily_BalStdWt7,
                            'Daily_BalNegTol7' : repeatData.detailArry.Daily_BalNegTol7,
                            'Daily_BalPosTol7' : repeatData.detailArry.Daily_BalPosTol7,
                            'Daily_ActualWt7' : 0,
                            'Daily_StdWtIDNo7' : repeatData.detailArry.Daily_StdWtIDNo7,
                            'Daily_StdWt7' : repeatData.detailArry.Daily_StdWt7,
                            'Daily_WeightBox_certfctNo7' : repeatData.detailArry.Daily_WeightBox_certfctNo7,
                            'Daily_ValDate7' : repeatData.detailArry.Daily_ValDate7,
                            'PercentofCapacity7': repeatData.detailArry.PercentofCapacity7,

                            'Daily_BalStdWt8' : repeatData.detailArry.Daily_BalStdWt8,
                            'Daily_BalNegTol8' : repeatData.detailArry.Daily_BalNegTol8,
                            'Daily_BalPosTol8' : repeatData.detailArry.Daily_BalPosTol8,
                            'Daily_ActualWt8' : 0,
                            'Daily_StdWtIDNo8' : repeatData.detailArry.Daily_StdWtIDNo8,
                            'Daily_StdWt8' : repeatData.detailArry.Daily_StdWt8,
                            'Daily_WeightBox_certfctNo8' : repeatData.detailArry.Daily_WeightBox_certfctNo8,
                            'Daily_ValDate8' : repeatData.detailArry.Daily_ValDate8,
                            'PercentofCapacity8': repeatData.detailArry.PercentofCapacity8,
                        },
                            {
                                where:
                                {
                                    Daily_RepNo: 0,
                                    HMI_ID: clientIp.split(':')[3] ,
                                    
                                },
                                transaction: t
                            }
                        );
                    var str_resultUpdateWeightData1 = obj_weightData;

            }
        });
            return arrCalibData[0];
        }
        catch (error) {
            console.log("insertDailyToTemp", error);
            throw error;
        }
    }

    async insertDailyToTempSoftShell(MasterDetailArray, clientIp, reportType, str_weightBoxIDSValidDate, str_monthAndYear, dt_nextCalibDate, str_balWeights) {
        try {
            var arrCalibData = [];
            var calibStatus, str_tableName = "tbl_temp_calbdailydetail_for_sunhalol";
            for (const master of MasterDetailArray) {
                if (master.hasOwnProperty('NDCR_SrNo')) {
                    const noRemakObj = {
                        str_tableName: str_tableName,
                        data: [
                            { str_colName: 'Daily_RepNo', value: 0 },
                            { str_colName: 'Daily_RecNo', value: 0 },
                            { str_colName: 'Daily_CalbDate', value: master.NDCR_DT },
                            { str_colName: 'Daily_SpiritLevel', value: 0 },
                            { str_colName: 'Daily_ZeroError', value: 0 },
                            // { str_colName: 'Daily_GeneralCare', value: 0 },
                            { str_colName: 'Daily_NextPeriodicDate', value: dt_nextCalibDate },
                            { str_colName: 'Daily_MonthYear', value: str_monthAndYear },
                            { str_colName: 'Daily_Reason', value: master.NDCR_Reason },
                            { str_colName: 'Daily_UserID', value: 'NULL' },
                            { str_colName: 'Daily_VerifyID', value: 'NULL' },
                            { str_colName: 'HMI_ID', value: clientIp.split(':')[3].split('.')[3] }
                        ]
                    }
                    var resultNoRemark = await database.save(noRemakObj);
                }
                else if (master.hasOwnProperty('Daily_RepNo')) {
                    if (master.Daily_RepNo == "NULL") {
                        const nocaliObj = {
                            str_tableName: str_tableName,
                            data: [
                                { str_colName: 'Daily_RepNo', value: 0 },
                                { str_colName: 'Daily_RecNo', value: 0 },
                                { str_colName: 'Daily_CalbDate', value: master.Daily_CalbDate },
                                { str_colName: 'Daily_SpiritLevel', value: 0 },
                                { str_colName: 'Daily_ZeroError', value: 0 },
                                { str_colName: 'Daily_NextPeriodicDate', value: dt_nextCalibDate },
                                // { str_colName: 'Daily_GeneralCare', value: 0 },
                                { str_colName: 'Daily_MonthYear', value: str_monthAndYear },
                                { str_colName: 'Daily_Reason', value: 'NULL' },
                                { str_colName: 'Daily_UserID', value: 'NULL' },
                                { str_colName: 'Daily_VerifyID', value: 'NULL' },
                                { str_colName: 'HMI_ID', value: clientIp.split(':')[3].split('.')[3] }
                            ]
                        }
                        var resultNoRemark = await database.save(nocaliObj);
                    }
                    else {
                        (reportType == 'Complete') ? calibStatus = 'Complies' : calibStatus = master.CalibrationStatus;

                        arrCalibData.push(master);
                        const ObjDAilyMaster = {
                            str_tableName: str_tableName,
                            data: [
                                { str_colName: 'Daily_RepNo', value: master.Daily_RepNo },
                                { str_colName: 'Daily_RecNo', value: 1 },
                                { str_colName: 'Daily_Location', value: master.Daily_Location },
                                { str_colName: 'Daily_CubicalNo', value: master.Daily_CubicalNo },
                                { str_colName: 'Daily_BalID', value: master.Daily_BalID },
                                { str_colName: 'Daily_MinCap', value: master.Daily_MinCap },
                                { str_colName: 'Daily_MaxCap', value: master.Daily_MaxCap },
                                { str_colName: 'Daily_LeastCnt', value: master.Daily_LeastCnt },
                                { str_colName: 'Daily_Bal_MinoptRange', value: master.Daily_Bal_MinoptRange },
                                { str_colName: 'Daily_Bal_MaxoptRange', value: master.Daily_Bal_MaxoptRange },
                                { str_colName: 'Daily_CalbDate', value: master.Daily_CalbDate },
                                { str_colName: 'Daily_CalbTime', value: master.Daily_CalbTime },
                                { str_colName: 'Daily_SpiritLevel', value: master.Daily_SpiritLevel[0] },
                                { str_colName: 'Daily_ZeroError', value: master.Daily_ZeroError[0] },
                                { str_colName: 'Daily_MonthYear', value: str_monthAndYear },
                                { str_colName: 'Daily_NextPeriodicDate', value: dt_nextCalibDate },
                                // { str_colName: 'Daily_GeneralCare', value: master.Daily_GeneralCare[0] },
                                { str_colName: 'Daily_Reason', value: "NULL" },
                                { str_colName: 'Daily_UserID', value: master.Daily_UserID },
                                { str_colName: 'Daily_VerifyID', value: master.Daily_VerifyID },
                                { str_colName: 'HMI_ID', value: clientIp.split(':')[3].split('.')[3] },
                                { str_colName: 'Daily_RoomNo', value: 0 },
                                { str_colName: 'Decimal_Point', value: master.Decimal_Point }
                            ]
                        }
                        var masterResult = await database.save(ObjDAilyMaster);

                        for (let i of [1, 2, 3, 4, 5, 6, 7, 8]) {
                            let obj_updateDatas = {
                                str_tableName: str_tableName,
                                data: [
                                    { str_colName: "Daily_BalStdWt" + i, value: this.formatValuesRound(master.detailArry[0]['Daily_BalStdWt' + i], master.Decimal_Point) },
                                    { str_colName: "Daily_BalPosTol" + i, value: this.formatValuesRound(master.detailArry[0]['Daily_BalPosTol' + i], master.Decimal_Point) },
                                    { str_colName: "Daily_BalNegTol" + i, value: this.formatValuesRound(master.detailArry[0]['Daily_BalNegTol' + i], master.Decimal_Point) },
                                    { str_colName: "Daily_ActualWt" + i, value: this.formatValuesRound(master.detailArry[0]['Daily_ActualWt' + i], master.Decimal_Point) },
                                ],
                                condition: [
                                    { str_colName: 'RecNo', value: masterResult[0].insertId }
                                ]
                            }

                            if (i < 5) {
                                obj_updateDatas.data.push(
                                    { str_colName: "Daily_StdWtBoxID" + i, value: str_weightBoxIDSValidDate['weightBox' + i] },
                                    { str_colName: "Daily_StdWtBoxValDT" + i, value: str_weightBoxIDSValidDate['validUpto' + i] }
                                );
                            }
                            var detailResult = await database.update(obj_updateDatas);

                            if (reportType != "Complete") // update other weights
                            {
                                if (i > 5) {
                                    obj_updateDatas.data.push(
                                        { str_colName: "Daily_BalStdWt" + i, value: str_balWeights['stdWt' + i] },
                                        { str_colName: "Daily_BalPosTol" + i, value: str_balWeights['posWt' + i] },
                                        { str_colName: "Daily_BalNegTol" + i, value: str_balWeights['negWt' + i] }
                                    );

                                    var detailResultWeights = await database.update(obj_updateDatas);
                                }
                            }
                        }

                    }
                }
            }
            if (arrCalibData.length > 0) {
                var repeatData = arrCalibData[0];
                let obj_updateOtherData = {
                    str_tableName: str_tableName,
                    data: [
                        { str_colName: 'Daily_Location', value: repeatData.Daily_Location },
                        { str_colName: 'Daily_CubicalNo', value: repeatData.Daily_CubicalNo },
                        { str_colName: 'Daily_BalID', value: repeatData.Daily_BalID },
                        { str_colName: 'Daily_MinCap', value: repeatData.Daily_MinCap },
                        { str_colName: 'Daily_MaxCap', value: repeatData.Daily_MaxCap },
                        { str_colName: 'Daily_LeastCnt', value: repeatData.Daily_LeastCnt },
                        { str_colName: 'Daily_Bal_MinoptRange', value: repeatData.Daily_Bal_MinoptRange },
                        { str_colName: 'Daily_Bal_MaxoptRange', value: repeatData.Daily_Bal_MaxoptRange },
                        { str_colName: 'Daily_RoomNo', value: 0 },
                        { str_colName: 'Decimal_Point', value: repeatData.Decimal_Point },
                    ],
                    condition: [
                        { str_colName: 'Daily_RepNo', value: 0, comp: 'eq' },
                        { str_colName: 'HMI_ID', value: clientIp.split(':')[3].split('.')[3], comp: 'eq' }
                    ]
                }

                var str_resultUpdateOtherData = await database.update(obj_updateOtherData);

                for (let j of [1, 2, 3, 4, 5, 6, 7, 8]) {
                    let obj_weightData = {
                        str_tableName: str_tableName,
                        data: [
                            { str_colName: `Daily_BalStdWt` + j, value: this.formatValuesRound(repeatData.detailArry[0]['Daily_BalStdWt' + j], repeatData.Decimal_Point) },
                            { str_colName: `Daily_BalNegTol` + j, value: this.formatValuesRound(repeatData.detailArry[0]['Daily_BalNegTol' + j], repeatData.Decimal_Point) },
                            { str_colName: `Daily_BalPosTol` + j, value: this.formatValuesRound(repeatData.detailArry[0]['Daily_BalPosTol' + j], repeatData.Decimal_Point) },
                            { str_colName: `Daily_ActualWt` + j, value: 0 },
                        ],
                        condition: [
                            { str_colName: 'Daily_RepNo', value: 0 },
                            { str_colName: 'HMI_ID', value: clientIp.split(':')[3].split('.')[3] }
                        ]
                    }

                    if (j < 5) {
                        obj_weightData.data.push(
                            { str_colName: `Daily_StdWtBoxID` + j, value: str_weightBoxIDSValidDate['weightBox' + j] },
                            { str_colName: `Daily_StdWtBoxValDT` + j, value: str_weightBoxIDSValidDate['validUpto' + j] },
                        );
                    }

                    var str_resultUpdateWeightData = await database.update(obj_weightData);

                    if (reportType != "Complete") // update other weights
                    {
                        if (j > 5) {
                            obj_weightData.data.push(
                                { str_colName: "Daily_BalStdWt" + j, value: str_balWeights['stdWt' + j] },
                                { str_colName: "Daily_BalPosTol" + j, value: str_balWeights['posWt' + j] },
                                { str_colName: "Daily_BalNegTol" + j, value: str_balWeights['negWt' + j] }
                            );

                            var detailResultWeights = await database.update(obj_weightData);
                        }
                    }
                }
            }
            return arrCalibData[0];
        } catch (error) {
            return error;
        }
    }

    formatValues(value, dpVal) {
        return parseFloat(Math.trunc(value * Math.pow(10, dpVal)) / Math.pow(10, dpVal)).toFixed(dpVal)
    }

    formatValuesRound(value, dpVal) {
        return parseFloat(Math.round(value * Math.pow(10, dpVal)) / Math.pow(10, dpVal)).toFixed(dpVal)
    }

    async getCheckByForDailyCalibration(req) {
        try {
            var responseObj = {};
            var str_type = req.body.reportType;
            var str_table;
            (str_type == "Complete") ? str_table = "tbl_calibration_daily_master" : str_table = "tbl_calibration_daily_master_incomplete";

            const obj_getMaxRepoNo = await models[str_table].findAll({
                attributes: [
                    [sequelize.fn('MAX', sequelize.col("Daily_RepNo")), "Daily_RepNo"],
                ],
                where: {
                    Daily_BalID: req.body.balId,
                    Daily_CalibChange: req.body.calibChange

                }
            });
            console.log(obj_getMaxRepoNo[0]);

            if (obj_getMaxRepoNo.length > 0) {
                var obj_checkVerify = await models[str_table].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('Daily_VerifyID')), 'Daily_UserID'],
                    where: { Daily_RepNo: obj_getMaxRepoNo[0].Daily_RepNo }
                });

                var obj_checkVerifyUserID = await models[str_table].findAll({
                    attributes: [sequelize.fn('DISTINCT', sequelize.col('Daily_UserID'))],
                    where: { Daily_RepNo: obj_getMaxRepoNo[0].Daily_RepNo }
                });

                if (obj_checkVerify.length > 0) {
                    if (obj_checkVerify[0].Daily_VerifyID != "NULL" && obj_checkVerify[0].Daily_VerifyID != ""
                        && obj_checkVerify[0].Daily_VerifyID != null && obj_checkVerify[0].Daily_VerifyID != undefined) {
                        Object.assign(responseObj, { status: 'success' }, { result: obj_checkVerify[0] })
                        return responseObj;
                    }
                    else {
                        Object.assign(responseObj, { status: 'success' }, { result: 'Not Verified' }, { resultUser: obj_checkVerifyUserID[0] })
                        return responseObj;
                    }
                }

            }
            else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Records Not Found' })
                return responseObj;
            }
        } catch (error) {
            return error;
        }
    }

    async storeVerifyDetailForCalibration(req) {
        try {
            var responseObj = {};
            var str_type = req.body.reportType;
            var str_table;
            let now = new Date();
            (str_type == "Complete") ? str_table = "tbl_calibration_daily_master" : str_table = "tbl_calibration_daily_master_incomplete";
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
            let obj_getMaxRepoNo = await models['' + str_table].findAll
                ({
                    attributes: [
                        [sequelize.fn('MAX', sequelize.col("Daily_RepNo")), "Daily_RepNo"],
                    ],
                    where:
                    {
                        Daily_BalID: req.body.balId,
                        Daily_CalibChange: req.body.calibChange
                    }
                });
            console.log(obj_getMaxRepoNo);
            var resultMaxRepNo = obj_getMaxRepoNo

            const obj_updateData = await models['' + str_table].update
                (
                    {
                        Daily_VerifyID: req.body.userId,
                        Daily_VerifyName: req.body.username,
                        Daily_VerifyDate: date.format(now, 'YYYY-MM-DD HH:mm:ss')  
                    },
                    {
                        where: { Daily_RepNo: resultMaxRepNo[0].Daily_RepNo },
                        transaction: t
                    }
                );
                return "success";
            });

            Object.assign(responseObj, { status: 'success' }, { result: 'Records Updated' })
            return responseObj;
        } catch (error) {
            return error;
        }
    }
}



module.exports = DailyCalibReport;