const UserModel = require('../model/clsUserModel');
const objUserModel = new UserModel();
const Joi = require('joi');
const clsUserSchema = require('../Validation/User/User.schema');
const objUserSchema = new clsUserSchema();


exports.getUsers = (req, res) => {
    objUserModel.getUsers().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.getPerticularUser = (req, res) => {
    objUserModel.getPerticularUser(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.storeUser = (req, res) => {
    if(req.body.isLdap == 1)
    {
        Joi.validate(req.body, objUserSchema.saveLdapUserSchema(), function (err, value) {
            if (err) {
                console.log(err);
                res.statusCode = 400;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: err.message
                })
                res.send(responseObj);
            } else {
                objUserModel.storeUserLdp(value).then((result) => {
                    res.statusCode = 200;
                    res.send(result);
                }).catch(err => {
                    console.log(err)
                    res.statusCode = 500;
                    let responseObj = {}
                    Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                    res.send(responseObj);
                })
            }

        });   
    }
else
    {
        Joi.validate(req.body, objUserSchema.saveUserSchema(), function (err, value) {
            if (err) {
                console.log(err);
                res.statusCode = 400;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: err.message
                })
                res.send(responseObj);
            } else {
                    objUserModel.storeUser(value).then((result) => {
                        res.statusCode = 200;
                        res.send(result);
                    }).catch(err => {
                        console.log(err)
                        res.statusCode = 500;
                        let responseObj = {}
                        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                        res.send(responseObj);
                    })
            }

        }); 
    }
}

exports.updateUserStatus = (req,res) => {
    Joi.validate(req.body, objUserSchema.updateUserStatusSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objUserModel.updateUserStatus(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

exports.updateUser = (req, res) => {
    Joi.validate(req.body, objUserSchema.updateUserSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objUserModel.updateUser(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })   
        }

    }); 
}

exports.tempUserStatus = (req, res) => {
    Joi.validate(req.body, objUserSchema.tempUserStatusSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objUserModel.tempUserStatus(req,value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })   
        }

    }); 
}

exports.getUsersForChangeProfile = (req, res) => {
    objUserModel.getUsersForChangeProfile().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}