const TabletModel = require('../model/clsTabletModel');
const objTabletMaster = new TabletModel();
const ReportSchema = require('../Validation/Report/Report.schema');
const objReportSchema = new ReportSchema()
const Joi = require('joi');
const LoginModel = require('../model/clsloginModel');
const objLogin = new LoginModel();
const config = require('../global/serverConfig');


exports.getProductDetails = (req, res) => {
    Joi.validate(req.body, objReportSchema.getProductSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objLogin.getProjectName().then(projectName => {
                if(projectName == false){
                    res.statusCode = 400;
                    let responseObj = {}
                    Object.assign(responseObj, {
                        status: 'fail'
                    }, {
                            result: 'Project Name Is Not Set In RPT Path'
                        })
                    res.send(responseObj); 
                }else{
                    var int_isML = 0;
                    if(int_isML == '1') {
                        objTabletMVL.getProductDetails(req).then(result => {
                            res.statusCode = 200;
                            res.send(result);
                        })
                   }else{
                        objTabletMaster.getProductDetails(req).then(result => {
                            res.statusCode = 200;
                            res.send(result);
                        })
                   }
                }
                
            })
            
        }
    })
 
}

exports.calculationLOD = (req, res) => {
    Joi.validate(req.body, objReportSchema.calculationLODSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objTabletMaster.calculationLOD(req).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })
 
}
//*************************************************************************************** */
/**
 * @param req Request object
 * @description Function Pass the data to model for further processing if incoming data is valid
 * otherwise send back error response or else send success response to requsted origin
 */
exports.viewTabReports = (req, res) => { 
    objLogin.getProjectName().then(projectName => {
        if(projectName == false){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: 'Project Name Is Not Set In RPT Path'
                })
            res.send(responseObj); 
        }else{
            var int_consolidatedReport =  0;
            var int_projectName_ML =  0;

            if(int_consolidatedReport == '1') {
                if(req.body.testType == "Initial"){
                    Joi.validate(req.body, objReportSchema.viewTabReportMVLInitial(), (err, value) => {
                        // ON ERROR
                        if (err) {
                            res.statusCode = 400;
                            let responseObj = {}
                            Object.assign(responseObj, {
                                status: 'fail'
                            }, {
                                    result: err.message
                                })
                            res.send(responseObj);
                        } else { 
                            objTabletMaster.viewTabReport(value, req).then(result => {
                                res.statusCode = 200;
                                res.send(result);
                            })
                        }
                    });
                }else{
                    Joi.validate(req.body, objReportSchema.viewTabReportMVL(), (err, value) => {
                        // ON ERROR
                        if (err) {
                            res.statusCode = 400;
                            let responseObj = {}
                            Object.assign(responseObj, {
                                status: 'fail'
                            }, {
                                    result: err.message
                                })
                            res.send(responseObj);
                        } else { 
                            objTabletMVL.viewTabReport(value, req).then(result => {
                                res.statusCode = 200;
                                res.send(result);
                            })
                        }
                    });
                }
            }else{
                if(int_projectName_ML == '1'){
                    Joi.validate(req.body, objReportSchema.viewTabReportMVL(), (err, value) => {
                        // ON ERROR
                        if (err) {
                            res.statusCode = 400;
                            let responseObj = {}
                            Object.assign(responseObj, {
                                status: 'fail'
                            }, {
                                    result: err.message
                                })
                            res.send(responseObj);
                        } else { 
                               
                            objTabletMVL.viewTabReport(value, req).then(result => {
                            res.statusCode = 200;
                            res.send(result);
                        })
                        }
                    });
                }else{
                    Joi.validate(req.body, objReportSchema.viewTabReport(), (err, value) => {
                        // ON ERROR
                        if (err) {
                            res.statusCode = 400;
                            let responseObj = {}
                            Object.assign(responseObj, {
                                status: 'fail'
                            }, {
                                    result: err.message
                                })
                            res.send(responseObj);
                        } else { 
                               
                        objTabletMaster.viewTabReport(value, req).then(result => {
                            res.statusCode = 200;
                            res.send(result);
                        })
                        }
                    });
                }
                
            }
        }
                
    })
}

//*************************************************************************************** */


