const Joi = require('joi');
const clsYieldReconSchema = require('../Validation/yieldRecon/yieldRecon.schema');
const objYieldReconSchema = new clsYieldReconSchema();
const clsYieldreco = require('../model/clsproductYieldModel');
const objclsYieldreco = new clsYieldreco();
const clsvalidateYieldreco = require('../model/validateYield');
const objValidateYield = new clsvalidateYieldreco();
const ValidationYieldEdit = require('../model/validateYieldEdit');
const objValidationYieldEdit = new ValidationYieldEdit();


exports.addYieldRecon = (req, res) => {
    Joi.validate(req.body, objYieldReconSchema.saveYieldSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err
            })
            res.send(responseObj);
        }
        else {
            objclsYieldreco.storeYieldReco(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }
    })
}

exports.updateYieldRecon = (req, res) => {
    Joi.validate(req.body, objYieldReconSchema.updateSchemaYield(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        }
        else {
            objclsYieldreco.updateProductYield(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);

            });


        }
    });
}

exports.auditNewYieldRecon = (req, res) => {
    var objProductNew = req.body.newData;


    if (objProductNew == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {

        objValidateYield.validateYield(objProductNew).then((value) => {
            res.statusCode = 200;

            const result = {}
            Object.assign(result, {
                result: value
            })

            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }

}

exports.auditEditProductYield = (req,res) => {
    var objProductOld = req.body.oldData;
    var objProductNew = req.body.newData;

    if (objProductOld == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {

        objValidationYieldEdit.auditEditProductYield(objProductOld, objProductNew).then((value) => {
            res.statusCode = 200;

            const result = {}
            Object.assign(result, {
                status: 'Success'
            }, {
                result: value
            })

            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
}

exports.getAllProduct = (req,res)=>{
    objclsYieldreco.getAllProduct().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

/*exports.getYieldData = (req,res)=>{
    objclsYieldreco.getYieldData().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}*/

exports.getProductYield = (req,res) => {
    if (req.body.cubicalType == '' || req.body.cubicalType == undefined) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Bad Request'
        })
        res.send(responseObj);
    }
    else{
        objclsYieldreco.getProductYield(req.body.cubicalType).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
    
        }); 

    }
   
}

exports.getYieldProductDetail = (req,res) => {
    Joi.validate(req.body, objYieldReconSchema.getYieldProductSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        }
        else {
            objclsYieldreco.getYieldProductDetail(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);

            });


        }
    });
}