const clsprecalibrationModel = require('../model/clsprecalibrationModel');
const objclsprecaliModel = new clsprecalibrationModel();
const clsPrecalibrationSchema = require('../Validation/Precalibration/Precalibration.schema');
const objPrecalibrationSchema = new clsPrecalibrationSchema();
const Joi = require('joi');

exports.getcalibrationArea = (req, res) => {
    objclsprecaliModel.getcalibrationArea().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.getEqpIDVernier = (req, res) => {
    objclsprecaliModel.getEqpIDVernier().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.getEqpID = (req, res) => {
    objclsprecaliModel.getEqpID().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.getcubicleNo = (req, res) => {
    objclsprecaliModel.getcubicleNo(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.storePrecalibration = (req, res) => {
    Joi.validate(req.body, objPrecalibrationSchema.storePrecalibrationSchema(), function (err, obj) {
        if (err){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err})
            res.send(responseObj);  
        } else {
            objclsprecaliModel.storePrecalibration(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            }) 
        }
    }) 
   
}

exports.getPrecalibrationRecord = (req, res) => {
    objclsprecaliModel.getPrecalibrationRecord(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}

exports.handledWeighmentData = (req, res) => {
    Joi.validate(req.body, objPrecalibrationSchema.handledWeighmentDataSchema(), function (err, obj) {
        if (err){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err})
            res.send(responseObj);  
        } else {
            objclsprecaliModel.handledWeighmentData(obj).then((result) => {
                //console.log(result);
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    }) 
}

exports.getBalID = (req, res) => {
    objclsprecaliModel.getBalID(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    }) 
}