const implementjs = require('implement-js')
const implement = implementjs.default
const clsMachineModel = require('../model/clsMachineModel');
const objClsMachineModel = new clsMachineModel();
var Joi = require('joi');
const clsMachineSchema = require('../Validation/Machine/Machine.schema');
const objClsMachineSchema = new clsMachineSchema();


exports.getAllMachineData = (req, res) => {
    {
        let strMachineId = req.params.strMachineId == undefined ? "" : req.params.strMachineId;
        objClsMachineModel.getMachineData(strMachineId).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
}

exports.saveMachineData = (req, res) => {
    Joi.validate(req.body, objClsMachineSchema.saveMachineSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

           objClsMachineModel.saveMachineData(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });
}
exports.updateActiveDeactive = (req, res) => { 
    Joi.validate(req.body, objClsMachineSchema.updateActiveDeactiveSchema(), function (err, value) { 
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objClsMachineModel.updateActiveDeactive(value).then(result => { 
                res.statusCode = 200;
                res.send(result);
            }).catch(err => { 
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                        result: 'Internal server error'
                    })
                res.send(responseObj);
            })
        }
    })
}
exports.editMachineData = (req, res) => {

    Joi.validate(req.body, objClsMachineSchema.editMachineSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

           objClsMachineModel.editMachineData(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });



}

exports.lockMachineData = (req, res) => {

    Joi.validate(req.body, objClsMachineSchema.getLockSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

           objClsMachineModel.togglelock(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });
}

exports.checkInCubicle = (req,res) => {
    objClsMachineModel.checkInCubicle(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}