const Joi = require('joi');
const LoginModel = require('../model/clsloginModel');
const requestIp = require('request-ip');
const objLoginModel = new LoginModel();
const fs = require('fs');
const clsLoginSchema = require('../Validation/Login/Login.schema');
const objLoginSchema = new clsLoginSchema();

exports.unauthorizedUser = (req, res) =>{
    objLoginModel.unauthorizedUser().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}
// exports.chkUserActive = (req,res) =>{
//     if ((req.body.userId === "") || (req.body.userId === undefined)) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     }
//     else 
//     {
//         objLoginModel.chkUserActive(req).then(result => {
//             res.statusCode = 200;
//             res.send(result);
//             }).catch(err => { 
//                 console.log(err)
//                 res.statusCode = 500;
//                 let responseObj = {}
//                 Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//                 res.send(responseObj);
//         })
//     }
// }

exports.chkUserActive = (req, res) => {
    var Ip = requestIp.getClientIp(req);
    Joi.validate(req.body, objLoginSchema.chkUserActiveSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.chkUserActive(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}
/**
 * @below router is use for developer pannel
 */
var content="";
exports.developerPannel = (req, res) => {
    try {
        objLoginModel.developerPannel().then(result => {
            var fileName =  result;
            if (fs.existsSync(fileName)) {
                fs.readFile(fileName, function(err, data) {
                    if(err){
                        console.log(err);
                    }
                    // var readable = fs.createReadStream(usersFilePath);
                    // readable.pipe(res);
                    content=data;
                    processFile().then((result) => {
                        
                        var actualData = result.toString();
                        
                        res.send(actualData)
                    }).catch( err => {
                        throw err;
                    })
                    
                    });
                    
            }
            else
            {
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            }
        }).catch( err => {
            throw err;
        })
    } catch (error) {
        console.log(error);
        throw error;
    }
    
}

function processFile() {
    return new Promise((resolve,reject) => {
        //console.log(content);
        resolve(content);
    }).catch(err => {
        reject(err);
    })
}

// exports.loginMain =(req,res) => {
//     var Ip = requestIp.getClientIp(req);
//     if (req.body.userId == "" || req.body.userPass == "" || 
//     req.body.userId === undefined || req.body.userPass === undefined ||
//     req.body.source == "" || req.body.source === undefined) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     }
//     else {
//        // console.log(req.body,Ip)
//         objLoginModel.loginMain(req.body.userId, req.body.userPass, req.body.source, Ip,req)
//             .then((result) => {
//                 if (result.status === 'success') {
//                     res.statusCode = 200;
//                     res.json(result)
//                 } else {
//                     res.statusCode = 200;
//                     res.json(result)
//                 }

//             }).catch((err) => {
//                 console.log(err)
//                 res.statusCode = 500;
//                 let responseObj = {}
//                 Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//                 res.send(responseObj);
//             });
//     } 
// }
exports.loginMain = (req, res) => {
    var Ip = requestIp.getClientIp(req);
    Joi.validate(req.body, objLoginSchema.LoginMainSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.loginMain(value.userId, value.userPass, value.source, Ip,req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}
exports.validateUser = (req, res) => {
    let Ip = requestIp.getClientIp(req);
    if (req.body.userId === "" || req.body.userPass === "" || 
    req.body.userId === undefined || req.body.userPass === undefined) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    }
    else {
        objLoginModel.validateUserModel(req.body.userId, req.body.userPass, Ip)
            .then((result) => {
                if (result.status === 'success') {
                    res.statusCode = 200;
                    res.json(result)
                } else {
                    res.statusCode = 200;
                    res.json(result)
                }

            }).catch((err) => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            });
    }

}

exports.checkuserstatusLds = (req, res) => { 
    if ((req.body.user === "") || (req.body.user === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    }
    else 
    {
        objLoginModel.checkuserstatusLds(req).then(result => {
            res.statusCode = 200;
            res.send(result);
            }).catch(err => { 
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
        })
    }

}

exports.validateUserDetails = (req, res) => { 
    
        if ((req.body.user === "") || (req.body.user === undefined) || 
        (req.body.userId === "") || (req.body.userId === undefined)) { 
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else { 
            objLoginModel.validateUserDetails(req).then(result => {
                    res.statusCode = 200;
                    res.send(result);
                    }).catch(err => { 
                        console.log(err)
                        res.statusCode = 500;
                        let responseObj = {}
                        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                        res.send(responseObj);
                })
            }
  
    
}

// exports.setUserActive = (req, res) => {
//     let clientIp = requestIp.getClientIp(req);
//     if ((req.body.userId === "") || (req.body.userId === undefined) || 
//     (req.body.source === "") || (req.body.source === undefined)) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     }
//     else {
//         objLoginModel.setUserActiveModel(req.body.userId, clientIp, req.body.source).then(result => {
//             res.statusCode = 200;
//             res.send(result);
//         }).catch(err => {
//             console.log(err)
//             res.statusCode = 500;
//             let responseObj = {}
//             Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//             res.send(responseObj);
//         });
//     }
// }
exports.setUserActive = (req, res) => {
    let clientIp = requestIp.getClientIp(req);
    Joi.validate(req.body, objLoginSchema.setUserActiveSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.setUserActiveModel(value.userId, clientIp, value.source).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}
// exports.logOut = (req, res) => {
//     if ((req.body.userId === "") || (req.body.userId === undefined) || 
//     (req.body.mode == "") || (req.body.mode === undefined)) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     }
//     else {
//         objLoginModel.logOutModel(req.body.userId,req.body.mode).then(result => {
//             res.statusCode = 200;
//             res.send(result);
//         }).catch(err => {
//             console.log(err)
//             res.statusCode = 500;
//             let responseObj = {}
//             Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//             res.send(responseObj);
//         })
//     }

// }

exports.logOut = (req, res) => {
    let clientIp = requestIp.getClientIp(req);
    Joi.validate(req.body, objLoginSchema.logOutSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.logOutModel(value.userId,value.mode).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}

// exports.updatepassword = (req, res) => {
//     if ((req.body.status === "") || (req.body.status === undefined) || 
//     (req.body.userId === "") || (req.body.userId === undefined) || 
//     (req.body.userPassword === "") || (req.body.userPassword === undefined) || 
//     (req.body.userOldPassword === undefined) || (req.body.userOldPassword === undefined)) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     } else {
//         objLoginModel.updatepassword(req).then(result => {
//             res.statusCode = 200;
//             res.send(result);
//         }).catch(err => {
//             console.log(err)
//             res.statusCode = 500;
//             let responseObj = {}
//             Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//             res.send(responseObj);
//         })
//     }
// }

exports.updatepassword = (req, res) => {
    Joi.validate(req.body, objLoginSchema.updatePasswordSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.updatepassword(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}

// exports.passwordHistory = (req, res) => {
//     if ((req.body.userId === "") || (req.body.userId === undefined)) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     } else {
//         objLoginModel.passwordHistory(req).then(result => {
//             res.statusCode = 200;
//             res.send(result);
//         }).catch(err => {
//             console.log(err)
//             res.statusCode = 500;
//             let responseObj = {}
//             Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//             res.send(responseObj);
//         })
//     }
// }
exports.passwordHistory = (req, res) => {
    Joi.validate(req.body, objLoginSchema.passwordHistorySchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.passwordHistory(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}
// exports.updateUserLock = (req,res) => {
//     if((req.body.userId == "") || (req.body.userId === undefined) || 
//     (req.body.ACT == "") || (req.body.ACT === undefined) || 
//     (req.body.Remark == "") || (req.body.Remark === undefined)) {
//         res.statusCode = 400;
//         let responseObj = {}
//         Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
//         res.send(responseObj);
//     } else {
//         objLoginModel.updateUserLock(req).then(result => {
//             res.statusCode = 200;
//             res.send(result);
//         }).catch(err => {
//             console.log(err)
//             res.statusCode = 500;
//             let responseObj = {}
//             Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
//             res.send(responseObj);
//         })
//     }
// }
exports.updateUserLock = (req, res) => {
    Joi.validate(req.body, objLoginSchema.updateUserLockSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objLoginModel.passwordHistory(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    });  
}
exports.truncateTable = (req, res) => {
    objLoginModel.truncateTableModel()
    .then((result) => {
        let responseObj = {}
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.statusCode = 200;
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    });
}

exports.truncateTableAll = (req, res) => {
    objLoginModel.truncateTableAll()
    .then((result) => {
        if (result === 'Success') {
            res.statusCode = 200;
            res.json(result)
        } else {
            res.statusCode = 200;
            res.json(result)
        }

    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    });
}


exports.unauthorizedUserLDAP = (req,res) =>{
    var Ip = requestIp.getClientIp(req);
    if ((req.body.username === "") || (req.body.username === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    }
    else 
    {
        objLoginModel.unauthorizedUserLDAP(req,Ip).then(result => {
            res.statusCode = 200;
            res.send(result);
            }).catch(err => { 
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
        })
    }
}

exports.verifyConfiguration = (req, res) =>{
    objLoginModel.verifyConfiguration().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}