var Joi = require('joi');
const InstrumentModel = require('../model/clsInstrumentModel');
const objInstrument = new InstrumentModel();
const InstrumentSchema = require('../Validation/Instrument/Instrument.schema');
const objInstrumentSchema = new InstrumentSchema();

exports.saveTempData = (req, res) => {
            objInstrument.saveTempData(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
}

exports.getEqpIdFromInstrumentLog = (req, res) => {

    objInstrument.getEqpIdFromInstrumentLog(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
    res.statusCode = 500;
    let responseObj = {}
    Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
    res.send(responseObj);
    });
}
