const clsContentModel = require('../model/clsContentModel');
const objContentModel = new clsContentModel();
var Joi = require('joi');
const clsContentSchema = require('../Validation/Content/Content.schema');
const objClsContentSchema = new clsContentSchema();

exports.getContent = (req, res) => {
    objContentModel.getContent().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.storeContent = (req, res) => {
    Joi.validate(req.body, objClsContentSchema.saveSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objContentModel.storeContent(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }

    }); 
}