const clsbalanceModel = require('../model/clsbalanceModel');
const objbalanceModel = new clsbalanceModel();
var Joi = require('joi');
const clsBalanceSchema = require('../Validation/Balance/Balance.schema');
const objClsBalanceSchema = new clsBalanceSchema();

exports.getBalance = (req,res) =>{
    objbalanceModel.getBalance().then((result)=>{
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.getBalanceDetails = (req, res) => {
    objbalanceModel.getBalanceDetails().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {status: 'success'}, {result: result })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail'}, {result: 'Internal server error'})
        res.send(responseObj);
    })
}

exports.storeBalance = (req, res) => {
    Joi.validate(req.body, objClsBalanceSchema.saveBalanceSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objbalanceModel.storeBalance(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    });
}

exports.updateBalanceLock = (req,res) => {
    objbalanceModel.updateBalanceLock(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.updateBalance = (req,res) => {
    Joi.validate(req.body, objClsBalanceSchema.editBalanceSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objbalanceModel.updateBalance(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    });
    
}

exports.updateActiveDeactive = (req,res) => {
    Joi.validate(req.body, objClsBalanceSchema.updateActiveDeactiveSchema(), function (err, value) { 
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else { 
            objbalanceModel.updateActiveDeactive(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    });
}

exports.checkInCubicle = (req,res) => {
    objbalanceModel.checkInCubicle(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.addBalanceNoCalib = (req,res)=>{
    objbalanceModel.addBalanceNoCalib(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.updateBalanceNoCalib = (req,res)=>{
    objbalanceModel.updateBalanceNoCalib(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.getBalList_DisallowToEditBalIfRoutineCalbPending = (req,res) => {
    objbalanceModel.getBalList_DisallowToEditBalIfRoutineCalbPending().then((result)=>{
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success' }, { result: result });
        res.send(responseObj);

    }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' });
        res.send(responseObj);
    });
}