const clsAreaSetting = require('../model/clsAreaSettingModel');
const clsAreaSchema = require('../Validation/Area/Area.schema');
const objAreaSetting = new clsAreaSetting();
const objAreaSchema = new clsAreaSchema();
var Joi = require('joi');

exports.getAuditArea = (req, res) => {
    objAreaSetting.getAuditArea().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getIDS = (req, res) => {
    objAreaSetting.getIDS().then((result) => {
        res.statusCode = 200;
        res.send(result)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.saveArea = (req, res) => {

    Joi.validate(req.body, objAreaSchema.getSaveSchema(), function (err, result) {
        if (err) {
            //console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objAreaSetting.updateAllAreaRef(result).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: err
                })
                res.send(responseObj);
            })

        }

    })

}

exports.getCubicleName = (req, res) => {
    objAreaSetting.getCubicleName(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}
