const clsReportModel = require("../model/clsReportModel");
const requestIp = require("request-ip");
const Joi = require('joi');
const ReportSchema = require('../validation/report/report.schema');
const LoginModel = require('../model/clsloginModel');
const objLogin = new LoginModel();
const config = require('../global/serverConfig');


exports.generateReport = (req, res, next) => {
//   let FullIp = requestIp.getClientIp(req);
//   let ClientIp = FullIp.split(":")[3];
//   var intLastIP;

//   if ((("idsNo" in req.body.data) == true)) {
//     intLastIP = `${req.body.data.idsNo}`;
// } else {
//   if (ClientIp === undefined) {
//     ClientIp = "127.0.0.1";
//   } else {
//     ClientIp = ClientIp;
//   }

//   intLastIP = ClientIp.split(".")[3];
// }
  
  // 
  
  let intLastIP = req.body.data.HmiId;
  if (intLastIP === undefined) {
    let FullIp = requestIp.getClientIp(req);
    let ClientIp = FullIp.split(":")[3];
    intLastIP = ClientIp;
  }
  // let Ip = requestIp.getClientIp(req);
  //           let ClIp = Ip.split(':')[3]
  //           var ClientIp;
  //           if (ClIp === undefined) {
  //               ClientIp = '127.0.0.1';
  //           } else {
  //               ClientIp = ClIp;
  //           }
  //           var intLastIP = ClientIp;
  console.log("lastip",intLastIP);
 // const objReportModel = new clsReportModel(req.body.FileName);
 const objReportModel = new clsReportModel(req.body.FileName,req.body.data); // print issue
  setTimeout(() => { 

      objReportModel.makeReport(req.body.FileName, req.body.data, intLastIP)
      .then(result => {
        res.statusCode = 200;
        res.send(result);
      })
      .catch(err => {
        console.log(err);
        //database.createTextFile("GenerateReport.txt",req.body.data);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj,
          {
            status: "fail"
          },
          {
            result: "Internal server error"
          }
        );
        res.send(responseObj);
      });

  },500)
  
};


//Audit trail Report controller for // Coding done for 'No record found OR return Report '
/**
 * @param req REquest object from requesting resource
 * @description Below Model function used for Admin name Audit 
 */
exports.auditAdminName = (req, res) => { 
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.auditAdminNameSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.reptAdminName(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object
 * @description Controller for Admin password Audit trail
 */
exports.auditAdminPassword = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.adminPassword(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAdminPassword(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request Object
 * @description Controller for Set All Parameters Audit trail
 */
exports.auditSetAllParam = (req, res) => { 
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptSetAllParameterSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptSetAllParam(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request Object
 * @description Controller to print Audit trail for activity Log
 */
exports.rptActivityLog = (req, res) => { 
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.reportActivityLogSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      console.log(`${(new Date())}`);
      objReportModel.reportActivityLog(value, ClientIp).then(result => {
        console.log(`${(new Date())}`);
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request Object form requesting resource
 * @description Controller for unauthorize login 
 */
exports.rptUnauthorizeLogin = (req, res) => { 
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.unAuthoriseLogin(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptUnauthorizeLogin(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object
 * @description Cotroller for Pronting audit trail for Roles
 */
exports.rptAuditRoles = (req, res) => { 
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.auditRolesSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditRoles(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for rptAuditUser report
 */
exports.rptAuditUser = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAuditUsers(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditUsers(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.rptDepartment = (req, res) => { 
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptDeparmentSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptDeparment(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object 
 * @description Contrller for Calibration box
 */
exports.rptCalibBox = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCalibBoxSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptCalibratiobBox(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Balance audit report
 */
exports.rptAuditBalnce = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptBalanceSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptBalance(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for varnier audit report
 */
exports.rptAuditVernier = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptVarnier(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptVernier(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for other instrumnet audit report
 */
exports.rptAuditOther = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptOtherEquipment(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptOtherEquipment(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for other instrumnet audit report
 */
exports.rptAuditMachine = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptMachineSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptMachine(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Media audit report
 */
exports.rptAuditMedia = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAlertSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptMedia(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Audit stage audit report
 */
exports.rptAuditStage = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptStageSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptStage(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Audit stage audit report
 */
exports.rptAuditProduct = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptProductSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptProduct(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @param req Request object from requested resource
 * @description Controller for Audit Area
 */
exports.rptAuditArea = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAreaSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptArea(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Port
 */
exports.rptAuditPort = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptPortSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptPort(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit cleaner
 */
exports.rptAuditCleaner = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCleanerSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditCleaner(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit container
 */
exports.rptAuditContainer = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptContainersSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptContainer(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit container
 */
exports.rptAuditBinStage = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCleanerSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditBinStage(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Cubicle
 */
exports.rptAuditCubicle = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCubicleSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptCubicle(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit cleaner
 */
exports.rptAuditCleaner = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(".")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptCleanerSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditCleaner(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: err }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Recalibration
 */
exports.rptAuditRecalib = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptRecalibSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptRecalib(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountCapsule = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintReportCount(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintNoCapsule(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountSummary = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintReportCountSummary(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintNoSummary(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountBinSummary = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.increasePrintCountBinSummarySchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintCountBinSummary(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.increasePrintCountUpBinLabel = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printcountupBinLabelSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintCountUpBinLabel(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @description Controller used to increase the count in the calibtation print tables
 */
exports.increasePrintCountCalibration = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintCountCalibrationSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.increasePrintNoCalibration(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.printCountUpCalibrationVernier = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.PrintCountCalibrationSchemaVernier(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printCountUpCalibrationVernier(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.verifyReport = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.VerifyReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.verifyReport(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Report Verification Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.verifyReportCapsule = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.VerifyReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.verifyReportCapsule(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Report Verification Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.checkCapsuleReportIsVerified = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.checkReportIsVerified(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.checkCapsuleReportIsVerified(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: result }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}


exports.printReasonReportCapsule = (req, res) =>{
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printReasonReport(),(err, value) =>{
    if(err){
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printReasonReportCapsule(value,req).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
/**
 * @description Controller for print reasons report for Calibration
 */
exports.printReasonReportCalibration = (req, res) =>{
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printReasonReportCalib(),(err, value) =>{
    if(err){
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printReasonReportCalibration(value,req).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.printReasonReportVernierCalibration = (req, res) =>{
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printReasonReportCalibVernier(),(err, value) =>{
    if(err){
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printReasonReportVernierCalibration(value,req).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for Media audit report
 */
exports.rptAlertAudit = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAlertSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAlert(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req request object from requested resouce
 * @description controller for yield audit report  rptAuditYield
 */
exports.rptAuditYield = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAuditYieldSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditYield(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

/**
 * @param req Request object from requested resource
 * @description Controller for password complexity audit report
 */

 exports.auditpasswordComplexity = (req, res) =>{
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();


  Joi.validate(req.body, ReportSchema.passwordComplexitySchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.AdminPasswordComplexity(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
  
 }
 /**
  * report for AuditPrecalibration
  */
 exports.rptAuditPrecalibration = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptAuditPrecalibrationSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptAuditPrecalibration(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.printcountupYield = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.printcountupYield(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.printcountupYield(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Operation Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}
exports.periodicCalibrationRemarkForFailed = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.periodicCalibrationRemarkForFailed(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.periodicCalibrationRemarkForFailed(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Remark Added Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.periodicCalibrationRemarkForFailedVernier = (req, res) => {
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.periodicCalibrationRemarkForFailed(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.periodicCalibrationRemarkForFailedVernier(value).then(result => {
        res.statusCode = 200;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "Success" }, { result: "Remark Added Successfull" }
        );
        res.send(responseObj);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

exports.generateReportBatchSummaryAll = async (req, res, next) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  if (ClientIp === undefined) {
    ClientIp = "127.0.0.1";
  } else {
    ClientIp = ClientIp;
  }
  // 
  let intLastIP = ClientIp.split(".")[3];

  for(let i of req.body.arr_param)
  {
    
    var str_fileName = req.body.FileName+i;
    const objReportModel = new clsReportModel(str_fileName);
  //  let a = await setTimeout(() => {
  //   result =  objReportModel.makeReportSummary(str_fileName, req.body.data, intLastIP);
  //  }, 500); 
     
   var result = await objReportModel.makeReportSummary(str_fileName, req.body.data, intLastIP);
   //console.log("Result",result);
   var tmout = await delay(1000)
   //console.log(tmout);
  }

  res.statusCode = 200;
  let responseObj = {};
  Object.assign(responseObj, { status: "Success" }, { result: result });
  res.send(responseObj);

}

/**
 * @param req Request object from requested resource
 * @description Controller for Audit Content audit report
 */
exports.rptAuditContent = (req, res) => {
  let FullIp = requestIp.getClientIp(req);
  let ClientIp = FullIp.split(":")[3];
  const objReportModel = new clsReportModel();
  Joi.validate(req.body, ReportSchema.rptContentSchema(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      let responseObj = {}
      Object.assign(responseObj, {
        status: 'fail'
      }, { result: err })
      res.send(responseObj);
    } else {
      objReportModel.rptContent(value, ClientIp).then(result => {
        res.statusCode = 200;
        res.send(result);
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {};
        Object.assign(
          responseObj, { status: "fail" }, { result: "Internal server error" }
        );
        res.send(responseObj);
      })
    }
  })
}

const delay = timeToWait => new Promise(resolve => setTimeout(resolve, timeToWait));

