const clsPwdComplexityModel = require('../model/clspwdcomplexityModel');
const objclsPwdComplexityModel = new clsPwdComplexityModel();
const Joi = require('joi');
const clsPassPolicySchema = require('../Validation/PasswordPolicy/PasswordPolicy.schema');
const objPassPolicySchema = new clsPassPolicySchema();

exports.getPassword = (req, res) => {
    objclsPwdComplexityModel.getPassword().then((result) => {
       
        res.statusCode = 200;
        
        res.json(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.updatePassword = (req, res) => {
Joi.validate(req.body, objPassPolicySchema.savePasswordPolicySchema(), function (err, value) {
    if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {
        objclsPwdComplexityModel.updatePassword(value).then((result) => {
            res.statusCode = 200;
            let responseObj = {}
            Object.assign(responseObj, { status: 'success' }, { result: 'Password Complexity Updated Successfully' })
            res.send(responseObj);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
})
}