const clsDailyCalibReport = require('../model/clsDailyCalibReport');
const obj_dailyCalibReport = new clsDailyCalibReport();

exports.getBalanceID = (req, res) => {
    if ((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.reportType == '') || (req.body.reportType === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.getBalanceID(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.getDailyReportPrintCount = (req, res) => {
    if ((req.body.reportType == '') || (req.body.reportType === undefined) || 
    (req.body.calibrationType == '') || (req.body.calibrationType === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.getDailyReportPrintCount(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.getDailyCalibrationFailedRemark = (req, res) => {
    if ((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.getDailyCalibrationFailedRemark(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.getDailyCalibrationFailedTime = (req, res) => {
    if ((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.getDailyCalibrationFailedTime(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.setNoCalibrationRemarkForDailyCalibration = (req, res) => {
    if ((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined) || 
    (req.body.reason == '') || (req.body.reason === undefined) || 
    (req.body.UserId == '') || (req.body.UserId === undefined) || 
    (req.body.UserName == '') || (req.body.UserName === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.setNoCalibrationRemarkForDailyCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.getNoCalibrationDatesForDailyCalibration = (req, res) => {
    if ((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.getNoCalibrationDatesForDailyCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.setRemarkForFailedDailyCalibration = (req, res) => {
    if((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined) || 
    (req.body.reason == '') || (req.body.reason == undefined) || 
    (req.body.time === undefined) || (req.body.time == '') ) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.setRemarkForFailedDailyCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }  
}

exports.viewDailyCalibrationReport = (req, res) => {
    if ((req.body.date == '') || (req.body.date === undefined) || 
    (req.body.reportType == '') || (req.body.reportType === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.viewDailyCalibrationReport(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.getDailyCalibrationChange = (req, res) => {
    if ((req.body.month == '') || (req.body.month === undefined) || 
    (req.body.reportType == '') || (req.body.reportType === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.getDailyCalibrationChange(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: err })
            res.send(responseObj);
        })
    }
}

exports.getCheckByForDailyCalibration = (req,res) => {
    if ((req.body.reportType == '') || (req.body.reportType === undefined) || 
    (req.body.balId == '') || (req.body.balId === undefined)){
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj); 
    }
    else
    {
        obj_dailyCalibReport.getCheckByForDailyCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        }) 
    }
}

exports.storeVerifyDetailForCalibration = (req, res) => {
    if ((req.body.reportType == '') || (req.body.reportType === undefined) 
        || (req.body.balId == '') || (req.body.balId === undefined)
        || (req.body.userId == '') || (req.body.userId === undefined)
        || (req.body.username == '') || (req.body.username === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        obj_dailyCalibReport.storeVerifyDetailForCalibration(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}