const clscubicleModel = require('../model/clscubicleModel');
const objclscubicleModel = new clscubicleModel();
var Joi = require('joi');
const clsCubicalUpdateLock = require('../Validation/Cubicle/CubicalUpdateLock.Schema');
const objCubicalUpdateLock = new clsCubicalUpdateLock();
const clsCubicleSchema = require('../Validation/Cubicle/CubicleUpdate.schema');

exports.getArea = (req, res) => {
    objclscubicleModel.getArea().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}


exports.getCubicleInfo = (req, res) => {
    objclscubicleModel.getCubicleInfo().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getAreaInfo = (req, res) => {
    objclscubicleModel.getAllArea().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBatches = (req, res) => {
    objclscubicleModel.getBatches().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getMaxStatusForBatch = (req, res) => {
    objclscubicleModel.getMaxStatusForBatch(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}


exports.checkWeighmentStatus = (req, res) => {
    let intCubicleNo = req.params.intCubicleNo == undefined ? "" : req.params.intCubicleNo;
    objclscubicleModel.checkWeighmentStatus(intCubicleNo).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getProductSamples = (req, res) => {
    objclscubicleModel.getProductSamples(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.updateLock = (req, res) => {
    Joi.validate(req.body, objCubicalUpdateLock.updateLockSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclscubicleModel.updateLock(req).then((result) => {
                // let responseObj = {};
                res.statusCode = 200;
                //Object.assign(responseObj, { status: 'success' }, { result: result })
                res.send(result)
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    });
}

exports.updateCubicle = (req, res) => {
    Joi.validate(req.body, clsCubicleSchema.updateSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclscubicleModel.updateCubicle(value).then((result) => {

                let responseObj = {};
                res.statusCode = 200;
                Object.assign(responseObj, {
                    status: 'Success'
                }, {
                    result: 'Cubicle Updated Successfully'
                })
                res.send(responseObj)


            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    });
}

exports.chkCalibSatus = (req, res) => {

    objclscubicleModel.chkCalibSatus(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}
exports.endCubicleBatch = (req, res) => { 
    Joi.validate(req.body, clsCubicleSchema.updateStausSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclscubicleModel.endBatch(value).then((Endresult) => {

                let responseObj = {};
                res.statusCode = 200;
                Object.assign(responseObj, {status: 'success'}, {result : Endresult})
                res.send(responseObj)


            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {status: 'fail'}, {result: 'Internal server error'})
                res.send(responseObj);
            })
        }
    });
}

exports.getProductDetailIndNGrp = (req, res) => {
    objclscubicleModel.getProductDetailIndNGrp(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getCubicleTypeFromArea = (req, res) => {
    objclscubicleModel.getCubicleTypeFromArea(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getDataOnSelectionOfCubicle = (req, res) => {
    objclscubicleModel.getDataOnSelectionOfCubicle(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getProductTypeFromDatabase = (req, res) => {
    objclscubicleModel.getProductTypeFromDatabase(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getProductUnit = (req, res) => {
    objclscubicleModel.getProductUnit(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.saveSample = (req, res) => {
    objclscubicleModel.saveSample(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    })
}

exports.getSampleFromProductCubicle = (req, res) => {
    objclscubicleModel.getSampleFromProductCubicle(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    })
}

exports.batchForCubical = (req, res) => {
    objclscubicleModel.batchForCubical(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    })
}
