const CapsuleModel = require('../model/clsProductCapsuleModel');
const objCapsuleModel = new CapsuleModel();
const ReportSchema = require('../Validation/Report/Report.schema');
const objReportSchema = new ReportSchema()
const clsCapsuleSchema = require('../Validation/Product/Product.schema');
const clsProductModel = require('../model/clsproductModel');
const objProductModel = new clsProductModel();
const LoginModel = require('../model/clsloginModel');
const objLogin = new LoginModel();
const config = require('../global/serverConfig');

const Joi = require('joi');

exports.getProductDetails = (req, res) => {
    Joi.validate(req.body, objReportSchema.getProductCapSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objLogin.getProjectName().then(projectName => {
                if(projectName == false){
                    res.statusCode = 400;
                    let responseObj = {}
                    Object.assign(responseObj, {
                        status: 'fail'
                    }, {
                            result: 'Project Name Is Not Set In RPT Path'
                        })
                    res.send(responseObj); 
                }else{
                    objCapsuleModel.getProductDetails(req).then(result => {
                        res.statusCode = 200;
                        res.send(result);
                    })
                }
                
            })
            
        }
    })

}

exports.viewCapsuleReport=(req,res)=>{
    objLogin.getProjectName().then(projectName => {
        if(projectName == false){
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: 'Project Name Is Not Set In RPT Path'
                })
            res.send(responseObj); 
        }else{
            Joi.validate(req.body,objReportSchema.viewCapRepSchemaForOther(),function(err,value){
                if(err){
                    res.statusCode = 400;
                    let responseObj = {}
                    Object.assign(responseObj, {
                        status: 'fail'
                    }, {
                            result: err.message
                        })
                    res.send(responseObj);  
                }
                else{   
                    objCapsuleModel.viewCapsuleReport(value, req).then(result => {
                        res.statusCode = 200;
                        res.send(result);
                    })
                }    
            });
        }
                
    })
}

exports.saveProduct = (req, res) => {
    Joi.validate(req.body, clsCapsuleSchema.saveSchemaCapsule(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objProductModel.addProduct(value,2).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })

}

exports.UpdateProduct = (req, res) => {
    Joi.validate(req.body, clsCapsuleSchema.updateSchemaCapsule(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objProductModel.updateProductCapsule(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                        result: 'Internal server error'
                    })
                res.send(responseObj);
            })
        }
    })

}

exports.calculationCapsuleLOD = (req, res) => {
    Joi.validate(req.body, objReportSchema.calculationLODCapSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objCapsuleModel.calculationCapsuleLOD(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            })
        }
    })

}