const Joi = require('joi');

class SoftgelSchema {
     saveSoftgelSchema()
    { 
        const saveSoftgelSchema = Joi.object().keys({
            BFGCode: Joi.string().max(25).required().not(['',null,'undefined']),
            ProductName: Joi.string().max(250).required().not(['',null,'undefined']),
            PVersion: Joi.string().max(25).required().not(['',null,'undefined']),
            Version: Joi.string().max(25).required().not(['',null,'undefined']),
            UserID: Joi.string().max(100).required().not(['', null, 'undefined']),
            UserName: Joi.string().max(100).required().not(['', null, 'undefined']),
            Action: Joi.string().max(20).required().not(['',null,'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            int_chkBFG: Joi.number().max(1).required().not(['',null,'undefined']),
            int_chkPrdVersion: Joi.number().max(1).required().not(['',null,'undefined']),
            int_chkVersion: Joi.number().max(1).required().not(['',null,'undefined']),
            chkBFGCode: Joi.allow(),
            chkPrdVersion: Joi.allow(),
            chkVersion: Joi.allow(),
            auditObject: Joi.object().keys({
                status: Joi.string().not([null, 'undefined']),
                result: Joi.object().keys({
                    SoftGel: Joi.object().keys({
                        //oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined'])
                    }),
                }),
            })
        });
        
        return saveSoftgelSchema;
    }

    activateSoftgelSchema(){
        const activateSoftgelSchema = Joi.object().keys({
            productID: Joi.string().max(100).required().not(['',null,'undefined']),
            productName: Joi.string().max(500).required().not(['',null,'undefined']),
            productVersion: Joi.string().max(50).required().not(['',null,'undefined']),
            Version: Joi.string().max(50).required().not(['',null,'undefined']),
            userId: Joi.string().max(100).required().not(['', null, 'undefined']),
            userName: Joi.string().max(100).required().not(['', null, 'undefined']),
            action: Joi.string().max(20).required().not(['',null,'undefined']),
            remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            productType: Joi.string().max(100).required().not(['', null, 'undefined'])
        });
        
        return activateSoftgelSchema;  
    }
}

module.exports = SoftgelSchema;