const Joi = require('joi');
// const { join } = require('mysql2/lib/constants/charset_encodings');

class ProductSchema {
    static saveTabSchema() {
        const saveTabSchema = Joi.object().keys({
            str_BFGCode: Joi.string().max(25).required().not(['', null, 'undefined']),
            str_Prd: Joi.string().max(300).required().not(['', null, 'undefined']),
            str_PV: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_V: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_UpperSurface : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_LowerSurface :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_ApperanceDesc :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_ApperanceDesc_Coat :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            int_chkBFG: Joi.number(),
            int_chkPrdVersion: Joi.number(),
            int_chkVersion: Joi.number(),
            //str_GenericName: Joi.string().max(300).required().not(['', null, 'undefined']),
            str_GenericName: Joi.string().max(300).required().allow(null),
            str_GenericName: Joi.string(),
            int_prdType: Joi.number().empty(['', null]).allow('', null).default(1),
            strProjectName: Joi.string().required().not([null, 'undefined']),
            flt_BatchSize: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_BatchUnit: Joi.string().max(50).required().not(['', null, 'undefined']),
            intGenericName: Joi.number(),
            bln_TypeCoatPrd: Joi.boolean().required(),
            bln_TypeBiLayPrd: Joi.boolean().required(),
            bln_TypeTriLayPrd: Joi.boolean().required(),
            bln_TypeGrannualPrd: Joi.boolean().required(),
            bln_TypeCompressed: Joi.boolean().required(),
            bln_TypeDosaDry: Joi.boolean().required(),
            bln_IsBinWeiging: Joi.boolean().empty("").default(false),
            biLayerLabel: Joi.string().empty(['', null]).allow('', null).default('NA'),
            triLayerLabel: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_ind_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_indL1_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_indL2_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_indCoat_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            //int_SetNMTTabCount: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),
            //below parameter added on 18/05/2021
            bln_BFGCode: Joi.boolean().required(),
            bln_PrdVersion: Joi.boolean().required(),
            bln_Version: Joi.boolean().required(),

            flt_IndStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndDP: Joi.number().empty("").default(4),
            str_IndGraphOn: Joi.string().max(255).empty("").default('Standard'),
            str_IndLimitOn: Joi.string().max(255).empty("").default('Actual'),
            int_IndNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            // Individual Coated
            flt_IndStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndCoatDp: Joi.number().empty("").default(4),
            str_IndGraphOnCoat: Joi.string().max(255).empty("").default('Standard'),
            str_IndLimitOnCoat: Joi.string().max(255).empty("").default('Actual'),
            int_IndNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_GrpStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Grpdp: Joi.number().empty("").default(4),
            str_GrpGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_GrpNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpLimitOn: Joi.string().max(255).empty("").default('Actual'),

            // Group Coated
            flt_GrpStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_GrpCoatDp: Joi.number().empty("").default(4),
            str_GrpLimitOnCoat: Joi.string().max(255).empty("").default('Actual'),
            str_GrpGraphOnCoat: Joi.string().max(255).empty("").default('Standard'),
            int_GrpNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_ThkStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Thkdp: Joi.number().empty("").default(2),
            int_ThkNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_ThkGraphOn: Joi.string().max(255).empty("").default('Standard'),
            str_ThkLimitOn: Joi.string().empty(['', null]).allow('', null).default(""),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Thickness Coated
            flt_ThkStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_ThkCoatDp: Joi.number().empty("").default(2),
            int_ThkNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            // Breath
            flt_BrdStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Brddp: Joi.number().empty("").default(2),
            str_BrdGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_BrdNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Breath Coated
            flt_BrdStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_BrdCoatDp: Joi.number().empty("").default(2),
            int_BrdNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_LenStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_LenDp: Joi.number().empty("").default(2),
            str_LenGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_LenNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Length Coated
            flt_LenStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_LenCoatDp: Joi.number().empty("").default(2),
            int_LenNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_DiaStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_DiaDp: Joi.number().empty("").default(2),
            str_DiaGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_DiaNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Diameter Coated
            flt_DiaStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_DiaCoatDp: Joi.number().empty("").default(2),
            int_DiaNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_HrdStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_3: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_3: Joi.string().empty(['', null]).allow('', null).default(99999),
            //int_HrdDp: Joi.number().max(11).required().not(['',null,'undefined']),
            str_HrdGraphOn: Joi.string().max(255).empty("").default('Standard'),
            str_HrdUnit: Joi.string().empty("").default(""),
            int_HardDp: Joi.number().empty("").default(1),
            str_HardLimitOn: Joi.allow(),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Hardness Coated
            flt_HrdStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_3Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_3Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_HrdUnitCoat: Joi.string().empty("").default(""),
            str_HrdGraphOnCoat: Joi.string().empty("").default(""),
            int_HardDpCoat: Joi.number().empty("").default(1),
            str_HardLimitOnCoat: Joi.allow(),

            flt_FriNMT: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_FriSetCnt: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_FriSetRPM: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_FriDp: Joi.number().empty(['', null]).allow('', null).default(0),
            //str_DiaGraphOn: Joi.string().alphanum().max(255).required().not(['', null, 'undefined']),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Friability Coated
            flt_FriNMTCoat: Joi.empty(['', null]).allow('', null).default(99999),
            int_FriSetCntCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_FriSetRPMCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_FriCoatDp: Joi.number().empty(['', null]).allow('', null).default(0),

            flt_IndL1Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndL1Dp: Joi.number().empty("").default(4),
            str_IndL1GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_IndL1NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_IndL1LimitOn: Joi.string().max(255).empty("").default('Actual'),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            flt_GrpL1Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_GrpL1Dp: Joi.number().empty("").default(4),
            str_GrpL1GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_GrpL1NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpL1LimitOn: Joi.string().max(255).empty("").default('Actual'),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            flt_IndL2Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndL2Dp: Joi.number().empty("").default(4),
            str_IndL2GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_IndL2NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_IndL2LimitOn: Joi.string().max(255).empty("").default('Actual'),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            flt_GrpL2Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_GrpL2Dp: Joi.number().empty("").default(4),
            str_GrpL2GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_GrpL2NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpL2LimitOn: Joi.string().max(255).empty("").default('Actual'),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            int_DTHHTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTemp: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTemp: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_DTDp: Joi.number().empty("").default(4),

            // DT Coated
            int_DTMMTimeCoat: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTimeCoat: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTHHTimeCoat: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTempCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTempCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_DTDpCoat: Joi.number().empty("").default(4),

            flt_TDT1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TDT2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_MAT1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_MAT2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_SST1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_SST2: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_TDDp: Joi.number().empty("").default(4),
            int_MADp: Joi.number().empty("").default(4),
            int_SSDp: Joi.number().empty("").default(4),

            flt_MAT1Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_MAT2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_MADpCoat: Joi.number().empty("").default(4),

            flt_CompDryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompDryMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            int_DTHHTime_Lay_1: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime_Lay_1: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime_Lay_1: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTemp_Lay_1: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTemp_Lay_1: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_DTHHTime_Lay_2: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime_Lay_2: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime_Lay_2: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTemp_Lay_2: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTemp_Lay_2: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Pan: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Pan: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_FineMin_blw_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Pan_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Pan_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_FineMin_blw_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Pan_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Pan_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            
            flt_FineMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),

            int_dryDpGran: Joi.number().empty("").default(4),
            int_lubDpGran: Joi.number().empty("").default(4),
            int_dryL1DpGran: Joi.number().empty("").default(4),
            int_lubL1DpGran: Joi.number().empty("").default(4),
            int_dryL2DpGran: Joi.number().empty("").default(4),
            int_lubL2DpGran: Joi.number().empty("").default(4),
            int_tdDpGran: Joi.number().empty("").default(4),
            int_fineDpGran: Joi.number().empty("").default(4),
            int_psDpGran: Joi.number().empty("").default(4),
            int_bulkDpGran: Joi.number().empty("").default(4),
            int_DTDp_Lay_1: Joi.number().empty("").default(4),
            int_DTDp_Lay_2: Joi.number().empty("").default(4),
            int_tdDpGran_Lay_1: Joi.number().empty("").default(4),
            int_tdDpGran_Lay_2: Joi.number().empty("").default(4),
            int_bulkDpGran_Lay_1: Joi.number().empty("").default(4),
            int_bulkDpGran_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_30: Joi.number().empty("").default(4),
            int_fineDpGran_abv_30: Joi.number().empty("").default(4),
            int_fineDpGran_blw_40: Joi.number().empty("").default(4),
            int_fineDpGran_abv_40: Joi.number().empty("").default(4),
            int_fineDpGran_blw_60: Joi.number().empty("").default(4),
            int_fineDpGran_abv_60: Joi.number().empty("").default(4),
            int_fineDpGran_blw_80: Joi.number().empty("").default(4),
            int_fineDpGran_abv_80: Joi.number().empty("").default(4),
            int_fineDpGran_blw_100: Joi.number().empty("").default(4),
            int_fineDpGran_abv_100: Joi.number().empty("").default(4),
            int_fineDpGran_Pan: Joi.number().empty("").default(4),

            int_fineDpGran_blw_30_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_30_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_40_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_40_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_60_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_60_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_80_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_80_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_100_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_100_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_Pan_Lay_1: Joi.number().empty("").default(4),

            int_fineDpGran_blw_30_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_30_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_40_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_40_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_60_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_60_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_80_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_80_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_100_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_100_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_Pan_Lay_2: Joi.number().empty("").default(4),
            
            int_fineDpGran_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_Lay_2: Joi.number().empty("").default(4),
            int_PSD_DpGran: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100_Lay_1: Joi.number().empty("").default(4),
            int_psDpGran_Lay_1: Joi.number().empty("").default(4),
            int_psDpGran_Lay_2: Joi.number().empty("").default(4),

            str_unit_Vernier: Joi.allow(),
            str_unit_Balance: Joi.allow(),
            str_unit_Group: Joi.allow(),
            str_indUnit: Joi.allow(),
            str_groupUnit: Joi.allow(),
            str_verUnit: Joi.allow(),
            auditObject: Joi.object().keys({
                status: Joi.string().required().not([null, 'undefined']),
                result: Joi.object().keys({
                    Compressed: Joi.object().keys({
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    Coated: Joi.object().keys({
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    Grannual: Joi.object().keys({
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                }),
            }),


            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(50).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark: Joi.string().max(500).required().not(['', null, 'undefined'])
           // remark: Joi.string().regex(/^[a-zA-Z0-9!@#$&()\\-`.+,/\" \-]*$/).max(500).required().not(['', null, 'undefined'])


        });

        return saveTabSchema;
    }

    static updateSchema() {
        var updateSchema;
        updateSchema = Joi.object().keys({
            str_BFGCode: Joi.string().max(25).required().not(['', null, 'undefined']),
            str_Prd: Joi.string().max(300).required().not(['', null, 'undefined']),
            str_PV: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_V: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_UpperSurface : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_LowerSurface :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_ApperanceDesc :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_ApperanceDesc_Coat :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_GenericName: Joi.string(),
            int_prdType: Joi.number().required().empty(['', null]).allow('', null).default(1),
            intGenericName: Joi.number(),

            str_indUnit:Joi.allow(),
            str_verUnit:Joi.allow(),
            str_unit_Balance:Joi.allow(),
            str_groupUnit:Joi.allow(),
            str_unit_Vernier:Joi.allow(),
            str_unit_Group:Joi.allow(),
            
            strOldBFG: Joi.string().max(25).required().not(['', null, 'undefined']),
            strOldPrd: Joi.string().max(300).required().not(['', null, 'undefined']),
            strOldPV: Joi.string().max(50).required().not(['', null, 'undefined']),
            strOldV: Joi.string().max(50).required().not(['', null, 'undefined']),
            strOldGName: Joi.string().max(300).required().not(['', null, 'undefined']),
            IsPrdDetailChange: Joi.boolean().required(),
            str_Old_UpperSurface : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_Old_LowerSurface : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_Old_AppearanceDesc : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_Old_AppearanceDesc_Coat : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),

            flt_BatchSize: Joi.empty(['', null]).allow('', null).default(99999),
            str_BatchUnit: Joi.string().max(50).required().not(['', null, 'undefined']),
            bln_TypeCoatPrd: Joi.boolean().required(),
            bln_TypeBiLayPrd: Joi.boolean().required(),
            bln_TypeTriLayPrd: Joi.boolean().required(),
            wasCompressed: Joi.boolean().empty("").default(false),
            wasCoated: Joi.boolean().empty("").default(false),
            wasGrannual: Joi.boolean().empty("").default(false),
            wasBilayer: Joi.boolean().empty("").default(false),
            wasTrilayer: Joi.boolean().empty("").default(false),
            bln_IsBinWeiging: Joi.boolean().empty("").default(false),
            bln_TypeCompressed: Joi.boolean(),
            bln_TypeGrannualPrd: Joi.boolean(),
            bln_TypeDosaDry: Joi.boolean(),
            biLayerLabel: Joi.string().empty(['', null]).allow('', null).default('NA'),
            triLayerLabel: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_ind_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_indL1_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_indL2_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_indCoat_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            //nominalNomenclature: Joi.string().max(25).required(),

            flt_IndStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndDP: Joi.number().empty("").default(4),
            str_IndGraphOn: Joi.string().max(255).empty("").default('Standard'),
            str_IndLimitOn: Joi.string().max(255).empty("").default('Actual'),
            int_IndNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            // Individual Coated
            flt_IndStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndCoatDp: Joi.number().empty("").default(4),
            str_IndGraphOnCoat: Joi.string().max(255).empty("").default('Standard'),
            str_IndLimitOnCoat: Joi.string().max(255).empty("").default('Actual'),
            int_IndNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_GrpStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Grpdp: Joi.number().empty("").default(4),
            str_GrpGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_GrpNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpLimitOn: Joi.string().max(255).empty("").default('Actual'),

            // Group Coated
            flt_GrpStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_GrpCoatDp: Joi.number().empty("").default(4),
            str_GrpLimitOnCoat: Joi.string().max(255).empty("").default('Actual'),
            str_GrpGraphOnCoat: Joi.string().max(255).empty("").default('Standard'),
            int_GrpNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_ThkStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Thkdp: Joi.number().empty("").default(2),
            int_ThkNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_ThkGraphOn: Joi.string().max(255).empty("").default('Standard'),
            str_ThkLimitOn: Joi.string().empty(['', null]).allow('', null).default(""),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Thickness Coated
            flt_ThkStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_ThkT3PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_ThkCoatDp: Joi.number().empty("").default(2),
            int_ThkNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),


            flt_BrdStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Brddp: Joi.number().empty("").default(2),
            str_BrdGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_BrdNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            // Breath Coated
            flt_BrdStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_BrdT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_BrdCoatDp: Joi.number().empty("").default(2),
            int_BrdNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_LenStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_LenDp: Joi.number().empty("").default(2),
            str_LenGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_LenNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            // Length Coated
            flt_LenStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT3PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_LenCoatDp: Joi.number().empty("").default(2),
            int_LenNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_DiaStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_DiaDp: Joi.number().empty("").default(2),
            str_DiaGraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_DiaNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            // Diameter Coated
            flt_DiaStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3NegCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT3PosCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_DiaCoatDp: Joi.number().empty("").default(2),
            int_DiaNMTTabCntCoat: Joi.empty(['', null]).allow('', null).default(99999),

            flt_HrdStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_3: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_3: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_HrdGraphOn: Joi.string().max(255).empty("").default('Standard'),
            str_HrdUnit: Joi.string().empty("").default(""),
            int_HardDp: Joi.number().empty("").default(1),
            str_HardLimitOn:Joi.allow(),

            // Hardness Coated
            flt_HrdStdCoat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT1_3Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_HrdT2_3Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_HrdUnitCoat: Joi.string().empty("").default(""),
            str_HrdGraphOnCoat: Joi.string().empty("").default(""),
            int_HardDpCoat: Joi.number().empty("").default(1),
            str_HardLimitOnCoat:Joi.allow(),

            flt_FriNMT: Joi.empty(['', null]).allow('', null).default(99999),
            int_FriSetCnt: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_FriSetRPM: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_FriDp: Joi.number().empty("").default(0),

            // Friability Coated
            flt_FriNMTCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_FriSetCntCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_FriSetRPMCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_FriCoatDp: Joi.number().empty("").default(0),

            flt_IndL1Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL1T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndL1Dp: Joi.number().empty("").default(4),
            str_IndL1GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_IndL1NMTTabCount: Joi.number().empty(['', null]).allow('', null).default(99999),
            str_IndL1LimitOn: Joi.string().max(255).empty("").default('Actual'),

            flt_GrpL1Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL1T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_GrpL1Dp: Joi.number().empty("").default(4),
            str_GrpL1GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_GrpL1NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpL1LimitOn: Joi.string().max(255).empty("").default('Actual'),

            flt_IndL2Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndL2T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndL2Dp: Joi.number().empty("").default(4),
            str_IndL2GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_IndL2NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_IndL2LimitOn: Joi.string().max(255).empty("").default('Actual'),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            flt_GrpL2Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpL2T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_GrpL2Dp: Joi.number().empty("").default(4),
            str_GrpL2GraphOn: Joi.string().max(255).empty("").default('Standard'),
            int_GrpL2NMTTabCount: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpL2LimitOn: Joi.string().max(255).empty("").default('Actual'),
            //str_IndLimitOn: Joi.string().alphanum().max(50).required().not(['', null, 'undefined']),

            int_DTHHTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTemp: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTemp: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_DTDp: Joi.number().empty("").default(4),

            // DT Coated
            int_DTMMTimeCoat: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTimeCoat: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTHHTimeCoat: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTempCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTempCoat: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_DTDpCoat: Joi.number().empty("").default(4),

            flt_TDT1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TDT2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_MAT1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_MAT2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_SST1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_SST2: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_TDDp: Joi.number().empty("").default(4),
            int_MADp: Joi.number().empty("").default(4),
            int_SSDp: Joi.number().empty("").default(4),

            flt_MAT1Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_MAT2Coat: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_MADpCoat: Joi.number().empty("").default(4),


            flt_CompDryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompDryMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            int_DTHHTime_Lay_1: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime_Lay_1: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime_Lay_1: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTemp_Lay_1: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTemp_Lay_1: Joi.number().empty(['', null]).allow('', null).default(99999),
            int_DTHHTime_Lay_2: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime_Lay_2: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime_Lay_2: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMinTemp_Lay_2: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_DTMaxTemp_Lay_2: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_30: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Pan: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Pan: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_FineMin_blw_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_30_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Pan_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Pan_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_FineMin_blw_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_30_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_40_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_60_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_80_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_blw_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_blw_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_abv_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_abv_100_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Pan_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Pan_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_FineMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax_Lay_2: Joi.string().empty(['', null]).allow('', null).default(99999),
            
            int_dryDpGran: Joi.number().empty("").default(4),
            int_lubDpGran: Joi.number().empty("").default(4),
            int_dryL1DpGran: Joi.number().empty("").default(4),
            int_lubL1DpGran: Joi.number().empty("").default(4),
            int_dryL2DpGran: Joi.number().empty("").default(4),
            int_lubL2DpGran: Joi.number().empty("").default(4),
            int_tdDpGran: Joi.number().empty("").default(4),
            int_fineDpGran: Joi.number().empty("").default(4),
            int_psDpGran: Joi.number().empty("").default(4),
            int_bulkDpGran: Joi.number().empty("").default(4),
            int_DTDp_Lay_1: Joi.number().empty("").default(4),
            int_DTDp_Lay_2: Joi.number().empty("").default(4),
            int_tdDpGran_Lay_1: Joi.number().empty("").default(4),
            int_tdDpGran_Lay_2: Joi.number().empty("").default(4),
            int_bulkDpGran_Lay_1: Joi.number().empty("").default(4),
            int_bulkDpGran_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_30: Joi.number().empty("").default(4),
            int_fineDpGran_abv_30: Joi.number().empty("").default(4),
            int_fineDpGran_blw_40: Joi.number().empty("").default(4),
            int_fineDpGran_abv_40: Joi.number().empty("").default(4),
            int_fineDpGran_blw_60: Joi.number().empty("").default(4),
            int_fineDpGran_abv_60: Joi.number().empty("").default(4),
            int_fineDpGran_blw_80: Joi.number().empty("").default(4),
            int_fineDpGran_abv_80: Joi.number().empty("").default(4),
            int_fineDpGran_blw_100: Joi.number().empty("").default(4),
            int_fineDpGran_abv_100: Joi.number().empty("").default(4),
            int_fineDpGran_Pan: Joi.number().empty("").default(4),

            int_fineDpGran_blw_30_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_30_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_40_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_40_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_60_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_60_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_80_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_80_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_blw_100_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_abv_100_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_Pan_Lay_1: Joi.number().empty("").default(4),

            int_fineDpGran_blw_30_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_30_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_40_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_40_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_60_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_60_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_80_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_80_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_blw_100_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_abv_100_Lay_2: Joi.number().empty("").default(4),
            int_fineDpGran_Pan_Lay_2: Joi.number().empty("").default(4),

            int_fineDpGran_Lay_1: Joi.number().empty("").default(4),
            int_fineDpGran_Lay_2: Joi.number().empty("").default(4),
            int_PSD_DpGran: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100_Lay_1: Joi.number().empty("").default(4),
            int_psDpGran_Lay_1: Joi.number().empty("").default(4),
            int_psDpGran_Lay_2: Joi.number().empty("").default(4),
            
            strProjectName: Joi.string().required().not([null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(50).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
           // remark: Joi.string().regex(/^[a-zA-Z0-9!@#$&()\\-`.+,/\" \-]*$/).max(500).required().not(['', null, 'undefined']),
            remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            auditObject: Joi.object().keys({
                status: Joi.string().not([null, 'undefined']),
                result: Joi.object().keys({
                    result: Joi.string().not([null, 'undefined']),
                    Compressed: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    Coated: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    Grannual: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    ProductDetail: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                }),
            }),

        });
        return updateSchema;
    }

    static saveSchemaCapsule() {
        const saveSchemaCapsule = Joi.object().keys({
            str_BFGCode: Joi.string().max(25).required().not(['', null, 'undefined']),
            str_Prd: Joi.string().max(300).required().not(['', null, 'undefined']),
            str_PV: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_V: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_UpperSurface : Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_LowerSurface :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_ApperanceDesc :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            str_ApperanceDesc_Coat :  Joi.string().max(500).empty(['', null,'undefined']).allow(['', null, 'undefined']).default(''),
            int_prdType: Joi.number().empty(['', null]).allow('', null).default(1),
            str_GenericName: Joi.string(),
            intGenericName: Joi.number(),
            int_chkBFG: Joi.number(),
            int_chkPrdVersion: Joi.number(),
            int_chkVersion: Joi.number(),
            flt_BatchSize: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_BatchUnit: Joi.string().max(50).required().not(['', null, 'undefined']),
            bln_TypeCompressed: Joi.boolean().required(),
            // bln_TypeCapsule: Joi.boolean().required(),
            bln_TypeCoatPrd: Joi.boolean().required(),
            bln_IsBinWeiging: Joi.boolean().empty("").default(false),
            bln_TypeGrannualPrd: Joi.boolean().empty("").default(false),
            str_ind_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            //below parameter added on 18/05/2021
            bln_BFGCode: Joi.boolean().required(),
            bln_PrdVersion: Joi.boolean().required(),
            bln_Version: Joi.boolean().required(),

            str_unit_Vernier: Joi.allow(),
            str_unit_Balance: Joi.allow(),
            str_unit_Group:Joi.allow(),
            str_indUnit: Joi.allow(), 
            str_groupUnit: Joi.allow(),
            str_verUnit: Joi.allow(),

            flt_IndStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndDP: Joi.number().empty(['', null]).allow('', null).default(4),
            str_IndGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            str_IndLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            int_IndNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            flt_GrpStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Grpdp: Joi.number().empty(['', null]).allow('', null).default(4),
            str_GrpGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_GrpNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_DiffNet: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_NetDp: Joi.number().empty(['', null]).allow('', null).default(4),
            flt_DiffNetGraphOn: Joi.string().max(10).empty(['', null]).allow('', null).default('Standard'),
            flt_DiffNetNMTCnt: Joi.empty(['', null]).allow('', null).default(99999),
            flt_DiffNetLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_Emptystd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_EmptyDp: Joi.number().empty(['', null]).allow('', null).default(4),
            flt_EmptyGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            flt_EmptyNMTCnt: Joi.empty(['', null]).allow('', null).default(99999),
            flt_EmptyLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_LenStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_LenDp: Joi.number().empty(['', null]).allow('', null).default(2),
            str_LenGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_LenNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_ThkLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_DiaStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_DiaDp: Joi.number().empty(['', null]).allow('', null).default(2),
            str_DiaGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_DiaNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),


            int_DTHHTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTDp: Joi.number().empty(['', null]).allow('', null).default(2),

            flt_DTMinTemp: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMaxTemp: Joi.string().empty(['', null]).allow('', null).default(null),

            flt_CompDryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompDryMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_CompLubMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_Layer1DryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_Layer1LubMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_Layer2DryMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_Layer2LubMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_TapDenMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_FineMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_FineMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_PartSizingMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            flt_bulkMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax: Joi.string().empty(['', null]).allow('', null).default(99999),

            //PSD PARAMS
            flt_PSDMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),

            int_dryDpGran: Joi.number().empty("").default(4),
            int_lubDpGran: Joi.number().empty("").default(4),
            int_dryL1DpGran: Joi.number().empty("").default(4),
            int_lubL1DpGran: Joi.number().empty("").default(4),
            int_dryL2DpGran: Joi.number().empty("").default(4),
            int_lubL2DpGran: Joi.number().empty("").default(4),
            int_tdDpGran: Joi.number().empty("").default(4),
            int_fineDpGran: Joi.number().empty("").default(4),
            int_psDpGran: Joi.number().empty("").default(4),
            int_bulkDpGran: Joi.number().empty("").default(4),

            int_PSD_DpGran: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100_Lay_1: Joi.number().empty("").default(4),


            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(50).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
            //bln_TypeBiLayPrd: Joi.boolean().required(),

            //Content added here
            flt_Content1Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content1LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content1GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content1NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content1_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content1_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            flt_Content2Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content2LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content2GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content2NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content2_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content2_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            flt_Content3Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content3LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content3GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content3NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content3_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content3_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            flt_Content4Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content4LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content4GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content4NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content4_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content4_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            int_Content1DP: Joi.number().empty("").default(4),
            int_Content2DP: Joi.number().empty("").default(4),
            int_Content3DP: Joi.number().empty("").default(4),
            int_Content4DP: Joi.number().empty("").default(4),

            remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            auditObject: Joi.object().keys({
                status: Joi.string().not([null, 'undefined']),
                result: Joi.object().keys({
                    Capsule: Joi.object().keys({
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                        //oldData: Joi.string().not([null, 'undefined'])
                    }),
                    Grannual: Joi.object().keys({
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    })
                }),
            })
        })

        return saveSchemaCapsule;
    }
    static updateSchemaCapsule() {
        const updateSchemaCapsule = Joi.object().keys({
            str_BFGCode: Joi.string().max(25).required().not(['', null, 'undefined']),
            str_Prd: Joi.string().max(300).required().not(['', null, 'undefined']),
            str_PV: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_V: Joi.string().max(50).required().not(['', null, 'undefined']),
            str_V: Joi.string().max(50).required().not(['', null, 'undefined']),
            int_prdType: Joi.number().empty(['', null]).allow('', null).default(1),
            str_ind_nomNomnclature: Joi.string().max(255).empty("").default('NA'),
            str_GenericName: Joi.string(),
            intGenericName: Joi.number(),
            strOldBFG: Joi.string().max(25).required().not(['', null, 'undefined']),
            strOldPrd: Joi.string().max(300).required().not(['', null, 'undefined']),
            strOldPV: Joi.string().max(50).required().not(['', null, 'undefined']),
            strOldV: Joi.string().max(50).required().not(['', null, 'undefined']),
            strOldGName: Joi.string().max(300).required().not(['', null, 'undefined']),
            IsPrdDetailChange: Joi.boolean().required(),

            str_unit_Vernier: Joi.allow(),
            str_unit_Balance: Joi.allow(),
            str_unit_Group: Joi.allow(),
            str_indUnit:Joi.allow(),
            str_groupUnit:Joi.allow(),

            flt_BatchSize: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_BatchUnit: Joi.string().max(50).required().not(['', null, 'undefined']),
            bln_TypeCoatPrd: Joi.boolean().required(),
            bln_IsBinWeiging: Joi.boolean().empty("").default(false),

            flt_IndStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_IndT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_IndDP: Joi.number().empty(['', null]).allow('', null).default(4),
            str_IndGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            str_IndLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            int_IndNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            flt_GrpStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_GrpT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_Grpdp: Joi.number().empty(['', null]).allow('', null).default(4),
            str_GrpGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_GrpNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_GrpLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_DiffNet: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiffNetT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_NetDp: Joi.number().empty(['', null]).allow('', null).default(4),
            flt_DiffNetGraphOn: Joi.string().max(10).empty(['', null]).allow('', null).default('Standard'),
            flt_DiffNetNMTCnt: Joi.empty(['', null]).allow('', null).default(99999),
            flt_DiffNetLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_Emptystd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_EmptyT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_EmptyDp: Joi.number().empty(['', null]).allow('', null).default(4),
            flt_EmptyGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            flt_EmptyNMTCnt: Joi.empty(['', null]).allow('', null).default(99999),
            flt_EmptyLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_LenStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_LenT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_LenDp: Joi.number().empty(['', null]).allow('', null).default(2),
            str_LenGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_LenNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),


            flt_DiaStd: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_DiaT2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            int_DiaDp: Joi.number().empty(['', null]).allow('', null).default(2),
            str_DiaGraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_DiaNMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),

            str_ThkLimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),

            flt_DTMinTemp: Joi.string().empty(['', null]).allow('', null).default(null),
            flt_DTMaxTemp: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTDp: Joi.number().empty(['', null]).allow('', null).default(2),

            int_DTHHTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTMMTime: Joi.string().empty(['', null]).allow('', null).default(null),
            int_DTSSTime: Joi.string().empty(['', null]).allow('', null).default(null),

            flt_CompDryMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_CompDryMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_CompLubMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1DryMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer1LubMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2DryMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_Layer2LubMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_TapDenMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_FineMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_FineMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_PartSizingMax: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_bulkMin: Joi.number().empty(['', null]).allow('', null).default(99999),
            flt_bulkMax: Joi.number().empty(['', null]).allow('', null).default(99999),

            //Content added here
            flt_Content1Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content1T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content1LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content1GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content1NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content1_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content1_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            flt_Content2Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content2T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content2LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content2GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content2NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content2_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content2_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            flt_Content3Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content3T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content3LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content3GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content3NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content3_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content3_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            flt_Content4Std: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T1Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T1Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T2Neg: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_Content4T2Pos: Joi.string().empty(['', null]).allow('', null).default(99999),
            str_Content4LimitOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Actual'),
            str_Content4GraphOn: Joi.string().max(255).empty(['', null]).allow('', null).default('Standard'),
            int_Content4NMTTabCnt: Joi.empty(['', null]).allow('', null).default(99999),
            str_content4_type: Joi.string().empty(['', null]).allow('', null).default('NA'),
            str_content4_Name: Joi.string().empty(['', null]).allow('', null).default('NA'),

            int_Content1DP: Joi.number().empty("").default(4),
            int_Content2DP: Joi.number().empty("").default(4),
            int_Content3DP: Joi.number().empty("").default(4),
            int_Content4DP: Joi.number().empty("").default(4),

            int_dryDpGran: Joi.number().empty("").default(4),
            int_lubDpGran: Joi.number().empty("").default(4),
            int_dryL1DpGran: Joi.number().empty("").default(4),
            int_lubL1DpGran: Joi.number().empty("").default(4),
            int_dryL2DpGran: Joi.number().empty("").default(4),
            int_lubL2DpGran: Joi.number().empty("").default(4),
            int_tdDpGran: Joi.number().empty("").default(4),
            int_fineDpGran: Joi.number().empty("").default(4),
            int_psDpGran: Joi.number().empty("").default(4),
            int_bulkDpGran: Joi.number().empty("").default(4),
            strProjectName: Joi.string().required().not([null, 'undefined']),
            bln_TypeGrannualPrd: Joi.boolean(),
            bln_TypeCompressed: Joi.boolean(),
            wasCompressed: Joi.boolean(),
            wasGrannual: Joi.boolean(),

            int_PSD_DpGran: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100: Joi.number().empty("").default(4),
            int_PSD_DpGran_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_20_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_40_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_60_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_80_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_abv_100_Lay_1: Joi.number().empty("").default(4),
            int_PSD_DpGran_blw_100_Lay_1: Joi.number().empty("").default(4),

            //PSD PARAMS
            flt_PSDMin: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_20_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_40_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_60_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_80_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_abv_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMin_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),
            flt_PSDMax_blw_100_Lay_1: Joi.string().empty(['', null]).allow('', null).default(99999),

            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(50).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark: Joi.string().max(500).required().not(['', null, 'undefined']),

            str_verUnit: Joi.allow(),
            auditObject: Joi.object().keys({
                status: Joi.string().not([null, 'undefined']),
                result: Joi.object().keys({
                    Capsule: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    ProductDetail: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    Grannual: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                }),
            })


        });
        return updateSchemaCapsule;
    }

    productCombinationSchema() {
        const productCombination = Joi.object().keys({
            ProductId: Joi.string().required().allow('', null),
            ProductName: Joi.string().required().allow('', null),
            ProductVersion: Joi.string().required().allow('', null),
            Version: Joi.string().required().allow('', null),
        })
        return productCombination;
    }

    activateProductSchema(){
        const activateProductSchema = Joi.object().keys({
            action:Joi.string().required().not(['', null, 'undefined']),
            productID:Joi.string().required().not(['', null, 'undefined']),
            productType:Joi.string().required().not(['', null, 'undefined']),
            productVersion:Joi.string().required().not(['', null, 'undefined']),
            productname:Joi.string().required().not(['', null, 'undefined']),
            remark:Joi.string().required().not(['', null, 'undefined']),
            userId:Joi.string().required().not(['', null, 'undefined']),
            userName:Joi.string().required().not(['', null, 'undefined']),
            Version:Joi.string().required().not(['', null, 'undefined']),
            GenericName:Joi.string().required().not(['', null, 'undefined']),
       })
        return activateProductSchema;  
    }

    checkInCubicleSchema(){
        const checkInCubicleSchema = Joi.object().keys({
            productID:Joi.string().required().not(['', null, 'undefined']),
            productVersion:Joi.string().required().not(['', null, 'undefined']),
            productname:Joi.string().required().not(['', null, 'undefined']),
            Version:Joi.string().required().not(['', null, 'undefined']),
            GenericName:Joi.string().required().not(['', null, 'undefined']),
       })
        return checkInCubicleSchema;  
    }

    getStatusCountSchema(){
        const getStatusCountSchema = Joi.object().keys({
            productname:Joi.string().required().not(['', null, 'undefined']),
            productVersion:Joi.string().required().not(['', null, 'undefined']),
            productID:Joi.string().required().not(['', null, 'undefined']),
            Version:Joi.string().required().not(['', null, 'undefined']),
            GenericName:Joi.string().required().not(['', null, 'undefined']),
       })
        return getStatusCountSchema;  
    }
    
}



module.exports = ProductSchema;