const Joi = require('joi');

class BalanceSchema {
    saveBalanceSchema()
    { 
        const saveBalanceSchema = Joi.object().keys({
            balID: Joi.string().max(100).required().not(['',null,'undefined']),
            make: Joi.string().max(100).required().not(['',null,'undefined']),
            cal_store_type: Joi.string(),
            calibration_date: Joi.string(),
            leastCount:Joi.allow(""),
            set_reminder: Joi.number(),
            Bal_DSNW: Joi.number(),
            bal_dp: Joi.number(),
            Bal_Cert_No: Joi.allow(),
            maxCapacity: Joi.string().max(100).required().not(['',null,'undefined']),
            maxOperatingRange: Joi.string().max(100).required().not(['',null,'undefined']),
            minCapacity: Joi.string().max(100).required().not(['',null,'undefined']),
            minOperatingRange: Joi.string().max(100).required().not(['',null,'undefined']),
            department: Joi.string().max(100).required().not(['',null,'undefined']),
            modelNo: Joi.string().max(100).required().not(['',null,'undefined']),
            selectedUnit: Joi.string().max(50).required().not(['', null, 'undefined']),
            serialNo: Joi.string().max(50).required().not(['', null, 'undefined']),
            LoggeduserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            Loggedusername: Joi.string().max(255).required().not(['', null, 'undefined']),
            hdnAction: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['',null,'undefined']),
            cal_dates: Joi.allow(),
            weights: Joi.array(),
            newParameter:Joi.string().max(900).required().not(['',null,'undefined']),
            chkIsBinBalance: Joi.boolean(),
            duration: Joi.allow(),
            selectedStatus: Joi.string().max(50).required().not(['', null, 'undefined']),
            formNo: Joi.string().max(100).required().not(['',null,'undefined']),
            versionNo: Joi.string().max(100).required().not(['',null,'undefined']),
            location: Joi.string().max(100).required().not(['',null,'undefined']),
            intEccentricityCount: Joi.number().max(100).required().not(['',null,'undefined']),
            intUncertaintyCount: Joi.number().max(100).required().not(['',null,'undefined']),
            intRepeatabilityCount: Joi.number().max(100).required().not(['',null,'undefined'])

        });
        
        return saveBalanceSchema;
    }

    updateActiveDeactiveSchema() {
        const updateActiveDeactiveSchema = Joi.object().keys({
            action: Joi.string().required().not(['', null, 'undefined']),
            balID: Joi.required().not(['', null, 'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            userName: Joi.string().required().not(['', null, 'undefined']),
        })
        return updateActiveDeactiveSchema;
    }

    editBalanceSchema()
    { 
        const editBalanceSchema = Joi.object().keys({
            balID: Joi.string().max(100).required().not(['',null,'undefined']),
            make: Joi.string().max(100).required().not(['',null,'undefined']),
            Bal_Cert_No: Joi.allow(),
            cal_store_type: Joi.string(),
            calibration_date: Joi.string(),
            leastCount:Joi.allow(""),
            set_reminder: Joi.number(),
            Bal_DSNW: Joi.number(),
            bal_dp: Joi.number(),
            maxCapacity: Joi.string().max(100).required().not(['',null,'undefined']),
            maxOperatingRange: Joi.string().max(100).required().not(['',null,'undefined']),
            minCapacity: Joi.string().max(100).required().not(['',null,'undefined']),
            minOperatingRange: Joi.string().max(100).required().not(['',null,'undefined']),
            department: Joi.string().max(100).required().not(['',null,'undefined']),
            modelNo: Joi.string().max(100).required().not(['',null,'undefined']),
            selectedUnit: Joi.string().max(50).required().not(['', null, 'undefined']),
            serialNo: Joi.string().max(50).required().not(['', null, 'undefined']),
            LoggeduserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            Loggedusername: Joi.string().max(255).required().not(['', null, 'undefined']),
            hdnAction: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['',null,'undefined']),
            cal_dates: Joi.allow(),
            weights: Joi.array(),
            newWeights: Joi.allow(),
            oldParameter:Joi.string().max(900).required().not(['',null,'undefined']),
            newParameter:Joi.string().max(900).required().not(['',null,'undefined']),
            chkIsBinBalance: Joi.boolean(),
            oldWeights:Joi.allow(),
            duration: Joi.allow(),
            selectedStatus: Joi.string().max(50).required().not(['', null, 'undefined']),
            formNo: Joi.string().max(100).required().not(['',null,'undefined']),
            versionNo: Joi.string().max(100).required().not(['',null,'undefined']),
            location: Joi.string().max(100).required().not(['',null,'undefined']),
            intEccentricityCount: Joi.number().max(100).required().not(['',null,'undefined']),
            intUncertaintyCount: Joi.number().max(100).required().not(['',null,'undefined']),
            intRepeatabilityCount: Joi.number().max(100).required().not(['',null,'undefined'])
        });
        
        return editBalanceSchema;
    }
   
}




module.exports = BalanceSchema;