const Joi = require('joi');

class VernierSchema {
    updateStatusSchema() {
        const statusSchema = Joi.object().keys({
            action: Joi.string().required().not(['', null, 'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            userName: Joi.string().required().not(['', null, 'undefined']),
            vernierID: Joi.required().not(['', null, 'undefined']),
        })
        return statusSchema;
    }

    insertWithoutWeightSchema() {
        const WithoutCalibrationSchema = Joi.object().keys({
            vernierCode: Joi.string().required().not(['', null, 'undefined']),
            vernierModelNo: Joi.string().required().not(['', null, 'undefined']),
            vernierSerialNo: Joi.string().required().not(['', null, 'undefined']),
            leastCount: Joi.required().not(['', null, 'undefined']),
            unit: Joi.string().required().not(['', null, 'undefined']),
            maxRange: Joi.number().required().not(['', null, 'undefined']),
            minRange: Joi.number().required().not(['', null, 'undefined']),
            LoggeduserId: Joi.string().required().not(['', null, 'undefined']),
            Loggedusername: Joi.string().required().not(['', null, 'undefined']),
            hdnAction: Joi.string().required().not(['', null, 'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            oldParameters: Joi.string().required().not(['', null, 'undefined']),
            newParameters: Joi.string().required().not(['', null, 'undefined']),
            int_dp: Joi.number().required().not(['', null, 'undefined']),
            vernierMake: Joi.string().required().not(['', null, 'undefined'])
        })
        return WithoutCalibrationSchema;
    }

    getVernierWithoutWeight() {
        const VernierSchema = Joi.object().keys({
            VernierID: Joi.string().required().not(['', null, 'undefined']),
            Model: Joi.string().alphanum().required().not(['', null, 'undefined']),
            VernierNo: Joi.string().alphanum().required().not(['', null, 'undefined']),
            leastCount: Joi.number().required().not(['', null, 'undefined']),
            RangeUnit: Joi.string().alphanum().required().not(['', null, 'undefined']),
            RangeMinVal: Joi.number().required().not(['', null, 'undefined']),
            RangeMaxVal: Joi.number().required().not(['', null, 'undefined']),
            int_dp: Joi.number().empty("").default(5),
        })
        return VernierSchema;
    }


    updateWithoutWeightSchema() {
        const statusSchema = Joi.object().keys({
            LoggeduserId: Joi.string().required().not(['', null, 'undefined']),
            Loggedusername: Joi.string().required().not(['', null, 'undefined']),
            hdnAction: Joi.string().required().not(['', null, 'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            vernierCode: Joi.string().required().not(['', null, 'undefined']),
            vernierSerialNo: Joi.string().required().not(['', null, 'undefined']),
            vernierModelNo: Joi.string().required().not(['', null, 'undefined']),
            leastCount: Joi.required().not(['', null, 'undefined']),
            unit: Joi.string().required().not(['', null, 'undefined']),
            maxRange: Joi.number().required().not(['', null, 'undefined']),
            minRange: Joi.number().required().not(['', null, 'undefined']),
            oldParameters: Joi.string().required().not(['', null, 'undefined']),
            newParameters: Joi.string().required().not(['', null, 'undefined']),
            int_dp: Joi.number().required().not(['', null, 'undefined']),
            vernierMake: Joi.string().required().not(['', null, 'undefined'])

        })
        return statusSchema;

    }

    insertVernierSchema(){
        const insertVernierSchema = Joi.object().keys({
            vernierCode: Joi.string().required().not(['', null, 'undefined']),
            cal_store_type: Joi.string().required().not(['', null, 'undefined']),
            hdnAction: Joi.string().required().not(['', null, 'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            vernierCode: Joi.string().required().not(['', null, 'undefined']),
            vernierSerialNo: Joi.string().required().not(['', null, 'undefined']),
            vernierModelNo: Joi.string().required().not(['', null, 'undefined']),
            leastCount: Joi.required().not(['', null, 'undefined']),
            unit: Joi.string().required().not(['', null, 'undefined']),
            maxRange: Joi.number().required().not(['', null, 'undefined']),
            minRange: Joi.number().required().not(['', null, 'undefined']),
            oldParameters: Joi.string().required().not(['', null, 'undefined']),
            newParameters: Joi.string().required().not(['', null, 'undefined']),
            int_dp: Joi.number().required().not(['', null, 'undefined']),
            vernierMake: Joi.string().required().not(['', null, 'undefined'])

        })
        return insertVernierSchema;
    }
}

module.exports = VernierSchema;